{extends file='dashboard/layout.tpl'}

{block name='content_wrapper'}

    {if $section == ""}
    
        <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">Customers</h3>
                        <div class="nk-block-des text-soft">
                            <p>You have total {$total_customers} customers.</p>
                        </div>
                    </div>

                    <!-- .nk-block-head-content -->
                    <div class="nk-block-head-content">
                        <div class="toggle-wrap nk-block-tools-toggle">
                            <a href="#" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                            <div class="toggle-expand-content" data-content="more-options">
                                <ul class="nk-block-tools g-3">
                                    <li>
                                        <form class="form-control-wrap" method="get" id="filter_form" autocomplete="off"> 
                                            <div class="form-icon form-icon-right">
                                                <em class="icon ni ni-search"></em>
                                            </div>
                                            <input type="text" class="form-control" value="{$query}" name="query" placeholder="Search by ID & email">
                                        </form>
                                    </li>
                                    <li>
                                        <a href="{$base_uri}/customers/export" class="btn btn-white btn-outline-light">
                                            <em class="icon ni ni-download-cloud"></em><span>Export</span>
                                        </a>
                                    </li>
                                    <li class="nk-block-tools-opt">
                                        <a href="{$base_uri}/customers/add" data-ajax="/customers/add" class="btn btn-icon btn-primary d-md-none"><em class="icon ni ni-plus"></em></a>
                                        <a href="{$base_uri}/customers/add" data-ajax="/customers/add" class="btn btn-primary d-none d-md-inline-flex"><em class="icon ni ni-plus"></em><span>Add</span></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>

            {if count($customers)}
                <div class="nk-block">
                    <div class="card card-stretch">
                        <div class="card-inner-group">
                            <div class="card-inner p-0">
                                <table class="nk-tb-list nk-tb-ulist">
                                    <thead>
                                        <tr class="nk-tb-item nk-tb-head">
                                            <th class="nk-tb-col"><span class="sub-text">Customer</span></th>
                                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Phone</span></th>
                                            <th class="nk-tb-col"><span class="sub-text">Total Spent</span></th>
                                            <th class="nk-tb-col"><span class="sub-text">From Site</span></th>
                                            <th class="nk-tb-col tb-col-xxl"><span class="sub-text">Registered</span></th>
                                            <th class="nk-tb-col nk-tb-col-tools text-right">&nbsp;</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        {foreach $customers as $customer}
                                            <tr class="nk-tb-item">
                                                <td class="nk-tb-col">
                                                    <a href="{$base_uri}/customers/edit/{$customer.id}" data-ajax="/customers/edit/{$customer.id}" class="project-title">
                                                        <div class="user-card">
                                                            <div class="user-avatar {if $customer.is_anonymous}bg-warning{else}bg-primary{/if} sq">
                                                                {if $customer.is_anonymous}
                                                                    <span>A</span>
                                                                {else}
                                                                    <span>{if $customer.name} {$customer.name[0]|strtoupper} {else} {$customer.email[0]|strtoupper} {/if}</span>
                                                                {/if}
                                                            </div>
                                                            <div class="user-info ml-1">
                                                                {if $customer.name}
                                                                    <span class="tb-lead">{$customer.name}</span>
                                                                {/if}
                                                                <span>{if $customer.is_anonymous}Anonymous{else}{$customer.email}{/if}</span>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </td>
                                                <td class="nk-tb-col tb-col-lg">
                                                    <span>{if $customer.phone} {$customer.phone} {else} N.A {/if}</span>
                                                </td>
                                                <td class="nk-tb-col">
                                                    <span class="tb-amount">${$customer.total_spent} <span class="currency d-none d-sm-inline-block">USD</span></span>
                                                </td>
                                                <td class="nk-tb-col">
                                                    <span>{if $customer.site_name} {$customer.site_name} {else} N.A {/if}</span>
                                                </td>
                                                <td class="nk-tb-col tb-col-xxl">
                                                    <span class="js_moment" data-time="{$customer.reg_date}">{$customer.reg_date}</span>
                                                </td>
                                                <td class="nk-tb-col nk-tb-col-tools">
                                                    <ul class="nk-tb-actions gx-1">
                                                        <li class="nk-tb-action-hidden">
                                                            <a href="{$base_uri}/customers/edit/{$customer.id}" data-ajax="/customers/edit/{$customer.id}" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="" data-original-title="View Details">
                                                                <em class="icon ni ni-eye-fill"></em>
                                                            </a>
                                                        </li>
                                                        <li class="nk-tb-action-hidden">
                                                            <a target="_blank" href="{$customer.site_url}/api/v1/auth/{$customer.id}?authKey={$customer.secure_key}" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="" data-original-title="Impersonate">
                                                                <em class="icon ni ni-security"></em>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <div class="drodown">
                                                                <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                                <div class="dropdown-menu dropdown-menu-right">
                                                                    <ul class="link-list-opt no-bdr">
                                                                        <li>
                                                                            <a href="{$base_uri}/customers/edit/{$customer.id}" data-ajax="/customers/edit/{$customer.id}">
                                                                                <em class="icon ni ni-eye"></em><span>View Details</span>
                                                                            </a>
                                                                        </li>
                                                                        <li>
                                                                            <a href="{$base_uri}/orders/customer/{$customer.id}" data-ajax="/orders/customer/{$customer.id}">
                                                                                <em class="icon ni ni-bag-fill"></em><span>Orders</span>
                                                                            </a>
                                                                        </li>
                                                                        <li>
                                                                            <a target="_blank" href="{$customer.site_url}/api/v1/auth/{$customer.id}?authKey={$customer.secure_key}"><em class="icon ni ni-security"></em><span>Impersonate</span></a>
                                                                        </li>
                                                                        <li class="divider"></li>
                                                                        <li>
                                                                            <a class="js_deleter" href="javascript:void(0);" data-handle="customer" data-id="{$customer.id}">
                                                                                <em class="icon ni ni-trash"></em><span>Delete</span>
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="nk-block-between-md mt-3">
                        <div class="g">
                            {$pager nofilter}
                        </div>
                    </div><!-- .nk-block-between -->
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                    <h6 class="text-dark title mb-3">No customers to show</h6>
                </div>
            {/if}
        </div>

    {elseif $section == "add"}

        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/customers" data-ajax="/customers">
                            <em class="icon ni ni-arrow-left"></em><span>Customers</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Add new customer</h2>
                </div>
            </div>

            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms form-horizontal" data-url="/customers?do=add" autocomplete="off">
                        <div class="form-group">
                            <label class="form-label text-left">Site Name</label>
                            <select class="form-select" data-ui="lg" name="site_id" required>
                                <option value="-1">Select Site</option>
                                {foreach $sites as $site}
                                <option value="{$site.site_id}">{$site.name}</option>
                                {/foreach}
                            </select>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="form-label text-left">Name <small class="text-muted">(optional)</small></label>
                                <input class="form-control form-control-lg" type="text" name="name" autocomplete="off">
                            </div>
        
                            <div class="form-group col-md-6">
                                <label class="form-label text-left">Email</label>
                                <input class="form-control form-control-lg" type="email" name="email" required autocomplete="off">
                            </div>
                        </div>
     
                        <div class="form-group">
                            <label class="form-label text-left">Password</label>
                            <input class="form-control form-control-lg" type="text" name="password" required>
                        </div>
    
                        <!-- success -->
                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                        <!-- success -->

                        <!-- error -->
                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                        <!-- error -->
    
                        <button type="submit" class="btn btn-lg btn-primary">Add Customer</button>
                    </form>
                </div>
            </div>
        </div>

    {elseif $section == "edit"}
 
        <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between g-3">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">Customers / <strong class="text-primary small">{$customer.email|strtolower}</strong></h3>
                    </div>
                    <div class="nk-block-head-content">
                        <a href="{$base_uri}/customers" data-ajax="/customers" class="btn btn-outline-light bg-white d-none d-sm-inline-flex"><em class="icon ni ni-arrow-left"></em><span>Back</span></a>
                        <a href="{$base_uri}/customers" data-ajax="/customers" class="btn btn-icon btn-outline-light bg-white d-inline-flex d-sm-none"><em class="icon ni ni-arrow-left"></em></a>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-aside-wrap">
                    <div class="card-inner card-inner-lg">
                        <div class="tab-content">
                            <div class="tab-pane active" id="personalInformation">
                                <div class="nk-block-head">
                                    <div class="nk-block-between d-flex justify-content-between">
                                        <div class="nk-block-head-content">
                                            <h4 class="nk-block-title">Personal Information</h4>
                                            <div class="nk-block-des">
                                                <p>Basic info, like your name and address, that you use on {$customer.site_name}.</p>
                                            </div>
                                        </div>
                                        <div class="nk-tab-actions mr-n1">
                                            <a href="#" class="btn btn-icon btn-trigger d-none d-lg-block" data-toggle="modal" data-url="#profileEditModal" data-size="large">
                                                <em class="icon ni ni-edit"></em>
                                            </a>

                                            <a href="#" class="toggle btn btn-icon btn-trigger d-lg-none" data-target="userAside">
                                                <em class="icon ni ni-menu-alt-r"></em>
                                            </a>
                                        </div>
                                    </div>
                                </div><!-- .nk-block-head -->

                                <div class="nk-block">
                                    <div class="nk-data data-list">
                                        <div class="data-head">
                                            <h6 class="overline-title">Basics</h6>
                                        </div>
                                        <div class="data-item">
                                            <div class="data-col">
                                                <span class="data-label">Customer ID</span>
                                                <span class="data-value">{$customer.id}</span>
                                            </div>
                                        </div>
                                        

                                        {if !$customer.is_anonymous}
                                            <!-- data-item -->
                                            <div class="data-item">
                                                <div class="data-col">
                                                    <span class="data-label">Name</span>
                                                    <span class="data-value">{if $customer.name} {$customer.name} {else} N.A {/if}</span>
                                                </div>
                                            </div>
                                            
                                            <!-- data-item -->
                                            <div class="data-item">
                                                <div class="data-col">
                                                    <span class="data-label">Email</span>
                                                    <span class="data-value">{$customer.email}</span>
                                                </div>
                                            </div>

                                            <!-- data-item -->
                                            <div class="data-item">
                                                <div class="data-col">
                                                    <span class="data-label">Phone Number</span>
                                                    <span class="data-value text-soft">{if $customer.phone} {$customer.phone} {else} Not add yet {/if}</span>
                                                </div>
                                            </div>
                                        {/if}

                                        <!-- data-item -->
                                        <div class="data-item">
                                            <div class="data-col">
                                                <span class="data-label">From Site</span>
                                                <span class="data-value">{$customer.site_name}</span>
                                            </div>
                                        </div>

                                        {if !$customer.is_anonymous}
                                            <!-- data-item -->
                                            <div class="data-item">
                                                <div class="data-col">
                                                    <span class="data-label">Subscription</span>
                                                    <span class="data-value">
                                                        {if $customer.is_subscribed}
                                                            <span class="badge badge-dot badge-dot-xs badge-success">Subscribed</span>
                                                        {else}
                                                            <span class="badge badge-dot badge-dot-xs badge-danger">Not Subscribed</span>
                                                        {/if}
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                        
                                        <!-- data-item -->
                                        <div class="data-item">
                                            <div class="data-col">
                                                <span class="data-label">Policy Accepted</span>
                                                <span class="data-value">
                                                    {if $customer.policy_accepted}
                                                        <span class="js_moment" data-time="{$customer.policy_accepted_at}">{$customer.policy_accepted_at}</span>
                                                    {else}
                                                        <span class="badge badge-dot badge-dot-xs badge-danger">Not Yet</span>
                                                    {/if}
                                                </span>
                                            </div>
                                        </div>
                                        <!-- data-item -->
                                    </div>
                                    <!-- data-list -->
                                </div>
                            </div> 

                            {hook h='displayAdminEditCustomerNavContent' customerId=$customer.id}
                        </div>
                    </div>
                    <div class="card-aside card-aside-left user-aside toggle-slide toggle-slide-left toggle-break-lg" data-content="userAside" data-toggle-screen="lg" data-toggle-overlay="true">
                        <div class="card-inner-group" data-simplebar>
                            <div class="card-inner">
                                <div class="user-card">
                                    <div class="user-avatar {if $customer.is_anonymous}bg-warning{else}bg-primary{/if}">
                                        {if $customer.is_anonymous}
                                            <span>A</span>
                                        {else}
                                            <span>{if $customer.name} {$customer.name[0]|strtoupper} {else} {$customer.email[0]|strtoupper} {/if}</span>
                                        {/if}
                                    </div>
                                    <div class="user-info">
                                        {if $customer.is_anonymous}
                                            <span class="lead-text">Anonymous</span>
                                        {else}
                                            <span class="lead-text">{$customer.name}</span>
                                            <span class="sub-text">{$customer.email|strtolower}</span>
                                        {/if}
                                    </div>
                                </div><!-- .user-card -->
                            </div><!-- .card-inner -->
                            <div class="card-inner card-inner-sm">
                                <ul class="btn-toolbar justify-center gx-1">
                                    <li>
                                        <a target="_blank" href="{$customer_site.domain}/api/v1/auth/{$customer.id}?authKey={$customer.secure_key}" class="btn btn-trigger btn-icon" data-toggle="tooltip" title="Impersonate User">
                                            <em class="icon ni ni-security"></em>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{$base_uri}/orders/customer/{$customer.id}" class="btn btn-trigger btn-icon" data-toggle="tooltip" title="View Orders">
                                            <em class="icon ni ni-bag-fill"></em>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" class="btn btn-trigger btn-icon js_reset-password-link" data-id="{$customer.id}" data-handle="customer" data-toggle="tooltip" title="Password reset link">
                                            <em class="icon ni ni-lock"></em>
                                        </a>
                                    </li>
                                </ul>
                            </div> 

                            <div class="card-inner p-0">
                                <ul class="link-list-menu nav nav-tabs">
                                    <li>
                                        <a class="active" data-toggle="tab" href="#personalInformation">
                                            <em class="icon ni ni-user-fill-c"></em><span>Personal Infomation</span>
                                        </a>
                                    </li>

                                    {hook h='displayAdminEditCustomerNavbar' customerId=$customer.id}
                                </ul>
                            </div><!-- .card-inner -->

                            <div class="card-inner">
                                <div class="overline-title-alt mb-2">Orders Summary</div>
                                <div class="profile-balance">
                                    <div class="profile-balance-group gx-4">
                                        <div class="profile-balance-sub">
                                            <div class="profile-balance-amount">
                                                <div class="number">{formatPrice($customer.total_spent)} <small class="currency currency-usd">USD</small></div>
                                            </div>
                                            <div class="profile-balance-subtitle">Total Spent</div>
                                        </div>
                                        <div class="profile-balance-sub">
                                            <span class="profile-balance-plus text-soft"><em class="icon ni ni-plus"></em></span>
                                            <div class="profile-balance-amount">
                                                <div class="number">{$customer.completed_orders}</div>
                                            </div>
                                            <div class="profile-balance-subtitle">Completed Orders</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- .card-inner -->

                            {if $isReferralEnabled}
                                <div class="card-inner">
                                    <div class="user-account-info py-0">
                                        <h6 class="overline-title-alt">Referral program</h6>
                                        <div class="user-balance">{$customer.friends_invited}</div>
                                        <div class="user-balance-sub">Friends Invited</div>
                                    </div>
                                </div>
                                <!-- .card-inner -->
                            {/if}

                            <div class="card-inner">
                                <h6 class="overline-title-alt mb-2">Additional</h6>
                                <div class="row g-3">
                                    <div class="col-6">
                                        <span class="sub-text">Customer ID:</span>
                                        <span>{$customer.id}</span>
                                    </div>
                                    <div class="col-6">
                                        <span class="sub-text">Last Login:</span>
                                        <span class="js_moment" data-time="{$customer.last_login}">{$customer.last_login}</span>
                                    </div>
                                    <div class="col-6">
                                        <span class="sub-text">From Site:</span>
                                        <span>{$customer.site_name}</span>
                                    </div>
                                    <div class="col-6">
                                        <span class="sub-text">Register At:</span>
                                        <span class="js_moment" data-time="{$customer.reg_date}">{$customer.reg_date}</span>
                                    </div>
                                </div>
                            </div><!-- .card-inner -->
                        </div><!-- .card-inner-group -->
                    </div><!-- card-aside -->
                </div><!-- .card-aside-wrap -->
            </div>
        </div>

        {if $user.is_admin}
            <!-- @@ Profile Edit Modal @e -->
            <script id="profileEditModal" type="text/template">
                <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                <div class="modal-body modal-body-lg">
                    <h5 class="title mb-4">Update Profile</h5>
                    <form class="js_ajax-forms" data-url="/customers?do=edit">
                        <input type="hidden" name="customer_id" value="{$customer.id}"/>

                        {if $customer.is_anonymous}
                            <div class="row mb-2">
                                <div class="form-group col-md-6">
                                    <label class="form-label">Total Spent</label>
                                    <div class="form-control-wrap">
                                        <div class="form-icon lg form-icon-left">
                                            <em class="icon ni ni-sign-dollar"></em>
                                        </div>
                                        <input type="text" class="form-control form-control-lg force-integer" name="total_spent" value="{$customer.total_spent}">
                                    </div>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="form-label">Customer Site</label>
                                    <select class="form-select" data-ui="lg" name="site_id" required>
                                        <option value="-1">Select Site</option>
                                        {foreach $sites as $site}
                                            <option value="{$site.site_id}" {if $customer.site_id == $site.site_id}selected=""{/if}>{$site.name}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            
                                <div class="form-group col-md-6">
                                    <label class="form-label">Password</label>
                                    <input class="form-control form-control-lg" type="text" name="password">
                                </div>
                            </div>
                        {else}
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="form-label">Email</label>
                                    <input class="form-control form-control-lg" type="text" name="email" value="{$customer.email}" required>
                                </div>
                            
                                <div class="form-group col-md-6">
                                    <label class="form-label">Phone</label>
                                    <input type="text" name="js_user_phone" class="form-control form-control-lg js_phone" placeholder="Enter mobile" autocomplete="off" {if $customer.phone}value="{$customer.phone}"{/if}>
                                    <input type="hidden" name="phone" class="form-control form-control-lg js_phone_number" autocomplete="off" readonly="true" {if $customer.phone}value="{$customer.phone}"{/if}>
                                </div>
                            </div>
                        
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="form-label">Name <small class="text-muted">(optional)</small></label>
                                    <input class="form-control form-control-lg" type="text" name="name" value="{$customer.name}">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="form-label">Customer Site</label>
                                    <select class="form-select" data-ui="lg" name="site_id" required>
                                        <option value="-1">Select Site</option>
                                        {foreach $sites as $site}
                                            <option value="{$site.site_id}" {if $customer.site_id == $site.site_id}selected=""{/if}>{$site.name}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="form-label">Total Spent</label>
                                    <div class="form-control-wrap">
                                        <div class="form-icon lg form-icon-left">
                                            <em class="icon ni ni-sign-dollar"></em>
                                        </div>
                                        <input type="text" class="form-control form-control-lg force-integer" name="total_spent" value="{$customer.total_spent}">
                                    </div>
                                </div>
                            
                                <div class="form-group col-md-6">
                                    <label class="form-label">Password</label>
                                    <input class="form-control form-control-lg" type="text" name="password">
                                </div>
                            </div>
                        {/if}
                        
                        <div class="form-group">
                            <!-- error -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->

                            <!-- success -->
                            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                            <!-- success -->
                        </div>
                    
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </form>
                </div>
            </script>
            <!-- @@ Profile Edit Modal @e -->
        {/if}

    {/if}
{/block}
