{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="card">
            <div class="card-inner border-bottom">
                <div class="card-title-group">
                    <div class="card-title">
                        <h6 class="title">System Updates</h6>
                    </div>
                </div>
            </div>
            <div class="card-inner">
                {if $last_version_check}
                    <p>Last checked on {$last_version_check}. &nbsp; <a class="btn btn-dark" href="{$base_uri}/updates?force-check=1">Check Again</a></p>
                {/if}

                {if $check_for_update}
                    {if $update_available}
                        <p>A newer version of Proxim is available: <strong>{$new_update_version}</strong></p>
                        <a class="btn btn-primary" href="{$base_uri}/upgrader">Install Update</a>
                    {else}
                        <p>You have the latest version of Proxim: <strong>{$system_version}</strong></p>
                    {/if}
                {else}
                    <p>Your current Proxim version: <strong>{$system_version}</strong></p>
                    <a class="btn btn-primary" href="{$base_uri}/updates?force-check=1">Check for Updates</a>
                {/if}
            </div>
        </div>

        {if count($sites)}
            <div class="card">
                <div class="card-inner border-bottom">
                    <div class="card-title-group">
                        <div class="card-title">
                            <h6 class="title">My Sites</h6>
                        </div>
                    </div>
                </div>
                <div class="card-inner">
                    <table class="table table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <td>Site Name</td>
                                <td>Version</td>
                                <td>Last Update</td>
                                <td>Actions</td>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $sites as $site}
                                <tr>
                                    <td><a href="{$base_uri}/my-sites/{$site.id}/edit">{$site.name}</a></td>
                                    <td>{$site.version}</td>
                                    <td>
                                        <span class="js_moment" data-time="{$site.last_update}">{$site.last_update}</span>
                                    </td>
                                    <td>
                                        <a target="_blank" href="{$site.domain}/updates?force-check=1" class="btn btn-xs btn-success">
                                            <i class="fas fa-sync"></i> Update
                                        </a>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>
                </div>
            </div>
        {/if}

        <div class="card">
            <div class="card-inner border-bottom">
                <div class="card-title-group">
                    <div class="card-title">
                        <h6 class="title">Changelog</h6>
                    </div>
                </div>
            </div>
            <div class="card-inner">
                {include file="updates/changelog.tpl"}
            </div>
        </div>

    </div>
{/block}