<!doctype html>
<html lang="en-US">
  	<head>
		{block name='head'}
			{include file='_partials/head.tpl'}
		{/block}
	</head>

    <body class="nk-body bg-white npc-default pg-auth {$body_classes|classnames} {if $theme_mode_night}night-mode{/if}">

        <div class="nk-app-root">
            <!-- main @s -->
            <div class="nk-main ">
                <!-- wrap @s -->
                <div class="nk-wrap nk-wrap-nosidebar">
                    <!-- content @s -->
                    <div class="nk-content ">
                        <div class="nk-block nk-block-middle nk-auth-body  wide-xs">
                            <div class="nk-block nk-block-middle nk-auth-body">
                                {if $site_logo}
                                    <div class="brand-logo pb-5">
                                        <a href="{$base_uri}" class="logo-link">
                                            <img class="logo-light logo-img logo-img-lg" src="{$uploads_path}/{$site_logo}" srcset="{$uploads_path}/{$site_logo} 2x" alt="logo">
                                            <img class="logo-dark logo-img logo-img-lg" src="{$uploads_path}/{$site_logo}" srcset="{$uploads_path}/{$site_logo} 2x" alt="logo-dark">
                                        </a>
                                    </div>
                                {/if}

                                {if $do == "reset"}
                                    <div class="nk-block-head">
                                        <div class="nk-block-head-content">
                                            <h4 class="nk-block-title">Reset password</h4>
                                            <div class="nk-block-des">
                                                <p>If you forgot your password, well, then we’ll email you instructions to reset your password.</p>
                                            </div>
                                        </div>
                                    </div><!-- .nk-block-head -->

                                    <form class="js_ajax-forms" data-url="/reset-password">
                                        <div class="form-group">
                                            <div class="form-label-group">
                                                <label class="form-label" for="default-01">Email</label>
                                            </div>
                                            <div class="form-control-wrap">
                                                <input type="text" class="form-control form-control-lg" name="email" placeholder="Enter your email address">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <!-- error -->
                                            <div class="alert alert-danger alert-fill alert-icon x-hidden mb-2"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                            <!-- error -->

                                            <!-- success -->
                                            <div class="alert alert-success alert-fill alert-icon x-hidden mb-2"><em class="icon ni ni-check"></em> <span></span></div>
                                            <!-- success -->
                                        </div>

                                        <div class="form-group">
                                            <button type="submit" class="btn btn-lg btn-primary btn-block">Send Reset Link</button>
                                        </div>
                                    </form>

                                    <div class="form-note-s2 text-center pt-4">
                                        <a href="{$base_uri}/signin" data-ajax="/signin"><strong>Return to login</strong></a>
                                    </div>

                                {elseif $do == "change"}
                                    <div class="nk-block-head">
                                        <div class="nk-block-head-content">
                                            <h4 class="nk-block-title">Change Password</h4>
                                            <div class="nk-block-des">
                                                <p>Create a new, strong password that you don't use for other websites.</p>
                                            </div>
                                        </div>
                                    </div><!-- .nk-block-head -->
                                    
                                    <form class="js_ajax-forms" data-url="/forget-password-confirm">
                                        <input type="hidden" name="reset_key" value="{$reset_key}"/>
                                        <div class="form-group">
                                            <label class="form-label" for="new">New Password</label>
                                            <input name="new" id="new" type="password" class="form-control form-control-lg" required>
                                        </div>

                                        <div class="form-group">
                                            <label class="form-label" for="confirm">Confirm Password</label>
                                            <input name="confirm" id="confirm" type="password" class="form-control form-control-lg" required>
                                        </div>

                                        <!-- error -->
                                        <div class="alert alert-danger alert-fill alert-icon x-hidden mb-2"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                        <!-- error -->

                                        <!-- success -->
                                        <div class="alert alert-success alert-fill alert-icon x-hidden mb-2"><em class="icon ni ni-check"></em> <span></span></div>
                                        <!-- success -->

                                        <button type="submit" class="btn btn-primary btn-block">Change Password</button>
                                    </form>
                                {/if}

                            </div><!-- .nk-block -->
                        </div>
                        <div class="nk-footer nk-auth-footer-full">
                            <div class="container wide-lg">
                                <div class="nk-block-content text-center text-lg-left">
                                    <p class="text-soft">&copy; {date('Y')} {$site_name}. All Rights Reserved.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- wrap @e -->
                </div>
                <!-- content @e -->
            </div>
            <!-- main @e -->
        </div>

        {include file="_partials/_js_files.tpl"}
    </body>
</html>
