{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block">
            <div class="card">
                <div class="card-aside-wrap">
                    <div class="card-inner card-inner-lg">

                        {if $_settings == 'general'}
                            <div class="nk-block-head">
                                <div class="nk-block-between d-flex justify-content-between">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title">Personal Information</h4>
                                        <div class="nk-block-des">
                                            <p>Basic info, like your name and address.</p>
                                        </div>
                                    </div>
                                    <div class="nk-tab-actions mr-n1">
                                        {if $user.employee_status != "6"}
                                            <a href="#" class="btn btn-icon btn-trigger d-none d-lg-block" data-toggle="modal" data-url="#profileEditModal" data-size="large">
                                                <em class="icon ni ni-edit"></em>
                                            </a>
                                        {/if}

                                        <a href="#" class="toggle btn btn-icon btn-trigger d-lg-none" data-target="userProfileAside">
                                            <em class="icon ni ni-menu-alt-r"></em>
                                        </a>
                                    </div>
                                </div>
                            </div><!-- .nk-block-head -->
                            
                            <div class="nk-block">
                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Basics</h6>
                                    </div>
                                    <div class="data-item" {if $user.employee_status != "6"}data-toggle="modal" data-size="large" data-url="#profileEditModal"{/if}>
                                        <div class="data-col">
                                            <span class="data-label">Full Name</span>
                                            <span class="data-value">{$user.first_name} {$user.middle_name} {$user.last_name}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            {if $user.employee_status == "6"}
                                                <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                            {else}
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            {/if}
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                    <div class="data-item">
                                        <div class="data-col">
                                            <span class="data-label">Email</span>
                                            <span class="data-value">{$user.email}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                    <div class="data-item" {if $user.employee_status != "6"}data-toggle="modal" data-size="large" data-url="#profileEditModal"{/if}>
                                        <div class="data-col">
                                            <span class="data-label">Phone Number</span>
                                            <span class="data-value text-soft">{if $user.phone}{$user.phone}{else}Not add yet{/if}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            {if $user.employee_status == "6"}
                                                <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                            {else}
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            {/if}
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                    <div class="data-item" {if $user.employee_status != "6"}data-toggle="modal" data-size="large" data-url="#profileEditModal"{/if}>
                                        <div class="data-col">
                                            <span class="data-label">Date of Birth</span>
                                            <span class="data-value text-soft">{$user.date_of_birth}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            {if $user.employee_status == "6"}
                                                <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                            {else}
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            {/if}
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                    <div class="data-item" {if $user.employee_status != "6"}data-toggle="modal" data-size="large" data-url="#profileEditModal"{/if}>
                                        <div class="data-col">
                                            <span class="data-label">Gender</span>
                                            <span class="data-value">{$user.gender|ucfirst}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            {if $user.employee_status == "6"}
                                                <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                            {else}
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            {/if}
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                    <div class="data-item" {if $user.employee_status != "6"}data-toggle="modal" data-size="large" data-url="#profileEditModal"{/if}>
                                        <div class="data-col">
                                            <span class="data-label">Country</span>
                                            <span class="data-value text-soft">{if $user.country}{$user.country_name}{else}Not add yet{/if}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            {if $user.employee_status == "6"}
                                                <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                            {else}
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            {/if}
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                    <div class="data-item" {if $user.employee_status != "6"}data-toggle="modal" data-size="large" data-url="#profileEditModal"{/if}>
                                        <div class="data-col">
                                            <span class="data-label">City/Town</span>
                                            <span class="data-value text-soft">{if $user.city}{$user.city}{else}Not add yet{/if}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            {if $user.employee_status == "6"}
                                                <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                            {else}
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            {/if}
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                </div>
                                <!-- data-list -->
                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Preferences</h6>
                                    </div>
                                    <div class="data-item">
                                        <div class="data-col">
                                            <span class="data-label">Timezone</span>
                                            <span class="data-value">{$user.timezone}</span>
                                        </div>
                                        <div class="data-col data-col-end">
                                            <a href="javascript:void(0);" data-toggle="modal" data-url="#profileTimezone" class="link link-primary">Change</a>
                                        </div>
                                    </div>
                                    <!-- data-item -->
                                </div>
                                <!-- data-list -->

                                {if $user.is_editor || $user.is_writer}
        
                                    <div class="nk-data data-list">
                                        <div class="data-head">
                                            <h6 class="overline-title">Account</h6>
                                        </div>

                                        <div class="data-item">
                                            <div class="data-col">
                                                <span class="data-label">Status</span>
                                                <span class="data-value text-soft">
                                                    {if $user.employee_status == "2"}
                                                        <span class="badge badge-dot badge-dot-xs badge-success">Looking for orders</span>
                                                    {elseif $user.employee_status == "4"}
                                                        <span class="badge badge-dot badge-dot-xs badge-warning">Cannot work for now</span>
                                                    {elseif $user.employee_status == "5"}
                                                        <span class="badge badge-dot badge-dot-xs badge-danger">Do not use your service</span>
                                                    {elseif $user.employee_status == "6"}
                                                        <span class="badge badge-dot badge-dot-xs badge-danger">Probation</span>
                                                    {/if}
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                {if $user.employee_status == "6"}
                                                    <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                                {else}
                                                    <a href="#" data-toggle="modal" data-url="#profileAccountWorkingStatus" data-size="small" class="link link-primary">Change</a>
                                                {/if}
                                            </div>
                                        </div>
                                        <!-- data-item -->
    
                                        <div class="data-item" data-toggle="modal" data-url="#profileAccountWorkingStatus" data-size="small">
                                            <div class="data-col">
                                                <span class="data-label">Available 24/7</span>
                                                <span class="data-value text-soft">
                                                    {if $user.available_247}
                                                        <span class="badge badge-dot badge-dot-xs badge-success">Yes</span>
                                                    {else}
                                                        <span class="badge badge-dot badge-dot-xs badge-warning">No</span>
                                                    {/if}
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                {if $user.employee_status == "6"}
                                                    <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                                {else}
                                                    <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                                {/if}
                                            </div>
                                        </div>
                                        <!-- data-item -->

                                        <div class="data-item" data-toggle="modal" data-url="#profileAccountWorkingStatus" data-size="small">
                                            <div class="data-col">
                                                <span class="data-label">Urgent Orders</span>
                                                <span class="data-value text-soft">
                                                    {if $user.available_urgent_orders}
                                                        <span class="badge badge-dot badge-dot-xs badge-success">Yes</span>
                                                    {else}
                                                        <span class="badge badge-dot badge-dot-xs badge-warning">No</span>
                                                    {/if}
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                {if $user.employee_status == "6"}
                                                    <span class="data-more disable"><em class="icon ni ni-lock-alt"></em></span>
                                                {else}
                                                    <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                                {/if}
                                            </div>
                                        </div>
                                        <!-- data-item -->
                                    </div>
                                    <!-- data-list -->
    
                                {/if}
                            </div>
                            <!-- .nk-block -->

                            <!-- @@ Profile Edit Modal @e -->
                            <script id="profileEditModal" type="text/template">
                                <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                                <div class="modal-body modal-body-lg">
                                    <h5 class="title">Update Profile</h5>
                                    <ul class="nk-nav nav nav-tabs">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-toggle="tab" href="#personal">Personal</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#email-address">Email Address</a>
                                        </li>
                                    </ul><!-- .nav-tabs -->
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="personal">
                                            <form class="js_ajax-forms" method="POST" data-url="/user/settings?edit=basic" autocomplete="off">
                                                <div class="row gy-4">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label" for="first_name">First Name</label>
                                                            <input type="text" class="form-control form-control-lg" name="first_name" value="{$user.first_name}" autocomplete="off" placeholder="Enter First name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label" for="middle_name">Middle Name</label>
                                                            <input type="text" class="form-control form-control-lg" name="middle_name" value="{$user.middle_name}" autocomplete="off" placeholder="Enter Middle name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label" for="last_name">Last Name</label>
                                                            <input type="text" class="form-control form-control-lg" name="last_name" value="{$user.last_name}" autocomplete="off" placeholder="Enter Last name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label" for="phone-no">Phone Number</label>
                                                            <input type="text" name="js_user_phone" class="form-control form-control-lg js_phone" placeholder="Enter mobile" autocomplete="off" {if $user.phone}value="{$user.phone}"{/if}>
                                                            <input type="hidden" name="phone" class="form-control js_phone_number" autocomplete="off" readonly="true" {if $user.phone}value="{$user.phone}"{/if}>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label" for="gender">Gender</label>
                                                            <div>
                                                                <ul class="custom-control-group">
                                                                    <li>
                                                                        <div class="custom-control custom-control-lg pl-0 custom-checkbox custom-control-pro no-control checked">
                                                                            <input type="radio" class="custom-control-input" name="gender" id="gender_male" value="male" {if $user.gender == 'male'}checked="checked"{/if}>
                                                                            <label class="custom-control-label" for="gender_male"><em class="icon fas fa-male"></em><span>Male</span></label>
                                                                        </div>
                                                                    </li>
                                                                    <li>
                                                                        <div class="custom-control custom-control-lg pl-0 custom-checkbox custom-control-pro no-control">
                                                                            <input type="radio" class="custom-control-input" name="gender" id="gender_female" value="female" {if $user.gender == 'female'}checked="checked"{/if}>
                                                                            <label class="custom-control-label" for="gender_female"><em class="icon fas fa-female"></em><span>Female</span></label>
                                                                        </div>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label">Date of Birth</label>
                                                            <div class="form-control-wrap">
                                                                <input type="text" data-msg="Required" class="form-control form-control-lg date-picker-alt required" data-date-format="yyyy-mm-dd" name="date_of_birth" {if $user.date_of_birth != '0000-00-00'}value="{$user.date_of_birth}"{/if} required>
                                                            </div>
                                                        </div>
                                                    </div>
                    
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label">Country</label>
                                                            <div class="form-control-wrap">
                                                                <select class="form-select" data-ui="lg" data-search="on" name="country">
                                                                    {foreach from=$countries item=country key=key}
                                                                        <option value="{$key}" {if $user.country == $key } selected="" {/if}>{$country.name}</option>
                                                                    {/foreach}
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label">City/Town</label>
                                                            <div class="form-control-wrap">
                                                                <input type="text" data-msg="Required" class="form-control form-control-lg required" name="city" value="{$user.city}">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <!-- error -->
                                                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                        <!-- error -->

                                                        <!-- success -->
                                                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                                        <!-- success -->
                                                    </div>
                                                    
                                                    <div class="col-12">
                                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                                            <li>
                                                                <button type="submit" class="btn btn-lg btn-primary">Update Profile</button>
                                                            </li>
                                                            <li>
                                                                <a href="javascript:void(0);" data-dismiss="modal" class="link link-light">Cancel</a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </form>
                                        </div><!-- .tab-pane -->
                                        <div class="tab-pane" id="email-address">
                                            <form class="js_ajax-forms" data-url="/user/settings?edit=email" autocomplete="off">
                                                <div class="row gy-4">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">Email Address</label>
                                                            <input type="email" class="form-control form-control-lg" name="email" value="{$user.email}"> 
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-12">
                                                        <!-- error -->
                                                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                        <!-- error -->

                                                        <!-- success -->
                                                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                                        <!-- success -->
                                                    </div>

                                                    <div class="col-12">
                                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                                            <li>
                                                                <button type="submit" class="btn btn-lg btn-primary">Update Email</button>
                                                            </li>
                                                            <li>
                                                                <a href="javascript:void(0);" data-dismiss="modal" class="link link-light">Cancel</a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </form>
                                        </div><!-- .tab-pane -->
                                    </div><!-- .tab-content -->
                                </div><!-- .modal-body -->
                            </script>

                            <!-- @@ Profile Timezone Modal @e -->
                            <script id="profileTimezone" type="text/template">
                                <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                                <div class="modal-body">
                                    <h5 class="title">Update Timezone</h5>
                                    <form class="js_ajax-forms" data-url="/user/settings?edit=timezone" autocomplete="off">
                                        <div class="form-group mt-4">
                                            <label class="form-label">Timezone</label>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <select id="timezone-region" class="form-control form-control-lg" data-combo="timezone-combo">
                                                        {foreach from=$regions item=region key=key name=name}
                                                            <option value="{$key}" {if $user.default_region == $key } selected="" {/if} >{$key}</option>
                                                        {/foreach}
                                                    </select>
                                                </div>
                                                {assign var='timezoneId' value=0}
                                                <div id="timezone-combo" class="col-md-6">
                                                    {foreach from=$regions item=region key=key name=name}
                                                        <select id="timezone-combo-{$key}" class="form-control form-control-lg {if $user.default_region != $key } x-hidden {/if} switch-combo" data-combo-value="{$key}">
                                                            {foreach from=$region item=item key=key name=name}
                                                                <option value="{$key}" {if $user.timezone == $key } selected="" {/if} >{$item}</option>
                                                            {/foreach}
                                                        </select>
                                                    {assign var='timezoneId' value=$timezoneId+1}
                                                    {/foreach}
                                                </div>
                                            </div>
                                            <input type="hidden" id="timezone" name="timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">
                                        </div>
                                            
                                        <!-- error -->
                                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                        <!-- error -->

                                        <!-- success -->
                                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                        <!-- success -->
                                            
                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                            <li>
                                                <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                                            </li>
                                            <li>
                                                <a href="javascript:void(0);" data-dismiss="modal" class="link link-light">Cancel</a>
                                            </li>
                                        </ul>
                                    </form>
                                </div>
                            </script>

                        {elseif $_settings == 'about'}
                            <div class="nk-block-head">
                                <div class="nk-block-between d-flex justify-content-between">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title">About & Qualifications</h4>
                                        <div class="nk-block-des">
                                            <p>Employee bio, qualifications, experience, software access and programming languages.</p>
                                        </div>
                                    </div>
                                    <div class="nk-tab-actions mr-n1">
                                        {if $user.employee_status != "6"}
                                            <a href="#" class="btn btn-icon btn-trigger d-none d-lg-block" data-toggle="modal" data-url="#accountEditModal" data-size="large">
                                                <em class="icon ni ni-edit"></em>
                                            </a>
                                        {/if}

                                        <a href="#" class="toggle btn btn-icon btn-trigger d-lg-none" data-target="userProfileAside">
                                            <em class="icon ni ni-menu-alt-r"></em>
                                        </a>
                                    </div>
                                </div>
                            </div><!-- .nk-block-head -->

                            <div class="nk-block">
                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">About</h6>
                                    </div>

                                    <div class="mt-4">
                                        {if $user.about}
                                            {$userAbout nofilter}
                                        {else}
                                            <div class="alert alert-warning alert-icon">
                                                <em class="icon ni ni-alert-circle"></em> No about. Add your profile about <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                            </div>
                                        {/if}
                                    </div>
                                    <!-- data-item -->

                                </div>

                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Languages</h6>
                                    </div>

                                    <div class="mt-4">
                                        {if count($user.other_languages_array)}
                                            <ul class="preview-list m-0">
                                                {foreach from=$languages item=language key=key}
                                                    {if in_array($key, $user.other_languages_array)}
                                                        <li class="preview-item p-1">
                                                            <span class="badge badge-default badge-md">{$language.name}</span>
                                                        </li>
                                                    {/if}
                                                {/foreach}
                                            </ul>
                                        {else}
                                            <div class="alert alert-warning alert-icon">
                                                <em class="icon ni ni-alert-circle"></em> No languages select. Add other languages you can write at <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                            </div>
                                        {/if}
                                    </div>

                                </div>

                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Proficient Disciplines</h6>
                                    </div>

                                    <div class="mt-4">
                                       {if count($user_disciplines)}
                                            <ul class="preview-list m-0">
                                                {foreach $user_disciplines as $discipline}
                                                    <li class="preview-item p-1">
                                                        <span class="badge badge-default badge-md">{$discipline.title}</span>
                                                    </li>
                                                {/foreach}
                                            </ul>
                                        {else}
                                            <div class="alert alert-warning alert-icon">
                                                <em class="icon ni ni-alert-circle"></em> Please select 3-7 disciplines you are proficient in <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                            </div>
                                        {/if}
                                    </div>

                                </div>

                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Software &amp; Programming Language</h6>
                                    </div>

                                    <div class="mt-4">
                                        {if count($user_softwares)}
                                            <ul class="preview-list m-0">
                                                {foreach $user_softwares as $software}
                                                    <li class="preview-item p-1">
                                                        <span class="badge badge-default badge-md">{$software.title}</span>
                                                    </li>
                                                {/foreach}
                                            </ul>
                                        {else}
                                            <div class="alert alert-warning alert-icon">
                                                <em class="icon ni ni-alert-circle"></em> Please indicate software you have access to and/or programming language you are expert in <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                            </div>
                                        {/if}
                                    </div>

                                </div>
                            </div>

                            <!-- @@ Account Edit Modal @e -->
                            <script id="accountEditModal" type="text/template">
                                <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                                <div class="modal-body modal-body-lg">
                                    <h5 class="title">Update Account</h5>
                                    <ul class="nk-nav nav nav-tabs">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-toggle="tab" href="#about">About</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#qualification">Qualification & Experience</a>
                                        </li>
                                    </ul><!-- .nav-tabs -->
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="about">
                                            <form class="js_ajax-forms" method="POST" data-url="/user/settings?edit=about" autocomplete="off">
                                                <input type="hidden" name="employee_id" value="{$user.id}"/>
                                                <div class="row gy-4">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="form-label">About Me</label>
                                                            <div class="form-control-wrap">
                                                                <textarea class="form-control summernote-minimal" data-height="250" name="about_me">{$user.about}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">Facebook Profile</label>
                                                            <div class="form-control-wrap">
                                                                <input type="text" class="form-control form-control-lg" name="facebook_profile" value="{$user.facebook_profile}">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">LinkedIn Profile</label>
                                                            <div class="form-control-wrap">
                                                                <input type="text" class="form-control form-control-lg" name="linkedin_profile" value="{$user.linkedin_profile}">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <!-- error -->
                                                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                        <!-- error -->
                                        
                                                        <!-- success -->
                                                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                                        <!-- success -->
                                                    </div>
                                                    
                                                    <div class="col-12">
                                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                                            <li>
                                                                <button type="submit" class="btn btn-lg btn-primary">Update Account</button>
                                                            </li>
                                                            <li>
                                                                <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                </div>
                                            </form>
                                        </div>
                                        <!-- .tab-pane -->

                                        <div class="tab-pane" id="qualification">
                                            <form class="js_ajax-forms" method="POST" data-url="/user/settings?edit=qualifications" autocomplete="off">
                                                <input type="hidden" name="employee_id" value="{$user.id}"/>
                                                <div class="row gy-4">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">Your Native Language</label>
                                                            <div class="form-control-wrap">
                                                                <select class="form-select" data-ui="lg" data-search="on" name="native_language" required>
                                                                    {foreach from=$languages item=language key=key}
                                                                        <option value="{$key}" {if $user.native_language == $key } selected="" {/if}>{$language.name}</option>
                                                                    {/foreach}
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="form-label">Other Languages You Can Write At</label>
                                                            <div class="form-control-wrap">
                                                                <select class="form-select" data-ui="lg" data-search="on" name="other_languages[]" multiple data-search="on">
                                                                    {foreach from=$languages item=language key=key}
                                                                        <option value="{$key}" {if in_array($key, $user.other_languages_array)} selected="" {/if}>{$language.name}</option>
                                                                    {/foreach}
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">Your Highest Verifiable Academic Degree</label>
                                                            <div class="form-control-wrap">
                                                                <select class="form-select" data-ui="lg" data-search="on" name="highest_academic_degree" required>
                                                                    {foreach from=$academicDegrees item=academicDegree key=key}
                                                                        <option value="{$key}" {if $user.highest_academic_degree == $key } selected="" {/if}>{$academicDegree.degree}</option>
                                                                    {/foreach}
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">Your Degree Major</label>
                                                            <div class="form-control-wrap">
                                                                <input type="text" data-msg="Required" class="form-control form-control-lg required" name="academic_degree_major" value="{$user.academic_degree_major}" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="form-label">Please Select 3-7 Disciplines You Are Proficient In</label>
                                                            <div class="form-control-wrap">
                                                                <select class="form-select required" data-search="on" data-ui="lg" data-msg="Required" name="proficient_disciplines[]" multiple data-search="on">
                                                                    {foreach $disciplineGroups as $topicCat}
                                                                        <optgroup label="{$topicCat.title}">
                                                                            {foreach $topicCat.disciplines as $discipline}
                                                                                <option value="{$discipline.discipline_id}" {if in_array($discipline.discipline_id, $user.proficient_disciplines_array)}selected=""{/if} >{$discipline.title}</option>
                                                                            {/foreach}
                                                                        </optgroup>
                                                                    {/foreach}
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="form-label">Please Indicate Software You Have Access To And/OR Programming Language You Are Expert In</label>
                                                            <div class="form-control-wrap">
                                                                <select class="form-select required" data-search="on" data-ui="lg" data-msg="Required" name="software[]" multiple data-search="on">
                                                                    {foreach $software_programming as $snf}
                                                                        <option value="{$snf.software_programming_id}" {if in_array($snf.software_programming_id, $user.software_array)}selected=""{/if}>{$snf.title}</option>
                                                                    {/foreach}
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- .col -->

                                                    <div class="col-12">
                                                        <!-- error -->
                                                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                        <!-- error -->
                                        
                                                        <!-- success -->
                                                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                                        <!-- success -->
                                                    </div>
                                                    
                                                    <div class="col-12">
                                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                                            <li>
                                                                <button type="submit" class="btn btn-lg btn-primary">Update Account</button>
                                                            </li>
                                                            <li>
                                                                <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                </div>
                                            </form>
                                        </div>
                                        <!-- .tab-pane -->

                                    </div><!-- .tab-content -->
                                </div><!-- .modal-body -->
                            </script>
                        {elseif $_settings == 'essays'}
                            <div class="nk-block-head">
                                <div class="nk-block-between d-flex justify-content-between">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title">Essays &amp; Samples</h4>
                                        <div class="nk-block-des">
                                            <p>Employee bio, qualifications, experience, software access and programming languages.</p>
                                        </div>
                                    </div>
                                </div>
                            </div><!-- .nk-block-head -->

                            <div class="nk-block">
                                
                               {if isset($user_files['application-essay'])}
                                    <div class="nk-data data-list">
                                        <div class="data-head">
                                            <h6 class="overline-title">Essays</h6>
                                        </div>
        
                                        <div class="nk-files nk-files-view-group mt-2">
                                            <div class="nk-files-group">
                                                <div class="nk-files-list">
                                                    {foreach $user_files['application-essay'] as $file}
                                                        {include file='dashboard/users/_application.file.tpl'}
                                                    {/foreach}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                {/if}

                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Samples</h6>
                                    </div>

                                    {if isset($user_files['application-sample'])}
                                        <div class="nk-files nk-files-view-group mt-2">
                                            <div class="nk-files-group">
                                                <div class="nk-files-list">
                                                    {foreach $user_files['application-sample'] as $file}
                                                        {include file='dashboard/users/_application.file.tpl'}
                                                    {/foreach}
                                                </div>
                                            </div>
                                        </div>
                                    {else}
                                        <div class="card bg-secondary-dim mt-3">
                                            <div class="card-inner">
                                                <div class="nk-block-text">
                                                    <h5>Samples (optional)</h5>
                                                    <p>You may upload samples of your work here to show your knowledge and writing skills. The fies should be uploaded in doc / docx / pdf format (no more than 3 files and 50 MB).</p>
                                                </div>
                                            </div>
                                            <div class="card-footer">
                                                <button class="btn btn-lg btn-primary pull-right" type="button" data-toggle="modal" data-url="#modal-upload-file"data-options='{literal}{{/literal}"handle":"application-sample"{literal}}{/literal}'>
                                                    <em class="icon ni ni-upload"></em> <span>Upload</span>
                                                </button>
                                            </div>
                                        </div>
                                    
                                    {/if}
                                </div>

                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">CV</h6>
                                    </div>

                                    {if isset($user_files['application-cv'])}
                                        <div class="nk-files nk-files-view-group mt-2">
                                            <div class="nk-files-group">
                                                <div class="nk-files-list">
                                                    {foreach $user_files['application-cv'] as $file}
                                                        {include file='dashboard/users/_application.file.tpl'}
                                                    {/foreach}
                                                </div>
                                            </div>
                                        </div>
                                    {else}
                                        <div class="card bg-secondary-dim mt-3">
                                            <div class="card-inner">
                                                <div class="nk-block-text">
                                                    <h5>CV</h5>
                                                    <p class="mb-2">You are welcome to upload your CV or resume here. Make sure it is written in English and contains the description of your educational background, professional experience and recommendations if you have any.</p> 
                                                    <p class="mb-2">The file(s) should be uploaded in doc / docx / pdf format (no more than 3 files and 50 MB).</p>
                                                    <p>If you have any questions, please email us at <strong>{$site_email}</strong></p>
                                                </div>
                                            </div>
                                            <div class="card-footer">
                                                <button class="btn btn-lg btn-primary pull-right" type="button" data-toggle="modal" data-url="#modal-upload-cv" data-options='{literal}{{/literal}"handle":"application-cv"{literal}}{/literal}'>
                                                    <em class="icon ni ni-upload"></em> <span>Upload</span>
                                                </button>
                                            </div>
                                        </div>
                                    {/if}
                                </div>

                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Degree Certificate</h6>
                                    </div>

                                    {if isset($user_files['application-degree'])}
                                        <div class="nk-files nk-files-view-group mt-2">
                                            <div class="nk-files-group">
                                                <div class="nk-files-list">
                                                    {foreach $user_files['application-degree'] as $file}
                                                        {include file='dashboard/users/_application.file.tpl'}
                                                    {/foreach}
                                                </div>
                                            </div>
                                        </div>
                                    {else}
                                        <div class="card bg-secondary-dim mt-3">
                                            <div class="card-inner">
                                                <div class="nk-block-text">
                                                    <h5>Degree Certificate</h5>
                                                    <p class="mb-2">Please upload a photo of your education certificate and/or academic transcripts that can prove your highest qualification attained certificates issued in non English speaking countries should be submitted along with their English translations.</p>
                                                    <p class="mb-2">The files should be uploaded in jpg/ipeg format (no more than 3 files and 50 MB).</p>
                                                    <p>If you have any questions, please email us at <strong>{$site_email}</strong></p>
                                                </div>
                                            </div>
                                            <div class="card-footer">
                                                <button class="btn btn-lg btn-primary pull-right" type="button" data-toggle="modal" data-url="#modal-upload-degree" data-options='{literal}{{/literal}"handle":"application-degree"{literal}}{/literal}'>
                                                    <em class="icon ni ni-upload"></em> <span>Upload</span>
                                                </button>
                                            </div>
                                        </div>
                                    {/if}
                                </div>
                            </div>

                            <script id="modal-upload-file" type="text/template">
                                <form class="js_files-uploader p0 m0" method="POST" data-action="user/settings?edit=upload" data-handle="{literal}{{handle}}{/literal}">
                                    <div class="modal-header"> 
                                        <h5 class="modal-title">Essay</h5>
                                        <span class="close" data-dismiss="modal" aria-label="Close">
                                            <em class="icon ni ni-cross"></em>
                                        </span>
                                    </div>
                                    
                                    <div class="modal-body">
                                        <div class="alert alert-secondary">
                                            <p>Upload your sample essay in <strong>doc/docx/pdf format</strong>. Make sure your sample essay:</p>
                                            <ul class="list list-checked-circle">
                                                <li>Contains 275-350 words</li>
                                                <li>Is formatted according to the <strong>indicated format style</strong></li>
                                                <li>Is <strong>not handwritten</strong></li>
                                            </ul>
                                        </div>
                            
                                        <h6 class="mb-3 overline-title title">Upload File</h6>
                                        <div class="files-control js_dropzone" data-handle="{literal}{{handle}}{/literal}">
                                            <div class="files-control--files"></div>
                                            <div class="dropzone-description">
                                                <button class="browse-button btn btn-primary" type="button">Browse </button>
                                                <span class="control-or">or</span>
                                                <span class="control-drop-here">Drop plugin here</span>
                                            </div>
                                            <div class="dropzone-static">
                                                <div class="dropzone-border">Drop files here</div>
                                            </div>
                                            <input accept=".pdf,.doc,.docx" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
                                        </div>
                                        <!-- error -->
                                        <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
                                        <!-- error -->
                                    </div>
                                    <div class="modal-footer bg-lighter">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
                                    </div>
                                </form>
                            </script>
                            
                            <script id="modal-upload-cv" type="text/template">
                                <form class="js_files-uploader p0 m0" method="POST" data-action="user/settings?edit=upload" data-handle="{literal}{{handle}}{/literal}">
                                    <div class="modal-header"> 
                                        <h5 class="modal-title">CV</h5>
                                        <span class="close" data-dismiss="modal" aria-label="Close">
                                            <em class="icon ni ni-cross"></em>
                                        </span>
                                    </div>
                                    
                                    <div class="modal-body">
                                        <div class="alert alert-secondary">
                                            <p>Please upload your CV / resume here.</p>
                                            <p>The file(s) should be uploaded in <strong>doc / docx / pdf format (no more than 3 files and 50MB)</strong></p>
                                        </div>
                            
                                        <h6 class="mb-3 overline-title title">Upload File</h6>
                                        <div class="files-control js_dropzone" data-handle="{literal}{{handle}}{/literal}">
                                            <div class="files-control--files"></div>
                                            <div class="dropzone-description">
                                                <button class="browse-button btn btn-primary" type="button">Browse </button>
                                                <span class="control-or">or</span>
                                                <span class="control-drop-here">Drop plugin here</span>
                                            </div>
                                            <div class="dropzone-static">
                                                <div class="dropzone-border">Drop files here</div>
                                            </div>
                                            <input accept=".pdf,.doc,.docx" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
                                        </div>
                                        <!-- error -->
                                        <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
                                        <!-- error -->
                                    </div>
                                    <div class="modal-footer bg-lighter">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
                                    </div>
                                </form>
                            </script>
                            
                            <script id="modal-upload-degree" type="text/template">
                                <form class="js_files-uploader p0 m0" method="POST" data-action="user/settings?edit=upload" data-handle="{literal}{{handle}}{/literal}">
                                    <div class="modal-header"> 
                                        <h5 class="modal-title">Degree Certificate</h5>
                                        <span class="close" data-dismiss="modal" aria-label="Close">
                                            <em class="icon ni ni-cross"></em>
                                        </span>
                                    </div>
                                    
                                    <div class="modal-body">
                                        <div class="alert alert-secondary">
                                            <p>Please upload a photo of your education certificate and/or academic transcripts that can prove your highest qualification attained.</p>
                                            <p><strong>Certificates issued in non-English-speaking countries should be submitted along with their English translations.</strong></p>
                                            <p>The file(s) should be uploaded in <strong>jpg / jpeg format (no more than 3 files and 50MB)</strong></p>
                                        </div>
                            
                                        <h6 class="mb-3 overline-title title">Upload File</h6>
                                        <div class="files-control js_dropzone" data-handle="{literal}{{handle}}{/literal}">
                                            <div class="files-control--files"></div>
                                            <div class="dropzone-description">
                                                <button class="browse-button btn btn-primary" type="button">Browse </button>
                                                <span class="control-or">or</span>
                                                <span class="control-drop-here">Drop plugin here</span>
                                            </div>
                                            <div class="dropzone-static">
                                                <div class="dropzone-border">Drop files here</div>
                                            </div>
                                            <input accept=".jpg,.jpeg" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
                                        </div>
                                        <!-- error -->
                                        <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
                                        <!-- error -->
                                    </div>
                                    <div class="modal-footer bg-lighter">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
                                    </div>
                                </form>
                            </script>
                        {elseif $_settings == 'password'}

                            <div class="nk-block-head nk-block-head-lg">
                                <div class="nk-block-between">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title">Security Settings</h4>
                                        <div class="nk-block-des">
                                            <p>These settings are helps you keep your account secure.</p>
                                        </div>
                                    </div>
                                    <div class="nk-block-head-content align-self-start d-lg-none">
                                        <a href="javascript:void(0);" class="toggle btn btn-icon btn-trigger mt-n1" data-target="userProfileAside"><em class="icon ni ni-menu-alt-r"></em></a>
                                    </div>
                                </div>
                            </div>
                            <!-- .nk-block-head -->

                            <div class="nk-block">
                                <div class="card">
                                    <div class="card-inner-group">
                                        <div class="card-inner">
                                            <div class="between-center flex-wrap g-3">
                                                <div class="nk-block-text">
                                                    <h6>Change Password</h6>
                                                    <p>Set a unique password to protect your account.</p>
                                                </div>
                                                <div class="nk-block-actions flex-shrink-sm-0">
                                                    <ul class="align-center flex-wrap flex-sm-nowrap gx-3 gy-2">
                                                        <li class="order-md-last">
                                                            <a href="javascript:void(0);" class="btn btn-primary" data-toggle="modal" data-url="#passwordChangeModal">Change Password</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- .card-inner -->
                                    </div>
                                    <!-- .card-inner-group -->
                                </div>
                                <!-- .card -->
                            </div>

                            <!-- @@ Change Password Modal @e -->
                            <script id="passwordChangeModal" type="text/template">
                                <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                                <div class="modal-body">
                                    <h5 class="title">Change Password</h5>
                                    <form class="js_ajax-forms" data-url="/user/settings?edit=password" autocomplete="off">
                                        <div class="form-group mt-4">
                                            <label class="form-label">Current Password</label>
                                            <input type="password" class="form-control form-control-lg" name="current" autocomplete="off"> 
                                        </div>
                                        <div class="form-group form-row">
                                            <div class="col-md-6">
                                                <label class="form-label">New Password</label>
                                                <input type="password" class="form-control form-control-lg" name="new" autocomplete="off"> 
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">Re-type New Password</label>
                                                <input type="password" class="form-control form-control-lg" name="confirm" autocomplete="off"> 
                                            </div>
                                        </div>

                                        <!-- error -->
                                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                        <!-- error -->

                                        <!-- success -->
                                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                        <!-- success -->
                                            
                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                            <li>
                                                <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                                            </li>
                                            <li>
                                                <a href="javascript:void(0);" data-dismiss="modal" class="link link-light">Cancel</a>
                                            </li>
                                        </ul>
                                    </form>
                                </div>
                            </script>

                        {elseif $_settings == 'sessions'}

                            <div class="nk-block-head nk-block-head-lg">
                                <div class="nk-block-between">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title">Login Activity</h4>
                                        <div class="nk-block-des">
                                            <p>Here is your last {count($sessions)} login activities log.</p>
                                        </div>
                                    </div>
                                    <div class="nk-block-head-content align-self-start d-lg-none">
                                        <a href="#" class="toggle btn btn-icon btn-trigger mt-n1" data-target="userProfileAside">
                                            <em class="icon ni ni-menu-alt-r"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <!-- .nk-block-head -->

                            <div class="nk-block">
                                {if count($sessions)}
                                    <div class="active_sessions">
                                        <div class="table-responsive">
                                            {foreach $sessions as $session}
                                                <div class="as_list" id="session_{$session.session_id}">
                                                    <div class="platform_icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="#222" d="M21,16H3V4H21M21,2H3C1.89,2 1,2.89 1,4V16A2,2 0 0,0 3,18H10V20H8V22H16V20H14V18H21A2,2 0 0,0 23,16V4C23,2.89 22.1,2 21,2Z"></path></svg>
                                                    </div>
                                                    <button title="Log Out" class="btn btn-mat log_out_session js_session-deleter" data-id="{$session.session_id}">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z"></path></svg>
                                                    </button>
                                                    <div class="session_info">
                                                        <h4>{$session.user_os}</h4>
                                                        <p>
                                                            <span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="currentColor" d="M21,3H3A2,2 0 0,0 1,5V19A2,2 0 0,0 3,21H21A2,2 0 0,0 23,19V5A2,2 0 0,0 21,3M21,19H3V5H13V9H21V19Z"></path></svg> {$session.user_browser}</span>
                                                            <span class="middot">·</span>
                                                            <span>
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="currentColor" d="M12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22C6.47,22 2,17.5 2,12A10,10 0 0,1 12,2M12.5,7V12.25L17,14.92L16.25,16.15L11,13V7H12.5Z"></path></svg> 
                                                                <span class="js_moment" data-time="{$session.login_time}">{$session.login_time}</span>
                                                            </span>
                                                        </p>
                                                        <p>IP Address: {$session.user_ip}</p>
                                                    </div>
                                                </div>
                                            {/foreach}
                                        </div>

                                        <div class="nk-block-between-md mt-3">
                                            <div class="g">
                                                {$pager nofilter}
                                            </div>
                                        </div><!-- .nk-block-between -->
                                    </div>
                                {else}
                                    <div class="text-center x-muted"> 
                                        {include file='__svg_icons.tpl' class="mb-3" icon="secure" width="100px" height="100px"}
                                        <h6 class="text-muted fw-normal title mb-3">No sessions to show</h6>
                                    </div>
                                {/if}   
                            </div>
                        {else}
                            {hook h='displayProfileNavContent'}
                        {/if}
                    </div>
                    
                    <div class="card-aside card-aside-left user-aside toggle-slide toggle-slide-left toggle-break-lg toggle-screen-lg" data-content="userProfileAside" data-toggle-screen="lg" data-toggle-overlay="true">
                        <div class="card-inner-group" data-simplebar>
                            <div class="card-inner">
                                <div class="user-card">
                                    <div class="profile-avatar-wrapper mr-3">
                                        {if $user.user_picture_default}
                                            <div class="user-avatar bg-primary avatar sq md">
                                                <span>{$user.first_name[0]}{$user.last_name[0]}</span>
                                            </div>
                                        {else}
                                            <div class="user-avatar avatar-img avatar sq md" style="background-image: url('{$user.user_picture}');"></div>
                                        {/if}

                                        <div class="profile-avatar-change-loader">
                                            <div class="loader loader_medium"></div>
                                        </div>
                                    </div>
                                    <div class="user-info">
                                        <span class="lead-text">{$user.first_name} {$user.last_name}</span>
                                        <span class="sub-text">{$user.email}</span>
                                    </div>
                                    <div class="user-action">
                                        <div class="dropdown">
                                            <a class="btn btn-icon btn-trigger mr-n2" data-toggle="dropdown" href="javascript:void(0);">
                                                <em class="icon ni ni-more-v"></em>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <ul class="link-list-opt no-bdr">
                                                    <li>
                                                        <a href="javascript:void(0);" class="js_x-uploader" data-handle="picture-user">
                                                            <em class="icon ni ni-camera-fill"></em><span>Change Photo</span>
                                                        </a>
                                                    </li>
                                                    {if !$user.user_picture_default}
                                                        <li>
                                                            <a href="javascript:void(0);" class="js_delete-picture" data-handle="picture-user">
                                                                <em class="icon ni ni-cross-fill-c"></em><span>Delete Photo</span>
                                                            </a>
                                                        </li>
                                                    {/if}

                                                    {if $user.employee_status != "6"}
                                                        <li>
                                                            <a href="javascript:void(0);" data-toggle="modal" data-size="large" data-url="#profileEditModal">
                                                                <em class="icon ni ni-edit-fill"></em><span>Update Profile</span>
                                                            </a>
                                                        </li>
                                                    {/if}
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- .user-card -->
                            </div>
                            <!-- .card-inner -->
                            {if $user.is_writer || $user.is_editor}
                                <div class="card-inner">
                                    <div class="user-account-info py-0">
                                        <h6 class="overline-title-alt">Outstanding Balance</h6>
                                        <div class="user-balance">
                                            {formatPrice($writer_outstanding_balance, $writer_currency_format)} 
                                        </div>
                                    </div>
                                </div>
                            {/if}
                            <!-- .card-inner -->
                            <div class="card-inner p-0">
                                <ul class="link-list-menu">
                                    <li>
                                        <a {if $_settings == 'general'}class="active"{/if} href="{$base_uri}/settings/general" data-ajax="/settings/general">
                                            <em class="icon ni ni-user-fill-c"></em><span>Personal Infomation</span>
                                        </a>
                                    </li> 

                                    {if $user.is_editor || $user.is_writer}
                                        <li>
                                            <a {if $_settings == 'about'}class="active"{/if} href="{$base_uri}/settings/about" data-ajax="/settings/about">
                                                <em class="icon ni ni-user-list-fill"></em><span>About &amp; Qualifications</span>
                                            </a>
                                        </li>

                                        <li>
                                            <a {if $_settings == 'essays'}class="active"{/if} href="{$base_uri}/settings/essays" data-ajax="/settings/essays">
                                                <em class="icon ni ni-files"></em><span>Essays &amp; Samples</span>
                                            </a>
                                        </li>
                                    {/if}
                                    
                                    <li>
                                        <a {if $_settings == 'password'}class="active"{/if} href="{$base_uri}/settings/password" data-ajax="/settings/password">
                                            <em class="icon ni ni-lock-alt-fill"></em><span>Password</span>
                                        </a>
                                    </li>

                                    <li>
                                        <a {if $_settings == 'sessions'}class="active"{/if} href="{$base_uri}/settings/sessions" data-ajax="/settings/sessions">
                                            <em class="icon ni ni-activity"></em><span>Sessions</span>
                                        </a>
                                    </li>

                                    {hook h='displayProfileNavbar'}
                                </ul>
                            </div>
                            <!-- .card-inner -->
                        </div>
                        <!-- .card-inner-group -->
                    </div>
                    <!-- card-aside -->
                </div>
                <!-- .card-aside-wrap -->
            </div>
            <!-- .card -->
        </div>
        <!-- .nk-block -->
    </div>
{/block}