{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Preferences / <strong class="text-primary small">Writer Pools</strong>
                    </h3> 
                </div>

                <div class="nk-block-head-content">
                    <button type="button" data-toggle="modal" data-url="#addWriterPoolModal" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> <span>Add New Pool</span>
                    </button>
                </div>

            </div>
        </div>

    </div>  

    <!-- Add Writer Pool -->
    <script id="addWriterPoolModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDeliverable" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Writer Pool</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg">
                </div>

                <div class="form-group">
                    <label class="control-label">Base price increase</label>
                    <div class="form-control-wrap w-150px">
                        <div class="form-icon lg form-icon-right">
                            <em class="icon ni ni-percent"></em>
                        </div>
                        <input type="text" class="form-control form-control-lg force-integer" name="base_price">
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label">Order Takes</label>
                    <input type="text" class="form-control w-150px form-control-lg force-integer" name="takes">
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label">Academic Level</label>
                    <select name="academicLevelId" multiple class="form-select" data-ui="lg">
                        {foreach $academicLevels as $academicLevel}
                            <option value="{$academicLevel.id}">{$academicLevel.title}</option>
                        {/foreach}
                    </select>
                </div>

                <div class="form-group">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" name="auto_delivery" id="auto_delivery">
                        <label class="custom-control-label" for="auto_delivery">Auto-delivery of final work</label>
                    </div>
                </div>

                <div class="form-group">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" name="is_default" id="is_default">
                        <label class="custom-control-label" for="is_default">Default writer pool for new accounts</label>
                    </div>
                </div>

                <!-- success -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Deliverable</button>
            </div>
        </form>
    </script>
    <!-- Add Writer Pool -->
{/block}