{if count($disciplines)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx">
                <thead>
                    <tr class="tb-tnx-head">
                        <th>Title</th>
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead> 
                <tbody>
                    {foreach $disciplines as $discipline}
                        <tr class="tb-tnx-item">
                            <td>
                                {$discipline.title}
                            </td>
                            <td class="tb-tnx-action">
                                <a class="btn btn-secondary btn-sm" href="javascript:void(0);" data-toggle="modal" data-url="#editDisciplineModal" data-size="small" data-options='{$discipline|json_encode nofilter}'>
                                    <em class="icon ni ni-edit"></em><span>Edit</span>
                                </a>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No disciplines to show</strong></p>
    </div>
{/if}

<!-- Edit Discipline -->
<script id="editDisciplineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDiscipline" method="POST" autocomplete="off">
        <input type="hidden" name="discipline_id" value="{literal}{{discipline_id}}{/literal}">
        {literal}{{#is_complex_assignment}}{/literal}
        <input type="hidden" name="is_complex_assignment" value="1">
        {literal}{{/is_complex_assignment}}{/literal}

        {literal}{{#is_academic_writing}}{/literal}
        <input type="hidden" name="is_academic_writing" value="1">
        {literal}{{/is_academic_writing}}{/literal}

        {literal}{{#is_programming}}{/literal}
        <input type="hidden" name="is_programming" value="1">
        {literal}{{/is_programming}}{/literal}

        {literal}{{#is_calculations}}{/literal}
        <input type="hidden" name="is_calculations" value="1">
        {literal}{{/is_calculations}}{/literal}

        {literal}{{#is_article_writing}}{/literal}
        <input type="hidden" name="is_article_writing" value="1">
        {literal}{{/is_article_writing}}{/literal}

        <div class="modal-header">
            <h5 class="modal-title">Edit Discipline</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Discipline -->