{if count($deliverables)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx">
                <thead>
                    <tr class="tb-tnx-head">
                        <th>Name</th> 
                        <th>Slug</th>
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach $deliverables as $deliverable}
                        <tr class="tb-tnx-item">
                            <td>{$deliverable.name}</td>
                            <td>{$deliverable.slug}</td>
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$deliverable.deliverable_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$deliverable.deliverable_id}">
                                        <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDeliverableModal" data-size="medium" data-options='{$deliverable|json_encode nofilter}'>
                                            <em class="icon ni ni-edit"></em><span>Edit</span>
                                        </a>
                                        <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="deliverable" data-id="{$deliverable.deliverable_id}">
                                            <i class="fas fa-trash mr5"></i> Delete
                                        </a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No deliverables to show</strong></p>
    </div>
{/if}

<!-- Add Deliverable -->
<script id="addDeliverableModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDeliverable" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Deliverable</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Name</label>
                <input name="name" type="text" class="form-control form-control-lg">
            </div>

            <!-- success -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Deliverable</button>
        </div>
    </form>
</script>
<!-- Add Deliverable -->

<!-- Edit Deliverable -->
<script id="editDeliverableModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDeliverable" method="POST" autocomplete="off">
        <input type="hidden" name="deliverable_id" value="{literal}{{deliverable_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Deliverable</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="name" type="text" class="form-control form-control-lg" value="{literal}{{name}}{/literal}">
            </div>

            <div class="form-group">
                <label class="form-label">Slug</label>
                <input name="slug" type="text" class="form-control form-control-lg" value="{literal}{{slug}}{/literal}">
            </div>

            <!-- success -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Deliverable -->