{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Preferences / <strong class="text-primary small">General</strong>
                    </h3> 
                </div>
                <div class="nk-block-head-content">
                    {if $controller == "disciplines"}
                        <button type="button"  data-toggle="modal" data-url="#addDisciplineModal" data-size="medium" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Discipline</span>
                        </button>
                    {/if}

                    {if $controller == "uploadTypes"}
                        <button type="button"  data-toggle="modal" data-url="#addUploadTypeModal" data-size="small" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Upload Type</span>
                        </button>
                    {/if}

                    {if $controller == "deliverables"}
                        <button type="button"  data-toggle="modal" data-url="#addDeliverableModal" data-size="small" class="btn btn-primary">
                           <em class="icon ni ni-plus"></em> <span>Add Deliverable</span>
                        </button>
                    {/if}
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>
        
        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "disciplines"}active{/if}" href="{$base_uri}/preferences/general/disciplines" data-ajax="/preferences/general/disciplines"> 
                                {if $controller == "disciplines"}<strong class="pr5">Disciplines</strong>{else}Disciplines{/if} 
                            </a>
                        </li>
        
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "uploadTypes"}active{/if}" href="{$base_uri}/preferences/general/upload-types" data-ajax="/preferences/general/upload-types"> 
                                {if $controller == "uploadTypes"}<strong class="pr5">Upload Types</strong>{else}Upload Types{/if} 
                            </a>
                        </li>
        
                        {if $is_programming_enabled || $is_calculations_enabled}
                            <li class="nav-item">
                                <a class="nav-link {if $controller == "deliverables"}active{/if}" href="{$base_uri}/preferences/general/deliverables" data-ajax="/preferences/general/deliverables"> 
                                    {if $controller == "deliverables"}<strong class="pr5">Deliverables</strong>{else}Deliverables{/if} 
                                </a>
                            </li>
                        {/if}
                    </ul>

                    {include file="dashboard/preferences/general/$controller.tpl"}
                </div>
            </div>

        </div>
    </div>  
{/block}