<div class="card-inner-group">
    <div class="card-inner">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h5 class="nk-block-title">English Type</h5>
                    </div>
                    <!-- .nk-block-head-content -->
                    {if count($englishTypes)}
                        <div class="nk-block-head-content">
                            <button type="button" data-toggle="modal" data-size="small" data-url="#addEnglishTypeModal" class="btn btn-primary ml-auto mr0">
                                <em class="icon ni ni-plus"></em> Add English Type
                            </button>
                        </div>
                    {/if}
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>
        </div>

        <div class="nk-block">
            {if count($englishTypes)}
                <table class="table table-tranx">
                    <thead>
                        <tr class="tb-tnx-head">
                            <th class="tb-tnx-info">Title</th>
                            <th class="tb-tnx-info">Date</th>
                            <th class="tb-tnx-action">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $englishTypes as $englishType}
                            <tr class="tb-tnx-item">
                                <td width="40%">{$englishType.title}</td>
                                <td>
                                    <span class="js_moment" data-time="{$englishType.date_add}">{$englishType.date_add}</span>
                                </td>
                                <td class="tb-tnx-action">
                                    <div class="dropdown">
                                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$englishType.english_type_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$englishType.english_type_id}">
                                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editEnglishTypeModal" data-options='{$englishType|json_encode nofilter}'>
                                                <i class="fas fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="englishType" data-id="{$englishType.english_type_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="10%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No data to show</strong></p>
                    <button type="button" data-toggle="modal" data-size="small" data-url="#addEnglishTypeModal" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> Add English Type
                    </button>
                </div>
            {/if}
        </div>
    </div>

    <!-- Add English Type -->
    <script id="addEnglishTypeModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addEnglishType" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add English Type</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg">
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add English Type</button>
            </div>
        </form>
    </script>
    <!-- Add English Type -->

    <!-- Edit English Type -->
    <script id="editEnglishTypeModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editEnglishType" method="POST" autocomplete="off">
            <input type="hidden" name="englishTypeId" value="{literal}{{english_type_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Edit English Type</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Edit English Type -->

    <div class="card-inner">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h5 class="nk-block-title">Target Audience</h5>
                    </div>
                    <!-- .nk-block-head-content -->
                    {if count($targetAudiences)}
                        <div class="nk-block-head-content">
                            <button type="button" data-toggle="modal" data-size="small" data-url="#addTargetAudienceModal" class="btn btn-primary ml-auto mr0">
                                <em class="icon ni ni-plus"></em> Add Target Audience
                            </button>
                        </div>
                    {/if}
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>
        </div>

        <div class="nk-block">
            {if count($targetAudiences)}
                <table class="table table-tranx">
                    <thead>
                        <tr class="tb-tnx-head">
                            <th class="tb-tnx-info">Title</th>
                            <th class="tb-tnx-info">Date</th>
                            <th class="tb-tnx-action">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $targetAudiences as $targetAudience}
                            <tr class="tb-tnx-item">
                                <td width="40%">{$targetAudience.title}</td>
                                <td>
                                    <span class="js_moment" data-time="{$targetAudience.date_add}">{$targetAudience.date_add}</span>
                                </td>
                                <td class="tb-tnx-action">
                                    <div class="dropdown">
                                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$targetAudience.target_audience_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$targetAudience.target_audience_id}">
                                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editTargetAudienceModal" data-options='{$targetAudience|json_encode nofilter}'>
                                                <i class="fas fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="targetAudience" data-id="{$targetAudience.target_audience_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="10%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No data to show</strong></p>
                    <button type="button" data-toggle="modal" data-size="small" data-url="#addTargetAudienceModal" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> Add Target Audience
                    </button>
                </div>
            {/if}
        </div>
    </div>

    <!-- Add Target Audience -->
    <script id="addTargetAudienceModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addTargetAudience" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Target Audience</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg">
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Target Audience</button>
            </div>
        </form>
    </script>
    <!-- Add Target Audience -->

    <!-- Edit Target Audience -->
    <script id="editTargetAudienceModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editTargetAudience" method="POST" autocomplete="off">
            <input type="hidden" name="targetAudienceId" value="{literal}{{target_audience_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Edit Target Audience</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Edit Target Audience -->

    <div class="card-inner">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h5 class="nk-block-title">Writing Tone</h5>
                    </div>
                    <!-- .nk-block-head-content -->
                    {if count($writingTones)}
                        <div class="nk-block-head-content">
                            <button type="button" data-toggle="modal" data-size="small" data-url="#addWritingToneModal" class="btn btn-primary ml-auto mr0">
                                <em class="icon ni ni-plus"></em> Add Writing Tone
                            </button>
                        </div>
                    {/if}
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>
        </div>

        <div class="nk-block">
            {if count($writingTones)}
                <table class="table table-tranx">
                    <thead>
                        <tr class="tb-tnx-head">
                            <th class="tb-tnx-info">Title</th>
                            <th class="tb-tnx-info">Description</th>
                            <th class="tb-tnx-action">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $writingTones as $writingTone}
                            <tr class="tb-tnx-item">
                                <td>{$writingTone.title}</td>
                                <td>
                                    {$writingTone.description}
                                </td>
                                <td class="tb-tnx-action">
                                    <div class="dropdown">
                                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$writingTone.writing_tone_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$writingTone.writing_tone_id}">
                                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editWritingToneModal" data-options='{$writingTone|json_encode nofilter}'>
                                                <i class="fas fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="writingTone" data-id="{$writingTone.writing_tone_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="10%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No data to show</strong></p>
                    <button type="button" data-toggle="modal" data-size="small" data-url="#addWritingToneModal" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> Add Writing Tone
                    </button>
                </div>
            {/if}
        </div>
    </div>

    <!-- Add Writing Tone -->
    <script id="addWritingToneModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addWritingTone" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Writing Tone</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg">
                </div>

                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control js_autosize"></textarea>
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Writing Tone</button>
            </div>
        </form>
    </script>
    <!-- Add Writing Tone -->

    <!-- Edit Writing Tone -->
    <script id="editWritingToneModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editWritingTone" method="POST" autocomplete="off">
            <input type="hidden" name="writingToneId" value="{literal}{{writing_tone_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Edit Writing Tone</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
                </div>

                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control js_autosize">{literal}{{description}}{/literal}</textarea>
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Edit Writing Tone -->

    <div class="card-inner">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h5 class="nk-block-title">Writing Style</h5>
                    </div>
                    <!-- .nk-block-head-content -->
                    {if count($writingStyles)}
                        <div class="nk-block-head-content">
                            <button type="button" data-toggle="modal" data-size="small" data-url="#addWritingStyleModal" class="btn btn-primary ml-auto mr0">
                                <em class="icon ni ni-plus"></em> Add Writing Style
                            </button>
                        </div>
                    {/if}
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>
        </div>

        <div class="nk-block">
            {if count($writingStyles)}
                <table class="table table-tranx">
                    <thead>
                        <tr class="tb-tnx-head">
                            <th class="tb-tnx-info">Title</th>
                            <th class="tb-tnx-info">Description</th>
                            <th class="tb-tnx-action">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $writingStyles as $writingStyle}
                            <tr class="tb-tnx-item">
                                <td>{$writingStyle.title}</td>
                                <td>
                                    {$writingStyle.description}
                                </td>
                                <td class="tb-tnx-action">
                                    <div class="dropdown">
                                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$writingStyle.writing_style_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$writingStyle.writing_style_id}">
                                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editWritingStyleModal" data-options='{$writingStyle|json_encode nofilter}'>
                                                <i class="fas fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="writingStyle" data-id="{$writingStyle.writing_style_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="10%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No data to show</strong></p>
                    <button type="button" data-toggle="modal" data-size="small" data-url="#addWritingStyleModal" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> Add Writing Style
                    </button>
                </div>
            {/if}
        </div>
    </div>

    <!-- Add Writing Style -->
    <script id="addWritingStyleModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addWritingStyle" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Writing Style</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg">
                </div>

                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control js_autosize"></textarea>
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Writing Style</button>
            </div>
        </form>
    </script>
    <!-- Add Writing Style -->

    <!-- Edit Writing Style -->
    <script id="editWritingStyleModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editWritingStyle" method="POST" autocomplete="off">
            <input type="hidden" name="writingStyleId" value="{literal}{{writing_style_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Edit Writing Style</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
                </div>

                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control js_autosize">{literal}{{description}}{/literal}</textarea>
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Edit Writing Style -->

    <div class="card-inner">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h5 class="nk-block-title">Content Feel</h5>
                    </div>
                    <!-- .nk-block-head-content -->
                    {if count($contentFeels)}
                        <div class="nk-block-head-content">
                            <button type="button" data-toggle="modal" data-size="small" data-url="#addContentFeelModal" class="btn btn-primary ml-auto mr0">
                                <em class="icon ni ni-plus"></em> Add Content Feel
                            </button>
                        </div>
                    {/if}
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>
        </div>

        <div class="nk-block">
            {if count($contentFeels)}
                <table class="table table-tranx">
                    <thead>
                        <tr class="tb-tnx-head">
                            <th class="tb-tnx-info">Title</th>
                            <th class="tb-tnx-info">Description</th>
                            <th class="tb-tnx-action">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $contentFeels as $contentFeel}
                            <tr class="tb-tnx-item">
                                <td>{$contentFeel.title}</td>
                                <td>
                                    {$contentFeel.description}
                                </td>
                                <td class="tb-tnx-action">
                                    <div class="dropdown">
                                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$contentFeel.content_feel_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$contentFeel.content_feel_id}">
                                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editContentFeelModal" data-options='{$contentFeel|json_encode nofilter}'>
                                                <i class="fas fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="contentFeel" data-id="{$contentFeel.content_feel_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="10%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No data to show</strong></p>
                    <button type="button" data-toggle="modal" data-size="small" data-url="#addContentFeelModal" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> Add Content Feel
                    </button>
                </div>
            {/if}
        </div>
    </div>

    <!-- Add Content Feel -->
    <script id="addContentFeelModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addContentFeel" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Content Feel</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg">
                </div>

                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control js_autosize"></textarea>
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Content Feel</button>
            </div>
        </form>
    </script>
    <!-- Add Content eel -->

    <!-- Edit Content Feel -->
    <script id="editContentFeelModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editContentFeel" method="POST" autocomplete="off">
            <input type="hidden" name="contentFeelId" value="{literal}{{content_feel_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Edit Content Feel</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
                </div>

                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control js_autosize">{literal}{{description}}{/literal}</textarea>
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Edit Content eel -->
</div>