{if count($contentTypes)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx">
                <thead>
                    <tr class="tb-tnx-head">
                        <th>Title</th>
                        <th>Date</th>
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach $contentTypes as $contentType}
                        <tr class="tb-tnx-item">
                            <td>{$contentType.title}</td>
                            <td>
                                <span class="js_moment" data-time="{$contentType.date_add}">{$contentType.date_add}</span>
                            </td>
                            <td class="tb-tnx-action">
                                <div class="dropdown">
                                    <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$contentType.paper_type_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$contentType.paper_type_id}">
                                        <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editContentTypeModal" data-size="small" data-options='{$contentType|json_encode nofilter}'>
                                            <i class="fas fa-pencil-alt mr5"></i> Edit
                                        </a>
                                        {if $contentType.paper_type_id != '64'}
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="paper_type" data-id="{$contentType.paper_type_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        {/if}
                                    </div>
                                </div>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted py-5"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No paper types to show</strong></p>
    </div>
{/if}

<!-- Add Content Type -->
<script id="addContentTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addPaperType" method="POST" autocomplete="off">
        <input type="hidden" name="is_article_writing" value="1"/>
        <div class="modal-header">
            <h5 class="modal-title">Add Content Type</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg">
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Content Type</button>
        </div>
    </form>
</script>
<!-- Add Content Type -->

<!-- Edit Content Type -->
<script id="editContentTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editPaperType" method="POST" autocomplete="off">
        <input type="hidden" name="paper_type_id" value="{literal}{{paper_type_id}}{/literal}">
        <input type="hidden" name="is_article_writing" value="1"/>
        <div class="modal-header">
            <h5 class="modal-title">Edit Content Type</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Content Type -->