{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">

        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Writer Pools</h3> 
                </div>
                <div class="nk-block-head-content">
                    <a href="{$base_uri}/pools/add" data-ajax="/pools/add" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> <span>Add Pool</span>
                    </a>
                </div>
            </div>
        </div> 

        {if count($writer_pools)}
            <div class="nk-block">
                <table class="nk-tb-list is-separate nk-tb-ulist">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col">
                                <span class="sub-text">Pool Name</span>
                            </th>
                            <th class="nk-tb-col tb-col-xxl">
                                <span class="sub-text">Base Price</span>
                            </th>
                            <th class="nk-tb-col tb-col-xxl">
                                <span class="sub-text">Price/Page</span>
                            </th>
                            <th class="nk-tb-col tb-col-lg">
                                <span class="sub-text">Employees</span>
                            </th>
                            <th class="nk-tb-col tb-col-xxl">
                                <span class="sub-text">Status</span>
                            </th>
                            <th class="nk-tb-col nk-tb-col-tools text-end"></th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $writer_pools as $writer_pool}
                            <tr class="nk-tb-item">
                                <td class="nk-tb-col">
                                    <a href="{$base_uri}/pools/view/{$writer_pool.id}" data-ajax="/pools/view/{$writer_pool.id}" class="project-title">
                                        {if $writer_pool.badge}
                                            <div class="user-avatar sq avatar-img" style="background-image: url('{$writer_pool.badge_url}')"></div>
                                        {else}
                                            <div class="user-avatar sq bg-primary"><span>{$writer_pool.name[0]|strtoupper}</span></div>
                                        {/if}
                                        <div class="project-info">
                                            <h6 class="title">{$writer_pool.name}</h6>
                                        </div>
                                    </a>
                                </td>
                                <td class="nk-tb-col tb-col-xxl">
                                    <span>{$writer_pool.base_price}%</span>
                                </td>
                                <td class="nk-tb-col tb-col-lg">
                                    <span>{formatPrice($writer_pool.price_per_page)}</span>
                                </td>
                                <td class="nk-tb-col tb-col-lg">
                                    {if count($writer_pool.employees)}
                                        <ul class="project-users g-1">
                                            {if isset($writer_pool.employees[0])}
                                                <li>
                                                    {if $writer_pool.employees[0].avatar}
                                                        <div class="user-avatar sm avatar-img" style="background-image: url('{$writer_pool.employees[0].user_picture}')"></div>
                                                    {else}
                                                        <div class="user-avatar sm bg-primary"><span>{$writer_pool.employees[0].first_name[0]|strtoupper}{$writer_pool.employees[0].last_name[0]|strtoupper}</span></div>
                                                    {/if}
                                                </li>
                                            {/if}

                                            {if isset($writer_pool.employees[1])}
                                                <li>
                                                    {if $writer_pool.employees[1].avatar}
                                                        <div class="user-avatar sm avatar-img" style="background-image: url('{$writer_pool.employees[1].user_picture}')"></div>
                                                    {else}
                                                        <div class="user-avatar sm bg-primary"><span>{$writer_pool.employees[1].first_name[0]|strtoupper}{$writer_pool.employees[1].last_name[0]|strtoupper}</span></div>
                                                    {/if}
                                                </li>
                                            {/if}

                                            {if count($writer_pool.employees) > 2}
                                                <li>
                                                    <div class="user-avatar bg-light sm"><span>+{count($writer_pool.employees)-2}</span></div>
                                                </li>
                                            {/if}
                                        </ul>
                                    {else}
                                        <div class="user-avatar bg-light sm"><span>0</span></div>
                                    {/if}
                                </td>
                                <td class="nk-tb-col tb-col-xxl">
                                    {if $writer_pool.status == 'active'}
                                        <span class="badge badge-dot badge-success">Active</span>
                                    {elseif $writer_pool.status == 'disabled'}
                                        <span class="badge badge-dot badge-danger">Disabled</span>
                                    {elseif $writer_pool.status == 'hidden'}
                                        <span class="badge badge-dot badge-info">Hidden</span>
                                    {/if}
                                </td>
                                <td class="nk-tb-col nk-tb-col-tools">
                                    <ul class="nk-tb-actions gx-1">
                                        <li>
                                            <div class="drodown">
                                                <a href="#" class="dropdown-toggle btn btn-sm btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                <div class="dropdown-menu dropdown-menu-end">
                                                    <ul class="link-list-opt no-bdr">
                                                        <li>
                                                            <a href="{$base_uri}/pools/view/{$writer_pool.id}" data-ajax="/pools/view/{$writer_pool.id}">
                                                                <em class="icon ni ni-eye"></em><span>View Pool</span>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="#" class="js_deleter" data-handle="writer-pool" data-id="{$writer_pool.id}">
                                                                <em class="icon ni ni-trash"></em><span>Delete Pool</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>

                <div class="nk-block-between-md mt-3">
                    <div class="g">
                        {$pager nofilter}
                    </div>
                </div><!-- .nk-block-between -->
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                <h6 class="text-dark title mb-3">No pools to show</h6>
            </div>
        {/if}
    </div>
{/block}