{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="wide-lg">

        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"> 
                        Writer Pools › <strong class="text-primary small">Add New</strong>
                    </h3>
                </div>
            </div>
        </div> 

        <div class="nk-block">
            <form class="row g-gs js_ajax-forms" method="POST" data-url="/pools/post" autocomplete="off">
                <div class="col-md-7">
                    <div class="card card-preview">
                        <div class="card-inner">
                            <div class="form-group">
                                <label class="control-label">Name</label>
                                <input type="text" class="form-control form-control-lg" name="name">
                            </div>

                            <div class="form-group">
                                <label class="control-label">Description</label>
                                <input type="text" class="form-control form-control-lg" name="description">
                            </div>

                            <div class="form-group">
                                <label class="control-label">Badge Icon</label>
                                <div class="x-image">
                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="badge" value="">
                                </div>
                                <span class="form-text text-muted">The perfect size for your badge should be (256x256)</span>
                            </div>

                            <div class="form-group form-row">
                                <div class="col-6">
                                    <label class="control-label">Status</label>
                                    <select class="form-select" data-ui="lg" name="status">
                                        <option value="active">Active</option>
                                        <option value="disabled">Disabled</option>
                                        <option value="hidden">Hidden</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <label class="control-label">Order</label>
                                    <input type="text" class="form-control form-control-lg force-integer" name="order" style="width:150px;">
                                </div>
                            </div>

                            <div class="heading-small my-4">Pool Settings</div>

                            <div class="form-group form-row">
                                <div class="col-6">
                                    <label class="control-label">Academic Level</label>
                                    <select class="form-select" data-ui="lg" name="academic_level">
                                        <option value="1">High school</option>
                                        <option value="2">Undergrad. (yrs 1-2)</option>
                                        <option value="3">Undergrad. (yrs 3-4)</option>
                                        <option value="4">Master's</option>
                                        <option value="5">Ph.D.</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <label class="control-label">Writer Category</label>
                                    <select class="form-select" data-ui="lg" name="writer_category">
                                        <option value="2">Best Available</option>
                                        <option value="3">ESL (English Second Language)</option>
                                        <option value="4">ENL (English Native Language)</option>
                                    </select>
                                </div>
                                <div class="col-12">
                                    <small class="form-text text-muted">Employee will view orders in the selected option and below</small>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <div class="col-6">
                                    <label class="control-label">Takes Limits</label>
                                    <input type="number" class="form-control form-control-lg" name="takes">
                                    <small class="form-text text-muted">Set -1 for unlimited.</small>
                                </div>

                                <div class="col-6">
                                    <label class="control-label">Bids Limits</label>
                                    <input type="number" class="form-control form-control-lg" name="bids">
                                    <small class="form-text text-muted">Set -1 for unlimited.</small>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <div class="{if $is_articlewriting_enabled}col-4{else}col-6{/if}">
                                    <label class="control-label">Base Price Increase</label>
                                    <div class="input-group" style="width:150px;">
                                        <input name="base_price" type="text" class="form-control form-control-lg force-integer">
                                        <div class="input-group-append"> 
                                            <span class="input-group-text">%</span> 
                                        </div>
                                    </div>
                                </div>

                                <div class="{if $is_articlewriting_enabled}col-4{else}col-6{/if}">
                                    <label class="control-label">Price Per Page</label>
                                    <div class="input-group" style="width:150px;">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text">$</span> 
                                        </div>
                                        <input name="price_per_page" type="text" class="form-control form-control-lg force-integer">
                                    </div>
                                </div>

                                <div class="{if $is_articlewriting_enabled}col-4{else}col-6{/if}">
                                    <label class="control-label">Price Per Word</label>
                                    <div class="input-group" style="width:150px;">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text">$</span> 
                                        </div>
                                        <input name="price_per_word" type="text" class="form-control form-control-lg force-integer">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-table-row"> 
                                <div> 
                                    <div class="form-control-label h6 fw-500 text-dark">Default</div> 
                                    <div class="form-text nk-block-des">Make this the default writer pool</div> 
                                </div> 
                                <div class="text-right"> 
                                    <label class="switch" for="is_default"> 
                                        <input type="checkbox" name="is_default" id="is_default"> 
                                        <span class="slider round"></span> 
                                    </label> 
                                </div> 
                            </div>

                            <div class="form-group form-table-row"> 
                                <div> 
                                    <div class="form-control-label h6 fw-500 text-dark">Urgent Orders</div> 
                                    <div class="form-text nk-block-des">Enabling this will make all writers in this pool see urgent orders.</div> 
                                </div> 
                                <div class="text-right"> 
                                    <label class="switch" for="urgent_orders"> 
                                        <input type="checkbox" name="urgent_orders" id="urgent_orders"> 
                                        <span class="slider round"></span> 
                                    </label> 
                                </div> 
                            </div>

                            <div class="form-group form-table-row"> 
                                <div> 
                                    <div class="form-control-label h6 fw-500 text-dark">Auto Delivery</div> 
                                    <div class="form-text nk-block-des">This option allows writers in this pool to skip editor process.</div> 
                                </div> 
                                <div class="text-right"> 
                                    <label class="switch" for="auto_delivery"> 
                                        <input type="checkbox" name="auto_delivery" id="auto_delivery"> 
                                        <span class="slider round"></span> 
                                    </label> 
                                </div> 
                            </div>

                            <div class="form-group form-table-row"> 
                                <div> 
                                    <div class="form-control-label h6 fw-500 text-dark">New Customers</div> 
                                    <div class="form-text nk-block-des">Enabling this will allow writers in this pool to view orders from new customers.</div> 
                                </div> 
                                <div class="text-right"> 
                                    <label class="switch" for="new_customers"> 
                                        <input type="checkbox" name="new_customers" id="new_customers"> 
                                        <span class="slider round"></span> 
                                    </label> 
                                </div> 
                            </div>
                            

                            <div class="form-group">
                                <!-- error -->
                                <div class="alert alert-danger alert-fill alert-icon x-hidden m-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                <!-- error -->
                
                                <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden m-0"><em class="icon ni ni-check"></em> <span></span></div>
                                <!-- success -->
                            </div>
                        </div>
                    
                        <div class="card-footer">
                            <button type="submit" class="btn btn-lg btn-block btn-primary">Add New Pool</button>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="card card-preview">
                        <div class="card-inner">
                            <div class="form-group">
                                <label class="control-label">Requirements</label>
                                <textarea rows="8" class="form-control form-control-lg js_autosize" name="requirements" placeholder="Rating 4.7 &#10;Atleast 100 quality pages per month&#10;Always reachable and responsive"></textarea>
                                <span class="form-text text-muted">Enter one per line</span>
                            </div>
                        </div>
                    </div>

                    <div class="card card-preview">
                        <div class="card-inner">
                            <div class="form-group">
                                <label class="control-label">Benefits</label>
                                <textarea rows="8" class="form-control form-control-lg js_autosize" name="benefits" placeholder="Base price increase by 15% &#10;Possiblilty to auto-take upto 10 orders &#10;Auto-delivery of the final work"></textarea>
                                <span class="form-text text-muted">Enter one per line</span>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
{/block}