{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Payments</h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        <div class="nk-block">
            <div class="card card-preview">
                <div class="card-inner">
                    <ul class="nav nav-tabs mt-n3">
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "overview"}active{/if}" href="{$base_uri}/payments/overview" data-ajax="/payments/overview">Overview</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "requests"}active{/if}" href="{$base_uri}/payments/requests" data-ajax="/payments/requests">Payment Requests</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "history"}active{/if}" href="{$base_uri}/payments/history" data-ajax="/payments/history">Payment History</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        {if $sub_view == "overview"}
                            <form method="GET" class="row" autocomplete="off">
                                <input type="hidden" name="page" value="{$selected_page}"/>
                                <div class="form-group col-md-3">
                                    <div class="form-control-wrap">
                                        <div class="form-icon md form-icon-left">
                                            <em class="icon ni ni-calendar"></em>
                                        </div>
                                        <input type="text" class="form-control form-control-md date-picker" data-date-format="dd-mm-yyyy" placeholder="From" value="{$date_from}" name="from">
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="form-control-wrap">
                                        <div class="form-icon md form-icon-left">
                                            <em class="icon ni ni-calendar"></em>
                                        </div>
                                        <input type="text" class="form-control form-control-md date-picker" data-date-format="dd-mm-yyyy" placeholder="To" value="{$date_to}" name="to">
                                    </div>
                                </div>
                                <div class="form-group col-md-2">
                                    <select name="employee" placeholder="Employee" class="form-select" data-ui="md">
                                        <option value="all" {if $employee_group == "all"}selected=""{/if}>All</option>
                                        <option value="writer" {if $employee_group == "writer"}selected=""{/if}>Writer</option>
                                        <option value="editor" {if $employee_group == "editor"}selected=""{/if}>Editor</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <button type="submit" class="btn btn-md btn-primary">
                                        <em class="icon ni ni-search"></em> <span>Search</span>
                                    </button>
                                </div>
                            </form>

                            {if count($payment_overview)}
                                <div class="border rounded">
                                    <table class="table table-orders is-compact">
                                        <thead class="tb-odr-head">
                                            <tr class="tb-odr-item nk-tb-head">
                                                <th class="tb-odr-info">EMPLOYEE</th>
                                                <th class="tb-odr-info">EMAIL</th>
                                                <th class="tb-odr-info">TASK</th>
                                                <th class="tb-odr-info">TOTAL</th>
                                            </tr>
                                        </thead>
                                        <tbody class="tb-odr-body">
                                            {foreach $payment_overview as $overview}
                                                <tr class="tb-odr-item">
                                                    <td class="tb-odr-info">
                                                        <strong>
                                                            {if $overview.employee_group == "2"}
                                                                Editor
                                                            {elseif $overview.employee_group == "3"}
                                                                Writer
                                                            {elseif $overview.employee_group == "4"}
                                                                Order Manager
                                                            {/if}
                                                            <a target="_blank" href="{$base_uri}/employees/edit/{$overview.employee_id}" data-ajax="/employees/edit/{$overview.employee_id}">{$overview.first_name} {$overview.last_name}</a>
                                                        </strong>
                                                    </td>
                                                    <td class="tb-odr-info">{$overview.email}</td>
                                                    <td class="tb-odr-info">
                                                        {pluralize('order', $overview.total_orders)} 
            
                                                        {if $overview.total_orders || $overview.total_words}
                                                            {if $overview.total_pages} 
                                                                - <strong>{pluralize('page', $overview.total_pages)}</strong>
                                                            {/if} 
            
                                                            {if $overview.total_words} 
                                                                - <strong>{pluralize('word', $overview.total_words)}</strong>
                                                            {/if} 
                                                        {/if}
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        <strong class="text-success">{formatPrice($overview.employee_pay, $currencyFormat)}</strong>
                                                    </td>
                                                </tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>
        
                                <div class="nk-block-between-md mt-3">
                                    <div class="g">
                                        {$pager nofilter}
                                    </div>
                                </div><!-- .nk-block-between -->
                            {else}
                                <div class="text-center x-muted py-4"> 
                                    {include file='__svg_icons.tpl' icon="transaction" class="mb-3" width="100px" height="100px"}
                                    <h6 class="text-dark title mb-3">No payments to show</h6>
                                </div>
                            {/if}

                        {elseif $sub_view == "requests"}

                            {if count($requests)}
                                <div class="border rounded">
                                    <table class="table table-orders is-compact">
                                        <thead class="tb-odr-head">
                                            <tr class="tb-odr-item nk-tb-head">
                                                <th class="tb-odr-info">EMPLOYEE</th>
                                                <th class="tb-odr-info">DATE</th>
                                                <th class="tb-odr-info">DONE</th>
                                                <th class="tb-odr-info">APPROVED</th>
                                                <th class="tb-odr-info">TOTAL</th>
                                                <th class="tb-odr-info">ORDERS</th>
                                                <th class="tb-odr-action">ACTIONS</th>
                                            </tr>
                                        </thead>
                                        <tbody class="tb-odr-body">
                                            {foreach $requests as $request}
                                                <tr class="tb-odr-item">
                                                    <td class="tb-odr-info">
                                                        <strong>
                                                            {if $request.employee.employee_group == "2"}
                                                                Editor
                                                            {elseif $request.employee.employee_group == "3"}
                                                                Writer
                                                            {elseif $request.employee.employee_group == "4"}
                                                                Order Manager
                                                            {/if}
                                                            <a target="_blank" href="{$base_uri}/employees/edit/{$request.employee.id}">{$request.employee.first_name} {$request.employee.last_name}</a>
                                                        </strong>
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        <span class="js_moment" data-time="{$request.date_add}">{$request.date_add}</span>
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        <strong class="text-success">{formatPrice($request.total_done_pay, $currencyFormat)}</strong>
                                                    <td class="tb-odr-info">
                                                        <strong class="text-success">{formatPrice($request.total_completed_pay, $currencyFormat)}</strong>
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        <strong class="text-success">{formatPrice($request.total_pay, $currencyFormat)}</strong>
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        <button class="btn btn-secondary btn-dim btn-sm dropdown-toggle" type="button" data-toggle="modal" data-size="large" data-url="/user/payment-requests/{$request.payment_request_id}">
                                                            <em class="icon ni ni-bag-fill"></em><span>Show Orders</span>
                                                        </button>
                                                    </td>
                                                    <td class="tb-odr-action">
                                                        <div class="dropdown">
                                                            <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$request.payment_request_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                <span>Actions</span><em class="icon ni ni-chevron-down"></em>
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$request.payment_request_id}">
                                                                <a href="javascript:void(0);" class="dropdown-item js_admin-withdraw" data-handle="approve" data-id="{$request.payment_request_id}" data-title="Mark as Paid">
                                                                    <i class="icon ni ni-check mr5"></i> <span>Mark as Paid</span>
                                                                </a>
                                                                <a href="#" class="dropdown-item" data-toggle="modal" data-size="small" data-url="#modalMpesaPayment" data-options='{literal}{{/literal}"user_phone":"{$request.employee.phone}","request_id":{$request.payment_request_id},"amount":{$request.request_amount_intl}{literal}}{/literal}' data-title="Mpesa Payment">
                                                                    <i class="icon ni ni-mobile mr5"></i> <span>Mpesa Payment</span>
                                                                </a>
                                                                <a class="dropdown-item" href="{$base_uri}/payments/download/{$request.payment_request_id}">
                                                                    <i class="icon ni ni-download mr5"></i> <span>Download Invoice</span>
                                                                </a>
                                                                <a href="javascript:void(0);" class="dropdown-item js_admin-withdraw" data-handle="decline" data-id="{$request.payment_request_id}" data-title="Decline Request">
                                                                    <i class="icon ni ni-cross mr5"></i> <span>Decline Request</span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>
        
                                <div class="nk-block-between-md mt-3">
                                    <div class="g">
                                        {$pager nofilter}
                                    </div>
                                </div><!-- .nk-block-between -->
                            {else}
                                <div class="text-center x-muted py-4"> 
                                    {include file='__svg_icons.tpl' icon="transaction" class="mb-3" width="100px" height="100px"}
                                    <h6 class="text-dark title mb-3">No payments to show</h6>
                                </div>
                            {/if}

                        {elseif $sub_view == "history"}
                            {if count($requests) > 0}
                                <div class="border rounded">
                                    <table class="table table-orders is-compact">
                                        <thead class="tb-odr-head">
                                            <tr class="tb-odr-item nk-tb-head">
                                                <th class="tb-odr-info">EMPLOYEE</th>
                                                <th class="tb-odr-info">PAID AT</th>
                                                <th class="tb-odr-info">TOTAL</th>
                                                <th class="tb-odr-info">ORDERS</th>
                                                <th class="tb-odr-info">STATUS</th>
                                                <th class="tb-odr-action">ACTIONS</th>
                                            </tr>
                                        </thead>
                                        <tbody class="tb-odr-body">
                                            {foreach $requests as $request}
                                                <tr class="tb-odr-item {if $request.status == "-1"}danger{/if}">
                                                    <td class="nk-tb-col text-left fw-bold">
                                                        {if $request.employee_group == "2"}
                                                            Editor
                                                        {elseif $request.employee_group == "3"}
                                                            Writer
                                                        {elseif $request.employee_group == "4"}
                                                            Order Manager
                                                        {/if} 
                                                        <a class="{if $request.status == "-1"}text-danger{else}link link-primary{/if}" href="{$base_uri}/employees/edit/{$request.user_id}" target="_blank">
                                                            {$request.first_name} {$request.last_name}
                                                        </a>
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        {if $request.status == "-1"} 
                                                            <strong class="text-danger">Declined</strong>
                                                        {else} 
                                                            <span class="js_moment" data-time="{$request.paid_at}">{$request.paid_at}</span> 
                                                        {/if}
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        <strong class="{if $request.status == "-1"}text-danger{else}text-success{/if}">{formatPrice($request.total_pay, $currencyFormat)}</strong>
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        <button class="btn btn-sm btn-secondary btn-dim dropdown-toggle" type="button" data-toggle="modal" data-size="large" data-url="/user/payment-requests/{$request.payment_request_id}">
                                                            <em class="icon ni ni-bag-fill"></em><span>Show Orders</span>
                                                        </button>
                                                    </td>
                                                    <td class="tb-odr-info">
                                                        {if $request.status == "0"}
                                                            <span class="badge badge-dot badge-warning">Pending</span>
                                                        {elseif $request.status == "1"}
                                                            <span class="badge badge-dot badge-success">Paid</span>
                                                        {elseif $request.status == "-1"}
                                                            <span class="badge badge-dot badge-danger">Declined</span>
                                                        {/if}
                                                    </td>
                                                    <td class="tb-odr-action">
                                                        <a href="{$base_uri}/payments/download/{$request.payment_request_id}" data-toggle="tooltip" data-placement="top" class="btn btn-sm btn-dim btn-primary" data-title="Download Invoice"> 
                                                            <i class="icon ni ni-download"></i> <span>Invoice</span>
                                                        </a>
                                                    </td>
                                                </tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>
        
                                <div class="nk-block-between-md mt-3">
                                    <div class="g">
                                        {$pager nofilter}
                                    </div>
                                </div><!-- .nk-block-between -->
                            {else}
                                <div class="text-center x-muted py-4"> 
                                    {include file='__svg_icons.tpl' icon="transaction" class="mb-3" width="100px" height="100px"}
                                    <h6 class="text-dark title mb-3">No payments to show</h6>
                                </div>
                            {/if}
                        {/if}
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Mpesa Payment -->
    <script id="modalMpesaPayment" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/mpesa_payout/makePayment" method="POST" autocomplete="off">
            <input type="hidden" name="request_id" value="{literal}{{request_id}}{/literal}">
            <div class="modal-header">
                <h5 class="modal-title">Mpesa Payment</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label" for="phone-no">Phone Number</label>
                    <input type="text" name="js_user_phone" class="form-control form-control-lg js_phone" placeholder="Enter mobile" autocomplete="off" value="{literal}{{user_phone}}{/literal}">
                    <input type="hidden" name="phone_number" class="form-control js_phone_number" autocomplete="off" readonly="true" value="{literal}{{user_phone}}{/literal}">
                </div>

                <div class="form-group">
                    <label class="control-label text-left">Amount</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">KES</span> 
                        </div>
                        <input name="amount" type="text" class="form-control form-control-lg force-integer" value="{literal}{{amount}}{/literal}">
                    </div>
                </div>
                
                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Make Payment</button>
            </div>
        </form>
    </script>
    <!-- Mpesa Payment -->

{/block}