{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title page-title">{$sub_view|capitalize} Orders</h4>
                    {if $sub_view != ""}
                        {assign var="blockDes" value="{$sub_view|capitalize} order"}
                        <div class="nk-block-des text-soft"><p>You have total {pluralize($blockDes, $total_orders)}.</p></div>
                    {/if}
                </div><!-- .nk-block-head-content -->

                {if $user.is_admin || $user.is_sub_admin}
                    {include file='dashboard/orders/_filters.orders.tpl'}
                {/if}
            </div><!-- .nk-block-between -->
        </div><!-- .nk-block-head -->

        <div class="nk-block">
            
            {if $user.employee_status == "4" || $user.employee_status == "5"} 
                <div class="wide-md">
                    <div class="alert alert-info alert-icon">
                        <em class="icon ni ni-alert-circle"></em> <strong>Hi {$user.first_name|ucfirst}, you've got {pluralize('order', count($orders))}, but you can't see them</strong>. Kindly change your <a href="#" data-toggle="modal" data-url="#profileAccountWorkingStatus" data-size="small" class="alert-link">working status</a> to view the orders.
                    </div>
                </div>
            {else}
                {if count($orders) || count($urgentOrders)}
                    <div class="nk-tb-list is-separate is-medium mb-3">
                        <div class="nk-tb-item nk-tb-head">
                            {if $user.is_admin || $user.is_sub_admin}
                                <div class="nk-tb-col nk-tb-col-check tb-col-md">
                                    <div class="custom-control custom-control-sm custom-checkbox notext">
                                        <input type="checkbox" class="custom-control-input js_select-all" name="select_all" id="oid">
                                        <label class="custom-control-label" for="oid"></label>
                                    </div>
                                </div>
                            {/if}
                            <div class="nk-tb-col">
                                <span>Order ID</span>
                            </div>
                            <div class="nk-tb-col tb-col-md">
                                <span>Topic Title</span>
                            </div>
                            <div class="nk-tb-col tb-col-md">
                                <span>Discipline</span>
                            </div>
                            <div class="nk-tb-col">
                                <span>Deadline</span>
                            </div>
                            <div class="nk-tb-col">
                                <span>Task</span>
                            </div>

                            {if $show_client_cost}
                                <div class="nk-tb-col tb-col-md">
                                    <span>COST</span>
                                </div>
                            {/if}

                            {if $user.is_admin || $user.is_sub_admin}
                                <div class="nk-tb-col nk-tb-col-tools">
                                    <ul class="nk-tb-actions gx-1 my-n1">
                                        <li>
                                            <a href="javascript:void(0);" class="btn btn-icon btn-trigger mr-n1 js_bulk-actions">
                                                <em class="icon ni ni-more-h"></em>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            {else}
                                <div class="nk-tb-col nk-tb-col-tools">&nbsp;</div>
                            {/if}
                        </div>

                        {if count($urgentOrders)}
                            {foreach $urgentOrders as $order}
                                {include file='dashboard/orders/_order.available.tpl'}
                            {/foreach}

                            <div class="my-4"></div>
                        {/if} 
                        

                        {foreach $orders as $order}
                            {include file='dashboard/orders/_order.available.tpl'}
                        {/foreach}
                    </div>

                    <div class="nk-block-between-md g-3">
                        <div class="g">
                            {$pager nofilter}
                        </div>
                    </div><!-- .nk-block-between -->
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <h6 class="text-dark title mb-3">No orders to show</h6>
                    </div>
                {/if}
            {/if}

        </div>
    </div>
{/block}
