<div class="nk-tb-item">
    {if $user.is_admin || $user.is_sub_admin}
        <div class="nk-tb-col nk-tb-col-check tb-col-md">
            <div class="custom-control custom-control-sm custom-checkbox notext">
                <input name="bulk_action" value="{$order.id}" type="checkbox" class="custom-control-input" id="oid-{$order.id}">
                <label class="custom-control-label tb-lead" for="oid-{$order.id}"></label>
            </div>
        </div>
    {/if}

    <div class="nk-tb-col">
        <span class="tb-lead">
            <a class="text-primary" href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}">#{$order.referenceId}</a>
        </span>
        {if $order.isNewCustomer}
            <span class="badge badge-dim badge-secondary">New Customer</span>
        {/if}
    </div>
    
    {if $order.isProgramming || $order.isCalculations}
        <div class="nk-tb-col tb-col-md">
            <span class="badge badge-sm badge-dot has-bg {if $order.isProgramming}badge-success{else}badge-info{/if}">{$order.serviceTypeTitle}</span>
        </div>
        <div class="nk-tb-col tb-col-md">
            <span class="tb-sub">{$order.topicCategory}</span>
            <small class="d-block tb-sub text-muted">{$order.sizeTitle}</small>
        </div>
    {elseif $order.isArticleWriting}
        <div class="nk-tb-col tb-col-md">
            <span class="tb-sub">{$order.title}</span>
        </div>
        <div class="nk-tb-col tb-col-md">
            <span class="tb-sub">{$order.contentTypeTitle}</span>
            <small class="d-block tb-sub text-muted">{$order.disciplineTitle}</small>
        </div>
    {else}
        <div class="nk-tb-col tb-col-md">
            <span  data-toggle="tooltip" title="{$order.title}" class="tb-sub">{$order.titleTruncated}</span>
        </div>
        <div class="nk-tb-col tb-col-md">
            <span class="tb-sub">{$order.topicCategory}</span>
            <small class="d-block tb-sub text-muted">{$order.academicLevelTitle}</small>
        </div>
    {/if}
    <div class="nk-tb-col">
        <span class="tb-sub">
            <span class="badge badge-dim badge-{$order.deadlineHighlight} text-{$order.deadlineHighlight}">
                <em class="icon ni ni-clock"></em><span>{$order.timeLeft}</span> 
            </span>
        </span>
    </div>
    {if $order.isProgramming || $order.isCalculations}
        <div class="nk-tb-col">
            <span class="tb-sub">{$order.sizeTitle}</span>
        </div>
    {elseif $order.isArticleWriting}
        <div class="nk-tb-col">
            <span class="tb-sub">{pluralize('word', $order.words)}</span>
        </div>
    {else}
        <div class="nk-tb-col">
            <span class="tb-sub">
                {if $order.pages} {pluralize('page', $order.pages)} {/if} 
                {if $order.slides}, {pluralize('slide', $order.slides)} {/if} 
                {if $order.charts} {pluralize('chart', $order.charts)} {/if} 
                {if $order.excel_sheets} {pluralize('excel sheet', $order.excel_sheets)} {/if} 
            </span>
        </div>
    {/if}

    {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
        <div class="nk-tb-col tb-col-md">
            <span class="tb-lead">{$order.priceFormatted}</span>
        </div>
    {elseif $user.is_writer}
        <div class="nk-tb-col tb-col-md">
            <span class="tb-lead">{$order.writerPayFormatted}</span>
        </div>
    {elseif $user.is_editor}
        <div class="nk-tb-col tb-col-md">
            <span class="tb-lead">{$order.editorPayFormatted}</span>
        </div>
    {/if}
    
    {if $user.is_admin || $user.is_sub_admin}
        <div class="nk-tb-col nk-tb-col-tools">
            <ul class="nk-tb-actions gx-1">
                <li class="nk-tb-action-hidden">
                    <a href="javascript:void(0);" class="btn btn-icon btn-trigger btn-tooltip js_deleter" data-handle="order" data-id="{$order.id}" data-original-title="Move to Trash">
                        <em class="icon ni ni-trash"></em>
                    </a>
                </li>
                <li class="nk-tb-action-hidden">
                    <a href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}" class="btn btn-icon btn-trigger btn-tooltip" data-original-title="View Order">
                        <em class="icon ni ni-eye"></em>
                    </a>
                </li>
                <li>
                    <div class="drodown mr-n1">
                        <a href="javascript:void(0);" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown">
                            <em class="icon ni ni-more-h"></em>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <ul class="link-list-opt no-bdr">
                                <li>
                                    <a href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}">
                                        <em class="icon ni ni-eye"></em><span>Order Details</span>
                                    </a>
                                </li>
                                
                                <li>
                                    <a href="{$base_uri}/order/{$order.id}/edit" data-ajax="/order/{$order.id}/edit">
                                        <em class="icon ni ni-edit"></em><span>Edit Order</span>
                                    </a>
                                </li>

                                {* Unpaid *}
                                {if $order.status == "0"}
                                    <li>
                                        <a href="javascript:void(0);" class="js_mark-as-paid" data-oid="{$order.id}">
                                            <em class="icon ni ni-money"></em><span>Mark as Paid</span>
                                        </a>
                                    </li>
                                {/if}

                                {if $order.status == "6" || $order.status == "7" || $order.status == "8"}
                                    <li>
                                        <a href="javascript:void(0);" class="js_deliver-order" data-oid="{$order.id}">
                                            <em class="icon ni ni-truck"></em><span>Deliver Order</span>
                                        </a>
                                    </li>
                                {/if}

                                {if $order.isPaid && $order.status != "10" && $order.status != "1" && $order.status != "9"}
                                    <li>
                                        <a href="{$base_uri}/order/{$order.id}/assign" data-ajax="/order/{$order.id}/assign">
                                            <em class="icon ni ni-user-check"></em><span>Assign Order</span>
                                        </a>
                                    </li>
                                {/if}

                                {if $order.status == "8"}
                                    <li>
                                        <a href="javascript:void(0);" data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#reviseOrderModal">
                                            <i class="icon ni ni-repeat-v fa-fw mr5"></i> <span>Revise Order</span>
                                        </a>
                                    </li>
                                {/if}

                                <li>
                                    <a href="javascript:void(0);" class="js_deleter" data-handle="order" data-id="{$order.id}">
                                        <em class="icon ni ni-trash"></em><span>Move to Trash</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    {else}
        <div class="nk-tb-col nk-tb-col-tools">
            <ul class="nk-tb-actions gx-1">
                <li>
                    <a href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}" class="btn btn-dim btn-sm btn-primary">
                        View
                    </a>
                </li>
            </ul>
        </div>
    {/if}
</div>