{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">

        {if $sub_view == "instructions" || $sub_view == "files" || $sub_view == "messages" || $sub_view == "history"}
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between g-3">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">Orders &rsaquo; <strong class="text-primary small">#{$order.referenceId}</strong></h3>
                        <div class="nk-block-des text-soft mt-3">
                            <ul class="list-inline">
                                {if $is_cancelled_order}
                                    <li>
                                        <span class="dot bg-danger d-mb-none"></span>
                                        <span class="badge badge-sm badge-dot has-bg badge-danger d-none d-mb-inline-flex">Cancelled</span>
                                    </li>
                                {else}
                                    <li>
                                        <span class="dot bg-{$order.statusBadge} d-mb-none"></span>
                                        <span class="badge badge-sm badge-dot has-bg badge-{$order.statusBadge} d-none d-mb-inline-flex">{$order.statusTitle}</span>
                                    </li>
                                    {if $order.isNewCustomer}
                                        <li>
                                            <span class="badge badge-sm badge-dot has-bg badge-secondary">New Customer</span>
                                        </li>
                                    {/if}
                                {/if}
                                
                            </ul>
                        </div>
                    </div> 

                    {if !$is_cancelled_order}
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1" data-target="orderMenu">
                                    <em class="icon ni ni-menu-alt-r"></em>
                                </a>

                                <div class="toggle-expand-content" data-content="orderMenu">
                                    <ul class="nk-block-tools g-3">
                                        {* Writer *}
                                        {if $user.is_writer}

                                            {* Order published || Inquiry published || Writer Accepted || Inquiry Writer Accepted*}
                                            {if $order.status == "19" || 
                                                $order.status == "16" || 
                                                $order.status == "7"  ||
                                                $order.status == "17" 
                                            }

                                                {if $can_take && !$has_bidded}
                                                    <li>
                                                        <button data-toggle="tooltip" title="Take the order if you are ready to execute this order for {$order.writerPayFormatted}" data-oid="{$order.id}" class="btn btn-success js_take-order"> 
                                                            <em class="icon ni ni-check"></em> <span class="d-none d-md-block">Take Order</span>
                                                        </button>
                                                    </li>
                                                {elseif $has_bidded}
                                                    <li>
                                                        <button data-toggle="tooltip" data-bid="{$bid.bid_id}" data-title="The bid you have placed equals to - ${$bid.amount} on {$bid.date_add}" data-oid="{$order.id}" class="btn btn-warning js_remove-bid">
                                                            <em class="icon ni ni-cross"></em> <span class="d-none d-md-block">Remove Bid</span>
                                                        </button>
                                                    </li>
                                                {elseif $can_bid}
                                                    <li>
                                                        <button data-toggle="tooltip" title="Place your bid if you are ready to execute this order for {$order.writerPayFormatted}" data-oid="{$order.id}" class="btn btn-success js_place-bid">
                                                            <em class="icon ni ni-check"></em> <span class="d-none d-md-block">Place Bid</span>
                                                        </button>
                                                    </li>
                                                {/if}

                                            {/if}

                                            {* Writer Assigned *}
                                            {if $order.status == "6"}

                                                {if !$order.isWriterConfirmed}
                                                    <li>
                                                        <button data-toggle="tooltip" title="I will work on the order" class="btn btn-success js_confirm-order" data-action="accept" data-oid="{$order.id}">
                                                            <em class="icon ni ni-check fa-fw mr5"></em> <span class="d-none d-md-block">Accept</span>
                                                        </button>
                                                    </li>

                                                    <li>
                                                        <button data-toggle="tooltip" title="I cannot work on the order at the moment" class="btn btn-danger js_confirm-order" data-action="decline" data-oid="{$order.id}">
                                                            <em class="icon ni ni-cross fa-fw mr5"></em> <span class="d-none d-md-block">Decline</span>
                                                        </button>
                                                    </li>
                                                {else}
                                                    {if $order.canSubmitOrder}
                                                        {if !$editor_account_enabled}
                                                            <li>
                                                                <button data-toggle="tooltip" title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                                                    <em class="icon ni ni-truck fa-fw mr5"></em> <span>Deliver Order</span>
                                                                </button>
                                                            </li>
                                                        {else}
                                                            <li>
                                                                <button data-toggle="tooltip" title="I have completed the order" class="btn btn-success js_complete-order" data-oid="{$order.id}">
                                                                    <em class="icon ni ni-truck fa-fw mr5"></em> <span class="d-none d-md-block">Mark as Complete</span>
                                                                </button>
                                                            </li>
                                                        {/if}
                                                    {/if}
                                                {/if}

                                            {/if}

                                            {* Revision *}
                                            {if $order.status == "14" && $order.canSubmitOrder}
                                                {if !$editor_account_enabled}
                                                    <li>
                                                        <button data-toggle="tooltip" title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                                            <em class="icon ni ni-truck fa-fw mr5"></em> <span class="d-none d-md-block">Deliver Order</span>
                                                        </button>
                                                    </li>
                                                {else}
                                                    <li>
                                                        <button data-toggle="tooltip" title="I have completed the order" class="btn btn-success js_complete-order" data-oid="{$order.id}">
                                                            <em class="icon ni ni-truck fa-fw mr5"></em> <span class="d-none d-md-block">Mark as Complete</span>
                                                        </button>
                                                    </li>
                                                {/if}
                                            {/if}
                                            
                                        {/if}

                                        {* Editor *}
                                        {if $user.is_editor}
                                            {* Done *}
                                            {if $order.status == "8" && !$order.isEditorAssigned}
                                                <li>
                                                    <button data-toggle="tooltip" title="Take and work on this order" class="btn btn-success js_take-order" data-oid="{$order.id}">
                                                        <em class="icon ni ni-check fa-fw mr5"></em> <span class="d-none d-md-block">Take Order</span>
                                                    </button>
                                                </li>
                                            {/if}

                                            {* In Progress *}
                                            {if $order.status == "8" && $order.isEditorAssigned}
                                                <li>
                                                    <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#reviseOrderModal" data-title="Send order to Revision" class="btn btn-danger" data-oid="{$order.id}">
                                                        <em class="icon ni ni-calendar fa-fw mr5"></em> <span class="d-none d-md-block">Revise Order</span>
                                                    </button>
                                                </li>
                                                
                                                <li>
                                                    <button data-toggle="tooltip" title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                                        <em class="icon ni ni-truck fa-fw mr5"></em> <span class="d-none d-md-block">Deliver Order</span>
                                                    </button>
                                                </li>
                                            {/if}
                                        {/if}

                                        {* Admin *}
                                        {if $user.is_admin || $user.is_sub_admin}

                                            {* Unpaid *}
                                            {if $order.status == "0"}
                                                <li>
                                                    <button data-toggle="tooltip" title="Make this order available to writers" data-oid="{$order.id}" class="btn btn-primary js_mark-as-paid">
                                                        <em class="icon ni ni-money fa-fw mr5"></em> <span class="d-none d-md-block">Mark as Paid</span>
                                                    </button>
                                                </li>
                                            {/if}

                                            {if $order.status == "6" || $order.status == "7" || $order.status == "8"}
                                                <li>
                                                    <button data-toggle="tooltip" title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                                        <em class="icon ni ni-truck fa-fw mr5"></em> <span class="d-none d-md-block">Deliver Order</span>
                                                    </button>
                                                </li>
                                            {/if}

                                            {if $order.status == "8"}
                                                <li>
                                                    <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#reviseOrderModal" data-title="Send order to Revision" class="btn btn-danger" data-oid="{$order.id}">
                                                        <em class="icon ni ni-calendar fa-fw mr5"></em> <span class="d-none d-md-block">Revise Order</span>
                                                    </button> 
                                                </li>
                                            {/if}

                                            {if $sub_view != "assign"}
                                                {if $order.isPaid && $order.status != "10" && $order.status != "1" && $order.status != "9"}
                                                    <li>
                                                        <a href="{$base_uri}/order/{$order.id}/assign" data-ajax="/order/{$order.id}/assign" class="btn btn-primary">
                                                            <em class="icon ni ni-user-check fa-fw mr5"></em> <span class="d-none d-md-block">Assign Order</span>
                                                        </a>
                                                    </li>
                                                {/if}
                                            {/if}

                                        {/if}

                                        {if $user.is_admin || $user.is_sub_admin}
                                            <li>
                                                <div class="drodown">
                                                    <button type="button" class="btn btn-secondary dropdown-toggle dropdown-toggle-split" data-toggle="dropdown">
                                                        <span>Actions</span> <em class="icon ni ni-chevron-down"></em>
                                                    </button>
                                                    
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <ul class="link-list-plain no-bdr">

                                                            {if $sub_view != "assign"}
                                                                <li>
                                                                    <a href="{$base_uri}/order/{$order.id}/edit" class="dropdown-item pointer">
                                                                        <em class="icon ni ni-edit fa-fw mr5"></em> <span>Edit Order</span>
                                                                    </a>
                                                                </li>
                                                            {/if}

                                                            {if $order.isArticleWriting}
                                                                <li>
                                                                    <a href="javascript:void(0);" data-toggle="modal" data-url="#duplicateOrderModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' class="dropdown-item pointer">
                                                                        <em class="icon ni ni-copy fa-fw mr5"></em> <span>Duplicate Order</span>
                                                                    </a>
                                                                </li>
                                                            {else}
                                                                <li>
                                                                    <a href="javascript:void(0);" class="dropdown-item pointer js_reorder" data-oid="{$order.id}">
                                                                        <em class="icon ni ni-redo fa-fw mr5"></em> <span>Re-order</span>
                                                                    </a>
                                                                </li>
                                                            {/if}

                                                            {hook h='displayOrderActions' order_id=$order.id}
                                                        </ul>
                                                    </div>
                                                </div>
                                            </li>
                                        {else}
                                            {hook h='displayOrderActions' order_id=$order.id}
                                        {/if}
                                    </ul>
                                </div>
                            </div>
                        </div>
                    {/if}
                </div>
            </div>

            <div class="nk-block">
                <div class="card card-bordered">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a data-toggle="tab" class="nav-link {if $sub_view == "instructions"} active {/if}" href="#instructions">
                                <em class="icon ni ni-info"></em><span>Instructions</span>
                            </a>
                        </li>
                        
                        {if !$is_cancelled_order}
                            {if $order.progressiveDeliveryHidden}
                                <li class="nav-item">
                                    <a data-toggle="tab" class="nav-link {if $sub_view == "#progressive-delivery"} active {/if}" href="#progressive-delivery">
                                        <em class="icon ni ni-calendar"></em><span>Progressive Delivery</span>
                                    </a>
                                </li>
                            {/if}

                            <li class="nav-item">
                                <a data-toggle="tab" class="nav-link {if $sub_view == "files"} active {/if}" href="#files">
                                    <em class="icon ni ni-file-text"></em><span>All Files {if $order.allFilesCount} ({$order.allFilesCount}) {/if}</span>
                                </a>
                            </li>
                            
                            {if $can_view_messages}
                                <li class="nav-item">
                                    <a data-toggle="tab" class="nav-link {if $sub_view == "messages"} active {/if}" href="#messages">
                                        <em class="icon ni ni-chat"></em><span>Messages {if $order.allMessagesCount} ({$order.allMessagesCount}) {/if}</span>
                                    </a>
                                </li>
                            {/if}

                            {if count($orderHistory)}
                                <li class="nav-item">
                                    <a data-toggle="tab" class="nav-link" href="#order-history">
                                        <em class="icon ni ni-activity"></em><span>Order History</span>
                                    </a>
                                </li>
                            {/if}
                        {/if}
                    </ul>

                    <div class="card-inner p-3">
                        <!-- tabs content -->
                        <div class="tab-content">

                            <!-- instructions tab -->
                            <div class="tab-pane {if $sub_view == "instructions"}active{/if}" id="instructions">

                                <div class="nk-data data-list border rounded overflow-hidden mt-0">
                                    <div class="oinfo__data-item">
                                        <div class="oinfo__data-col">
                                            <span class="oinfo__data-label">Type of Service:</span>
                                            <span class="oinfo__data-value">{$order.serviceTypeTitle}</span>
                                        </div>
                                    </div>
                                    
                                    {if $order.trackingId && ($user.is_admin || $user.is_sub_admin)}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Tracking ID:</span>
                                                <span class="oinfo__data-value">{$order.trackingId}</span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if $order.isAcademicWriting}
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">{if $order.ukForm}Desirable Grade{else}Writer Category{/if}:</span>
                                                    <span class="oinfo__data-value">{$order.writerCategoryTitle}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Work Type:</span>
                                                <span class="oinfo__data-value">{$order.paperTypeTitle} {if $order.paperType == "64"}: {$order.paperTypeOption} {/if}</span>
                                            </div>
                                        </div>
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Format:</span>
                                                <span class="oinfo__data-value">{$order.paperFormatTitle} {if $order.paperFormat == "4"}: {$order.paperFormatTypeOption} {/if}</span>
                                            </div>
                                        </div>
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Pages:</span> 
                                                <span class="oinfo__data-value">{pluralize('page', $order.pages)} - <strong>{pluralize('word', $order.wordsPerPage)}, {$order.spacing|capitalize} spaced</strong></span>
                                            </div>
                                        </div>
                                
                                        {if $order.slides}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Slides:</span>
                                                    <span class="oinfo__data-value">{$order.slides}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.charts}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Charts:</span>
                                                    <span class="oinfo__data-value">{$order.charts}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.excelSheets}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Excel Sheets:</span>
                                                    <span class="oinfo__data-value">{$order.excelSheets}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if count($order.services)}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Additional services:</span>
                                                    <span class="oinfo__data-value">
                                                        {foreach $order.services as $service}
                                                            <output class="fw-bold">{$service.title}</output>
                                                        {/foreach}
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                    {/if}
                                
                                    {if $order.isArticleWriting}
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Writer Category:</span>
                                                    <span class="oinfo__data-value">{$order.writerCategoryTitle}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Type of Content:</span>
                                                <span class="oinfo__data-value">{$order.contentTypeTitle}</span>
                                            </div>
                                        </div>
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Words:</span>
                                                <span class="oinfo__data-value">{pluralize('word', $order.words)}</span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    <div class="oinfo__data-item">
                                        <div class="oinfo__data-col">
                                            <span class="oinfo__data-label">Deadline:</span>
                                            <span class="oinfo__data-value">
                                                <div class="d-flex align-items-center">
                                                    <span class="js_moment mr-1" data-time="{$order.deadline}">{$order.deadline}</span> ({$order.timeLeftHtml nofilter})
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <button type="button" data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"customer"{literal}}{/literal}' class="btn btn-secondary ml-auto d-none d-md-inline-flex">
                                                            <em class="icon ni ni-clock"></em> <span>Change Deadline</span>
                                                        </button> 

                                                        <button type="button" data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"customer"{literal}}{/literal}' class="btn btn-secondary ml-auto d-md-none">
                                                            <em class="icon ni ni-clock"></em>
                                                        </button> 
                                                    {/if}
                                                </div>
                                            </span>
                                        </div>
                                    </div>
                                    
                                    {if $user.is_admin || $user.is_sub_admin}
                                        {if $order.isPaid}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Writer deadline:</span>
                                                    <span class="oinfo__data-value">
                                                        <div class="d-flex align-items-center">
                                                            <span class="js_moment mr-1" data-time="{$order.writerDeadline}">{$order.writerDeadline}</span> ({$order.writerTimeLeftHtml nofilter})
                                                            {if $user.is_admin || $user.is_sub_admin}
                                                                <button type="button" data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"writer"{literal}}{/literal}' class="btn btn-secondary ml-auto d-none d-md-inline-flex">
                                                                    <em class="icon ni ni-clock"></em> <span>Change Deadline</span>
                                                                </button>

                                                                <button type="button" data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"writer"{literal}}{/literal}' class="btn btn-secondary ml-auto d-md-none">
                                                                    <em class="icon ni ni-clock"></em>
                                                                </button> 
                                                            {/if}
                                                        </div>  
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Created At:</span>
                                                <span class="oinfo__data-value">
                                                    <span class="js_moment" data-time="{$order.createdAt}">{$order.createdAt}</span>
                                                </span>
                                            </div>
                                        </div>
                                
                                        {if $order.status == "11" || $order.status == "10"}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Delivered At:</span>
                                                    <span class="oinfo__data-value">
                                                        <span class="js_moment" data-time="{$order.finishedAt}">{$order.finishedAt}</span>
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.status == "10"}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Approved At:</span>
                                                    <span class="oinfo__data-value">
                                                        <span class="js_moment" data-time="{$order.approvedAt}">{$order.approvedAt}</span>
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}

                                        {if $order.status == "9"}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Cancelled At:</span>
                                                    <span class="oinfo__data-value">
                                                        <span class="js_moment" data-time="{$order.cancelledAt}">{$order.cancelledAt}</span>
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                    {/if}
                                </div>
                                
                                <div class="nk-data data-list border rounded overflow-hidden mt-3">
                                    {if $order.isAcademicWriting}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Academic level:</span>
                                                <span class="oinfo__data-value">{$order.academicLevelTitle}</span>
                                            </div>
                                        </div>
                                        
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Discipline:</span>
                                                <span class="oinfo__data-value">{$order.topicCategory} {if $order.topicCategoryId == "52"}: {$order.topicCategoryOption} {/if}</span>
                                            </div>
                                        </div>
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Title:</span>
                                                <span class="oinfo__data-value">{$order.title}</span>
                                            </div>
                                        </div>
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Number of sources:</span>
                                                <span class="oinfo__data-value">{$order.sources}</span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if $order.isArticleWriting}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Category:</span>
                                                <span class="oinfo__data-value">{$order.disciplineTitle}</span>
                                            </div>
                                        </div>
                                
                                        {if $order.keywords}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Keywords:</span>
                                                    <span class="oinfo__data-value">{$order.keywords}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.englishTypeTitle}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">English Type:</span>
                                                    <span class="oinfo__data-value">{$order.englishTypeTitle}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.targetAudienceTitle}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Target Audience:</span>
                                                    <span class="oinfo__data-value">{$order.targetAudienceTitle}</span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.writingStyleTitle}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Writing Style:</span>
                                                    <span class="oinfo__data-value">
                                                        <span>{$order.writingStyleTitle}</span>
                                                        <span class="nk-block-des ml-1" data-toggle="tooltip" title="{$order.writingStyleDescription}"><em class="icon ni ni-info"></em></span>
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.writingToneTitle}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Writing Tone:</span>
                                                    <span class="oinfo__data-value">
                                                        <span>{$order.writingToneTitle}</span>
                                                        <span class="nk-block-des ml-1" data-toggle="tooltip" title="{$order.writingToneDescription}"><em class="icon ni ni-info"></em></span>
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.contentFeelTitle}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Content Feel:</span>
                                                    <span class="oinfo__data-value">
                                                        <span>{$order.contentFeelTitle}</span>
                                                        <span class="nk-block-des ml-1" data-toggle="tooltip" title="{$order.contentFeelDescription}"><em class="icon ni ni-info"></em></span>
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                    {/if}
                                
                                    {if $order.isProgramming || $order.isCalculations}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Discipline:</span>
                                                <span class="oinfo__data-value">{$order.topicCategory} {if $order.topicCategoryId == "52"}: {$order.topicCategoryOption} {/if}</span>
                                            </div>
                                        </div>
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Task size:</span>
                                                <span class="oinfo__data-value">
                                                    <h6 class="fw-bold mt5 mb-1 text-dark h6">{$order.sizeTitle}</h6>
                                                    {if count($order.deliverables)} 
                                                        <div class="fw-bold mt5 mb5 text-muted">Possible Deliverables:</div>
                                                        <ul class="task_deliverables">
                                                            {foreach $order.deliverables as $deliverable}
                                                                <li class="task_deliverables_item task_deliverables_item--{$deliverable.slug}">{$deliverable.name}</li>
                                                            {/foreach}
                                                        </ul>
                                                    {/if}
                                                </span>
                                            </div>
                                        </div>
                                
                                        {if $order.software}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Software:</span>
                                                    <span class="oinfo__data-value">{$order.software}</span>
                                                </div>
                                            </div>
                                        {/if}
                                    {/if}
                                </div>
                                
                                <div class="nk-data data-list border rounded overflow-hidden mt-3">
                                    {if $order.paperDetails}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">{if $order.isAcademicWriting}Paper instructions:{else}Instructions:{/if}</span>
                                                <span class="oinfo__data-value">
                                                    <div class="OrderInstructions">
                                                        {$order.paperDetails nofilter}
                                                    </div>
                                                </span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if $user.is_admin || $user.is_sub_admin}
                                        {if $order.requestedWriter.id}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Requested Writer:</span>
                                                <span class="oinfo__data-value">
                                                    {if $show_writer_info}
                                                        <a class="text-primary" href="{$base_uri}/employees/edit/{$order.requestedWriter.id}" target="_blank"> {$order.requestedWriter.first_name} {$order.requestedWriter.last_name} ({$order.requestedWriter.id}) </a>
                                                    {else}
                                                        <strong class="text-primary">{$order.requestedWriter.id} - {$order.requestedWriter.first_name}</strong>
                                                    {/if}
                                                </span>
                                            </div>
                                        </div>
                                        {/if}
                                    {/if}
                                
                                    {if $order.comments}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Additional comments from Customer:</span>
                                                <span class="oinfo__data-value">{$order.comments}</span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Price:</span>
                                                <span class="oinfo__data-value">
                                                    <div class="d-flex align-items-center">
                                                        {if $order.noDiscountPrice > $order.price}
                                                            <span style="text-decoration:line-through;" class="text-dark mr-2 text-sm">{$order.noDiscountPriceFormatted}</span>
                                                        {/if}
                                                        <span class="text-primary text-lg fw-500">{$order.priceFormatted}</span>
                                
                                                        <div class="ml-auto mr0">
                                                            {if $user.is_admin || $user.is_sub_admin}
                                                            
                                                                {if isset($order.orderServices['servicesById'])}
                                                                    <button type="button" data-toggle="modal" data-url="#modal-show-pricebreakdown" data-size="small" class="btn btn-light btn-icon ml-auto d-none d-md-inline-flex">
                                                                        <em class="icon ni ni-info"></em>
                                                                    </button>
                                                                {/if}
                                                                
                                                                <button type="button" data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_customer_pay":"1","customer_pay":{$order.price}{literal}}{/literal}' class="btn btn-secondary ml-auto d-none d-md-inline-flex">
                                                                    <em class="icon ni ni-edit mr1"></em> <span>Edit</span>
                                                                </button>

                                                                <button type="button" data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_customer_pay":"1","customer_pay":{$order.price}{literal}}{/literal}' class="btn btn-secondary ml-auto d-md-none">
                                                                    <em class="icon ni ni-edit"></em>
                                                                </button> 
                                                            {/if}
                                
                                                            {if $user.is_admin || $user.is_sub_admin}
                                                                <button type="button" data-toggle="modal" data-url="#modalAdditionalPayment" data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' class="btn btn-secondary ml-auto d-none d-md-inline-flex ml-2">
                                                                    <em class="icon ni ni-cc-fill mr1"></em> <span>Additional Payment</span>
                                                                </button>

                                                                <button type="button" data-toggle="modal" data-url="#modalAdditionalPayment" data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' class="btn btn-secondary ml-auto d-md-none">
                                                                    <em class="icon ni ni-cc-fill"></em>
                                                                </button> 
                                                            {/if}
                                                        </div>
                                                    </div>
                                                </span>
                                            </div>
                                        </div>
                                
                                        {if $order.additionalPayments}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Additional payments:</span>
                                                    <span class="oinfo__data-value">
                                                        {foreach $order.additionalPayments as $additionalPayment}
                                                            <div>{$additionalPayment.title} was paid on <span class="js_moment" data-time="{$additionalPayment.paidAt}"></span></div>
                                                            {if count($order.additionalPayments) > 1}<hr  class="mb10 mt10">{/if}
                                                        {/foreach}
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                
                                        {if $order.paymentMethod}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Payment Method:</span>
                                                    <span class="oinfo__data-value text-capitalize">{$order.paymentMethod}</span>
                                                </div>
                                            </div>
                                        {/if}
                                    {/if}
                                
                                    {if count($order.orderReviews)}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Feedback:</span>
                                                <span class="oinfo__data-value">
                                                    {foreach from=$order.orderReviews item=$orderReview key=$ratingId}
                                                        <div class="card card-bordered shadow-none">
                                                            <div class="card-inner">
                                                                <h6 class="card-title mb-1">{if $orderReview.user_type == 'customer'}Customer's Feedback{else}Editor's Feedback{/if}</h6>
                                                                <ul class="pt-2 gy-1">
                                                                    {if $orderReview.user_type == 'customer'}  
                                                                        <li class="mb-1">
                                                                            <span class="mr-3 fw-bold">Service Rating</span>
                                                                            <span>
                                                                                <div class="Rating Rating--labeled" data-star_rating="{$orderReview.service_rating}">
                                                                                    <span class="Rating-total">
                                                                                        <span class="Rating-progress"></span>
                                                                                    </span>
                                                                                </div>
                                                                            </span>
                                                                        </li>
                                                                    {/if}
                                
                                                                    <li>
                                                                        <span class="mr-3 fw-bold">Paper Rating</span>
                                                                        <span>
                                                                            <div class="Rating Rating--labeled" data-star_rating="{$orderReview.paper_rating}">
                                                                                <span class="Rating-total">
                                                                                    <span class="Rating-progress"></span>
                                                                                </span>
                                                                            </div>
                                                                        </span>
                                                                    </li>
                                                                </ul>
                                                                <div class="d-flex justify-content-between align-items-end">
                                                                    <ul class="pt-2 gy-1">
                                                                        <li>
                                                                            <em class="icon ni ni-calender-date"></em><span class="js_moment" data-time="{$orderReview.date}">{$orderReview.date}</span>
                                                                        </li>
                                                                    </ul>
                                                                    {if $orderReview.paper_on_time}
                                                                        <span class="badge badge-dim badge-sm badge-pill badge-outline-success">Paper on Time</span>
                                                                    {else}
                                                                        <span class="badge badge-dim badge-sm badge-pill badge-outline-danger">Paper Late</span>
                                                                    {/if}
                                                                </div><p class="text-muted mt-2">{$orderReview.comment nofilter}</p>
                                                                
                                                            </div>
                                                            
                                                        </div>
                                                    {/foreach}
                                                </span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if $user.is_admin || $user.is_sub_admin || $user.is_writer}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">{if $user.is_admin || $user.is_sub_admin}Writer {/if}Fee:</span>
                                                <span class="oinfo__data-value">
                                                    <div class="d-flex align-items-center">
                                                        <span class="text-primary text-lg fw-500">{$order.writerPayFormatted}</span> 
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <button type="button" data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_writer_pay":"1","writer_pay":{$order.writerPay}{literal}}{/literal}' class="btn btn-secondary ml-auto d-none d-md-inline-flex">
                                                                <em class="icon ni ni-edit"></em><span>Edit</span>
                                                            </button>

                                                            <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_writer_pay":"1","writer_pay":{$order.writerPay}{literal}}{/literal}' class="btn btn-secondary ml-auto d-md-none">
                                                                <em class="icon ni ni-edit"></em>
                                                            </span> 
                                                        {/if}
                                                    </div>
                                                </span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if $user.is_admin || $user.is_sub_admin || $user.is_editor}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">{if $user.is_admin || $user.is_sub_admin}Editor {/if}Fee:</span>
                                                <span class="oinfo__data-value">
                                                    <div class="d-flex align-items-center">
                                                        <span class="text-primary text-lg fw-500">{$order.editorPayFormatted}</span>
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <button type="button" data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_editor_pay":"1","editor_pay":{$order.editorPay}{literal}}{/literal}' class="btn btn-secondary ml-auto d-none d-md-inline-flex">
                                                                <em class="icon ni ni-edit"></em><span>Edit</span>
                                                            </button>

                                                            <button type="button" data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_editor_pay":"1","editor_pay":{$order.editorPay}{literal}}{/literal}' class="btn btn-secondary ml-auto d-md-none">
                                                                <em class="icon ni ni-clock"></em>
                                                            </button> 
                                                        {/if}
                                                    </div>
                                                </span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if $user.is_admin || $user.is_sub_admin}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Order Manager Fee:</span>
                                                <span class="oinfo__data-value">
                                                    <div class="d-flex align-items-center">
                                                        <span class="text-primary text-lg fw-500">{$order.orderManagerPayFormatted}</span>
                                                        {if $user.is_admin}
                                                            <button type="button" data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_ordermanager_pay":"1","ordermanager_pay":{$order.orderManagerPay}{literal}}{/literal}' class="btn btn-secondary ml-auto d-none d-md-inline-flex">
                                                                <em class="icon ni ni-edit"></em><span>Edit</span>
                                                            </button>

                                                            <button type="button" data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_ordermanager_pay":"1","ordermanager_pay":{$order.orderManagerPay}{literal}}{/literal}' class="btn btn-secondary ml-auto d-md-none">
                                                                <em class="icon ni ni-edit"></em>
                                                            </button> 
                                                        {/if}
                                                    </div>
                                                </span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if ($user.is_writer || $user.is_editor) && $order.customerCountry}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Customer:</span>
                                                <span class="oinfo__data-value">
                                                    <div data-toggle="tooltip" title="{$order.customerCountry.name}" class="customer-country iti-flag {$order.customerCountry.countryCode}"></div>
                                                </span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {if  $user.is_editor && $order.writer.id}
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Writer:</span>
                                                <span class="oinfo__data-value">
                                                    <strong class="text-primary">{$order.writer.id} - {$order.writer.first_name} {$order.writer.last_name}</strong>
                                                </span>
                                            </div>
                                        </div>
                                    {/if}
                                
                                    {hook h='displayOrderAdditionalInfo' order_id=$order.id|intval}
                                </div>
                                
                                {if $user.is_admin || $user.is_sub_admin}
                                    <div class="nk-data data-list border rounded overflow-hidden mt-3">
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Status:</span>
                                                <span class="oinfo__data-value">
                                                    <div class="d-flex align-items-center">
                                                        <div>
                                                            <span class="dot bg-{$order.statusBadge} d-mb-none"></span>
                                                            <span class="badge badge-sm badge-dot has-bg badge-{$order.statusBadge} d-none d-mb-inline-flex">{$order.statusTitle}</span>
                                                        </div>

                                                        <button type="button" data-toggle="modal" data-url="#editStatusModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"status_id":{$order.status}{literal}}{/literal}' class="btn btn-primary ml-auto d-none d-md-inline-flex">
                                                            <em class="icon ni ni-edit"></em><span>Change Status</span>
                                                        </button>

                                                        <button type="button" data-toggle="modal" data-url="#editStatusModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"status_id":{$order.status}{literal}}{/literal}' class="btn btn-primary ml-auto d-md-none">
                                                            <em class="icon ni ni-edit"></em>
                                                        </button> 
                                                    </div>
                                                </span>
                                            </div>
                                        </div>
                                
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Customer:</span>
                                                <span class="oinfo__data-value">
                                                    {if $user.is_sub_admin}
                                                        <strong>{$order.customer.id}</strong>
                                                    {else}
                                                        <a class="text-primary" href="{$base_uri}/customers/edit/{$order.customer.id}" target="_blank"> {$order.customer.name} ({$order.customer.id}) </a>
                                                    {/if}
                                    
                                                    {if $order.customerCountry}
                                                        <div data-toggle="tooltip" title="{$order.customerCountry.name}" class="ml10 customer-country iti-flag {$order.customerCountry.countryCode}"></div>
                                                    {/if}
                                                </span>
                                            </div>
                                        </div>
                                    
                                        {if $order.writer.id}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Writer:</span>
                                                    <span class="oinfo__data-value">
                                                        {if $show_writer_info}
                                                            <a class="text-primary" href="{$base_uri}/employees/edit/{$order.writer.id}" target="_blank"> {$order.writer.first_name} {$order.writer.last_name} ({$order.writer.id}) </a>
                                                        {else}
                                                            <strong class="text-primary">{$order.writer.id} - {$order.writer.first_name}</strong>
                                                        {/if}
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                    
                                        {if $order.editor.id}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Editor:</span>
                                                    <span class="oinfo__data-value">
                                                        <a class="text-primary" href="{$base_uri}/employees/edit/{$order.editor.id}" target="_blank"> {$order.editor.first_name} {$order.editor.last_name} ({$order.editor.id}) </a>
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                    
                                        {if $order.orderManager.id}
                                            <div class="oinfo__data-item">
                                                <div class="oinfo__data-col">
                                                    <span class="oinfo__data-label">Order Manager:</span>
                                                    <span class="oinfo__data-value">
                                                        {if $user.is_admin}
                                                            <a class="text-primary" href="{$base_uri}/employees/edit/{$order.orderManager.id}" target="_blank"> {$order.orderManager.first_name} {$order.orderManager.last_name} ({$order.orderManager.id}) </a>
                                                        {else}
                                                            <strong class="text-primary">{$order.orderManager.id} - {$order.orderManager.first_name} {$order.orderManager.last_name}</strong>
                                                        {/if}
                                                    </span>
                                                </div>
                                            </div>
                                        {/if}
                                    
                                        <div class="oinfo__data-item">
                                            <div class="oinfo__data-col">
                                                <span class="oinfo__data-label">Site:</span>
                                                <span class="oinfo__data-value">
                                                    {if $user.is_admin}
                                                        <a class="text-primary" href="{$base_uri}/my-sites/{$order.site.id}/edit" target="_blank"> {$order.site.name} </a>
                                                    {elseif $user.is_sub_admin}
                                                        <strong class="text-primary">#{$order.site.id}</strong>
                                                    {/if}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                {/if}
                                
                            </div>
                            <!-- instructions tab -->

                            {if $order.progressiveDeliveryHidden}
                                <!-- progressive-delivery tab -->
                                <div class="tab-pane" id="progressive-delivery">

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <div class="nk-block nk-block-lg mb-4">
                                            <div class="nk-block-head">
                                                <div class="nk-block-head-content">
                                                    <h5 class="nk-block-title">Progressive Delivery Schedule</h5>
                                                    <p>You can only get progressive delivery if your <strong class="text-primary">order is worth more than $200</strong>, includes <strong class="text-primary">6 pages</strong> or more, and has a <strong class="text-primary">deadline of over 5 days</strong>.</p>
                                                </div>
                                            </div>
                                        </div>
                                    {/if}

                                    {if count($order.pdSchedule)}

                                        <table class="table table-tranx mb-3">
                                            <thead>
                                                <tr class="tb-tnx-head">
                                                    <th class="tb-tnx-info">Part</th>
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <th class="tb-tnx-info">Customer Deadline</th>
                                                    {/if}
                                                    <th class="tb-tnx-info">Writer Deadline</th>
                                                    <th class="tb-tnx-info">Task</th>
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <th class="tb-tnx-action">Actions</th>
                                                    {/if}
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {counter assign=schedulePart start=1 print=false}
                                                {foreach $order.pdSchedule as $schedule}
                                                    <tr class="tb-tnx-item">
                                                        <td class="tb-tnx-info">Part {$schedulePart}</td>
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <td class="tb-tnx-info">
                                                                {$schedule.customer_deadline|date_format:"%e %b %I:%M %p"}
                                                            </td>
                                                        {/if}
                                                        <td class="tb-tnx-info">
                                                            {$schedule.writer_deadline|date_format:"%e %b %I:%M %p"}
                                                        </td>
                                                        <td class="tb-tnx-info">
                                                            {if $schedule.pages} {pluralize('page', $schedule.pages)} {/if} 
                                                            {if $schedule.slides}, {pluralize('slide', $schedule.slides)} {/if} 
                                                            {if $schedule.charts} {pluralize('chart', $schedule.charts)} {/if} 
                                                        </td>
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <td class="tb-tnx-action">
                                                                <div class="dropdown">
                                                                    <a class="text-soft dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-xs">
                                                                        <ul class="link-list-plain">
                                                                            <li>
                                                                                <a href="javascript:void(0);" data-toggle="modal">
                                                                                    <em class="icon ni ni-edit mr5"></em> <span>Edit</span>
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="js_deleter" href="javascript:void(0);" data-handle="pd_schedule" data-id="{$schedule.schedule_id}">
                                                                                    <em class="icon ni ni-trash-alt"></em> <span>Delete</span>
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        {/if}
                                                    </tr>
                                                    {counter}
                                                {/foreach}
                                            </tbody>
                                        </table>

                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="mb20 clearfix">
                                                <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#modalProgressiveDelivery" type="button" class="btn btn-primary ml-auto">
                                                    <em class="icon ni ni-plus"></em> <span>Add Delivery Schedule</span>
                                                </button>
                                            </div>
                                        {/if}
                                    {else} 
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="text-center x-muted mb-3 py-5"> 
                                                <em class="icon ni ni-calendar icon-circle icon-circle-xxl bg-warning mb-3"></em>
                                                <h6 class="text-muted mb-3 fw-normal">This is a progressive delivey order. Create a delivery schedule.</h6>
                                                <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#modalProgressiveDelivery" type="button" class="btn btn-primary">
                                                    <em class="icon ni ni-plus"></em> <span>Add Delivery Schedule</span>
                                                </button>
                                            </div>
                                        {else}
                                            <div class="text-center x-muted py-5"> 
                                                <em class="icon ni ni-calendar icon-circle icon-circle-xxl bg-info mb-3"></em>
                                                <h6 class="text-muted mb-3 fw-normal">No delivery schedule to show</h6>
                                            </div>
                                        {/if}
                                    {/if}

                                </div>
                                <!-- progressive-delivery tab -->
                            {/if}

                            <!-- files tab -->
                            <div class="tab-pane {if $sub_view == "files"}active{/if}" id="files">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="nk-files nk-files-view-group">
                                            <div class="nk-files-group">
                                                <h6 class="title border-top-0 border-bottom mb-3">Writer Files</h6>
                                                {if count($order.writerFiles) > 0}
                                                    <div class="nk-files-list">
                                                        {foreach $order.writerFiles as $file}
                                                            {include file="dashboard/order/_order.file.tpl"}
                                                        {/foreach}
                                                    </div>
                                                {else}
                                                    <div class="alert alert-icon alert-info">
                                                        <em class="icon ni ni-alert-circle"></em> There are no files uploaded by writer.
                                                    </div>
                                                {/if}
        
                                                <div class="nk-actions-group mt-4">
                                                    {if $user.is_writer}
                                                        {* Writer | Writer Assigned *}
                                                        {if $order.status == "11" || $order.status == "6" && $order.isWriterConfirmed}
                                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" data-size="medium" class="btn btn-primary">
                                                                <em class="icon ni ni-upload-cloud"></em> <span>Upload Files</span>
                                                            </button>
                                                        {/if}
        
                                                        {* Writer | Revision *}
                                                        {if $order.status == "14" && $order.isWriterConfirmed}
                                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" data-size="medium" class="btn btn-primary">
                                                                <em class="icon ni ni-upload-cloud"></em> <span>Upload Files</span>
                                                            </button>
                                                        {/if}
                                                    {/if}
        
                                                    {if $user.is_editor}
                                                        {* Editor | Done *}
                                                        {if $order.isEditorAssigned == '1' && $order.editor.id == $user.id && $order.status == "8"}
                                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" data-size="medium" class="btn btn-primary">
                                                                <em class="icon ni ni-upload-cloud"></em> <span>Upload Files</span>
                                                            </button>
                                                        {/if}
                                                    {/if}
        
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" data-size="medium" class="btn btn-primary">
                                                            <em class="icon ni ni-upload-cloud"></em> <span>Upload Files</span>
                                                        </button>
                                                    {/if}
        
                                                    {hook h='displayOrderWriterFilesActions' order_id=$order.id}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="nk-files nk-files-view-group">
                                            <div class="nk-files-group">
                                                <h6 class="title border-top-0 border-bottom mb-3">Customer Files</h6>
                                                {if count($order.customerFiles) > 0}
                                                    <div class="nk-files-list">
                                                        {foreach $order.customerFiles as $file}
                                                            {include file="dashboard/order/_order.file.tpl"}
                                                        {/foreach}
                                                    </div>
                                                {else}
                                                    <div class="alert alert-icon alert-info">
                                                        <em class="icon ni ni-alert-circle"></em> There are no files uploaded by customer.
                                                    </div>
                                                {/if}
        
                                                <div class="nk-actions-group mt-4">
                                                    {if count($order.customerFiles) && (!$cloud_storage && !$ifs_enabled)}
                                                        <a class="btn btn-primary" href="{$base_uri}/api/orders/{$order.id}/download_all_attachments">
                                                            <em class="icon ni ni-download"></em> <span>Download all attachments</span>
                                                        </a>
                                                    {/if}
        
                                                    {hook h='displayOrderCustomerFilesActions' order_id=$order.id}
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            <!-- files tab -->

                            <!-- messages tab -->
                            {if $can_view_messages}
                                <div class="tab-pane {if $sub_view == "messages"}active{/if}" id="messages">
                                    {if count($order.messages)}
                                        <div class="mb-3">
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#newMessage" class="btn btn-primary">
                                                <em class="icon ni ni-chat-fill"></em> <span>New Message</span>
                                            </button>
                                        </div>
                                    {/if}

                                    <div class="OrderMessages__content mt20">
                                        {if count($order.messages)}
                                            {foreach $order.messages as $message}
                                                <div class="message">
                                                    <div class="message--container js_order-message {if !$message.isSender && !$message.isViewed}new{/if}" data-id="{$message.id}" data-read="{$message.isViewed}">
                                                        <button class="message--toggle" data-toggle="collapse" href="#message-{$message.id}" role="button" aria-expanded="false" aria-controls="message-{$message.id}">
                                                            <div class="message--icon">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19" viewBox="0 0 20 19"><path d="M4,7.863l8,4.907,8-4.907h0L12,2.956,4,7.863H4m18,0v9.814a1.982,1.982,0,0,1-2,1.963H4a1.982,1.982,0,0,1-2-1.963V7.863a1.947,1.947,0,0,1,.97-1.678L12,.64l9.03,5.545A1.947,1.947,0,0,1,22,7.863Z" transform="translate(-2 -0.64)" fill="#9e9e9e"></path></svg>
                                                            </div>
                                                            <div class="message--from-to">
                                                                {if !$message.isSender && $message.fromDepartment.id == '6'}
                                                                    <div class="message--sender">W {$message.senderId}</div>
                                                                {else}
                                                                    <div class="message--sender">{$message.fromDepartment.name|ucfirst}</div>
                                                                {/if}

                                                                <div class="message--to">{$message.toDepartment.name|ucfirst}</div>
                                                            </div>
                                                            
                                                            <div class="message--subject">
                                                                <span class="message--subject__text_collapse">{$message.subject}</span>
                                                            </div>
                                                            <div class="message--date">
                                                                {if $message.isViewed && $message.isSender}
                                                                    <span data-toggle="tooltip" data-placement="top" data-title="{$message.readAt}">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16.749" height="11.42" viewBox="0 0 16.749 11.42"><path d="M9.375,7.926a2.284,2.284,0,1,0,2.284,2.284A2.284,2.284,0,0,0,9.375,7.926m0,6.091a3.807,3.807,0,1,1,3.807-3.807,3.807,3.807,0,0,1-3.807,3.807m0-9.517A9,9,0,0,0,1,10.21a9,9,0,0,0,16.749,0A9,9,0,0,0,9.375,4.5Z" transform="translate(-1 -4.5)" fill="#9e9e9e"></path></svg>
                                                                    </span>
                                                                {/if}
                                                                <span class="js_moment" data-time="{$message.createdAt}">{$message.createdAt}</span>
                                                            </div>
                                                            <div class="message--arrow">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="7.42" viewBox="0 0 12 7.42"><path d="M7.41,8.58,12,13.17l4.59-4.59L18,10l-6,6L6,10Z" transform="translate(-6 -8.58)" fill="#9e9e9e"></path></svg>
                                                            </div>
                                                        </button>
                                                        <div class="message--collapse collapse" id="message-{$message.id}">
                                                            <div class="message--text">{$message.body nofilter}</div>

                                                            {if !$message.isSender}
                                                                <div class="nk-reply-form ml-0 mr-0">
                                                                    <form data-url="/messages/{$message.id}/reply" class="nk-reply-form-editor js_ajax-forms" method="POST">
                                                                        <div class="nk-reply-form-field">
                                                                            <textarea name="reply" class="form-control form-control-simple js_autosize" placeholder="Type your reply..."></textarea>
                                                                            <!-- error -->
                                                                            <div class="alert alert-danger alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                                            <!-- error -->
                            
                                                                            <!-- success -->
                                                                            <div class="alert alert-success alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                                                                            <!-- success -->
                                                                        </div>
                                                                        <div class="nk-reply-form-tools">
                                                                            <div class="nk-reply-form-actions g-1">
                                                                                <button class="btn btn-primary mr-2" type="submit">
                                                                                    <em class="icon ni ni-reply"></em> <span>Reply</span>
                                                                                </button>
                                                                                <a class="btn btn-secondary mr-2" href="{$base_uri}/order/{$message.orderId}" data-ajax="/order/{$message.orderId}">
                                                                                    <em class="icon ni ni-eye"></em> <span>View Order</span>
                                                                                </a>
                                                                                {if $user.is_admin || $user.is_sub_admin}
                                                                                    <a class="btn btn-danger mr-2 js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">
                                                                                        <em class="icon ni ni-trash-alt"></em> <span>Delete</span>
                                                                                    </a>
                                                                                {/if}
                                                                            </div>
                                                                        </div>
                                                                        <!-- .nk-reply-form-tools -->
                                                                    </form>
                                                                </div>
                                                            {else}
                                                                {if $user.is_admin || $user.is_sub_admin}
                                                                    <div class="message--buttons">
                                                                        <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">
                                                                            <em class="icon ni ni-trash-alt"></em> <span>Delete</span>
                                                                        </a>
                                                                    </div>
                                                                {/if}
                                                            {/if}
                                                        </div>
                                                    </div>
                                                </div>
                                            {/foreach}
                                        {else}
                                            <div class="text-center x-muted py-5"> 
                                                <em class="icon ni ni-chat-fill icon-circle icon-circle-xxl bg-info mb-3"></em>
                                                <h6 class="text-muted mb-3 fw-normal">No messages to show</h6>
                                                <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#newMessage" class="btn btn-primary">
                                                    <em class="icon ni ni-chat-fill"></em> <span>New Message</span>
                                                </button>
                                            </div>
                                        {/if}
                                    </div>
                                </div>
                            {/if}
                            <!-- messages tab -->

                            <!-- order-history tab -->
                            {if count($orderHistory)}
                                <div class="tab-pane {if $sub_view == "history"}active{/if}" id="order-history">
                                    <div class="nk-tb-list is-separate is-medium mb-3">
                                        <div class="nk-tb-item nk-tb-head">
                                            <div class="nk-tb-col fw-bold">
                                                <span>Order ID</span>
                                            </div>
                                            <div class="nk-tb-col fw-bold tb-col-md">
                                                <span>Topic Title</span>
                                            </div>
                                            <div class="nk-tb-col fw-bold tb-col-md">
                                                <span>Discipline</span>
                                            </div>
                                            <div class="nk-tb-col fw-bold">
                                                <span>Status</span>
                                            </div>
                                            <div class="nk-tb-col fw-bold tb-col-md">
                                                <span>Deadline</span>
                                            </div>
                                            <div class="nk-tb-col fw-bold">
                                                <span>Task</span>
                                            </div>
                                            <div class="nk-tb-col fw-bold tb-col-md">
                                                <span>COST</span>
                                            </div>
                                            <div class="nk-tb-col">&nbsp;</div>
                                        </div>
                                
                                        {foreach $orderHistory as $oHistory}
                                            <div class="nk-tb-item">
                                                <div class="nk-tb-col">
                                                    <span class="tb-lead">
                                                        <a href="{$base_uri}/order/{$oHistory.id}" data-ajax="/order/{$oHistory.id}">#{$oHistory.referenceId}</a>
                                                    </span>
                                                </div>
                                                
                                                {if $oHistory.isProgramming || $oHistory.isCalculations}
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="badge badge-sm badge-dot has-bg {if $oHistory.isProgramming}badge-success{else}badge-info{/if}">{$oHistory.serviceTypeTitle}</span>
                                                    </div>
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="tb-sub">{$oHistory.topicCategory}</span>
                                                        <small class="d-block tb-sub text-muted">{$oHistory.sizeTitle}</small>
                                                    </div>
                                                {elseif $oHistory.isArticleWriting}
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="tb-sub">{$oHistory.title}</span>
                                                    </div>
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="tb-sub">{$oHistory.contentTypeTitle}</span>
                                                        <small class="d-block tb-sub text-muted">{$oHistory.disciplineTitle}</small>
                                                    </div>
                                                {else}
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span  data-toggle="tooltip" title="{$oHistory.title}" class="tb-sub">{$oHistory.titleTruncated}</span>
                                                    </div>
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="tb-sub">{$oHistory.topicCategory}</span>
                                                        <small class="d-block tb-sub text-muted">{$oHistory.academicLevelTitle}</small>
                                                    </div>
                                                {/if}
                                                <div class="nk-tb-col">
                                                    <span class="dot bg-{$oHistory.statusBadge} d-mb-none"></span>
                                                    <span class="badge badge-sm badge-dot has-bg badge-{$oHistory.statusBadge} d-none d-mb-inline-flex">{$oHistory.statusTitle}</span>
                                                </div>
                                                <div class="nk-tb-col tb-col-md">
                                                    <span class="tb-sub">{$oHistory.timeLeftHtml nofilter}</span>
                                                </div>
                                                {if $oHistory.isProgramming || $oHistory.isCalculations}
                                                    <div class="nk-tb-col">
                                                        <span class="tb-sub">{$oHistory.sizeTitle}</span>
                                                    </div>
                                                {elseif $oHistory.isArticleWriting}
                                                    <div class="nk-tb-col">
                                                        <span class="tb-sub">{pluralize('word', $oHistory.words)}</span>
                                                    </div>
                                                {else}
                                                    <div class="nk-tb-col">
                                                        <span class="tb-sub">
                                                            {if $oHistory.pages} {pluralize('page', $oHistory.pages)} {/if} 
                                                            {if $oHistory.slides}, {pluralize('slide', $oHistory.slides)} {/if} 
                                                            {if $oHistory.charts} {pluralize('chart', $oHistory.charts)} {/if} 
                                                            {if $oHistory.excel_sheets} {pluralize('excel sheet', $oHistory.excel_sheets)} {/if} 
                                                        </span>
                                                    </div>
                                                {/if}
                                
                                                {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="tb-lead">{$oHistory.priceFormatted}</span>
                                                    </div>
                                                {elseif $user.is_writer}
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="tb-lead">{$oHistory.writerPayFormatted}</span>
                                                    </div>
                                                {elseif $user.is_editor}
                                                    <div class="nk-tb-col tb-col-md">
                                                        <span class="tb-lead">{$oHistory.editorPayFormatted}</span>
                                                    </div>
                                                {/if}
                                                
                                                <div class="nk-tb-col nk-tb-col-tools">
                                                    <ul class="nk-tb-actions">
                                                        <li>
                                                            <a href="{$base_uri}/order/{$oHistory.id}" data-ajax="/order/{$oHistory.id}" class="btn btn-dim btn-sm btn-primary">
                                                                View
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        {/foreach}
                                    </div>
                                
                                    <div class="nk-block-between-md g-3">
                                        <div class="g">
                                            {$pager nofilter}
                                        </div>
                                    </div><!-- .nk-block-between -->
                                </div>
                            {/if}
                            <!-- order-history tab -->

                        </div>
                        <!-- tabs content -->
                    </div>
                </div>
            </div>
        {elseif $sub_view == "assign"}
            {include file='dashboard/order/order.assign.tpl'}
        {/if}

    </div>

    {if isset($order.orderServices['servicesById']) && $user.is_admin || $user.is_sub_admin}
        <script id="modal-show-pricebreakdown" type="text/template">
            <div class="modal-header">
                <h5 class="modal-title">Order Services</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">
                <table class="table table-borderless mb-0">
                    <tbody> 
                        {foreach from=$order.orderServices['servicesById'] key=$serviceId item=$serviceById}
                            {if isset($serviceById.active) && $serviceById.active}
                                <tr>
                                    <td>
                                        {$serviceById.title}
                                        {if $serviceId == 6 && $order.coupon.id}
                                            <code>{$order.coupon.coupon_code}</code>
                                        {/if}
                                    </td>
                                    <th scope="row">
                                        <span class="text-success">{formatPrice($serviceById.cost)}</span>
                                    </th>
                                </tr>
                            {/if}
                        {/foreach} 

                        {if $order.tax > 0}
                            <tr>
                                <td>Tax</td>
                                <th scope="row">
                                    <span class="text-success">{formatPrice($order.tax)}</span>
                                </th>
                            </tr>
                        {/if}
                        
                        <tr>
                            <td class="fw-bold">Total</td>
                            <th scope="row">
                                <span class="text-success">{formatPrice($order.price)}</span>
                            </th>
                        </tr>
                    </tbody> 
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </script>

        <!-- Order Status -->
        <script id="editStatusModal" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/orders/{$order.id}/edit-status" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Change Status</h5>
                    <span class="modal-close" data-dismiss="modal" aria-label="Close">
                        <em class="icon ni ni-cross"></em>
                    </span>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label">Select status</label>
                        <select class="form-select" data-ui="lg" name="status_id">
                            <option value="13" {if $order.status == '13'}selected=""{/if}>Free Inquiry</option>
                            <option value="0" {if $order.status == '0'}selected=""{/if}>Waiting for Payment</option>
                            <option value="12" {if $order.status == '12'}selected=""{/if}>New Paid</option>
                            <option value="19" {if $order.status == '19'}selected=""{/if}>Available</option>
                            <option value="6" {if $order.status == '6'}selected=""{/if}>Writer Assigned</option>
                            {if $editor_account_enabled}
                                <option value="8" {if $order.status == '8'}selected=""{/if}>Done/Editing</option>
                            {/if}
                            <option value="11" {if $order.status == '11'}selected=""{/if}>Delivered</option>
                            <option value="10" {if $order.status == '10'}selected=""{/if}>Finished</option>
                            <option value="14" {if $order.status == '14'}selected=""{/if}>Revision</option>
                            <option value="9" {if $order.status == '9'}selected=""{/if}>Cancelled</option>
                            <option value="1" {if $order.status == '1'}selected=""{/if}>Dispute</option>
                        </select>
                    </div>

                    <!-- success -->
                    <div class="alert alert-success alert-fill mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger alert-fill mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                </div>
            </form>
        </script>
        <!-- Order Status -->

        <!-- Additional Pay -->
        <script id="modalAdditionalPayment" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/orders/{$order.id}/additional-payment" method="POST" autocomplete="off">
                <div class="modal-header">
                    <h5 class="modal-title">Request Additional Payment</h5>
                    <span class="close" data-dismiss="modal" aria-label="Close">
                        <em class="icon ni ni-cross"></em>
                    </span>
                </div>
                <div class="modal-body">

                    <div class="form-group form-row">
                        <label class="col-sm-3 form-label text-left">Amount</label>
                        <div class="col-sm-4">
                            <div class="input-group">
                                <div class="input-group-prepend"> 
                                    <span class="input-group-text">$</span> 
                                </div>
                                <input name="amount" type="text" class="form-control form-control-lg force-integer" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    {if $order.isArticleWriting}
                        <div class="divider my-2"></div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Words</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="words" class="form-control form-control-lg number-spinner" placeholder="pages" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>
                    {/if}

                    {if $order.isAcademicWriting}
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Pages</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="pages" class="form-control form-control-lg number-spinner" placeholder="pages" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Charts</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="charts" class="form-control form-control-lg number-spinner" placeholder="charts" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Slides</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="slides" class="form-control form-control-lg number-spinner" placeholder="slides" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>
                    {/if}

                    <div class="form-group form-row">
                        <label class="form-label text-left">Comments</label>
                        <textarea name="comments" type="text" class="form-control js_autosize"></textarea>
                        <div class="text-muted">Comments regarding this additional payment</div>
                    </div>

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->
                </div>
                <div class="modal-footer bg-lighter">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Confirm</button>
                </div>
            </form>
        </script>
        <!-- Additional Pay -->

        <script id="modalAdditionalPaymentLink" type="text/template">
            <div class="modal-header">
                <h5 class="modal-title">Additional Payment Link</h5>
                <a href="javascript:void(0);" class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </a>
            </div>
            <div class="modal-body p-0">
                <div class="code-block">
                    <h6 class="overline-title title">Payment Link</h6>
                    <button class="btn btn-sm clipboard-init" title="Copy to clipboard" data-clipboard-target="#paymentLinkPrint" data-clip-success="Copied" data-clip-text="Copy">
                        <span class="clipboard-text">Copy</span>
                    </button>
                    <div class="bg-light p-2 round-sm" id="paymentLinkPrint">{literal}{{payment_link}}{/literal}</div>
                </div>
            </div>
            <div class="modal-body pt-0 text-center">
                <a href="javascript:void(0);" class="btn btn-secondary mx-auto" data-dismiss="modal">Done</a>
            </div>
        </script>
    {/if}
{/block}