{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="wide-md">
        <div class="nk-block-head nk-block-head-lg wide-sm">
            <div class="nk-block-head-content">
                <h2 class="nk-block-title fw-normal">Create new order</h2>
            </div>
        </div>

        <div class="card card-bordered">
            <form class=" js_ajax-forms" id="orderForm" data-url="/order" method="POST" autocomplete="off">
                <input type="hidden" name="customerId" value="{$customerId}"/>
                <div class="card-inner form-horizontal">
                    {if count($serviceTypes) > 1}
                        <div class="form-group form-row">
                            <label class="col-sm-2 form-label text-left" for="serviceType">Service Type</label>
                            <div class="col-sm-8">
                                <ul class="custom-control-group w-100">
                                    {foreach $serviceTypes as $serviceType} 
                                        <li>
                                            <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                                                <input type="radio" name="serviceType" value="{$serviceType.serviceId}" class="custom-control-input js_calculate" id="serviceType-{$serviceType.serviceId}"  {if $defaultOrderServiceTypeId == $serviceType.serviceId}checked{/if} data-combo="serviceType">
                                                <label class="custom-control-label" for="serviceType-{$serviceType.serviceId}">
                                                    {if count($serviceTypes) < 4}
                                                        <span class="user-card">
                                                            <span class="user-info">
                                                                <span class="lead-text">{$serviceType.name}</span>
                                                                <span class="sub-text">{$serviceType.description}</span>
                                                            </span>
                                                        </span>
                                                    {else}
                                                        <span>{$serviceType.shortName}</span>
                                                    {/if}
                                                </label>
                                            </div>
                                        </li>
                                    {/foreach}
                                </ul>
                            </div>
                        </div>
                    {else}
                        <input type="hidden" name="serviceType" value="{$defaultOrderServiceTypeId}"/>
                    {/if}
                    
                    <div id="serviceType">
                        {if $isAcademicWritingEnabled}
                            <div class="switch-combo {if $defaultOrderServiceTypeId != \Proxim\Order\Order::COMPLEX_ASSIGNMENT}x-hidden{/if}" data-service-type="{\Proxim\Order\Order::COMPLEX_ASSIGNMENT}" data-combo-value="{\Proxim\Order\Order::COMPLEX_ASSIGNMENT}">
                                {include file='dashboard/order/create/academic.tpl'}
                            </div>
                        {/if}
                        
                        {if $isProgrammingEnabled}
                            <div class="switch-combo {if $defaultOrderServiceTypeId != \Proxim\Order\Order::PROGRAMMING}x-hidden{/if}" data-service-type="{\Proxim\Order\Order::PROGRAMMING}" data-combo-value="{\Proxim\Order\Order::PROGRAMMING}">
                                {include file='dashboard/order/create/programming.tpl'}
                            </div>
                        {/if}

                        {if $isCalculationsEnabled}
                            <div class="switch-combo {if $defaultOrderServiceTypeId != \Proxim\Order\Order::CALCULATIONS}x-hidden{/if}" data-service-type="{\Proxim\Order\Order::CALCULATIONS}" data-combo-value="{\Proxim\Order\Order::CALCULATIONS}">
                                {include file='dashboard/order/create/calculations.tpl'}
                            </div>
                        {/if}

                        {if $isArticleWritingEnabled}
                            <div class="switch-combo {if $defaultOrderServiceTypeId != \Proxim\Order\Order::ARTICLE_WRITING}x-hidden{/if}" data-service-type="{\Proxim\Order\Order::ARTICLE_WRITING}" data-combo-value="{\Proxim\Order\Order::ARTICLE_WRITING}">
                                {include file='dashboard/order/create/article.tpl'}
                            </div>
                        {/if}
                    </div>

                    <div class="divider"></div>
                        
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">Total</label>
                        <div class="col-sm-8">
                            <span id="orderPrice" class="h2 text-success">$0.00</span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-md-9 offset-sm-3">
                            <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                            <!-- success -->
    
                            <!-- error -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->
                        </div>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <button type="submit" class="btn btn-primary">Create Order</button>
                </div>
            </form>
        </div>
    </div>
{/block}

{block name="custom_js"}
    <script type="text/javascript">
    $(function () { 
        var academicTariffs = {json_encode($academicTariffs) nofilter};
        var $form = $("#orderForm");
        var $form_target, serviceTypeId, $disciplineId;

        $form.find('[name="serviceType"]').change(function(e) {
            var serviceTypeId = $(this).val();
            $form_target = $form.find("[data-service-type~=" + serviceTypeId + "]");

            if(serviceTypeId == 50) {
                $form_target.find('[name="programming[topicCatId]"] option:first').prop('selected', true);
                $form_target.find('[name="programming[tariffId]"] option:first').prop('selected', true);
                $form_target.find('[name="programming[topicCatId]"]').change();

                // uncheck all
                $form.find('[name="programming[taskSizeId]"]').each(function () {
                    $(this).prop('checked', false);
                });

                $disciplineId = $form_target.find('[name="programming[topicCatId]"] option:first').val();
                var $taskSizes = $form_target.find("#taskSizes [data-combo-value~=" + $disciplineId + "]");
                $taskSizes.find('[name="programming[taskSizeId]"]').first().prop('checked', true);
            } else if (serviceTypeId == 51) {
                $form_target.find('[name="calculations[topicCatId]"] option:first').prop('selected', true);
                $form_target.find('[name="calculations[tariffId]"] option:first').prop('selected', true);
                $form_target.find('[name="calculations[topicCatId]"]').change();

                // uncheck all
                $form.find('[name="calculations[taskSizeId]"]').each(function () {
                    $(this).prop('checked', false);
                });

                $disciplineId = $form_target.find('[name="calculations[topicCatId]"] option:first').val();
                var $taskSizes = $form_target.find("#taskSizes [data-combo-value~=" + $disciplineId + "]");
                $taskSizes.find('[name="calculations[taskSizeId]"]').first().prop('checked', true);
            }
        });

        if($form.find('[name="academicLevelId"]')) {
            var academicLevel = $("[name='academicLevelId'] :selected").val();
            renderTariffs(academicLevel);
        }   

        $form.find('[name="academicLevelId"]').change(function(e) {
            academicLevel = $("[name='academicLevelId'] :selected").val();
            renderTariffs(academicLevel);
        });

        $(document).on('change click input', $form.find('.js_calculate'), function(e) {
            calculate();
        });

        $('.js_custom-toggle').on('change',function(){
            var _this = $(this);
            var $value= _this.val();
            var $val = _this.data('val');
            var parent = $(this).closest('.form-group');

            if($value == $val) {
                parent.next('.form-group').removeClass('x-hidden');
            } else {
                parent.next('.form-group').addClass('x-hidden');
            }
        });

        function renderTariffs( academicLevel ) {
            var tariffControl = $("[data-tariff-control]");
            tariffControl.empty();

            if ( academicLevel ) {
                var activeTariff = academicTariffs[academicLevel];
                $.each(activeTariff, function(i, tariff){
                    tariffControl.append( $('<option>').text(tariff.name).attr('value', tariff.id).attr('data-hrs', tariff.hrs).attr('data-cpp', tariff.pricePerPage.value) );
                });
            }

            return true;
        }

        function calculate() {
            var availableWinbackCoupons = discount = null;
            var formStateForCalculator = {};
            serviceTypeId = parseInt($form.find('[name="serviceType"]:checked').val()) || parseInt($form.find('[name="serviceType"]').val());
            $form_target = $form.find("[data-service-type~=" + serviceTypeId + "]");

            try {
                switch(serviceTypeId) {
                    case 50:
                        var itemPrice = $form_target.find('[name="calculations[taskSizeId]"]:checked').data('price') || 0;
                        var priceModifier = $form_target.find('[name="calculations[tariffId]"] :selected').data('pricing') || 0;
                        $form_target.find('[name="calculations[priceModifier]"]').val(priceModifier);

                        var cost = normalizePrice(itemPrice * priceModifier);
                        $form.find("#orderPrice").text("$"+cost);
                        break;

                    case 51:
                        var itemPrice = $form_target.find('[name="programming[taskSizeId]"]:checked').data('price') || 0;
                        var priceModifier = $form_target.find('[name="programming[tariffId]"] :selected').data('pricing') || 0;
                        $form_target.find('[name="programming[priceModifier]"]').val(priceModifier);

                        var cost = normalizePrice(itemPrice * priceModifier);
                        $form.find("#orderPrice").text("$"+cost);
                        break;
                        
                    case 52:
                        var pricePerWord = $form_target.find('[name="article[tariffId]"] :selected').data('pricing') || 0;
                        var wordsQty = parseInt($form_target.find('[name="article[words]"]').val());
                        var writerCategoryPercent = $form_target.find('[name="article[writerCategory]"]:checked').data('percent') || 0;
                        
                        var cost = normalizePrice(pricePerWord * wordsQty);
                        var prefferedWriterPrice = normalizePrice(
                            (cost * writerCategoryPercent) / 100
                        );

                        var baseCost = normalizePrice(cost + prefferedWriterPrice);
                        $form.find("#orderPrice").text("$"+baseCost);
                        break;

                    case 37:
                    default:
                        formStateForCalculator = {
                            discount,
                            winbackCoupons: availableWinbackCoupons,
                            writerCategoryId: parseInt($form_target.find('[name="writerCategoryId"] :selected').val()) || null,
                            writerPercent: parseInt($form_target.find('[name="writerCategoryId"] :selected').data('percent')) || null,
                            complexAssignmentDiscipline: $form_target.find('[name="topicCatId"] :selected').data('complex') || 0,
                            pages: parseFloat($form_target.find('[name="pages"]').val()),
                            slides: parseInt($form_target.find('[name="slides"]').val()),
                            charts: parseInt($form_target.find('[name="charts"]').val()),
                            excelSheets: parseInt($form_target.find('[name="excelSheets"]').val()),
                            tariffPricePerPage: $form_target.find('[name="tariffId"] :selected').data('cpp') || 0,
                            tariffHrs: $form_target.find('[name="tariffId"] :selected').data('hrs') || 0,
                            spacing: $form_target.find('[name="spacing"]:checked').val() || false,
                            getSamplesOn: $form_target.find('[name="samplesNeeded"]:checked').val() || false,
                            getProgressiveDeliveryOn: $form_target.find('[name="progressiveDeliveryHidden"]:checked').val() || false,
                            getUsedSourcesOn: $form_target.find('[name="usedsources"]:checked').val() || false,
                            expertProofreading: $form_target.find('[name="expertProofreading"]:checked').val() || false
                        };
                        var cost = PROXIMCostCalculator.calculate(formStateForCalculator);
                        $form.find("#orderPrice").text("$"+cost.totalCost);
                        break;
                }
                
            } catch (e) {
                console.error(e);
            }
        }        
    });
    </script>
{/block}