<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left" for="typeOfContent">Type of content</label>
    <div class="col-sm-8">
        <select name="article[typeOfContent]" class="form-select js_calculate" data-ui="lg" data-search="on">
            {foreach $configsForArticleWriting.contentTypes as $contentType}
                <option value="{$contentType.paper_type_id}">{$contentType.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left" for="categoryId">Category</label>
    <div class="col-sm-8">
        <select name="article[categoryId]" id="categoryId" class="form-select js_calculate" data-ui="lg" data-search="on">
            {foreach $configsForArticleWriting.categories as $category}
                <option value="{$category.discipline_id}">{$category.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left" for="title">Title</label>
    <div class="col-sm-8">   
        <input type="text" class="form-control form-control-lg" name="article[title]" id="title" maxlength="255">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left" for="paperDetails">Additional Information</label>
    <div class="col-sm-8">
        <textarea name="article[paperDetails]" class="form-control summernote-minimal" data-height="100"></textarea>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left" for="title">Suggested keywords</label>
    <div class="col-sm-8">   
        <input type="text" class="form-control form-control-lg" name="article[keywords]" id="keywords">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Deadline</label>
    <div class="col-sm-4">
        <select name="article[tariffId]" class="form-select js_calculate" data-ui="lg">
            {foreach $configsForArticleWriting.tariffs as $tariff}
                <option value="{$tariff.id}" data-pricing="{$tariff.pricePerWord.value}">{$tariff.name}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Words</label>
    <div class="col-sm-4">
        <div class="form-control-wrap number-spinner-wrap">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                <em class="icon ni ni-minus"></em>
            </button>
            <input type="text" name="article[words]" class="form-control form-control-lg js_calculate number-spinner" placeholder="pages" value="200" min="0" max="999">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                <em class="icon ni ni-plus"></em>
            </button>
        </div>
    </div>
</div>

<div class="data-head my-5">
    <h6 class="overline-title">Additional Information</h6>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Writer category</label>
    <div class="col-sm-10">
        <div class="form-selectgroup-boxes row mb-3">
            <div class="col-md-4">
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[writerCategory]" value="2" data-percent="0" class="form-selectgroup-input" checked>
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr-2">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title fw-bold mb-1">Standard</span>
                            <span class="d-block text-muted fw-normal">Great content on a budget. Professional writers who we've vetted, tested, and approved.</span>
                        </span>
                    </span>
                </label>
            </div>
            <div class="col-md-4">
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[writerCategory]" value="3" data-percent="25" class="form-selectgroup-input">
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr-2">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title fw-bold mb-1">Premium</span>
                            <span class="d-block text-muted fw-normal">Well researched content written by tested and talented writers who have a great rating in our system.</span>
                        </span>
                    </span>
                </label>
            </div>
            <div class="col-md-4">
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[writerCategory]" value="4" data-percent="30" class="form-selectgroup-input">
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr-2">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title fw-bold mb-1">Ultimate</span>
                            <span class="d-block text-muted fw-normal">Thoroughly researched content written by the very best writers in our talent pool (and on the planet).</span>
                        </span>
                    </span>
                </label>
            </div>
        </div>
    </div>
</div>

<div class="form-group form-row mb-2">
    <label class="col-sm-2 form-label text-left">English Type</label>
    <div class="col-sm-10">
        <div class="form-selectgroup mb-3">
            {foreach $configsForArticleWriting.englishTypes as $englishType}
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[englishTypeId]" value="{$englishType.id}" class="form-selectgroup-input">
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr-2">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title fw-bold mb-1">{$englishType.title}</span>
                        </span>
                    </span>
                </label>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row mb-2">
    <label class="col-sm-2 form-label text-left">Target Audience</label>
    <div class="col-sm-10">
        <div class="form-selectgroup mb-3">
            {foreach $configsForArticleWriting.targetAudiences as $targetAudience}
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[targetAudienceId]" value="{$targetAudience.id}" class="form-selectgroup-input">
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr-2">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title fw-bold mb-1">{$targetAudience.title}</span>
                        </span>
                    </span>
                </label>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row mb-2">
    <label class="col-sm-2 form-label text-left">Writing Tone</label>
    <div class="col-sm-10">
        <div class="form-selectgroup-boxes row mb-3">
            {foreach $configsForArticleWriting.writingTones as $writingTone}
                <div class="col-md-4">
                    <label class="form-selectgroup-item">
                        <input type="radio" name="article[writingToneId]" value="{$writingTone.id}" class="form-selectgroup-input">
                        <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                            <span class="mr-2">
                                <span class="form-selectgroup-check"></span>
                            </span>
                            <span class="form-selectgroup-label-content">
                                <span class="form-selectgroup-title fw-bold mb-1">{$writingTone.title}</span>
                                <span class="d-block text-muted fw-normal">{$writingTone.description}</span>
                            </span>
                        </span>
                    </label>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row mb-2">
    <label class="col-sm-2 form-label text-left">Writing Style</label>
    <div class="col-sm-10">
        <div class="form-selectgroup-boxes row mb-3">
            {foreach $configsForArticleWriting.writingStyles as $writingStyle}
                <div class="col-md-6">
                    <label class="form-selectgroup-item">
                        <input type="radio" name="article[writingStyleId]" value="{$writingStyle.id}" class="form-selectgroup-input">
                        <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                            <span class="mr-2">
                                <span class="form-selectgroup-check"></span>
                            </span>
                            <span class="form-selectgroup-label-content">
                                <span class="form-selectgroup-title fw-bold mb-1">{$writingStyle.title}</span>
                                <span class="d-block text-muted fw-normal">{$writingStyle.description}</span>
                            </span>
                        </span>
                    </label>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Content Feel</label>
    <div class="col-sm-10">
        <div class="form-selectgroup-boxes row mb-3">
            {foreach $configsForArticleWriting.contentFeels as $contentFeel}
                <div class="col-md-6">
                    <label class="form-selectgroup-item">
                        <input type="radio" name="article[contentFeelId]" value="{$contentFeel.id}" class="form-selectgroup-input">
                        <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                            <span class="mr-2">
                                <span class="form-selectgroup-check"></span>
                            </span>
                            <span class="form-selectgroup-label-content">
                                <span class="form-selectgroup-title fw-bold mb-1">{$contentFeel.title}</span>
                                <span class="d-block text-muted fw-normal">{$contentFeel.description}</span>
                            </span>
                        </span>
                    </label>
                </div>
            {/foreach}
        </div>
    </div>
</div>