{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Addons</h3>
                </div>
                <div class="nk-block-head-content">
                    {if $sub_view == "catalogue"}
                        <a class="btn btn-white btn-dim btn-outline-light mr10" href="{$base_uri}/modules/catalogue?refresh" data-ajax="/modules/catalogue?refresh"> 
                            <em class="icon ni ni-update"></em> <span>Refresh</span>
                        </a>
                        <button data-toggle="modal" data-url="#modalUploadPlugin" type="button" class="btn btn-primary">
                            <em class="icon ni ni-upload"></em> <span>Upload Addon</span>
                        </button>
                    {/if}
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>
 
        <div class="nk-block">  
            <div class="card card-bordered card-preview">
                <div class="card-inner">

                    <ul class="nav nav-tabs mt-n3">
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "catalogue"}active{/if}" href="{$base_uri}/modules/catalogue" data-ajax="/modules/catalogue">
                                <em class="icon ni ni-puzzle-fill"></em><span>Catalogue</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "installed"}active{/if}" href="{$base_uri}/modules/installed" data-ajax="/modules/installed">
                                <em class="icon ni ni-download"></em><span>Installed</span>
                            </a>
                        </li>
                    </ul>

                    <div class="tab-content">
                        {if $sub_view == "catalogue"}
            
                            {if count($modules_list)} 
                                <div class="row g-gs"> 
                                    {foreach $modules_list as $module}
                                        <div class="col-md-6">
                                            <div class="card shadow-none border">
                                                <div class="card-inner p-2">
                                                    <div class="align-center flex-wrap flex-md-nowrap g-4">
                                                        <div class="nk-block-image w-100px flex-shrink-0">
                                                            <div class="user-avatar avatar-img sq lg" style="background-image: url({$module->logo});background-size: contain;"></div>
                                                        </div>
                                                        <div class="nk-block-content">
                                                            <div class="nk-block-content-head px-lg-2">
                                                                <h6>{$module->displayName}</h6>
                                                                <p class="text-soft">{$module->description}</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-footer bg-white border-top p-2">
                                                    {if $module->not_on_disk}
                                                        {if isset($module->price)}
                                                            <a href="{$module->buylink}" class="btn btn-primary ml-auto">Buy {formatPrice($module->price)}</a>
                                                        {else}
                                                            <button data-module="{$module->name}" class="btn btn-success ml-auto js_download-module">
                                                                <em class="icon ni ni-download"></em><span>Install</span>
                                                            </button>
                                                        {/if}
                                                    {else}
                                                        {if !$module->installed}
                                                            {if isset($module->price)}
                                                                <a href="{$module->buylink}" class="btn btn-white btn-dim btn-outline-light">Buy {formatPrice($module->price)}</a>
                                                                <button data-options='{literal}{{/literal}"module_name":"{$module->name}"{literal}}{/literal}' data-toggle="modal" data-url="#activateModule" data-title="Activate Module" class="btn btn-primary ml-auto js_activate-module">Activate</button>
                                                            {else}
                                                                <button data-module="{$module->name}" data-title="{$module->displayName}" class="btn btn-primary ml-auto js_install-module">
                                                                    <em class="icon ni ni-download"></em><span>Install</span>
                                                                </button>
                                                            {/if}
                                                        {else}
                                                            <button data-module="{$module->name}" class="btn btn-secondary btn-dim btn-outline-light ml-auto js_uninstall-module">
                                                                <em class="icon ni ni-trash"></em><span>Uninstall</span>
                                                            </button>
                                                        {/if}
                                                    {/if}
                                                </div>
                                            </div>
                                            <!-- .sp-pdl-item -->
                                        </div>
                                    {/foreach}
                                </div>
                            {else}
                                <div class="text-center x-muted"> 
                                    <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                    <p class="mb10"><strong>No modules to show</strong></p>
                                </div>
                            {/if}
                        
                        {elseif $sub_view == "installed"}

                            {if count($modules_list)} 
                                <div class="row g-gs"> 
                                    {foreach $modules_list as $activeModule}
                                        <div class="col-md-6">
                                            <div class="card shadow-none border">
                                                <div class="card-inner p-2">
                                                    <div class="align-center flex-wrap flex-md-nowrap g-4">
                                                        <div class="nk-block-image w-100px flex-shrink-0">
                                                            <div class="user-avatar avatar-img sq lg" style="background-image: url({$activeModule->logo});background-size: contain !important;"></div>
                                                        </div>
                                                        <div class="nk-block-content">
                                                            <div class="nk-block-content-head px-lg-2">
                                                                <h6>{$activeModule->displayName}</h6>
                                                                <p class="text-soft">{$activeModule->description}</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-footer bg-white border-top p-2">
                                                    {if $activeModule->configure}
                                                        <a href="{$base_uri}/{$activeModule->name}/configure" data-ajax="/{$activeModule->name}/configure" class="btn btn-info ml-autos">
                                                            <em class="icon ni ni-setting"></em><span>Configure</span>
                                                        </a>
                                                    {/if}

                                                    {if $activeModule->installed}
                                                        <button data-module="{$activeModule->name}" class="btn btn-secondary btn-dim btn-outline-light ml-auto js_uninstall-module">
                                                            <em class="icon ni ni-trash"></em><span>Uninstall</span>
                                                        </button>
                                                    {elseif $activeModule->installed}
                                                    {else}
                                                        <button data-module="{$activeModule->name}" class="btn btn-primary ml-auto js_install-module">
                                                            <em class="icon ni ni-download"></em><span>Install</span>
                                                        </button>
                                                    {/if}
                                                </div>
                                            </div>
                                            <!-- .sp-pdl-item -->
                                        </div>
                                    {/foreach}
                                </div>
                            {else}
                                <div class="text-center x-muted"> 
                                    <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                    <p class="mb10"><strong>No modules to show</strong></p>
                                </div>
                            {/if}

                        {/if}

                    </div>
                </div>
            </div>
        </div>

    </div>
{/block}