<div class="wide-md">
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">
                    Mailing / <strong class="text-primary small">Mail templates</strong>
                </h3> 
            </div>
            {if $_tab == "templates"}
                <div class="nk-block-head-content">
                    <a href="{$base_uri}/mailing/templates" data-ajax="/mailing/templates/add" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> <span>Add New Templete</span>
                    </a>
                </div>
            {/if}
        </div>
    </div>

    <div class="card card-bordered">
        <div class="card-inner">
            {if $_tab == "templates"}
                <div class="heading-small mb-2">Orders</div>
                {if count($orderTemplates)}
                    <table class="table table-tranx mb-4">
                        <thead>
                            <tr class="tb-tnx-head"">
                                <th class="tb-tnx-info" width="80%">Template Name</th>
                                <th class="nk-tb-col nk-tb-col-tools text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $orderTemplates as $template}
                                <tr class="tb-tnx-item">
                                    <td class="tb-tnx-id fw-bold">
                                        <a href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">{$template.name}</a>
                                    </td>
                                    <td class="tb-tnx-action">
                                        <div class="dropdown">
                                            <a class="text-soft dropdown-toggle btn btn-icon btn-trigger" id="dropdownMenu-{$template.mail_template_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <em class="icon ni ni-more-h"></em>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-xs" aria-labelledby="dropdownMenu-{$template.mail_template_id}">
                                                <ul class="link-list-plain">
                                                    <li>
                                                        <a class="dropdown-item" href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">
                                                            <i class="icon ni ni-edit mr5"></i> <span>Edit</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="mail_template" data-id="{$template.mail_template_id}">
                                                            <i class="icon ni ni-trash mr5"></i> <span>Delete</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb-2"><strong>No order templates to show</strong></p>
                    </div>
                {/if}

                <div class="heading-small mb-2">Customers</div>

                {if count($customerTemplates)}
                    <table class="table table-tranx mb-4">
                        <thead>
                            <tr class="tb-tnx-head"">
                                <th class="tb-tnx-info" width="80%">Template Name</th>
                                <th class="nk-tb-col nk-tb-col-tools text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $customerTemplates as $template}
                                <tr class="tb-tnx-item">
                                    <td class="tb-tnx-id fw-bold">
                                        <a href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">{$template.name}</a>
                                    </td>
                                    <td class="tb-tnx-action">
                                        <div class="dropdown">
                                            <a class="text-soft dropdown-toggle btn btn-icon btn-trigger" id="dropdownMenu-{$template.mail_template_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <em class="icon ni ni-more-h"></em>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-xs" aria-labelledby="dropdownMenu-{$template.mail_template_id}">
                                                <ul class="link-list-plain">
                                                    <li>
                                                        <a class="dropdown-item" href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">
                                                            <i class="icon ni ni-edit mr5"></i> <span>Edit</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="mail_template" data-id="{$template.mail_template_id}">
                                                            <i class="icon ni ni-trash mr5"></i> <span>Delete</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb-2"><strong>No customer templates to show</strong></p>
                    </div>
                {/if}

                <div class="heading-small mb-2">Employees</div>

                {if count($employeeTemplates)}
                    <table class="table table-tranx">
                        <thead>
                            <tr class="tb-tnx-head"">
                                <th class="tb-tnx-info" width="80%">Template Name</th>
                                <th class="nk-tb-col nk-tb-col-tools text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $employeeTemplates as $template}
                                <tr class="tb-tnx-item">
                                    <td class="tb-tnx-id fw-bold">
                                        <a href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">{$template.name}</a>
                                    </td>
                                    <td class="tb-tnx-action">
                                        <div class="dropdown">
                                            <a class="text-soft dropdown-toggle btn btn-icon btn-trigger" id="dropdownMenu-{$template.mail_template_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <em class="icon ni ni-more-h"></em>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-xs" aria-labelledby="dropdownMenu-{$template.mail_template_id}">
                                                <ul class="link-list-plain">
                                                    <li>
                                                        <a class="dropdown-item" href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">
                                                            <i class="icon ni ni-edit mr5"></i> <span>Edit</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="mail_template" data-id="{$template.mail_template_id}">
                                                            <i class="icon ni ni-trash mr5"></i> <span>Delete</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb-2"><strong>No employee templates to show</strong></p>
                    </div>
                {/if}
            {elseif $_tab == "add"}
                <form class="js_ajax-forms row" data-url="/admin/mailing?do=add_template" autocomplete="off">
                    <div class="col-md-7">
                        <div class="form-group">
                            <label class="form-label text-left mb-2">Template</label>
                            <select class="form-select" data-ui="lg" name="template">
                                <optgroup label="Orders"> 
                                    <option value="order_payment" {if isset($emailTemplates['order_payment'])}disabled{/if}>Successful Order Payment (Sent to Customer)</option>
                                    <option value="new_order_available" {if isset($emailTemplates['new_order_available'])}disabled{/if}>New Order Available (Sent to Support &amp; Writers)</option>
                                    <option value="order_files" {if isset($emailTemplates['order_files'])}disabled{/if}>Order Files Uploaded (Sent to Support &amp; Writers)</option>
                                    <option value="order_assign" {if isset($emailTemplates['order_assign'])}disabled{/if}>New Order Assigned (Sent to Writers &amp; Editors)</option>
                                    <option value="writer_submitted_order" {if isset($emailTemplates['writer_submitted_order'])}disabled{/if}>Writer Submitted Order (Sent to Support)</option>
                                    <option value="editor_new_order" {if isset($emailTemplates['editor_new_order'])}disabled{/if}>New Order Available (Sent to Editor)</option>
                                    <option value="order_complete" {if isset($emailTemplates['order_complete'])}disabled{/if}>Order Complete (Sent to Customer)</option>
                                    <option value="order_status_change" {if isset($emailTemplates['order_status_change'])}disabled{/if}>Order Status Changed (Sent to Customer)</option>
                                    <option value="order_revision_request" {if isset($emailTemplates['order_revision_request'])}disabled{/if}>Order Revision Request (Sent to Support)</option>
                                    <option value="order_message" {if isset($emailTemplates['order_message'])}disabled{/if}>New Message (Sent to Customer &amp; Writers)</option>
                                    <option value="feedback_reply" {if isset($emailTemplates['feedback_reply'])}disabled{/if}>Feedback Reply  (Sent to Customer)</option>
                                    <option value="pay_order_reminder" {if isset($emailTemplates['pay_order_reminder'])}disabled{/if}>Pay Order Reminder (Sent to Customer)</option>
                                    <option value="order_file_delete" {if isset($emailTemplates['order_file_delete'])}disabled{/if}>Order File Delete Request (Sent to Support)</option>
                                    <option value="order_refund_request" {if isset($emailTemplates['order_refund_request'])}disabled{/if}>Order Refund Request (Sent to Support)</option>
                                </optgroup>
                                <optgroup label="Employees">
                                    <option value="employee_password_change" {if isset($emailTemplates['employee_password_change'])}disabled{/if}>Password Reset - Confirmation</option>
                                    <option value="employee_two_factor_email" {if isset($emailTemplates['employee_two_factor_email'])}disabled{/if}>Two Factor Authentication</option>
                                </optgroup>
                                <optgroup label="Customers">
                                    <option value="customer_password_change" {if isset($emailTemplates['customer_password_change'])}disabled{/if}>Password Reset - Confirmation</option>
                                </optgroup>
                            </select>
                        </div>

                        <div class="form-group">
                            <!-- success -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Add Template</button>
                        </div>
                    </div>
                </form>
            {elseif $_tab == "edit"}
                <form class="js_ajax-forms row" data-url="/admin/mailing?do=edit_template" autocomplete="off">
                    <input type="hidden" name="template_id" value="{$mailTemplate.id}">
                    <div class="col-md-7">
                        <div class="form-group">
                            <label class="form-label text-left mb-2">Template Title</label>
                            <input class="form-control form-control-lg" type="text" name="name" value="{$mailTemplate.name}" disabled="">
                        </div>

                        <div class="form-group">
                            <label class="form-label text-left mb-2">Subject</label>
                            <input class="form-control form-control-lg" type="text" name="subject" value="{$mailTemplate.subject}" required="">
                        </div>

                        <div class="form-group">
                            <label class="form-label text-left mb-2">From Name</label>
                            <input class="form-control form-control-lg" type="text" name="from_name" value="{$mailTemplate.from_name}" required="">
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="plaintext" id="plaintext" {if $mailTemplate.plaintext == '1'}checked{/if}>
                                <label for="plaintext" class="custom-control-label">Send as Plaintext</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="is_disabled" id="is_disabled" {if $mailTemplate.is_disabled == '1'}checked{/if}>
                                <label for="is_disabled" class="custom-control-label">Disabled</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label text-left mb-2">Email message</label>
                            <textarea class="form-control summernote-minimal" rows="10" name="message">{$mailTemplate.message nofilter}</textarea>
                        </div>

                        <div class="form-group">
                            <!-- success -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="heading-small mb-2">Available merge fields</div>
                        {if $mailTemplate.template == 'order_payment' || 
                            $mailTemplate.template == 'order_files'
                        }
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Customer</h6>
                                    <p class="mb-1 d-flex">Customer Name<span class="ml-auto text-primary">{username}</span></p>
                                </div>
                            {/literal}

                        {elseif $mailTemplate.template == 'writer_submitted_order' || 
                                $mailTemplate.template == 'order_complete'
                        }
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'order_status_change'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Customer</h6>
                                    <p class="mb-1 d-flex">Customer Name<span class="ml-auto text-primary">{username}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'order_assign'}
                        {elseif $mailTemplate.template == 'editor_new_order'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Employee</h6>
                                    <p class="mb-1 d-flex">Employee Name<span class="ml-auto text-primary">{username}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'new_order_available'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'order_file_delete'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">File</h6>
                                    <p class="mb-1 d-flex">File ID<span class="ml-auto text-primary">{file_id}</span></p>
                                    <p class="mb-1 d-flex">File Name<span class="ml-auto text-primary">{file_name}</span></p>
                                    <p class="mb-1 d-flex">File Size<span class="ml-auto text-primary">{file_size}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'feedback_reply'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Feedback</h6>
                                    <p class="mb-1 d-flex">Customer Feedback<span class="ml-auto text-primary">{username}</span></p>
                                    <p class="mb-1 d-flex">Support Reply<span class="ml-auto text-primary">{support_reply}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Customer</h6>
                                    <p class="mb-1 d-flex">Customer Name<span class="ml-auto text-primary">{username}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'writer_submitted_order'}
                        {elseif $mailTemplate.template == 'pay_order_reminder'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Customer</h6>
                                    <p class="mb-1 d-flex">Customer Name<span class="ml-auto text-primary">{username}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'order_refund_request'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Refund</h6>
                                    <p class="mb-1 d-flex">Content<span class="ml-auto text-primary">{content}</span></p>
                                    <p class="mb-1 d-flex">Sources<span class="ml-auto text-primary">{sources}</span></p>
                                    <p class="mb-1 d-flex">Format<span class="ml-auto text-primary">{format}</span></p>
                                    <p class="mb-1 d-flex">Grammar<span class="ml-auto text-primary">{grammar}</span></p>
                                    <p class="mb-1 d-flex">Instructions<span class="ml-auto text-primary">{instructions}</span></p>
                                    <p class="mb-1 d-flex">Other<span class="ml-auto text-primary">{other}</span></p>
                                    <p class="mb-1 d-flex">Message Body<span class="ml-auto text-primary">{message_body}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'order_revision_request'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                    <p class="mb-1 d-flex">Order Title<span class="ml-auto text-primary">{order_title}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Revision</h6>
                                    <p class="mb-1 d-flex">Sources<span class="ml-auto text-primary">{sources}</span></p>
                                    <p class="mb-1 d-flex">Format<span class="ml-auto text-primary">{format}</span></p>
                                    <p class="mb-1 d-flex">Grammar<span class="ml-auto text-primary">{grammar}</span></p>
                                    <p class="mb-1 d-flex">Instructions<span class="ml-auto text-primary">{instructions}</span></p>
                                    <p class="mb-1 d-flex">Customize Content<span class="ml-auto text-primary">{customize_content}</span></p>
                                    <p class="mb-1 d-flex">Other<span class="ml-auto text-primary">{other}</span></p>
                                    <p class="mb-1 d-flex">Message Body<span class="ml-auto text-primary">{message_body}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'order_message'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Message</h6>
                                    <p class="mb-1 d-flex">Subject<span class="ml-auto text-primary">{subject}</span></p>
                                    <p class="mb-1 d-flex">Username<span class="ml-auto text-primary">{username}</span></p>
                                    <p class="mb-1 d-flex">Text Message<span class="ml-auto text-primary">{text_message}</span></p>
                                    <p class="mb-1 d-flex">HTML Message<span class="ml-auto text-primary">{message}</span></p>
                                    <p class="mb-1 d-flex">Receiver Department<span class="ml-auto text-primary">{to_department}</span></p>
                                    <p class="mb-1 d-flex">Sender Department<span class="ml-auto text-primary">{from_department}</span></p>
                                </div> 

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Order</h6>
                                    <p class="mb-1 d-flex">Order ID<span class="ml-auto text-primary">{order_id}</span></p>
                                    <p class="mb-1 d-flex">Order Link<span class="ml-auto text-primary">{order_url}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'employee_password_change'}
                        {elseif $mailTemplate.template == 'customer_password_change'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Reset Link</h6>
                                    <p class="mb-1 d-flex">Password Reset Link<span class="ml-auto text-primary">{reset_url}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Employee</h6>
                                    <p class="mb-1 d-flex">Employee Name<span class="ml-auto text-primary">{username}</span></p>
                                </div>
                            {/literal}
                        {elseif $mailTemplate.template == 'employee_two_factor_email'}
                            {literal}
                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Two Factor</h6>
                                    <p class="mb-1 d-flex">Two Factor Key<span class="ml-auto text-primary">{two_factor_key}</span></p>
                                </div>

                                <div class="mb-2">
                                    <h6 class="fw-bold mb-2">Employee</h6>
                                    <p class="mb-1 d-flex">Employee Name<span class="ml-auto text-primary">{username}</span></p>
                                </div>
                            {/literal}
                        {/if}
                        {literal}
                            <div class="mb-2">
                                <h6 class="fw-bold mb-2">Website</h6>
                                <p class="mb-1 d-flex">Site Name<span class="ml-auto text-primary">{site_name}</span></p>
                            </div>
                        {/literal}
                    </div>
                </form>
            {/if}
        </div>
    </div>
</div>
