{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 
    <div class="wide-sm mx-auto">
        <div class="nk-block-head nk-block-head-lg wide-sm">
            <div class="nk-block-head-content">
                {if $sub_view == "writing-guide"}
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/info/writing-guide" data-ajax="/info/writing-guide">
                            <em class="icon ni ni-arrow-left"></em><span>Writing Guide</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Edit Guide</h2>
                {elseif $sub_view == "payment-guide"}
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/info/payment-guide" data-ajax="/info/payment-guide">
                            <em class="icon ni ni-arrow-left"></em><span>Payment Guide</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Edit Guide</h2>
                {elseif $sub_view == "faqs"}
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/info/faqs" data-ajax="/info/faqs">
                            <em class="icon ni ni-arrow-left"></em><span>FAQs</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Edit FAQ</h2>
                {/if}
            </div>
        </div>

        <div class="card card-bordered">
            <div class="card-inner">
                <form class="js_ajax-forms" data-url="/info/{$sub_view}/edit" autocomplete="off">
                    <input type="hidden" name="guide_id" value="{$guide.id}"/>
                    <div class="form-group mb-2">
                        <label class="form-label" for="title">Title</label>
                        <input type="text" class="form-control form-control-lg" name="title" id="title" value="{$guide.title}">
                    </div>

                    <div class="form-group mb-2">
                        <label class="form-label" for="coupon_expiry">Guide</label>
                        <textarea class="form-control summernote-minimal" data-height="250" name="guide">{$guide.guide nofilter}</textarea>
                    </div>

                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->

                    <div class="mt-4 text-center">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="icon ni ni-save"></i><span>Save Changes</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
{/block}