{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Feedback
                        {if $sub_view == "employee_feedback"} &rsaquo; <strong class="small">Employee</strong> &rsaquo; <strong class="small text-primary">{$employee_name}</strong>{/if}
                    </h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        {if $sub_view == "feedback" || $sub_view == "employee_feedback"}
            <div class="nk-block">
                <div class="row g-gs">
                    <div class="col-md-12 col-lg-6">
                        <div class="card card-bordered">
                            <div class="card-inner">
                                <h6 class="card-title">Customer Rating</h6>
                                <div class="d-flex align-center gy-3">
                                    <div class="progress-amount mr-4">
                                        <h1 class="title">{$insights['average_customer_rating']}</h1>
                                        <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_customer_rating']}">
                                            <span class="Rating-total">
                                                <span class="Rating-progress"></span>
                                            </span>
                                        </div>
                                        <span class="sub-text mt-1"><em class="icon ni ni-users-fill"></em> {$insights['total_customer_reviews']} Total</span>
                                    </div>

                                    <div class="rating-progress-bar gy-2 w-100">
                                        {foreach range(1,5) as $i}
                                            <div class="progress-rating">
                                                <div class="progress-rating-title">{$i} star</div>
                                                {if isset($insights['customer_ratings'][$i])}
                                                    <div class="progress progress-md progress-alt">
                                                        <div class="progress-bar mb-0 bg-teal" data-progress="{$insights['customer_ratings'][$i]['width']}"></div>
                                                    </div>
                                                    <div class="progress-rating-percent">{$insights['customer_ratings'][$i]['total_rating']}</div>
                                                {else}
                                                    <div class="progress progress-md progress-alt">
                                                        <div class="progress-bar mb-0 bg-teal" data-progress="0" style="width: 0%;"></div>
                                                    </div>
                                                    <div class="progress-rating-percent">0</div>
                                                {/if}
                                            </div>
                                        {/foreach}
                                    </div>
                                </div>
                            </div>
                            <!-- .card-inner -->
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-6">
                        <div class="card card-bordered">
                            <div class="card-inner">
                                <h6 class="card-title">Editor Rating</h6>
                                <div class="d-flex align-center gy-3">
                                    <div class="progress-amount mr-4">
                                        <h1 class="title">{$insights['average_editor_rating']}</h1>
                                        <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_editor_rating']}">
                                            <span class="Rating-total">
                                                <span class="Rating-progress"></span>
                                            </span>
                                        </div>
                                        <span class="sub-text mt-1"><em class="icon ni ni-users-fill"></em> {$insights['total_editor_reviews']} Total</span>
                                    </div>

                                    <div class="rating-progress-bar gy-2 w-100">
                                        {foreach range(1,5) as $i}
                                            <div class="progress-rating">
                                                <div class="progress-rating-title">{$i} star</div>
                                                {if isset($insights['editor_ratings'][$i])} 
                                                    <div class="progress progress-md progress-alt">
                                                        <div class="progress-bar mb-0 bg-teal" data-progress="{$insights['editor_ratings'][$i]['width']}"></div>
                                                    </div>
                                                    <div class="progress-rating-percent">{$insights['editor_ratings'][$i]['total_rating']}</div>
                                                {else}
                                                    <div class="progress progress-md progress-alt">
                                                        <div class="progress-bar mb-0 bg-teal" data-progress="0" style="width: 0%;"></div>
                                                    </div>
                                                    <div class="progress-rating-percent">0</div>
                                                {/if}
                                            </div>
                                        {/foreach}
                                    </div>
                                </div>
                            </div>
                            <!-- .card-inner -->
                        </div>
                    </div>
                </div>

            </div>

            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">Feedback</h4>
                    <p>You have total {pluralize('review', count($ratings))}.</p>
                </div>
            </div>

            {if count($ratings)}
                <div class="table-responsive">
                    <table class="nk-tb-list is-separate nk-tb-ulist mb-3">
                        <thead>
                            <tr class="nk-tb-item nk-tb-head">
                                <th class="nk-tb-col">Order ID</th>
                                <th class="nk-tb-col">Paper Rating</th>
                                <th class="nk-tb-col tb-col-md">Paper on Time</th>
                                <th class="nk-tb-col">Date</th>
                                <th class="nk-tb-col nk-tb-col-tools text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $ratings as $rating}
                                <tr class="nk-tb-item {if $rating.user_type == 'employee'}info{/if}">
                                    <td class="nk-tb-col">
                                        <a class="fw-bold" target="_blank" href="{$base_uri}/order/{$rating.order_id}" data-ajax="/order/{$rating.order_id}">#{$rating.order_id}</a>
                                    </td>
                                    <td class="nk-tb-col">  
                                        <div class="Rating Rating--labeled" data-star_rating="{$rating.paper_rating}">
                                            <span class="Rating-total">
                                                <span class="Rating-progress"></span>
                                            </span>
                                        </div>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        {if $rating.paper_on_time}
                                            <span class="badge badge-success">Yes</span>
                                        {else}
                                            <span class="badge badge-danger">No</span>
                                        {/if}
                                    </td>
                                    <td class="nk-tb-col">
                                        <span class="js_moment" data-time="{$rating.date}">{$rating.date}</span>
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <ul class="nk-tb-actions gx-1">
                                            <li>
                                                <button class="btn btn-primary btn-sm btn-dim" data-toggle="modal" data-url="#viewFeedbackModal" data-options="{$rating|json_encode}">
                                                    <i class="icon ni ni-eye mr5"></i> <span>View</span>
                                                </button>
                                            </li>
                                            <li>
                                                <button class="btn btn-danger btn-dim btn-sm js_deleter" data-handle="rating" data-id="{$rating.id}">
                                                    <i class="icon ni ni-trash mr5"></i> <span>Delete</span>
                                                </button>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                    <h6 class="text-dark title mb-3">No feedback to show</h6>
                </div>
            {/if} 

        {elseif $sub_view == "view"}
            <div class="card-body">
                <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info ratings">
                    <tbody>
                        <tr class="first">
                            <th>Order ID:</th>
                            <td>
                                <a target="_blank" href="{$base_uri}/order/{$feedback.order_id}">#{$feedback.order_id}</a>
                            </td>
                        </tr>
                        <tr class="first">
                            <th>Customer ID:</th>
                            <td>
                                {if $user.is_sub_admin}
                                    {$feedback.order.customer.id}
                                {else}
                                    <a target="_blank" href="{$base_uri}/customers/edit/{$feedback.order.customer.id}">#{$feedback.order.customer.id}</a>
                                {/if}
                            </td>
                        </tr>
                        <tr>
                            <th>Service Rating:</th>
                            <td>
                                <div class="Rating Rating--labeled" data-star_rating="{$feedback.paper_rating}">
                                    <span class="Rating-total">
                                        <span class="Rating-progress"></span>
                                    </span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>Paper Rating:</th>
                            <td>
                                <div class="Rating Rating--labeled" data-star_rating="{$feedback.service_rating}">
                                    <span class="Rating-total">
                                        <span class="Rating-progress"></span>
                                    </span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>Paper on Time:</th>
                            <td>
                                {if $feedback.paper_on_time}
                                    <span class="badge badge-success">Yes</span>
                                {else}
                                    <span class="badge badge-danger">No</span>
                                {/if}
                            </td>
                        </tr>
                        <tr>
                            <th>Comments:</th>
                            <td>{$feedback.comment nofilter}</td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-toggle="modal" data-url="#modal-feedback" data-options='{literal}{{/literal}"feedback_id":{$feedback.id}{literal}}{/literal}' class="btn btn-primary">Reply</button>
            </div>
            
        {/if}
    </div>

    <script id="viewFeedbackModal" type="text/template">
        <div class="modal-header fc-event-primary">
            <h5 class="modal-title">View Feedback</h5>
            <a href="#" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body">
            <div class="row gy-3 py-1">
                <div class="col-sm-6">
                    <h6 class="overline-title">Order ID</h6>
                    <a target="_blank" class="fw-bold" href="{$base_uri}/order/{literal}{{order_id}}{/literal}">#{literal}{{order_id}}{/literal}</a>
                </div>
                <div class="col-sm-6">
                    <h6 class="overline-title">Customer ID</h6>
                    {if $user.is_sub_admin}
                        <p class="fw-bold">#{literal}{{user_id}}{/literal}</p>
                    {else}
                        <a target="_blank" class="fw-bold" href="{$base_uri}/customers/edit/{literal}{{user_id}}{/literal}">#{literal}{{user_id}}{/literal}</a>
                    {/if}
                </div>
                <div class="col-sm-6">
                    <h6 class="overline-title">Service Rating</h6>
                    <div class="Rating Rating--labeled" data-star_rating="{literal}{{service_rating}}{/literal}">
                        <span class="Rating-total">
                            <span class="Rating-progress"></span>
                        </span>
                    </div>
                </div>
                <div class="col-sm-6">
                    <h6 class="overline-title">Paper Rating</h6>
                    <div class="Rating Rating--labeled" data-star_rating="{literal}{{paper_rating}}{/literal}">
                        <span class="Rating-total">
                            <span class="Rating-progress"></span>
                        </span>
                    </div>
                </div>
                <div class="col-sm-6">
                    <h6 class="overline-title">Paper on Time</h6>
                    {literal}{{#paper_on_time}}{/literal}
                        <span class="badge badge-success">Yes</span>
                    {literal}{{/paper_on_time}}{/literal}

                    {literal}{{^paper_on_time}}{/literal}
                        <span class="badge badge-danger">No</span>
                    {literal}{{/paper_on_time}}{/literal}
                </div>

                {literal}{{#comment}}{/literal}
                <div class="col-sm-10">
                    <h6 class="overline-title">Comment</h6>
                    <p>{literal} {{{ comment }}} {/literal}</p>
                </div>
                {literal}{{/comment}}{/literal}
            </div>
            <ul class="d-flex justify-content-between gx-4 mt-3">
                <li>
                    <button data-toggle="modal" data-url="#modal-feedback" data-options='{literal}{{/literal}"feedback_id":{literal}{{id}}{/literal}{literal}}{/literal}' class="btn btn-primary">Leave Reply</button>
                </li>
                <li>
                    <button data-handle="rating" data-id="{literal}{{id}}{/literal}" class="btn btn-danger btn-dim js_deleter">Delete</button>
                </li>
            </ul>
        </div>
    </script>
{/block}