<!doctype html>
<html lang="en-US">
  	<head>
		{block name='head'}
			{include file='_partials/head.tpl'}
		{/block}
	</head>

	<body class="nk-body bg-lighter npc-general has-sidebar {$body_classes|classnames} {if $theme_mode_night}dark-mode{/if}">
		<div class="nk-app-root"> 

            <div class="nk-app-root">
                <!-- main @s -->
                <div class="nk-main ">
                    <!-- wrap @s -->
                    <div class="nk-wrap nk-wrap-nosidebar">
                        <!-- content @s -->
                        <div class="nk-content ">
                            <div class="nk-block nk-block-middle nk-auth-body">
                                <div class="brand-logo pb-4">
                                    <a href="{$base_uri}" class="logo-link">
                                        {if $site_logo}
                                            <img class="logo-img" src="{$uploads_path}/{$site_logo}" srcset="{$uploads_path}/{$site_logo} 2x" alt="logo-dark">
                                        {else}
                                            {$site_name}
                                        {/if}
                                    </a>
                                </div>
                                <div class="nk-block-head">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title mb-3">Dear {$user.first_name|ucfirst} {$user.last_name|ucfirst},</h4>
                                        <div class="nk-block-des text-dark mb-3">
                                            <p>Thank you for your interest in working for our company. We would like to bring to your attention that we really appreciate your great effort and dedication. However, we are sorry to inform you that your writing skills do not meet our requirements. This might be due to the fact that your work contained too many mistakes (grammatical or stylistic), plagiarism, or that you didn't cover the requested topic. Unfortunately, you cannot work for our company as a writer.</p> 
                                            <p>We wish you all the best in all your future endeavors!</p>
                                            
                                            <p class="mb-1">Best regards,</p>
                                            <p>{$site_name} Support Team</p>
                                        </div>

                                        <a href="{$base_uri}/logout" class="btn btn-lg btn-primary btn-block">Sign out</a>
                                    </div>
                                </div>
                            </div>
                            <div class="nk-footer nk-auth-footer-full">
                                <div class="container wide-lg">
                                    <div class="nk-block-content text-center text-lg-left">
                                        <p class="text-soft">&copy; {date('Y')} {$site_name}. All Rights Reserved.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- wrap @e -->
                    </div>
                    <!-- content @e -->
                </div>
                <!-- main @e -->
            </div>

        </div>
        
    </body>

    {include file="_partials/_js_files.tpl"}

    {if $user.logged}
        <!-- Notification -->
        <audio id="notification_sound" preload="auto">
            <source src="{$base_uri}/static/sounds/notification.mp3" type="audio/mpeg">
        </audio>
        <!-- Notification -->
        <!-- Chat -->
        <audio id="chat_sound" preload="auto">
            <source src="{$base_uri}/static/sounds/chat.mp3" type="audio/mpeg">
        </audio>
        <!-- Chat -->
    {/if}

    {block name='hook_footer_after'}
        {hook h='displayFooterAfter'}
    {/block}

</html>