<div class="wide-md mx-auto p-5">
    <div class="nk-block-head wide-sm">
        <div class="nk-block-head-content">
            <h3 class="nk-block-title fw-normal">Writing Prompt</h3>
        </div>
    </div>

    <div class="card card-bordered">
        <div class="card-inner">
            <form data-url="/application/writing-prompt" class="row js_ajax-forms">
                <div class="col-md-9">
                    <p>Please <strong>choose one of the two questions</strong> and respond to it in <strong>100-150 words</strong>.</p>
                    <p>We expect you to give your own answer to the question, so no supporting sources are required.</p>

                    {foreach $writing_prompts as $writing_prompt}
                        <div class="form-group">
                            <div class="custom-control custom-radio">
                                <input type="radio" id="writing_prompt-{$writing_prompt.writing_prompt_id}" name="writing_prompt_id" value="{$writing_prompt.writing_prompt_id}" class="custom-control-input">
                                <label class="custom-control-label fw-bold" for="writing_prompt-{$writing_prompt.writing_prompt_id}">{$writing_prompt.title}</label>
                            </div>
                        </div>
                    {/foreach}
                    
                    <div class="form-group mt-5">
                        <textarea class="form-control js_autosize" rows="10" name="answer" placeholder="Type here..."></textarea>
                    </div>

                    <div class="form-group">
                        <!-- success -->
                            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                        <!-- success -->
    
                        <!-- error -->
                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                        <!-- error -->
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-lg btn-primary">Submit</button>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="d-flex flex-sm-wrap justify-content-between">
                        <div class="nk-sale-data">
                            <span class="sub-title">Time Left:</span>
                            <span class="amount" id="timer">15:00</span>
                        </div>
                        <div class="nk-sale-data">
                            <span class="sub-title">Words:</span>
                            <span class="amount text-muted" id="wordCount">0/150</span>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
let startTimestamp = 0;

function word_count(str) {
    return str.split(' ')
            .filter(function(n) { return n != '' })
            .length;
}

$(document).on('propertychange input', '[name="answer"]', function() {
    var $_answer = $(this).val();
    var $word_count = word_count($_answer);

    if($word_count > 150) {
        $("#wordCount").removeClass('text-success text-muted').addClass('text-danger');
    } else if( $word_count >= 100 && $word_count <= 150 ) {
        $("#wordCount").removeClass('text-muted text-danger').addClass('text-success');
    } else {
        $("#wordCount").removeClass('text-success text-danger').addClass('text-muted');
    }

    $("#wordCount").html($word_count+'/150');
});

function startTimer(duration, display) {
    var timer = duration, minutes, seconds;
    setInterval(function () {
        minutes = parseInt(timer / 60, 10);
        seconds = parseInt(timer % 60, 10);

        minutes = minutes < 10 ? "0" + minutes : minutes;
        seconds = seconds < 10 ? "0" + seconds : seconds;

        display.textContent = minutes + ":" + seconds;

        if (--timer < 0) {
            timer = duration;
            $(document).find('.js_ajax-forms').submit()
        }
    }, 1000);
}

window.onload = function() { 
    var seconds = 60*1000*15;

    var $timerMinutes = 60 * 15,
        display = document.querySelector('#timer');

    startTimer($timerMinutes, display);
};
</script>
