<div class="wide-lg mx-auto p-5">
    {if $user.is_application_completed}
        <div class="alert alert-success alert-fill alert-icon">
            <em class="icon ni ni-check-circle"></em> <strong>Hi there!</strong> Your application is submitted. You will receive a <strong>feedback via email</strong>. The email may go to your Spam folder, so make sure to check it too.
        </div>
    {else}
        <div class="alert alert-warning alert-icon">
            <em class="icon ni ni-check-circle"></em> <strong>Hi there!</strong> You are just a few steps away from joining our team. Please pass the following tests and uploadd the needed documents below.
        </div>
    {/if}

    <div class="nk-block-head wide-sm">
        <div class="nk-block-head-content">
            <h4 class="nk-block-title fw-normal">Application Steps</h4>
        </div>
    </div>

    <div class="card">
        <div class="card-inner">
            <div class="between-start flex-wrap flex-md-nowrap g-3">
                <div class="nk-block-icon d-none d-md-block">
                    <span class="user-avatar md sq bg-primary-dim">
                        <span class="icon fs-22px ni ni-todo-fill"></span>
                    </span>
                </div>
                <div class="nk-block-text">
                    <h5>STEP 1. Academic Writing Guide</h5>
                    <p>Short tutorial aimed to help you get acqueinted with the field of academic writing. The tutorial consists of 4 parts: General Fanformation. Plagiansm, Formatting. Specifics of working on the website.</p>
                </div>
                <div class="nk-block-actions">
                    {if $user.is_guide_complete}
                        <em class="icon icon-circle icon-circle-xxl ni ni-check bg-success-dim"></em>
                    {else}
                        <a href="{$base_uri}/application/guide" data-ajax="/application/guide" class="btn btn-lg btn-primary {if $current_step != 'guide'}disabled{/if}" {if $current_step != 'guide'}disabled{/if} type="button">Start</a>
                    {/if}
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-inner">
            <div class="between-start flex-wrap flex-md-nowrap g-3">
                <div class="nk-block-icon d-none d-md-block">
                    <span class="user-avatar md sq bg-primary-dim">
                        <span class="icon fs-22px ni ni-edit-alt-fill"></span>
                    </span>
                </div>
                <div class="nk-block-text">
                    <h5>STEP 2. Writing Prompt</h5>
                    <p>You will have to choose one out of two questions and respond to it in 100-150 words. You will have 15 minutes to submit , the prompt. We expect you to give your own answer to the question so no supporting sources are required.</p>
                </div>
                <div class="nk-block-actions">
                    {if $user.is_writingprompt_complete}
                        <em class="icon icon-circle icon-circle-xxl ni ni-check bg-success-dim"></em>
                    {else}
                        <a href="{$base_uri}/application/writing" data-ajax="/application/writing" class="btn btn-lg btn-primary {if $current_step != 'writingprompt'}disabled{/if}"  {if $current_step != 'writingprompt'}disabled{/if} type="button">Start</a>
                    {/if}
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-inner">
            <div class="between-start flex-wrap flex-md-nowrap g-3">
                <div class="nk-block-icon d-none d-md-block">
                    <div class="user-avatar md sq bg-primary-dim">
                        <span class="icon fs-22px ni ni-edit"></span>
                    </div>
                </div>
                <div class="nk-block-text">
                    <h5>STEP 3. Essay</h5>
                    <p>You will have to complete a sample essay on one of the two topics. It should contain 275-350 words, and be formatted according to the indicated formatting style. The file with your sample essay should be uploaded in doc / docx format (no handwritten essays are accepted).</p>
                    <p>If you have any questions or want to change the sample essay topic, please email us at <strong>{$site_email}</strong></p>
                    {if $current_step == 'essay' && count($essays)}
                        <div class="alert alert-secondary">
                            <p><strong>Select one of the following topics and indicate it in your sample essay:</strong></p>
                            <ul class="list list-checked-circle">
                                {foreach $essays as $essay}
                                    <li>{$essay.title}</li>
                                {/foreach}
                            </ul>
                            <p>Format the text according to the following formatting style: <strong>MLA</strong></p>
                        </div>
                    {/if}
                </div>
                <div class="nk-block-actions">
                    {if $user.is_essay_complete}
                        <em class="icon icon-circle icon-circle-xxl ni ni-check bg-success-dim"></em>
                    {else}
                        <button class="btn btn-lg btn-primary {if $current_step != 'essay'}disabled{/if}" {if $current_step != 'essay'}disabled{/if} type="button" data-toggle="modal" data-url="#modal-upload-file" data-options='{literal}{{/literal}"handle":"application-essay"{literal}}{/literal}'>Upload</button>
                    {/if}
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-inner">
            <div class="between-start flex-wrap flex-md-nowrap g-3">
                <div class="nk-block-icon d-none d-md-block">
                    <span class="user-avatar md sq bg-primary-dim">
                        <span class="icon fs-22px ni ni-file-docs"></span>
                    </span>
                </div>
                <div class="nk-block-text">
                    <h5>STEP 4. Samples (optional)</h5>
                    <p>You may upload samples of your work here to show your knowledge and writing skills. The fies should be uploaded in doc / docx / pdf format (no more than 3 files and 50 MB).</p>
                </div>
                <div class="nk-block-actions">
                    {if $user.is_samples_complete}
                        <em class="icon icon-circle icon-circle-xxl ni ni-check bg-success-dim"></em>
                    {else}
                        <button class="btn btn-lg btn-primary {if !$user.is_essay_complete}disabled{/if}" {if !$user.is_essay_complete}disabled{/if} type="button" data-toggle="modal" data-url="#modal-upload-file"data-options='{literal}{{/literal}"handle":"application-sample"{literal}}{/literal}'>Upload</button>
                    {/if}
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block-head wide-sm">
        <div class="nk-block-head-content">
            <h4 class="nk-block-title fw-normal">Education and Experience Proofs</h4>
        </div>
    </div>

    <div class="card">
        <div class="card-inner">
            <div class="between-start flex-wrap flex-md-nowrap g-3">
                <div class="nk-block-icon d-none d-md-block">
                    <span class="user-avatar md sq bg-primary-dim">
                        <span class="icon fs-22px ni ni-reports-alt"></span>
                    </span>
                </div>
                <div class="nk-block-text">
                    <h5>STEP 5. CV</h5>
                    <p class="mb-2">You are welcome to upload your CV or resume here. Make sure it is written in English and contains the description of your educational background, professional experience and recommendations if you have any.</p> 
                    <p class="mb-2">The file(s) should be uploaded in doc / docx / pdf format (no more than 3 files and 50 MB).</p>
                    <p>If you have any questions, please email us at <strong>{$site_email}</strong></p>
                </div>
                <div class="nk-block-actions">
                    {if $user.is_cv_complete}
                        <em class="icon icon-circle icon-circle-xxl ni ni-check bg-success-dim"></em>
                    {else}
                        <button class="btn btn-lg btn-primary {if $current_step != 'education_upload'}disabled{/if}"  {if $current_step != 'education_upload'}disabled{/if} type="button" data-toggle="modal" data-url="#modal-upload-cv" data-options='{literal}{{/literal}"handle":"application-cv"{literal}}{/literal}'>Upload</button>
                    {/if}
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-inner">
            <div class="between-start flex-wrap flex-md-nowrap g-3">
                <div class="nk-block-icon d-none d-md-block">
                    <span class="user-avatar md sq bg-primary-dim">
                        <span class="icon fs-22px ni ni-award"></span>
                    </span>
                </div>
                <div class="nk-block-text">
                    <h5>STEP 6. Degree Certificate</h5>
                    <p class="mb-2">Please upload a photo of your education certificate and/or academic transcripts that can prove your highest qualification attained certificates issued in non English speaking countries should be submitted along with their English translations.</p>
                    <p class="mb-2">The files should be uploaded in jpg/ipeg format (no more than 3 files and 50 MB).</p>
                    <p>If you have any questions, please email us at <strong>{$site_email}</strong></p>
                </div>
                <div class="nk-block-actions">
                    {if $user.is_degree_cert_complete}
                        <em class="icon icon-circle icon-circle-xxl ni ni-check bg-success-dim"></em>
                    {else}
                        <button class="btn btn-lg btn-primary {if $current_step != 'education_upload'}disabled{/if}" {if $current_step != 'education_upload'}disabled{/if} type="button" data-toggle="modal" data-url="#modal-upload-degree" data-options='{literal}{{/literal}"handle":"application-degree"{literal}}{/literal}'>Upload</button>
                    {/if}
                </div>
            </div>
        </div>
    </div>
</div>

<script id="modal-upload-file" type="text/template">
    <form class="js_files-uploader p0 m0" method="POST" data-action="application/upload" data-handle="{literal}{{handle}}{/literal}">
        <div class="modal-header"> 
            <h5 class="modal-title">Essay</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>
        
        <div class="modal-body">
            <div class="alert alert-secondary">
                <p>Upload your sample essay in <strong>doc/docx/pdf format</strong>. Make sure your sample essay:</p>
                <ul class="list list-checked-circle">
                    <li>Contains 275-350 words</li>
                    <li>Is formatted according to the <strong>indicated format style</strong></li>
                    <li>Is <strong>not handwritten</strong></li>
                </ul>
            </div>

            <h6 class="mb-3 overline-title title">Upload File</h6>
            <div class="files-control js_dropzone" data-handle="plugin">
                <div class="files-control--files"></div>
                <div class="dropzone-description">
                    <button class="browse-button btn btn-primary" type="button">Browse </button>
                    <span class="control-or">or</span>
                    <span class="control-drop-here">Drop plugin here</span>
                </div>
                <div class="dropzone-static">
                    <div class="dropzone-border">Drop files here</div>
                </div>
                <input accept=".pdf,.doc,.docx" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
            </div>
            <!-- error -->
            <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        <div class="modal-footer bg-lighter">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
        </div>
    </form>
</script>

<script id="modal-upload-cv" type="text/template">
    <form class="js_files-uploader p0 m0" method="POST" data-action="application/upload" data-handle="{literal}{{handle}}{/literal}">
        <div class="modal-header"> 
            <h5 class="modal-title">CV</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>
        
        <div class="modal-body">
            <div class="alert alert-secondary">
                <p>Please upload your CV / resume here.</p>
                <p>The file(s) should be uploaded in <strong>doc / docx / pdf format (no more than 3 files and 50MB)</strong></p>
            </div>

            <h6 class="mb-3 overline-title title">Upload File</h6>
            <div class="files-control js_dropzone" data-handle="plugin">
                <div class="files-control--files"></div>
                <div class="dropzone-description">
                    <button class="browse-button btn btn-primary" type="button">Browse </button>
                    <span class="control-or">or</span>
                    <span class="control-drop-here">Drop plugin here</span>
                </div>
                <div class="dropzone-static">
                    <div class="dropzone-border">Drop files here</div>
                </div>
                <input accept=".pdf,.doc,.docx" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
            </div>
            <!-- error -->
            <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        <div class="modal-footer bg-lighter">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
        </div>
    </form>
</script>

<script id="modal-upload-degree" type="text/template">
    <form class="js_files-uploader p0 m0" method="POST" data-action="application/upload" data-handle="{literal}{{handle}}{/literal}">
        <div class="modal-header"> 
            <h5 class="modal-title">Degree Certificate</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>
        
        <div class="modal-body">
            <div class="alert alert-secondary">
                <p>Please upload a photo of your education certificate and/or academic transcripts that can prove your highest qualification attained.</p>
                <p><strong>Certificates issued in non-English-speaking countries should be submitted along with their English translations.</strong></p>
                <p>The file(s) should be uploaded in <strong>jpg / jpeg format (no more than 3 files and 50MB)</strong></p>
            </div>

            <h6 class="mb-3 overline-title title">Upload File</h6>
            <div class="files-control js_dropzone" data-handle="plugin">
                <div class="files-control--files"></div>
                <div class="dropzone-description">
                    <button class="browse-button btn btn-primary" type="button">Browse </button>
                    <span class="control-or">or</span>
                    <span class="control-drop-here">Drop plugin here</span>
                </div>
                <div class="dropzone-static">
                    <div class="dropzone-border">Drop files here</div>
                </div> 
                <input accept=".jpg,.jpeg" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
            </div>
            <!-- error -->
            <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        <div class="modal-footer bg-lighter">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
        </div>
    </form>
</script>