<div class="wide-md mx-auto p-5">
    <div class="nk-block-head wide-sm">
        <div class="nk-block-head-content">
            <h3 class="nk-block-title fw-normal">Getting Started</h3>
            <div class="nk-block-des">
                <p class="lead">This information will let us know more about you.</p>
            </div>
        </div>
    </div>

    <div class="card card-bordered">
        <div class="card-inner">
            <div class="nk-wizard nk-wizard-simple is-alter">
                <div class="steps clearfix">
                    <ul role="tablist" class="js_wizard-steps">
                        <li role="tab" class="current">
                            <a href="#step-1">
                                <span class="number">01</span> 
                                <h5>Personal Details</h5>
                            </a>
                        </li>
                        <li role="tab" class="disabled">
                            <a href="#step-2">
                                <span class="number">02</span> 
                                <h5>Additional Information</h5>
                            </a>
                        </li>
                        <li role="tab" class="disabled">
                            <a href="#step-3">
                                <span class="number">03</span> 
                                <h5>Qualification &amp; Experience</h5>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="nk-wizard-content js_wizard-content" id="step-1">
                    <form data-url="/application/personal-details" class="js_ajax-forms">
                        <div class="nk-block-head nk-block-head-lg">
                            <div class="nk-block-head-content">
                                <h4 class="title nk-block-title">Personal Details</h4>
                            </div>
                        </div>
                
                        <div class="row gy-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">First Name</label>
                                    <div class="form-control-wrap">
                                        <input type="text" data-msg="Required" class="form-control form-control-lg required" name="first_name" value="{$user.first_name}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Middle Name</label>
                                    <div class="form-control-wrap">
                                        <input type="text" data-msg="Required" class="form-control form-control-lg required" name="middle_name" value="{$user.middle_name}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Last Name</label>
                                    <div class="form-control-wrap">
                                        <input type="text" data-msg="Required" class="form-control form-control-lg required" name="last_name" value="{$user.last_name}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Email Address</label>
                                    <div class="form-control-wrap">
                                        <input type="text" data-msg="Required" class="form-control form-control-lg required" name="email_address" value="{$user.email}" disabled required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label" for="fw-mobile-number">Mobile Number</label>
                                    <div class="form-control-wrap">
                                        <input type="text" name="js_user_phone" data-msg="Required" class="form-control form-control-lg js_phone required" placeholder="Enter mobile" autocomplete="off" {if $user.phone}value="{$user.phone}"{/if} required>
                                        <input type="hidden" name="phone" class="form-control js_phone_number" autocomplete="off" readonly="true" {if $user.phone}value="{$user.phone}"{/if}>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Date of Birth</label>
                                    <div class="form-control-wrap">
                                        <input type="text" data-msg="Required" class="form-control form-control-lg date-picker-alt required" data-date-format="yyyy-mm-dd" name="date_of_birth" {if $user.date_of_birth != '0000-00-00'}value="{$user.date_of_birth}"{/if} required>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label" for="gender">Gender</label>
                                    <div>
                                        <ul class="custom-control-group">
                                            <li>
                                                <div class="custom-control custom-checkbox custom-control-pro no-control checked">
                                                    <input type="radio" class="custom-control-input" name="gender" id="gender_male" value="male" {if $user.gender == 'male'}checked="checked"{/if}>
                                                    <label class="custom-control-label" for="gender_male"><em class="icon fas fa-male"></em><span>Male</span></label>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="custom-control custom-checkbox custom-control-pro no-control">
                                                    <input type="radio" class="custom-control-input" name="gender" id="gender_female" value="female" {if $user.gender == 'female'}checked="checked"{/if}>
                                                    <label class="custom-control-label" for="gender_female"><em class="icon fas fa-female"></em><span>Female</span></label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Country</label>
                                    <div class="form-control-wrap">
                                        <select class="form-select" data-ui="lg" data-search="on" name="country" required>
                                            {foreach from=$countries item=country key=key}
                                                <option value="{$key}" {if $user.country == $key } selected="" {/if}>{$country.name}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">City/Town</label>
                                    <div class="form-control-wrap">
                                        <input type="text" data-msg="Required" class="form-control form-control-lg required" name="city" value="{$user.city}" required>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Timezone</label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <select id="timezone-region" class="form-select" data-ui="lg" data-search="on" data-combo="timezone-combo">
                                                {foreach from=$regions item=region key=key name=name}
                                                    <option value="{$key}" {if $user.default_region == $key } selected="" {/if} >{$key}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                        {assign var='timezoneId' value=0}
                                        <div id="timezone-combo" class="col-md-6">
                                            {foreach from=$regions item=region key=key name=name}
                                                <select id="timezone-combo-{$key}" class="form-control form-control-lg {if $user.default_region != $key } x-hidden {/if} switch-combo" data-ui="lg" data-search="on" data-combo-value="{$key}">
                                                    {foreach from=$region item=item key=key name=name}
                                                        <option value="{$key}" {if $user.timezone == $key } selected="" {/if} >{$item}</option>
                                                    {/foreach}
                                                </select>
                                            {assign var='timezoneId' value=$timezoneId+1}
                                            {/foreach}
                                        </div>
                                    </div>
                                    <input type="hidden" id="timezone" name="timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">
                                </div>
                            </div>
                
                            <!-- .col -->
                        </div>

                        <div class="form-group mt-4">
                            <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                            <!-- success -->
        
                            <!-- error -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->
                        </div>

                        <!-- buttons -->
                        <div class="clearfix mt-4">
                            <div class="float-right">
                                <button type="button" class="btn btn-primary btn-lg" id="activate-step-2">
                                    <span>Next Step</span><i class="ni ni-arrow-right"></i>
                                </button>
                            </div>
                        </div>
                        <!-- buttons -->
                    </form>
                </div>

                <div class="nk-wizard-content js_wizard-content x-hidden" id="step-2">
                    <form data-url="/application/additional-info" class="js_ajax-forms">
                        <div class="nk-block-head nk-block-head-lg">
                            <div class="nk-block-head-content">
                                <h4 class="title nk-block-title">Additional Information</h4>
                            </div>
                        </div>
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="custom-control custom-control-lg custom-switch">
                                    <input type="checkbox" name="available_247" class="custom-control-input" id="available_247" {if $user.available_247}checked{/if}>
                                    <label class="custom-control-label" for="available_247">Available 24/7</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="custom-control custom-control-lg custom-switch">
                                    <input type="checkbox" name="available_urgent_orders" class="custom-control-input" id="available_urgent_orders" {if $user.available_urgent_orders}checked{/if}>
                                    <label class="custom-control-label" for="available_urgent_orders">Available To Take Urgent Orders</label>
                                </div>
                            </div>
                        </div>
                
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">About Me</label>
                                    <div class="form-control-wrap">
                                        <textarea class="form-control summernote-minimal" data-height="200" name="about_me">{$user.about nofilter}</textarea>
                                    </div>
                                </div>
                            </div>
                            <!-- .col -->
                        </div>
                
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Facebook Profile</label>
                                    <div class="form-control-wrap">
                                        <input type="text" class="form-control form-control-lg" name="facebook_profile" value="{$user.facebook_profile}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">LinkedIn Profile</label>
                                    <div class="form-control-wrap">
                                        <input type="text" class="form-control form-control-lg" name="linkedin_profile" value="{$user.linkedin_profile}">
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">How did you hear about our company?</label>
                                    <div class="form-control-wrap">
                                        <select class="form-select" data-ui="lg" name="referrer" required>
                                            <option value="referral" {if $user.referrer_source == "referral"}selected=''{/if}>Referral</option>
                                            <option value="social_media" {if $user.referrer_source == "social_media"}selected=''{/if}>Social media</option>
                                            <option value="search_engine" {if $user.referrer_source == "search_engine"}selected=''{/if}>Search engine</option>
                                            <option value="ad" {if $user.referrer_source == "ad"}selected=''{/if}>Ad</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- .row -->

                        <div class="form-group mt-4">
                            <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                            <!-- success -->
        
                            <!-- error -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->
                        </div>

                        <!-- buttons -->
                        <div class="clearfix mt-4">
                            <button type="button" id="activate-step-3" class="btn btn-primary btn-lg pull-right">
                                <span>Next</span><i class="icon ni ni-arrow-right"></i>
                            </button>
                        </div>
                        <!-- buttons -->
                    </form>
                </div>

                <div class="nk-wizard-content js_wizard-content x-hidden" id="step-3">
                    <form data-url="/application/qualifications" class="js_ajax-forms">
                        <div class="nk-block-head nk-block-head-lg">
                            <div class="nk-block-head-content">
                                <h4 class="title nk-block-title">Qualification &amp; Experience</h4>
                            </div>
                        </div>
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Your Native Language</label>
                                    <div class="form-control-wrap">
                                        <select class="form-select" data-ui="lg" data-search="on" name="native_language" required>
                                            {foreach from=$languages item=language key=key}
                                                <option value="{$key}" {if $user.native_language == $key } selected="" {/if}>{$language.name}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Other Languages You Can Write At</label>
                                    <div class="form-control-wrap">
                                        <select class="form-select" data-ui="lg" data-search="on" name="other_languages[]" multiple data-search="on">
                                            {foreach from=$languages item=language key=key}
                                                <option value="{$key}" {if in_array($key, $user.other_languages_array)} selected="" {/if}>{$language.name}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Your Highest Verifiable Academic Degree</label>
                                    <div class="form-control-wrap">
                                        <select class="form-select" data-ui="lg" data-search="on" name="highest_academic_degree" required>
                                            {foreach from=$academicDegrees item=academicDegree key=key}
                                                <option value="{$key}" {if $user.highest_academic_degree == $key } selected="" {/if}>{$academicDegree.degree}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Your Degree Major</label>
                                    <div class="form-control-wrap">
                                        <input type="text" data-msg="Required" class="form-control form-control-lg required" name="academic_degree_major" value="{$user.academic_degree_major}" required>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Please Select 3-7 Disciplines You Are Proficient In</label>
                                    <div class="form-control-wrap">
                                        <select class="form-select required" data-search="on" data-ui="lg" data-msg="Required" name="proficient_disciplines[]" multiple data-search="on">
                                            {foreach $disciplineGroups as $topicCat}
                                                <optgroup label="{$topicCat.title}">
                                                    {foreach $topicCat.disciplines as $discipline}
                                                        <option value="{$discipline.discipline_id}" {if in_array($discipline.discipline_id, $user.proficient_disciplines_array)}selected=""{/if} >{$discipline.title}</option>
                                                    {/foreach}
                                                </optgroup>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Please Indicate Software You Have Access To And/OR Programming Language You Are Expert In</label>
                                    <div class="form-control-wrap">
                                        <select class="form-select required" data-search="on" data-ui="lg" data-msg="Required" name="software[]" multiple data-search="on">
                                            {foreach $software_programming as $snf}
                                                <option value="{$snf.software_programming_id}" {if in_array($snf.software_programming_id, $user.software_array)}selected=""{/if}>{$snf.title}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <!-- .col -->
                        </div>

                        <div class="form-group mt-4">
                            <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                            <!-- success -->
        
                            <!-- error -->
                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->
                        </div>

                        <!-- buttons -->
                        <div class="clearfix mt-4">
                            <div class="float-right">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <span>Finish</span><i class="ni ni-arrow-right"></i>
                                </button>
                            </div>
                        </div>
                        <!-- buttons -->
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<script id="modal-application-success" type="text/template">
    <div class="modal-body modal-body-md text-center">
        <div class="nk-modal">
            <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-check bg-success"></em>
            <h4 class="nk-modal-title">Congratulations!</h4>
            <div class="nk-modal-text text-left">
                <p class="caption-text">You have successfully completed the first steps of the registration process.</p>
                <p class="caption-text">However, for us to be able to be able to assess your writing skills and make sure that you are capable of producing a flawless piece of writing, we need you to complete all tests, upload your education certificate abd samples essay into our platform. </p>
                <p class="caption-text">Please provide us with the required information as soon as possible, so that we could develop and continue our mutually beneficial cooperation.</p>
            </div>
            <div class="nk-modal-action">
                <a href="{$base_uri}/application" class="btn btn-lg btn-mw btn-primary">Continue</a>
            </div>
        </div>
    </div>
    <div class="modal-footer bg-lighter">
        <div class="text-center w-100">
            <p>If you encounter any issues please email as at <strong>{$site_email}</strong></p>
        </div>
    </div>
</script>

{literal}
<script type="text/javascript">
    $(function() {

        var wizard_steps = $('.js_wizard-steps li a');
        var wizard_content = $('.js_wizard-content');

        wizard_content.hide();

        wizard_steps.click(function(e) {
            e.preventDefault();
            var $target = $($(this).attr('href'));
            if (!$(this).hasClass('disabled')) {
                wizard_steps.parent().removeClass('current');
                $(this).parent().addClass('current');
                wizard_content.hide();
                $target.show();
            }
        });

        $('.js_wizard-steps li.current a').trigger('click');

        $('#activate-step-2').on('click', function(e) {
            var _this = $(this);
            /* show loading */
            button_status(_this, "loading"); 

            $(this).parents('form.js_ajax-forms').submit();
            
            /* hide loading */
            button_status(_this, "reset");
        });

        proxim.eventEmitter.on('applicantPersonalDetailsSuccess', function() {
            $('.js_wizard-steps li:eq(0)').addClass('done');
            $('.js_wizard-steps li:eq(1)').removeClass('disabled');
            $('.js_wizard-steps li:eq(1) a[href="#step-2"]').trigger('click');
        });

        $('#activate-step-3').on('click', function(e) {
            var _this = $(this);
            /* show loading */
            button_status(_this, "loading"); 

            $(this).parents('form.js_ajax-forms').submit();

            /* hide loading */
            button_status(_this, "reset");
        });

        proxim.eventEmitter.on('applicantAddInfoSuccess', function() {
            $('.js_wizard-steps li:eq(1)').addClass('done');
            $('.js_wizard-steps li:eq(2)').removeClass('disabled');
            $('.js_wizard-steps li a[href="#step-3"]').trigger('click');
        });

    });
</script>
{/literal}