{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Essays</h3>
                    <div class="nk-block-des text-soft">
                        <p>You have total {$total_essays} essays.</p>
                    </div>
                </div>

                <div class="nk-block-head-content">
                    <button type="button" data-toggle="modal" data-url="#addEssaysModal" data-size="medium" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> <span>Add Essay</span>
                    </button>
                </div>
            </div>
            <!-- .nk-block-between -->
        </div>

        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    
                    {if count($essays)}
                        <div class="card-inner-group">
                            <div class="card-inner p-0">
                                <table class="table table-tranx">
                                    <thead>
                                        <tr class="tb-tnx-head">
                                            <th>Title</th>
                                            <th class="tb-tnx-action">Actions</th>
                                        </tr>
                                    </thead> 
                                    <tbody>
                                        {foreach $essays as $essay}
                                            <tr class="tb-tnx-item">
                                                <td>{$essay.title}</td>
                                                <td class="tb-tnx-action">
                                                    <div class="drodown">
                                                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
                                                            Actions
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right">
                                                            <ul class="link-list-opt no-bdr">
                                                                <li>
                                                                    <a class="dropdown-item" href="#" data-toggle="modal" data-url="#editEssayModal" data-size="medium" data-options='{$essay|json_encode nofilter}'>
                                                                        <em class="icon ni ni-edit"></em><span>Edit</span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a class="js_deleter" href="#" data-handle="essay" data-id="{$essay.id}">
                                                                        <em class="icon ni ni-trash"></em><span>Delete</span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
                            </div>

                            {if $pager}
                                <div class="card-inner">
                                    {$pager nofilter}
                                </div>
                            {/if}
                        </div>
                    {else}
                        <div class="text-center x-muted py-5"> 
                            <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                            <p class="mb10"><strong>No essays to show</strong></p>
                        </div>
                    {/if}

                </div>
            </div>
        </div>

        <!-- Add Essay -->
        <script id="addEssaysModal" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/applications/essays/add" method="POST" autocomplete="off">
                <div class="modal-header">
                    <h5 class="modal-title">Add Essay</h5>
                    <span class="close" data-dismiss="modal" aria-label="Close">
                        <em class="icon ni ni-cross"></em>
                    </span>
                </div>

                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label">Title</label>
                        <input name="title" type="text" class="form-control form-control-lg">
                    </div>

                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Essay</button>
                </div>
            </form>
        </script>
        <!-- Add Essay -->

        <!-- Edit Essay -->
        <script id="editEssayModal" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/applications/essays/edit" method="POST" autocomplete="off">
                <input type="hidden" name="essay_id" value="{literal}{{id}}{/literal}">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Essay</h5>
                    <span class="close" data-dismiss="modal" aria-label="Close">
                        <em class="icon ni ni-cross"></em>
                    </span>
                </div>

                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label">Title</label>
                        <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
                    </div>

                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                </div>
            </form>
        </script>
        <!-- Edit Essay -->

    </div>
{/block}