{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Applications</h3>
                    <div class="nk-block-des text-soft">
                        <p>You have total {$total_applications} applications.</p>
                    </div>
                </div>
                <!-- .nk-block-head-content -->
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="#" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                        <div class="toggle-expand-content" data-content="more-options">
                            <ul class="nk-block-tools g-3">
                                <li>
                                    <form class="form-control-wrap" method="get" id="filter_form" autocomplete="off"> 
                                        <div class="form-icon form-icon-right">
                                            <em class="icon ni ni-search"></em>
                                        </div>
                                        <input type="text" class="form-control" value="{$query}" name="query" placeholder="Search by ID & email">
                                    </form>
                                </li>
                                <li>
                                    <div class="drodown">
                                        <a href="#" class="dropdown-toggle dropdown-indicator btn btn-outline-light btn-white" data-toggle="dropdown" aria-expanded="false">Status</a>
                                        <div class="dropdown-menu dropdown-menu-end" style="">
                                            <ul class="link-list-opt no-bdr">
                                                <li>
                                                    <a href="{$base_uri}/applications/all" data-ajax="/applications/all" {if $_status == 'all'}class="active"{/if}><span>All</span></a>
                                                </li>
                                                <li>
                                                    <a href="{$base_uri}/applications/pending" data-ajax="/applications/pending" {if $_status == 'pending'}class="active"{/if}><span>Pending</span></a>
                                                </li>
                                                <li>
                                                    <a href="{$base_uri}/applications/rejected" data-ajax="/applications/rejected" {if $_status == 'rejected'}class="active"{/if}><span>Rejected</span></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </li>
                                <li class="nk-block-tools-opt">
                                    <a href="{$base_uri}/employees/add" data-ajax="/employees/add" class="btn btn-icon btn-primary d-md-none"><em class="icon ni ni-plus"></em></a>
                                    <a href="{$base_uri}/employees/add" data-ajax="/employees/add" class="btn btn-primary d-none d-md-inline-flex"><em class="icon ni ni-plus"></em><span>Add</span></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        {if count($applications)}
            <div class="nk-block">
                <div class="card card-stretch">
                    <div class="card-inner-group">
                        <div class="card-inner p-0">
                            <table class="nk-tb-list nk-tb-ulist">
                                <thead>
                                    <tr class="nk-tb-item nk-tb-head">
                                        <th class="nk-tb-col"><span class="sub-text">Applicant</span></th>
                                        <th class="nk-tb-col"><span class="sub-text">Phone</span></th>
                                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Profile</span></th>
                                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Test</span></th>
                                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Status</span></th>
                                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Registered</span></th>
                                        <th class="nk-tb-col nk-tb-col-tools text-right">&nbsp;</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    {foreach $applications as $application}
                                        <tr class="nk-tb-item">
                                            <td class="nk-tb-col">
                                                <a href="{$base_uri}/employees/edit/{$application.id}" data-ajax="/employees/edit/{$application.id}" class="project-title">
                                                    <div class="user-card">
                                                        {if $application.user_picture_default && $application.first_name && $application.last_name}
                                                            <div class="user-avatar bg-primary sq">
                                                                <span>{$application.first_name[0]|strtoupper}{$application.last_name[0]|strtoupper}</span>
                                                            </div>
                                                        {else}
                                                            <div class="user-avatar avatar-img sq" style="background-image: url({$application.user_picture})"></div>
                                                        {/if}
                                                        <div class="flex-fill">
                                                            <div class="fw-bold">{$application.first_name} {$application.last_name}</div>
                                                            <div class="text-secondary">{$application.email}</div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </td>
                                            <td class="nk-tb-col">
                                                <span>{if $application.phone} {$application.phone} {else} N.A {/if}</span>
                                            </td>
                                            <td class="nk-tb-col tb-col-lg">
                                                {if $application.is_profile_completed}
                                                    <span class="badge badge-dim badge-success">Completed</span>
                                                {else}
                                                    <span class="badge badge-dim badge-danger">Incomplete</span>
                                                {/if}
                                            </td>
                                            <td class="nk-tb-col tb-col-lg">
                                                {if $application.is_application_completed}
                                                    <span class="badge badge-dim badge-success">Completed</span>
                                                {else}
                                                    <span class="badge badge-dim badge-danger">Incomplete</span>
                                                {/if}
                                            </td>
                                            <td class="nk-tb-col tb-col-lg">
                                                {if $application.is_application_approved}
                                                    <span class="badge badge-dim badge-success">Approved</span>
                                                {elseif $application.is_application_rejected}
                                                    <span class="badge badge-dim badge-danger">Rejected</span>
                                                {else}
                                                    <span class="badge badge-dim badge-info">Waiting</span>
                                                {/if}
                                            </td>
                                            <td class="nk-tb-col tb-col-lg">
                                                <span class="js_moment" data-time="{$application.reg_date}">{$application.reg_date}</span>
                                            </td>
                                            <td class="nk-tb-col nk-tb-col-tools">
                                                <ul class="nk-tb-actions gx-1">
                                                    <li class="nk-tb-action-hidden">
                                                        <a href="{$base_uri}/employees/edit/{$application.id}" data-ajax="/employees/edit/{$application.id}" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="" data-original-title="View Details">
                                                            <em class="icon ni ni-eye-fill"></em>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <div class="drodown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <li>
                                                                        <a href="{$base_uri}/employees/edit/{$application.id}" data-ajax="/employees/edit/{$application.id}">
                                                                            <em class="icon ni ni-eye"></em><span>View Details</span>
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a target="_blank" href="{$base_uri}/authorize/{$application.id}/{$application.secure_key}">
                                                                            <em class="icon ni ni-security"></em><span>Impersonate</span>
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="#" class="js_approve-application" data-handle="approve" data-id="{$application.employee_id}">
                                                                            <em class="icon ni ni-check"></em><span>Approve</span>
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="#" class="js_approve-application" data-handle="decline" data-id="{$application.employee_id}">
                                                                            <em class="icon ni ni-cross"></em><span>Decline</span>
                                                                        </a>
                                                                    </li>
                                                                    <li class="divider"></li>
                                                                    <li>
                                                                        <a class="js_deleter" href="#" data-handle="employee" data-id="{$application.id}">
                                                                            <em class="icon ni ni-trash"></em><span>Delete</span>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                    {/foreach}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="nk-block-between-md mt-3">
                    <div class="g">
                        {$pager nofilter}
                    </div>
                </div><!-- .nk-block-between -->
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                <h6 class="text-dark title mb-3">No applications to show</h6>
            </div>
        {/if}

    </div>
{/block}