<div class="modal-header">
    <h5 class="modal-title">Orders</h5>
    <span class="close" data-dismiss="modal" aria-label="Close">
        <em class="icon ni ni-cross"></em>
    </span>
</div>
<div class="modal-body p-0">

    {if count($orders) > 0}
        <table class="table table-tranx is-compact mb-0">
            <thead>
                <tr class="tb-tnx-head">
                    <th class="tb-tnx-info">DATE</th>
                    <th class="tb-tnx-info">ORDER</th>
                    <th class="tb-tnx-info">TRANSACTION TYPE</th>
                    <th class="tb-tnx-info">AMOUNT</th>
                </tr>
            </thead>
            <tbody>
                {foreach $orders as $order}
                    <tr class="tb-tnx-item">
                        <td class="tb-tnx-info">
                            {if $order.status == "10"}
                                <span class="js_moment" data-time="{$order.approvedAt}">{$order.approvedAt}</span>
                            {elseif $order.status == "11"}
                                <span class="js_moment" data-time="{$order.finishedAt}">{$order.finishedAt}</span>
                            {/if}
                        </td>
                        <td class="tb-tnx-info">
                            <strong>
                                <a target="_blank" href="{$base_uri}/order/{$order.id}">#{$order.referenceId}</a>
                            </strong>
                        </td>
                        <td class="tb-tnx-info"> 
                            {$order.statusTitle}
                            {" - "}
                            {if $order.isProgramming || $order.isCalculations}
                                {$order.serviceTypeTitle}
                            {elseif $order.isArticleWriting}
                                {pluralize('word', $order.words)}
                            {else}
                                {if $order.pages} {pluralize('page', $order.pages)} {/if} 
                                {if $order.slides}, {pluralize('slide', $order.slides)} {/if} 
                                {if $order.charts} {pluralize('chart', $order.charts)} {/if} 
                                {if $order.excel_sheets} {pluralize('excel sheet', $order.excel_sheets)} {/if} 
                            {/if}
                        </td>
                        <td class="tb-tnx-info text-right">
                            {if $employee.is_sub_admin}
                                <strong class="text-success">+ {$order.orderManagerPayFormatted}</strong>
                            {elseif $employee.is_writer}
                                <strong class="text-success">+ {$order.writerPayFormatted}</strong>
                            {elseif $employee.is_editor}
                                <strong class="text-success">+ {$order.editorPayFormatted}</strong>
                            {else}
                                <strong class="text-danger">+ $0.00</strong>
                            {/if}
                        </td>
                    </tr>
                {/foreach}
            </tbody>
            <tfoot class="tb-odr-foot">
                {if $pay_delivered_orders || $done_orders_pay}
                    <tr style="display: table-row;">
                        <th class="tb-tnx-info text-right align-middle" align="right" align="right" colspan="3">Completed orders:</th>
                        <td class="tb-tnx-info text-right">
                            <strong class="text-success">+ {formatPrice($done_orders_pay, $currencyFormat)}</strong>
                        </td>
                    </tr>
                {/if}
                <tr style="display: table-row;">
                    <th class="tb-tnx-info text-right align-middle" align="right"" align="right" colspan="3">Approved orders:</th>
                    <td class="tb-tnx-info text-right">
                        <strong class="text-success">+ {formatPrice($completed_orders_pay, $currencyFormat)}</strong>
                    </td>
                </tr>

                {if $total_credit || $total_fine}
                    <tr style="display: table-row;">
                        <th class="tb-tnx-info text-right align-middle" align="right" align="right" colspan="3">Sub Total:</th>
                        <td class="tb-tnx-info text-right">
                            <strong class="text-success">+ {formatPrice($subtotal_pay, $currencyFormat)}</strong>
                        </td>
                    </tr>
                {/if}

                {if $total_credit}
                    <tr style="display: table-row;">
                        <th class="tb-tnx-info text-right align-middle" align="right" align="right" colspan="3">Credit:</th>
                        <td class="tb-tnx-info text-right">
                            <strong class="text-warning">+ {formatPrice($total_credit, $currencyFormat)}</strong>
                        </td>
                    </tr>
                {/if}

                {if $total_fine}
                    <tr style="display: table-row;">
                        <th class="tb-tnx-info text-right align-middle" align="right" align="right" colspan="3">Fine:</th>
                        <td class="tb-tnx-info text-right">
                            <strong class="text-danger">- {formatPrice($total_fine, $currencyFormat)}</strong>
                        </td>
                    </tr>
                {/if}

                <tr style="display: table-row;">
                    <th class="tb-tnx-info text-right align-middle" align="right" align="right" colspan="3">Total:</th>
                    <td class="tb-tnx-info text-right">
                        <strong class="{if $total_pay < 0}text-danger{else}text-success{/if}">+ {formatPrice($total_pay, $currencyFormat)}</strong>
                    </td>
                </tr>
            </tfoot>
        </table>
    {else}
        <div class="text-center x-muted py-5"> 
            {include file='__svg_icons.tpl' icon="transaction" class="mb-3" width="100px" height="100px"}
            <h6 class="text-dark title mb-3">No orders to show</h6>
        </div>
    {/if}

</div>

<div class="modal-footer bg-light">
    <button type="button" class="btn btn-secondary ml-auto" data-dismiss="modal">Cancel</button>
</div>