<!-- main header @s -->
<div class="nk-header nk-header-fixed {$themeOptions.header}">
    <div class="container-fluid">
        <div class="nk-header-wrap">
            <div class="nk-menu-trigger d-xl-none ml-n1">
                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu">
                    <em class="icon ni ni-menu"></em>
                </a>
            </div>
            <div class="nk-header-brand d-xl-none">
                <a href="{$base_uri}" class="logo-link">
                    {if $site_logo}
                        <img class="logo-light logo-img" src="{$uploads_path}/{if $themeOptions.header == 'is-light' || $themeOptions.header == 'is-default'}{$site_dark_logo}{else}{$site_logo}{/if}" srcset="{$uploads_path}/{if $themeOptions.header == 'is-light' || $themeOptions.header == 'is-default'}{$site_dark_logo}{else}{$site_logo}{/if} 2x" alt="logo">
                        <img class="logo-dark logo-img" src="{$uploads_path}/{$site_dark_logo}" srcset="{$uploads_path}/{$site_dark_logo} 2x" alt="logo-dark">
                    {else}
                        {$site_name}
                    {/if}
                </a>
            </div>
            <!-- .nk-header-brand -->

            {if $user.is_admin || $user.is_sub_admin}
                <form method="GET" action="{$base_uri}/orders/all" class="nk-header-search ml-3 ml-xl-0">
                    <em class="icon ni ni-search"></em>
                    <input type="hidden" name="search" value="1"/>
                    <input type="text" name="order_id" class="form-control border-transparent force-integer form-focus-none" placeholder="Search order ID" autocomplete="off" {if isset($is_search) && isset($order_id)}value="{$order_id}"{/if}>
                </form>
            {/if}
            
            <div class="nk-header-tools">
                <ul class="nk-quick-nav">
                    {if $is_authorize}
                        <li>
                            <a data-toggle="tooltip" data-title="Back to Administrator" href="{$base_uri}/authorize/{$admin.id}/{$admin.secure_key}" class="nk-quick-nav-icon">
                                <em class="icon ni ni-signout"></em>
                            </a>
                        </li>
                    {/if}
                    
                    <li class="nav-item dropdown hide-mb-sm">
                        <a href="#" class="dropdown-toggle dropdown-indicator has-indicator nav-link" data-toggle="dropdown"><span>Info</span></a>
                        <div class="dropdown-menu dropdown-menu-sm dropdown-menu-end" style="">
                            <ul class="language-list">
                                <li><a href="{$base_uri}/guides/writing-guide" data-ajax="/guides/writing-guide" class="language-item"><span class="language-name">Writing Guide</span></a></li>
                                <li><a href="{$base_uri}/guides/payment-guide" data-ajax="/guides/payment-guide" class="language-item"><span class="language-name">Payment Guide</span></a></li>
                                <li><a href="{$base_uri}/guides/faqs" data-ajax="/guides/faqs" class="language-item"><span class="language-name">FAQs</span></a></li>
                            </ul>
                        </div>
                    </li>
                    
                    <!-- .nk-header-news -->
                    {hook h='displayHeaderNavbarNav'}

                    <!-- messages -->
                    {include file='_partials/_header.messages.tpl'}
                    <!-- messages -->

                    <!-- notifications -->
                    {include file='_partials/_header.notifications.tpl'}
                    <!-- notifications -->
                    
                    <li class="dropdown user-dropdown">
                        <a href="#" class="dropdown-toggle mr-n1" data-toggle="dropdown">
                            <div class="user-toggle">
                                {if $user.user_picture_default}
                                    <div class="user-avatar sm sq">
                                        <small>{$user.first_name[0]|strtoupper}{$user.last_name[0]|strtoupper}</small>

                                        {if $user.employee_status == "4" ||  $user.employee_status == "5"}
                                            <div class="status dot dot-lg dot-warning"></div>
                                        {elseif $user.employee_status == "6"}
                                            <div class="status dot dot-lg dot-danger"></div>
                                        {/if}
                                    </div>
                                {else}
                                    <div class="user-avatar avatar-img sm sq" style="background-image: url('{$user.user_picture}');">
                                        {if $user.employee_status == "4" ||  $user.employee_status == "5"}
                                            <div class="status dot dot-lg dot-warning"></div>
                                        {elseif $user.employee_status == "6"}
                                            <div class="status dot dot-lg dot-danger"></div>
                                        {/if}
                                    </div>
                                {/if}

                                <div class="user-info d-none d-xl-block">
                                    <div class="user-name dropdown-indicator">{$user.first_name|ucfirst} {$user.last_name|ucfirst}</div>

                                    {if $user.is_writer || $user.is_editor}

                                        {assign var='status_color' value="user-status-unverified"}

                                        {if $user.employee_status == "4" || $user.employee_status == "5" || $user.employee_status == "6"}
                                            {assign var='status_color' value="user-status-unverified"}
                                        {elseif $user.employee_status == "2"}
                                            {assign var='status_color' value="user-status-verified"}
                                        {/if}
                                        <div class="user-status {$status_color}">{$user.employee_status_title}</div>
                                    {/if}

                                </div>
                            </div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-md dropdown-menu-right">
                            <div class="dropdown-inner user-card-wrap bg-lighter d-none d-md-block">
                                <div class="user-card">
                                    {if $user.user_picture_default}
                                        <div class="user-avatar">
                                            <span>{$user.first_name[0]|strtoupper}{$user.last_name[0]|strtoupper}</span>
                                        </div>
                                    {else}
                                        <div class="user-avatar avatar-img" style="background-image: url('{$user.user_picture}')"></div>
                                    {/if}
                                    <div class="user-info">
                                        <span class="lead-text">{$user.first_name|ucfirst} {$user.last_name|ucfirst}</span>
                                        <span class="sub-text">{$user.email}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="dropdown-inner">
                                <ul class="link-list">
                                    {if $user.is_writer || $user.is_editor}
                                        <li class="mb-2">
                                            <div class="Rating Rating--labeled" data-star_rating="{$user_average_rating}">
                                                <span class="Rating-total">
                                                    <span class="Rating-progress"></span>
                                                </span>
                                            </div>
                                        </li>
                                    {/if}
                                    <li>
                                        <a href="{$base_uri}/profile" data-ajax="/profile">
                                            <em class="icon ni ni-user-alt"></em><span>View Profile</span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="{$base_uri}/orders/available" data-ajax="/orders/available">
                                            <em class="icon ni ni-bag"></em><span>Manage Orders</span>
                                        </a> 
                                    </li>

                                    {if $user.is_admin}
                                        <li>
                                            <a href="{$base_uri}/updates" data-ajax="/updates">
                                                <em class="icon ni ni-update"></em><span>Check for Updates</span> 
                                                {if $new_version}<span class="badge badge-pill badge-success ml-auto">New</span>{/if}
                                            </a> 
                                        </li>
                                    {/if}
                                    
                                    {if $is_authorize}
                                        <li>
                                            <a href="{$base_uri}/authorize/{$admin.id}/{$admin.secure_key}">
                                                <em class="icon ni ni-account-setting-fill"></em><span>Back to Administrator</span>
                                            </a> 
                                        </li>
                                    {/if}
                                    
                                    <li>
                                        <a class="dark-switch js_theme-mode {if $theme_mode_night}active{/if}" href="#" {if $theme_mode_night}data-mode="day"{else}data-mode="night"{/if}>
                                            <em class="icon ni ni-moon"></em><span>Dark Mode</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="dropdown-inner">
                                <ul class="link-list">
                                    <li><a href="{$base_uri}/logout"><em class="icon ni ni-signout"></em><span>Sign out</span></a></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div><!-- .nk-header-wrap -->
    </div><!-- .container-fliud -->
</div>
<!-- main header @e -->