{block name='head_charset'}
    <meta charset="utf-8">
{/block}

{block name='head_seo'}
	<title>{block name='head_seo_title'}{$page_title}{/block}</title>
	{if $site_favicon}
		<link rel="shortcut icon" href="{$uploads_path}/{$site_favicon}" />
	{/if}
{/block}

{block name='head_ie_compatibility'}
    <meta http-equiv="x-ua-compatible" content="ie=edge">
{/block}

{block name='head_viewport'}
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
{/block}

{if $pwa_enabled}
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="{$pwa_theme_color}">
    <link rel="apple-touch-icon" sizes="180x180" href="{$uploads_path}/{$pwa_app_icon}">
    <link rel="manifest" href="{$base_uri}/manifest.json">
{/if}

<link href="{$theme_uri}/css/dashlite.css?ver={$system_version}" rel="stylesheet" type="text/css"/>

<link id="skin-default" href="{$theme_uri}/css/skins/theme.css?ver={$system_version}" rel="stylesheet" type="text/css"/>

{if $themeOptions.skin != 'default'}
    <link id="skin-theme" href="{$theme_uri}/css/skins/theme-{$themeOptions.skin}.css?ver={$system_version}" rel="stylesheet" type="text/css"/>
{/if}

<!-- FontAwesome Icons --> 
<link rel="stylesheet" type="text/css" href="{$theme_uri}/css/libs/fontawesome-icons.css"> 

{if $user.logged}
    <link href="{$theme_uri}/js/plugins/bootstrap.colorpicker/bootstrap-colorpicker.min.css?ver={$system_version}" rel="stylesheet" type="text/css"/>
    <link href="{$theme_uri}/js/plugins/bootstrap.datetimepicker/bootstrap-datetimepicker.min.css?ver={$system_version}" rel="stylesheet" type="text/css"/>
    <link href="{$theme_uri}/css/intl.telinput/intlTelInput.css?ver={$system_version}" rel="stylesheet" type="text/css"/>
    <link href="{$theme_uri}/css/editors/quill.css?ver={$system_version}" rel="stylesheet" type="text/css"/>
    <link href="{$theme_uri}/css/editors/summernote.css?ver={$system_version}" rel="stylesheet" type="text/css"/>
{/if}

{block name='stylesheets'}
    {include file="_partials/stylesheets.tpl" stylesheets=$stylesheets}
{/block}

{block name='javascript_head'}
    {include file="_partials/javascript.tpl" javascript=$javascript.head vars=$js_custom_vars}
{/block}

<script type="text/javascript" src="{$theme_uri}/js/bundle.js?ver={$system_version}"></script>

{strip}

    {if $css_customize}
        <style type="text/css">
            {$custom_css nofilter}
        </style>
    {/if}

    {if isset($css_files)}
        {foreach from=$css_files key=css_uri item=media}
            <link href="{$css_uri|escape:'html':'UTF-8'}" rel="stylesheet" type="text/css"/>
        {/foreach}
    {/if}

{/strip}