{strip}
<!-- Modals -->
<div id="modal" class="modal fade zoom">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <div class="text-center">
                    <div class="spinner-border m-4" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 

<script id="modal-login" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">Not Logged In</h5>
    </div>
    <div class="modal-body">
        <p>Please log in to continue</p>
    </div>
    <div class="modal-footer bg-lighter">
        <a class="btn btn-primary" href="{$base_uri}/signin">Login</a>
    </div>
</script>

<script id="modal-message" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">{literal}{{title}}{/literal}</h5>
        <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
    </div>
    <div class="modal-body">
        <p>{literal}{{message}}{/literal}</p>
    </div>
</script>

<script id="modal-success" type="text/template">
    <div class="modal-body modal-body-lg text-center">
        <div class="nk-modal">
            <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-check bg-success"></em>
            <h4 class="nk-modal-title">{literal}{{title}}{/literal}</h4>
            <div class="nk-modal-text">
                <div class="caption-text">{literal}{{message}}{/literal}</div>
            </div>
            <div class="nk-modal-action">
                {literal}{{#redirect_link}}{/literal}
                    <a href="{literal}{{redirect_link}}{/literal}" class="btn btn-lg btn-mw btn-primary">OK</a>
                {literal}{{/redirect_link}}{/literal}

                {literal}{{^redirect_link}}{/literal}
                    <a href="#" onclick="window.location.reload();" class="btn btn-lg btn-mw btn-primary">OK</a>
                {literal}{{/redirect_link}}{/literal}
            </div>
        </div>
    </div><!-- .modal-body -->
</script>

<script id="modal-error" type="text/template">
    <div class="modal-body modal-body-lg text-center">
        <div class="nk-modal">
            <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-cross bg-danger"></em>
            <h4 class="nk-modal-title">{literal}{{title}}{/literal}</h4>
            <div class="nk-modal-text">
                <p class="lead">{literal}{{message}}{/literal}</p>
                <p class="text-soft">If you need help please contact support.</p>
            </div>
            <div class="nk-modal-action">
                <a href="#" onclick="window.location.reload();" class="btn btn-lg btn-mw btn-light" data-dismiss="modal">Return</a>
            </div>
        </div>
    </div>
</script>

<script id="modal-confirm" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">{literal}{{title}}{/literal}</h5>
        <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
    </div>
    <div class="modal-body">
        <p>{literal}{{message}}{/literal}</p>
    </div>
    <div class="modal-footer bg-lighter">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="modal-confirm-ok">Confirm</button>
    </div>
</script>

<script id="modal-confirm-delete" type="text/template">
    <div class="modal-body modal-body-lg text-center">
        <div class="nk-modal py-4">
            <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-cross bg-danger"></em>
            <h4 class="nk-modal-title">{literal}{{title}}{/literal}</h4>
            <div class="nk-modal-text mt-n2">
                <p class="text-soft">{literal}{{message}}{/literal}</p>
            </div>
            <ul class="d-flex justify-content-center gx-4 mt-4">
                <li>
                    <button type="button" id="modal-confirm-delete-ok" class="btn btn-success">Yes, Delete it</button>
                </li>
                <li>
                    <button data-dismiss="modal" class="btn btn-danger btn-dim">Cancel</button>
                </li>
            </ul>
        </div>
    </div>
</script>

<script id="modal-loading" type="text/template">
    <div class="modal-body">
        <div class="text-center">
            <div class="spinner-border m-4" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
    </div>
</script>
<!-- Modals -->

<!-- @@ Account Status Modal @e -->
<script id="profileAccountWorkingStatus" type="text/template">
    <a href="#" class="close" data-dismiss="modal">
        <em class="icon ni ni-cross-sm"></em>
    </a>
    <div class="modal-body">
        <h5 class="title">Change Working Status</h5>
        <form class="js_ajax-forms" data-url="/user/settings?edit=working_status" autocomplete="off">
            <input type="hidden" name="employee_id" value="{$user.id}"/>
            <div class="form-group mt-4 mb-4">
                <label class="form-label">Status</label>
                <select class="form-select" data-ui="lg" name="employee_status">
                    <option value="2" {if $user.employee_status == "2"}selected="selected"{/if}>Looking for orders</option>
                    <option value="4" {if $user.employee_status == "4"}selected="selected"{/if}>Cannot work for now</option>
                    <option value="5" {if $user.employee_status == "5"}selected="selected"{/if}>Do not use your service</option>
                </select>
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label fw-bold">Available 24/7</div> 
                </div> 
                <div class="text-right"> 
                    <div class="custom-control custom-control-md custom-switch">
                        <input type="checkbox" class="custom-control-input" name="available_247" class="custom-control-input" id="available_247" {if $user.available_247}checked{/if}>
                        <label class="custom-control-label" for="available_247"></label>
                    </div>
                </div> 
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label fw-bold">Available to take Urgent Orders</div> 
                </div> 
                <div class="text-right"> 
                    <div class="custom-control custom-control-md custom-switch">
                        <input type="checkbox" class="custom-control-input" name="available_urgent_orders" class="custom-control-input" id="available_urgent_orders" {if $user.available_urgent_orders}checked{/if}>
                        <label class="custom-control-label" for="available_urgent_orders"></label>
                    </div>
                </div> 
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
                
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li>
                    <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                </li>
                <li>
                    <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                </li>
            </ul>
        </form>
    </div>
</script>

{if $user.is_admin}
    <!-- Activate Module -->
    <script id="activateModule" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/admin/modules" method="POST">
            <input type="hidden" name="do" value="activate">
            <input type="hidden" name="module_name" value="{literal}{{module_name}}{/literal}">
            <div class="modal-header">
                <h5 class="modal-title">Activate Module</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label text-left">Activation Key</label>
                    <input name="activation_key" type="text" class="form-control" required="">
                </div>

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Activate</button>
            </div>
        </form>
    </script>
    <!-- Activate Module -->
    
    <!-- Upload Plugin -->
    <script id="modalUploadPlugin" type="text/template">
        <form class="js_files-uploader p0 m0" method="POST" data-handle="plugin">
            <div class="modal-header">
                <h5 class="modal-title">Upload Addon</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            
            <div class="modal-body">
                <div class="files-control js_dropzone" data-handle="plugin">
                    <div class="files-control--files"></div>
                    <div class="dropzone-description">
                        <button class="browse-button btn btn-primary" type="button">Browse </button>
                        <span class="control-or">or</span>
                        <span class="control-drop-here">Drop plugin here</span>
                    </div>
                    <div class="dropzone-static">
                        <div class="dropzone-border">Drop files here</div>
                    </div>
                    <input accept=".zip" multiple="" type="file" style="display: none;" data-handle="plugin">
                </div>
                <!-- error -->
                <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
            </div>
        </form>
    </script>
{/if}

{if $user.is_admin || $user.is_sub_admin}

    <script id="modalPasswordResetLink" type="text/template">
        <div class="modal-header">
            <h5 class="modal-title">Password Reset Link</h5>
            <a href="#" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body p-0">
            <div class="code-block">
                <h6 class="overline-title title">Reset Link</h6>
                <button class="btn btn-sm clipboard-init" title="Copy to clipboard" data-clipboard-target="#passwordResetLink" data-clip-success="Copied" data-clip-text="Copy">
                    <span class="clipboard-text">Copy</span>
                </button>
                <div class="bg-light p-2 round-sm" id="passwordResetLink">{literal}{{password_reset_link}}{/literal}</div>
            </div>
        </div>
        <div class="modal-body pt-0 text-center">
            <a href="#" class="btn btn-secondary mx-auto" data-dismiss="modal">Done</a>
        </div>
    </script>

    <!-- Change Deadline -->
    <script id="extendDeadlineModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/orders/{literal}{{order_id}}{/literal}/deadline" method="POST" autocomplete="off">
            <input type="hidden" name="handle" value="{literal}{{handle}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Change Deadline</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">

                <div class="form-group mb0">
                    <label class="form-label">Select Deadline</label>
                    <div class="input-group date" id="deadline" data-target-input="nearest">
                        <input type='text' class="form-control form-control-lg date-time-picker" data-target="#deadline" name="deadline" />
                        <div class="input-group-append" data-target="#deadline" data-toggle="datetimepicker">
                            <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                        </div>
                    </div>
                </div>

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Change Deadline</button>
            </div>
        </form>
    </script>
    <!-- Change Deadline -->

    <!-- Bulk Actions -->
    <script id="modalBulkActions"  type="text/template">
        <form class="js_ajax-forms" data-url="/admin/bulk-actions" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Bulk Actions</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <input name="orderIds" value="{literal}{{orderIds}}{/literal}" type="hidden">
                <div class="form-group">
                    <label class="form-label">Select an Action</label>
                    <select data-combo="bulk-actions-combo" name="action" class="form-select" data-ui="lg">
                        <optgroup label="Status">
                            <option value="status" selected="">Change order status</option>
                        </optgroup>
                        <optgroup label="Paid">
                            <option value="mark-paid">Mark as Client Paid</option>
                            <option value="writer-paid">Mark as Writer Paid</option>
                            <option value="editor-paid">Mark as Editor Paid</option>
                        </optgroup>
                        <optgroup label="Unpaid">
                            <option value="mark-unpaid">Mark as Client Unpaid</option>
                            <option value="writer-unpaid">Mark as Writer Unpaid</option>
                            <option value="editor-unpaid">Mark as Editor Unpaid</option>
                        </optgroup>
                        <optgroup label="Delete">
                            <option value="delete">Delete</option>
                        </optgroup>
                    </select>
                </div>

                <div id="bulk-actions-combo" class="mt-3">
                    <div data-combo-value="status" class="switch-combo">
                        <div class="form-group">
                            <label class="form-label">Status ID</label>
                            <select name="status_id" class="form-select" data-ui="lg">
                                <option value="13">Free Inquiry</option>
                                <option value="0">Waiting for Payment</option>
                                <option value="12">New Paid</option>
                                <option value="19">Available</option>
                                <option value="6">Writer Assigned</option>
                                {if $editor_account_enabled}
                                    <option value="8">Done/Editing</option>
                                {/if}
                                <option value="11">Delivered</option>
                                <option value="10">Finished</option>
                                <option value="14">Revision</option>
                                <option value="9">Cancelled</option>
                                <option value="1">Dispute</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Confirm</button>
            </div>
        </form>
    </script>
    <!-- Bulk Actions -->

    <!-- Feedback Modal -->
    <script id="modal-feedback" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/feedback/{literal}{{feedback_id}}{/literal}/reply" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Reply to Feedback</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">

                <div class="form-group">
                    <label class="form-label">Reply</label>
                    <textarea name="reply" type="text" class="form-control js_autosize"></textarea>
                </div>

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Reply</button>
            </div>
        </form>
    </script>
    <!-- Feedback Modal -->

    <!-- Duplicate Order Modal -->
    <script id="duplicateOrderModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/orders/{literal}{{order_id}}{/literal}/duplicate" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Duplicate Order</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">

                <div class="form-group">
                    <label class="form-label">Duplicates</label>
                    <input class="form-control force-integer" type="text" name="duplicates" autocomplete="off">
                </div>

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Duplicate</button>
            </div>
        </form>
    </script>
    <!-- Duplicate Order Modal -->

    <!-- Employee Pay -->
    <script id="modal-edit-pay" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/orders/{literal}{{order_id}}{/literal}/edit-cost" method="POST">
            <div class="modal-body">
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
                <h5 class="title mb-3">Edit Pay</h5>

                {literal}{{#edit_customer_pay}}{/literal}
                    {literal}{{#customer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="customer_pay">Customer Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="customer_pay" type="text" class="form-control form-control-lg force-integer" value="{literal}{{customer_pay}}{/literal}">
                            </div>
                        </div>
                    {literal}{{/customer_pay}}{/literal}

                    {literal}{{^customer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="customer_pay">Customer Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="customer_pay" type="text" class="form-control form-control-lg force-integer" value="0.00">
                            </div>
                        </div>
                    {literal}{{/customer_pay}}{/literal}
                {literal}{{/edit_customer_pay}}{/literal}

                {literal}{{#edit_writer_pay}}{/literal}
                    {literal}{{#writer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="writer_pay">Writer Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="writer_pay" type="text" class="form-control form-control-lg force-integer" value="{literal}{{writer_pay}}{/literal}">
                            </div>
                        </div>
                    {literal}{{/writer_pay}}{/literal}

                    {literal}{{^writer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="writer_pay">Writer Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="writer_pay" type="text" class="form-control form-control-lg force-integer" value="0.00">
                            </div>
                        </div>
                    {literal}{{/writer_pay}}{/literal}
                {literal}{{/edit_writer_pay}}{/literal}

                {literal}{{#edit_editor_pay}}{/literal}
                    {literal}{{#editor_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="editor_pay">Editor Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="editor_pay" type="text" class="form-control form-control-lg force-integer" value="{literal}{{editor_pay}}{/literal}">
                            </div>
                        </div>
                    {literal}{{/editor_pay}}{/literal}

                    {literal}{{^editor_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="editor_pay">Editor Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="editor_pay" type="text" class="form-control form-control-lg force-integer" value="0.00">
                            </div>
                        </div>
                    {literal}{{/editor_pay}}{/literal}
                {literal}{{/edit_editor_pay}}{/literal}

                {literal}{{#edit_ordermanager_pay}}{/literal}
                    {literal}{{#ordermanager_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="ordermanager_pay">Order Manager Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="ordermanager_pay" type="text" class="form-control form-control-lg force-integer"  value="{literal}{{ordermanager_pay}}{/literal}">
                            </div>
                        </div>
                    {literal}{{/ordermanager_pay}}{/literal}

                    {literal}{{^ordermanager_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label" for="ordermanager_pay">Order Manager Pay</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-left">
                                    <em class="icon ni ni-sign-dollar"></em>
                                </div>
                                <input name="ordermanager_pay" type="text" class="form-control form-control-lg force-integer" value="0.00">
                            </div>
                        </div>
                    {literal}{{/ordermanager_pay}}{/literal}
                {literal}{{/edit_ordermanager_pay}}{/literal}

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <div class="align-center flex-wrap flex-sm-nowrap">
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </script>
    <!-- Employee Pay -->

    <!-- Progressive Delivery -->
    <script id="modalProgressiveDelivery" type="text/template">
        <form class="js_ajax-forms" data-url="/orders/{literal}{{order_id}}{/literal}/pd_schedule" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Delivery Schedule</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group form-row">
                    <label class="col-sm-3 form-label text-left">Pages</label>'
                    <div class="col-sm-4">
                        <div class="form-control-wrap number-spinner-wrap">
                            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus" data-number="minus">
                                <em class="icon ni ni-minus"></em>
                            </button>
                            <input type="text" name="pages" class="form-control form-control-lg number-spinner" placeholder="pages" value="0" min="0" max="999">
                            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus" data-number="plus">
                                <em class="icon ni ni-plus"></em>
                            </button>
                        </div>
                    </div>
                </div> 

                <div class="form-group form-row">
                    <label class="col-sm-3 form-label text-left">Charts</label>
                    <div class="col-sm-4">
                        <div class="form-control-wrap number-spinner-wrap">
                            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus" data-number="minus">
                                <em class="icon ni ni-minus"></em>
                            </button>
                            <input type="text" name="charts" class="form-control form-control-lg number-spinner" placeholder="charts" value="0" min="0" max="999">
                            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus" data-number="plus">
                                <em class="icon ni ni-plus"></em>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 form-label text-left">Slides</label>
                    <div class="col-sm-4">
                        <div class="form-control-wrap number-spinner-wrap">
                            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus" data-number="minus">
                                <em class="icon ni ni-minus"></em>
                            </button>
                            <input type="text" name="slides" class="form-control form-control-lg number-spinner" placeholder="slides" value="0" min="0" max="999">
                            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus" data-number="plus">
                                <em class="icon ni ni-plus"></em>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="divider"></div>

                <div class="form-row">
                    <div class="form-group col-sm-6">
                        <label class="form-label text-left">Customer Deadline</label>
                        <div class="form-control-wrap">
                            <div class="form-icon lg form-icon-left">
                                <em class="icon ni ni-calendar"></em>
                            </div>
                            <input type="text" class="form-control form-control-lg datetimepicker-input date-time-picker"  name="customer_deadline">
                        </div>
                    </div>

                    <div class="form-group col-sm-6">
                        <label class="form-label text-left">Writer Deadline</label>
                        <div class="form-control-wrap">
                            <div class="form-icon lg form-icon-left">
                                <em class="icon ni ni-calendar"></em>
                            </div>
                            <input type="text" class="form-control form-control-lg datetimepicker-input date-time-picker"  name="writer_deadline">
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Comments</label>
                    <textarea name="comments" type="text" class="form-control js_autosize"></textarea>
                </div>

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

            </div>
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Schedule</button>
            </div>
        </form>
    </script>
    <!-- Progressive Delivery -->
{/if}

{if $user.logged}

    <script id="newMessage" type="text/template">
        <form class="js_ajax-forms p0 m0" autocomplete="off" data-url="/messages/send" method="POST">
            <input type="hidden" name="order_id" value="{literal}{{order_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">New message</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Recepient</label>
                    <select name="recepient" data-combo="recepient" class="form-select" data-ui="lg" required="">
                        {if $user.is_writer}
                            <option value="7">Customer</option>
                            <option value="8">Support Department</option>
                        {elseif $user.is_editor}
                            <option value="6">Writer</option>
                            <option value="8">Support Department</option>
                        {elseif $user.is_admin || $user.is_sub_admin}
                            <option value="7">Customer</option>
                            <option value="6">Writer</option>
                        {/if}
                    </select>
                </div>

                {if $user.is_admin || $user.is_sub_admin}
                    <div class="form-group">
                        <label class="form-label">Subject</label>
                        <input name="subject" class="form-control form-control-lg"/>
                    </div>
                {else}
                    <div id="recepient">
                        <div class="switch-combo x-hidden" data-combo-value="8">
                            <div class="form-group mb-3">
                                <label class="form-label">Subject</label>
                                <input name="subject" class="form-control form-control-lg"/>
                            </div>
                        </div>
                    </div>
                {/if}

                <div class="form-group">
                    <label class="form-label">Message</label>
                    <textarea name="message" class="form-control summernote-minimal" data-height="200"></textarea>
                </div>

                {if ($user.is_admin || $user.is_sub_admin) && $smsnotifications_enabled}
                    <div class="form-group">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="send_sms" id="send_sms">
                            <label class="custom-control-label" for="send_sms">Send SMS</label>
                        </div>
                    </div>
                {/if}

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>  
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Send</button>
            </div>
        </form>
    </script>

    <!-- Revision -->
    <script id="reviseOrderModal" type="text/template">
        <form class="js_ajax-forms p0 m0" autocomplete="off" data-url="/orders/{literal}{{order_id}}{/literal}/sendToRevision" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Send order to revision</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Revision Note</label>
                    <textarea name="revision_note" class="form-control summernote-minimal"></textarea>
                </div>

                <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>  
            <div class="modal-footer bg-lighter">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </script>

    <!-- Upload -->
    <script id="modal-upload" type="text/template">
        <div class="modal-header">
            <h5 class="modal-title">Upload Files</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <form class="js_files-uploader" data-oid="{literal}{{order_id}}{/literal}" {if !$user.is_admin}data-upload-me=""{/if} method="POST">
            <div class="modal-body">
                {if $user.is_admin || $user.is_sub_admin}
                    <div class="form-group">
                        <label class="form-label text-left">Upload on behalf of</label>
                        <ul class="custom-control-group">
                            <li>
                                <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                                    <input type="radio" name="upload_for" value="customer" class="custom-control-input" id="btnRadioControlCustomer" required="">
                                    <label class="custom-control-label" for="btnRadioControlCustomer">Customer</label>
                                </div>
                            </li>
                            <li>
                                <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                                    <input type="radio" name="upload_for" value="writer" class="custom-control-input" id="btnRadioControlWriter" required="">
                                    <label class="custom-control-label" for="btnRadioControlWriter">Writer</label>
                                </div>
                            </li>
                            <li>
                                <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                                    <input type="radio" name="upload_for" value="editor" class="custom-control-input" id="btnRadioControlEditor" required="">
                                    <label class="custom-control-label" for="btnRadioControlEditor">Editor</label>
                                </div>
                            </li>
                            <li>
                                <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                                    <input type="radio" name="upload_for" value="support" class="custom-control-input" id="btnRadioControlSupport" required="">
                                    <label class="custom-control-label" for="btnRadioControlSupport">Support</label>
                                </div>
                            </li>
                        </ul>
                    </div>
                {/if}
                <div class="files-control js_dropzone" data-handle="order"> 
                    <div class="files-control--files"></div>
                    <div class="dropzone-description">
                        <button class="browse-button btn btn-primary" type="button">Browse </button>
                        <span class="control-or">or</span>
                        <span class="control-drop-here">Drop files here</span>
                    </div>
                    <div class="dropzone-static">
                        <div class="dropzone-border">Drop files here</div>
                    </div>
                    <input multiple="" type="file" style="display: none;" data-handle="order" data-id="{literal}{{order_id}}{/literal}">
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mt-2"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>

            <div class="modal-footer bg-lighter">
                <button type="button" class="link link-primary" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
            </div>
        </form>
    </script>
    <!-- Upload -->

    <!-- Form File -->
    <script id="form-file" type="text/template">
        <div class="FormFile" data-id="{literal}{{id}}{/literal}">
            <div class="FormFile__controls">
                <div class="FormFile__icon">
                    <div class="FormFile__icon__badge FormFile__icon__badge--jpg">{literal}{{extension}}{/literal}</div>
                </div>
                <button type="button" class="FormFile__info">
                    <div class="FormFile__title">{literal}{{filename}}{/literal}</div>
                    <span class="FormFile__size">{literal}{{size}}{/literal}</span>
                </button>

                {literal}{{#is_order}}{/literal}
                    <div class="FormFile__upload-type-control">
                        <select name="uploadTypeId" class="form-control" disabled>
                            <option value="-1" selected="">Select file type</option>
                            {foreach $upload_types as $upload_type}
                                <option value="{$upload_type.id}">{$upload_type.title}</option>
                            {/foreach}
                        </select>
                    </div>
                {literal}{{/is_order}}{/literal}
                
                <button {literal}{{^isUploaded}}disabled{{/isUploaded}}{/literal} type="button" class="FormFile__remove-button"></button>
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden mt-2"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <div class="FormFile__upload-progress">
                <div class="FormFile__upload-progress-bar" style="width:0;"></div>
            </div>
        </div>
    </script>
    <!-- Form File -->

    {/strip}

    <!-- x-uploader -->
    <script id="x-uploader" type="text/template">
        <form class="x-uploader" action="{literal}{{url}}{/literal}" method="post" enctype="multipart/form-data">
            {literal}{{#multiple}}{/literal}
            <input name="file[]" type="file" multiple="multiple">
            {literal}{{/multiple}}{/literal}
            {literal}{{^multiple}}{/literal}
            <input name="file" type="file">
            {literal}{{/multiple}}{/literal}

            {literal}{{#localstorage}}{/literal}
            <input name="localstorage" type="hidden" value="1">
            {literal}{{/localstorage}}{/literal}
            
            <input type="hidden" name="secret" value="{literal}{{secret}}{/literal}">
        </form>
    </script>
    <!-- x-uploader -->

    <!-- Publisher -->
    <script id="publisher-attachments-item" type="text/template">
        <li class="item deletable" data-handle="{literal}{{handle}}{/literal}" data-id="{literal}{{id}}{/literal}">
            <div class="item-image" style="background-image:url('{literal}{{image_path}}{/literal}');"></div>
            <button type="button" class="close js_publisher-attachment-remover" title="Remove"><span>&times;</span></button>
        </li>
    </script>
    <!-- Publisher -->

    <!-- File Details -->
    <script id="modalFileDetails" type="text/template">
        <div class="modal-header align-center">
            <div class="nk-file-title">
                <div class="nk-file-icon">
                    <span class="nk-file-icon-type">
                        <div class="FormFile__icon">
                            <div class="FormFile__icon__badge FormFile__icon__badge--{literal}{{file.extension}}{/literal}">{literal}{{file.extension}}{/literal}</div>
                        </div>               
                    </span>
                </div>
                <div class="nk-file-name">
                    <div class="nk-file-name-text"><span class="title">{literal}{{file.name}}{/literal}</span></div>
                    <div class="nk-file-name-sub">{literal}{{file.fileDescription}}{/literal}</div>
                </div>
            </div>
            <a href="#" class="close" data-dismiss="modal">
                <em class="icon ni ni-cross-sm"></em>
            </a>
        </div>
        <div class="modal-body">
            <div class="nk-file-details">
                <div class="nk-file-details-row">
                    <div class="nk-file-details-col">File Type</div>
                    <div class="nk-file-details-col">{literal}{{file.fileDescription}}{/literal}</div>
                </div>
                <div class="nk-file-details-row">
                    <div class="nk-file-details-col">Size</div>
                    <div class="nk-file-details-col">{literal}{{file.sizeFormatted}}{/literal}</div>
                </div>

                {if $user.is_admin || $user.is_sub_admin}
                    {literal}{{#isDownloadedByCustomer}}{/literal}
                    <div class="nk-file-details-row">
                        <div class="nk-file-details-col">Downloaded At</div>
                        <div class="nk-file-details-col">
                            <span class="js_moment" data-time="{literal}{{file.downloadedAt}}{/literal}">{literal}{{file.downloadedAt}}{/literal}</span>
                        </div>
                    </div>
                    {literal}{{/isDownloadedByCustomer}}{/literal}
                {/if}

                <div class="nk-file-details-row">
                    <div class="nk-file-details-col">Uploaded At</div>
                    <div class="nk-file-details-col">
                        <span class="js_moment" data-time="{literal}{{file.createdAt}}{/literal}">{literal}{{file.createdAt}}{/literal}</span>
                    </div>
                </div>
            </div>
        </div>
        <!-- .modal-body -->
        <div class="modal-footer modal-footer-stretch bg-light">
            <div class="modal-footer-between">
                <ul class="btn-toolbar g-3">
                    {if $user.is_admin || $user.is_sub_admin}
                        <li>
                            <a href="#" class="btn btn-danger js_deleter" data-handle="file" data-id="{literal}{{file.id}}{/literal}">Delete</a>
                        </li>
                    {/if}
                    <li>
                        <a href="{literal}{{file.downloadLink}}{/literal}" class="btn btn-primary file-dl-toast">Download</a>
                    </li>
                </ul>
            </div>
        </div>
    </script>
    <!-- File Details -->

{/if}