/**
 * core js
 *
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

// initialize API URLs
var { base_uri, api_path, theme_mode_night } = proxim;

// "inherit" EventEmitter
proxim.eventEmitter = new EventEmitter();

/**
 * Date formatter with PHP "date()"-compatible format syntax.
 */
const formatDate = (format, date) => {
    if (!format) { format = 'Y-m-d' }
    if (!date) { date = new Date() }

    const parts = {
      Y: date.getFullYear().toString(),
      y: ('00' + (date.getYear() - 100)).toString().slice(-2),
      m: ('0' + (date.getMonth() + 1)).toString().slice(-2),
      n: (date.getMonth() + 1).toString(),
      d: ('0' + date.getDate()).toString().slice(-2),
      j: date.getDate().toString(),
      H: ('0' + date.getHours()).toString().slice(-2),
      G: date.getHours().toString(),
      i: ('0' + date.getMinutes()).toString().slice(-2),
      s: ('0' + date.getSeconds()).toString().slice(-2)
    }

    const modifiers = Object.keys(parts).join('')
    const reDate = new RegExp('(?<!\\\\)[' + modifiers + ']', 'g')
    const reEscape = new RegExp('\\\\([' + modifiers + '])', 'g')

    return format
      .replace(reDate, $0 => parts[$0])
      .replace(reEscape, ($0, $1) => $1)
}

// initialize the plugins
function initialize() {
    proxim.eventEmitter.emit('initializeApp'); 
}

// modal
function modal() {
    if(arguments[0] == "#modal-login") {
        /* disable the backdrop (don't close modal when click outside) */
        if($('#modal').data('bs.modal')) {
            $('#modal').data('bs.modal').options = {backdrop: 'static', keyboard: false};
        } else {
            $('#modal').modal({backdrop: 'static', keyboard: false});
        }
    }

    /* check if the modal not visible, show it */
    if(!$('#modal').is(":visible")) $('#modal').modal('show');

    /* prepare modal size */
    $('.modal-dialog').removeClass('modal-sm');
    $('.modal-dialog').removeClass('modal-md');
    $('.modal-dialog').removeClass('modal-lg');
    $('.modal-dialog').removeClass('modal-xlg');

    switch(arguments[2]) {
        case 'small':
            $('.modal-dialog').addClass('modal-sm');
            break;
        case 'medium':
            $('.modal-dialog').addClass('modal-md');
            break;
        case 'large':
            $('.modal-dialog').addClass('modal-lg');
            break;
        case 'extra-large':
            $('.modal-dialog').addClass('modal-xl');
            break;
    }

    /* update the modal-content with the rendered template */
    $('#modal').find('.modal-content').html( render_template(arguments[0], arguments[1]) );
    
    /* initialize modal if the function defined (user logged in) */
    if(typeof initialize_modal === "function") {
        initialize_modal();
    }

    proxim.eventEmitter.emit('initializeModal', arguments);
}

// confirm
function confirm(title, message, callback) {
    modal('#modal-confirm', {'title': title, 'message': message});
    $("#modal-confirm-ok").click( function() {
        $(this).prop('disabled', true);
        $(this).html('Loading...');
        if(callback) callback();
    });
}

function confirmDelete(title, message, callback) {
    modal('#modal-confirm-delete', {'title': title, 'message': message});
    $("#modal-confirm-delete-ok").click( function() {
        $(this).prop('disabled', true);
        $(this).html('Loading...');
        if(callback) callback();
    });
}

// render template
function render_template(selector, options) {
    var template = $(selector).html();
    Mustache.parse(template);
    var rendered_template = Mustache.render(template, options);
    return rendered_template;
}

// button status
function button_status(element, handle) {
    if(handle == "loading") {
        /* loading */
        element.data('text', element.html());
        element.prop('disabled', true);
        element.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> <span>Loading...</span>');
    } else {
        /* reset */
        element.prop('disabled', false);
        element.html(element.data('text'));
    }
}

function startLoadingBar() {
    $(".barloading").css("display", "block")
}
function stopLoadingBar() {
    $(".barloading").css("display", "none")
}

/**
 * Approximates number to hundredth
 * @param {number} amount
 * @returns {number}
 */
function normalizePrice(amount) {
    return Math.round(amount * 100) / 100;
};

$(function() {

    // init plugins
    initialize();

    $(document).ajaxComplete(function() {
        initialize();
    });

    // run bootstrap modal
    $('body').on('click', '[data-toggle="modal"]', function(e) {
        e.preventDefault();
        if($(e.target).hasClass('link') && $(e.target).hasClass('disabled')) {
            return false;
        } 

        var url = $(this).data('url');
        var options = $(this).data('options');
        var size = $(this).data('size') || "default";

        if (url.indexOf('#') == 0) {
            /* open already loaded modal with #id */
            modal(url, options, size);
        } else {
            /* init loading modal */
            modal('#modal-loading', options, size);
            /* get & load modal from url */
            $.getJSON(api_path+url, function(response) {
                /* check the response */
                if(!response) return;
                /* check if there is a callback */
                if(response.callback) {
                    eval(response.callback);
                }
            })
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        }
    });

    // bootsrap dropdown keep open (and for slimScrollBar)
    $(document).on('click', '.js_dropdown-keepopen, .slimScrollBar', function (e) {
        e.stopPropagation();
    });

    // run bootstrap btn-group
    $(document).on('click', '.btn-group a', function (e) {
        e.preventDefault();
        var parent = $(this).parents('.btn-group');
        /* change the value */
        parent.find('input[type="hidden"]').val($(this).data('value'));
        /* copy text to btn-group-text */
        parent.find('.btn-group-text').text($(this).text());
        /* copy icon to btn-group-icon */
        parent.find('.btn-group-icon').attr("class", $(this).find('i.fa').attr("class")).addClass('btn-group-icon');
        /* copy title to tooltip */
        parent.data('original-title', $(this).data('title'));
        parent.data('value', $(this).data('value'));
        parent.tooltip();
    });

    // run toggle-panel
    $('.js_toggle-panel').click(function(event){
        event.preventDefault;
        var parent = $(this).parents('.js_panel');
        parent.hide();
        parent.siblings().fadeIn();
        return false;
    }); 

    // run ajax-forms
    $(document).on('submit', '.js_ajax-forms', function(e) {
        e.preventDefault();
        var url =  $(this).data('url');
        var photos =  $(this).data('photos') || undefined;
        var submit =  $(this).find('button[type="submit"]');
        var error =  $(this).find('.alert.alert-danger');
        var success =  $(this).find('.alert.alert-success');
        /* show any collapsed section if any */
        if( $(this).find('.js_hidden-section').length > 0 && ! $(this).find('.js_hidden-section').is(':visible')) {
             $(this).find('.js_hidden-section').slideDown();
            return false;
        }
        /* show loading */ 
        button_status(submit, "loading"); 

        var formData = $(this).serializeObject();
        if(photos) {
            formData['photos'] = photos;
        }

        /* get ajax response */
        $.post(api_path+url, formData, function(response) {
            /* hide loading */
            button_status(submit, "reset");

            /* handle response */
            if(response.error) {
                if(success.is(":visible")) success.hide(); // hide previous alert
                if(error.hasClass('alert-icon')) {
                    error.find('span').html(response.message), error.slideDown();
                } else {
                    error.html(response.message), error.slideDown();
                }
            } else if(response.success) {
                if(error.is(":visible")) error.hide(); // hide previous alert
                if(success.hasClass('alert-icon')) {
                    success.find('span').html(response.message), success.slideDown();
                } else {
                    success.html(response.message), success.slideDown();
                }
            } else {
                eval(response.callback);
            }
        }, "json")
        .fail(function() {
            /* hide loading */
            button_status(submit, "reset");
            /* handle error */
            if(success.is(":visible")) success.hide(); // hide previous alert
            if(error.hasClass('alert-icon')) {
                error.find('span').html('There is something that went wrong!'), error.slideDown();
            } else {
                error.html('There is something that went wrong!'), error.slideDown();
            }
        });
    });
});

$.fn.serializeObject = function() {
    var o = {};
    var a = this.serializeArray();
    $.each(a, function() {
        if (o[this.name]) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};