{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-users mr10"></i>
            
            {if 
                $sub_view == "writers" ||
                $sub_view == "editors" ||
                $sub_view == "sub-admins" ||
                $sub_view == "administrators"
            }
                <div class="pull-right flip">
                    <a href="{$base_uri}/employees/add" class="btn btn-primary">
                        <i class="fa fa-plus"></i> Add New Employee
                    </a>
                </div>
            {/if}

            <strong>Employees</strong> &rsaquo; <strong>{$sub_view|capitalize}</strong>
            {if 
                $sub_view == "writers" ||
                $sub_view == "editors" ||
                $sub_view == "sub-admins" ||
                $sub_view == "administrators"
            }
                &rsaquo; <strong>{$total_employees}</strong>
            {/if}

            {if $sub_view == "edit"}
                &rsaquo; <strong>{$employee.id}</strong>
                <div class="pull-right flip">
                    {if $employee.is_writer}
                        <a href="{$base_uri}/feedback/employee/{$employee.id}" class="btn btn-success">
                            <i class="fa fa-star"></i> View Reviews
                        </a>
                    {/if}
                    <a target="_blank" href="{$base_uri}/authorize/{$employee.id}/{$employee.secure_key}" class="btn btn-warning">
                        <i class="fa fa-user"></i> Impersonate
                    </a>
                    <a href="{$base_uri}/orders/employee/{$employee.id}" class="btn btn-primary">
                        <i class="fa fa-shopping-basket"></i> View Orders
                    </a>
                </div>
            {/if}
        </div>

        {if 
            $sub_view == "writers" ||
            $sub_view == "editors" ||
            $sub_view == "sub-admins" ||
            $sub_view == "administrators"
        }

            <div class="card-body">
                <div class="mb20"> 
                    <form class="form-inline" method="get" id="filter_form" autocomplete="off"> 
                        <div class="form-group mb0"> 
                        <div class="input-group"> 
                            <input type="text" class="form-control" name="query" value="{$query}"> 
                            <div class="input-group-append"> 
                                <button type="submit" class="btn btn-sm btn-info">
                                    <i class="fas fa-search mr5"></i>Search</button> 
                                </div> 
                            </div> 
                        </div> 
                    </form> 
                    <div class="form-text small">
                        Search employee ID, name or email
                    </div> 
                </div>

                {if count($employees)}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <td>ID</td>
                                    <td>Name</td>
                                    <td>Email</td>
                                    <td>Started</td>
                                    {if $sub_view == "writers" || $sub_view == "editors"}
                                        <td>Total Earned</td>
                                    {/if}
                                    <td>Actions</td>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $employees as $employee}
                                    <tr>
                                        <td>
                                            <a href="{$base_uri}/employees/edit/{$employee.id}">#{$employee.id}</a>
                                        </td>
                                        <td>{$employee.first_name} {$employee.last_name}</td>
                                        <td>{$employee.email}</td>
                                        <td>
                                            {if $employee.is_started}
                                                <span class="label label-success">Yes</span>
                                            {else}
                                                <span class="label label-danger">No</span>
                                            {/if}
                                        </td>
                                        {if $sub_view == "writers" || $sub_view == "editors"}
                                            <td>{formatPrice($employee.total_paid)}</td>
                                        {/if}
                                        <td>
                                            <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="employee" data-id="{$employee.id}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                            <a data-toggle="tooltip" data-placement="top" title="Edit" href="{$base_uri}/employees/edit/{$employee.id}" class="btn btn-xs btn-primary">
                                                <i class="fa fa-pencil-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> <i class="fa fa-users fa-4x"></i>
                        <p class="mb10"><strong>No employees to show</strong></p>
                    </div>
                {/if}
            </div>
        
        {elseif $sub_view == "add"}

            <form class="js_ajax-forms" method="POST" data-url="/employees/add" autocomplete="off">
                <div class="card-body">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Employee Group</label>
                        <div class="col-sm-9">
                            <select class="form-control" name="employee_group">
                                <option value="3">Writer</option>
                                <option value="2">Editor</option>
                                <option value="4">Sub Admin</option>
                                <option value="1">Administrator</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">First name</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="first_name">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Last name</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="last_name">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Email Address</label>
                        <div class="col-sm-9">
                            <input type="email" class="form-control" name="email"> 
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Gender</label>
                        <div class="col-sm-9">
                            <div class="radio radio-primary"> 
                                <input type="radio" name="gender" value="male" id="gender_male"> 
                                <label for="gender_male">Male</label> 
                            </div>
                            <div class="radio radio-primary"> 
                                <input type="radio" name="gender" value="female" id="gender_female"> 
                                <label for="gender_female">Female</label> 
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Password</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="password" autocomplete="off"> 
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->
                        </div>
                    </div>
                </div>
                <div class="card-footer clearfix">
                    <button type="submit" class="btn btn-success pull-right">Add new Employee</button>
                </div>
            </form>

        {elseif $sub_view == "edit"}
            
            <div class="card-body">
                <div class="row">
                    <div class="col-xs-offset-3 col-xs-6 col-sm-offset-0 col-sm-2 mb10">
                        <img class="img-responsive img-thumbnail" src="{$employee.user_picture}">
                    </div>
                    <div class="col-xs-12 col-sm-5 mb100">
                        <ul class="list-group">
                            <li class="list-group-item"> 
                                <span class="badge badge-primary">{$employee.id}</span> {if $employee.is_admin}Administrator {elseif $employee.is_editor}Editor {elseif $employee.is_writer}Writer {/if} ID
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary">{$employee.employee_status_title}</span> Status
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary js_moment" data-time="{$employee.reg_date}">{$employee.reg_date}</span> Joined
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary js_moment" data-time="{$employee.last_activity}">{$employee.last_activity}</span> Last Activity
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary js_moment" data-time="{$employee.last_login}">{$employee.last_login}</span> Last Login
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary">{if $employee.is_started}Yes{else}No{/if}</span> Started
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary">{formatPrice($outstanding_payment)}</span> Outstanding Payment
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary">{formatPrice($employee.last_pay)}</span> Last Pay
                            </li>
                            <li class="list-group-item"> 
                                <span class="badge badge-primary">{formatPrice($employee.total_paid)}</span> Total Earned
                            </li>
                        </ul>
                    </div>

                    {if !$employee.is_admin && !$employee.is_sub_admin}
                        <div class="col-xs-12 col-sm-5 mb10">
                            <ul class="list-group">
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.order_stats.bids}</span> <a class="text-link" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=7">Bids</a>
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.order_stats.progress}</span> <a href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=6">In Progress</a> 
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.order_stats.done}</span> <a href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=8">Done</a> 
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.order_stats.delivered}</span> <a href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=11">Delivered</a> 
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.order_stats.revision}</span> <a href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=14">Revision</a> 
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.order_stats.finished}</span> <a href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=10">Finished</a> 
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.order_stats.dispute}</span> <a href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=1">Disputes</a> 
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.total_orders_revised}</span> Total Orders Revised
                                </li>
                                <li class="list-group-item"> 
                                    <span class="badge badge-primary">{$employee.total_orders_rejected}</span> Total Orders Disputed
                                </li>
                            </ul>
                        </div>
                    {/if}
                </div>
 
                <ul class="nav nav-tabs mb20"> 
                    <li class="nav-item"> 
                        <a class="nav-link active" href="#account" data-toggle="tab"> 
                            <i class="fa fa-cogs fa-fw mr5"></i><strong class="pr5">Account</strong> 
                        </a> 
                    </li>
                    <li class="nav-item"> 
                        <a class="nav-link" href="#profile" data-toggle="tab"> 
                            <i class="fa fa-user fa-fw mr5"></i><strong class="pr5">Profile</strong> 
                        </a> 
                    </li>

                    {if $employee.is_editor || $employee.is_writer}
                        <li class="nav-item"> 
                            <a class="nav-link" href="#finances" data-toggle="tab"> 
                                <i class="fa fa-credit-card fa-fw mr5"></i><strong class="pr5">Finances</strong> 
                            </a> 
                        </li>
                    {/if}

                    <li class="nav-item"> 
                        <a class="nav-link" href="#sessions" data-toggle="tab"> 
                            <i class="fa fa-user-shield fa-fw mr5"></i><strong class="pr5">Login Sessions</strong> 
                        </a> 
                    </li>
                </ul>

                <div class="tab-content">

                    <div class="tab-pane active" id="account">
                        <div class="row">
                            <div class="col-md-8">
                                <form class="js_ajax-forms" method="POST" data-url="/employees/edit?edit=account" autocomplete="off">
                                    <input type="hidden" name="employee_id" value="{$employee.id}"/>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Started</label>
                                        <div class="col-sm-9">
                                            <label class="switch" for="started">
                                                <input type="checkbox" name="started" id="started" {if $employee.is_started == '1'}checked="checked"{/if}>
                                                <span class="slider round"></span>
                                            </label>
                                            <span class="help-block">Employee can view and access orders</span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Banned</label>
                                        <div class="col-sm-9">
                                            <label class="switch" for="banned">
                                                <input type="checkbox" name="banned" id="banned" {if $employee.is_banned == '1'}checked="checked"{/if}>
                                                <span class="slider round"></span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Email Notifications</label>
                                        <div class="col-sm-9">
                                            <label class="switch" for="email_notifications">
                                                <input type="checkbox" name="email_notifications" id="email_notifications" {if $employee.email_notifications == '1'}checked="checked"{/if}>
                                                <span class="slider round"></span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Employee Group</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="employee_group">
                                                <option value="1" {if $employee.employee_group == "1"}selected="selected"{/if}>Administrator</option>
                                                <option value="4" {if $employee.employee_group == "4"}selected="selected"{/if}>Sub Admin</option>
                                                <option value="2" {if $employee.employee_group == "2"}selected="selected"{/if}>Editor</option>
                                                <option value="3" {if $employee.employee_group == "3"}selected="selected"{/if}>Writer</option>
                                            </select>
                                        </div>
                                    </div>

                                    {if $employee.is_editor || $employee.is_writer}
                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label">Status</label>
                                            <div class="col-sm-9">
                                                <select class="form-control" name="employee_status">
                                                    <option value="2" {if $employee.employee_status == "2"}selected="selected"{/if}>Looking for orders</option>
                                                    <option value="4" {if $employee.employee_status == "4"}selected="selected"{/if}>Cannot work for now</option>
                                                    <option value="5" {if $employee.employee_status == "5"}selected="selected"{/if}>Do not use your service</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label">Writer Category</label>
                                            <div class="col-sm-9">
                                                <select class="form-control" name="writer_category">
                                                    <option value="2" {if $employee.writer_category == "2"}selected="selected"{/if}>Best Available</option>
                                                    <option value="3" {if $employee.writer_category == "3"}selected="selected"{/if}>ESL (English Second Language)</option>
                                                    <option value="4" {if $employee.writer_category == "4"}selected="selected"{/if}>ENL (English Native Language)</option>
                                                </select>
                                            </div> 
                                        </div>

                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label">Academic Level</label>
                                            <div class="col-sm-9">
                                                <select class="form-control" name="academic_level">
                                                    <option value="1" {if $employee.academic_level == "1"}selected="selected"{/if}>High school</option>
                                                    <option value="2" {if $employee.academic_level == "2"}selected="selected"{/if}>Undergrad. (yrs 1-2)</option>
                                                    <option value="3" {if $employee.academic_level == "3"}selected="selected"{/if}>Undergrad. (yrs 3-4)</option>
                                                    <option value="4" {if $employee.academic_level == "4"}selected="selected"{/if}>Master's</option>
                                                    <option value="5" {if $employee.academic_level == "5"}selected="selected"{/if}>Ph.D.</option>
                                                </select>
                                            </div> 
                                        </div>
                                    {/if}

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Email Address</label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control" name="email" value="{$employee.email}"> 
                                        </div>
                                    </div>

                                    {if $employee.is_editor || $employee.is_writer}
                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label text-left">CPP Type</label>
                                            <div class="col-sm-9">
                                                <select class="form-control" name="cpp_type" data-combo="cpp_type">
                                                    <option value="system" {if $employee.cpp_type == 'system'}selected=""{/if}>System CPP</option>
                                                    <option value="custom" {if $employee.cpp_type == 'custom'}selected=""{/if}>Custom CPP</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div id="cpp_type">
                                            <div class="switch-combo {if $employee.cpp_type == 'system'}x-hidden{/if}" data-combo-value="custom">
                                                <div class="form-group form-row">
                                                    <label class="col-sm-3 control-label text-left">{if $article_writing_enabled}Cost Per Word{else}Cost Per Page{/if}</label>
                                                    <div class="col-sm-4">
                                                        <div class="input-group">
                                                            <div class="input-group-prepend"> 
                                                                <span class="input-group-text d-none d-sm-block">$</span> 
                                                            </div>
                                                            <input name="cpp_amount" type="text" class="form-control force-integer" value="{$employee.cpp_amount}">
                                                        </div>
                                                        <span class="help-block">
                                                            The amount {$employee.first_name} will earn per {if !$article_writing_enabled}word{else}page{/if}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    {/if}

                                    {if $employee.is_writer}
                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label text-left">Number of Takes</label>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <input name="number_of_takes" type="text" class="form-control force-integer" value="{$employee.number_of_takes}">
                                                </div>
                                                <span class="help-block">
                                                    The employee's number of order takes
                                                </span>
                                            </div>
                                        </div>
                                    {/if}

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Password</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="password" autocomplete="off"> 
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <div class="col-sm-9 offset-sm-3">
                                            <!-- success -->
                                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                            <!-- success -->

                                            <!-- error -->
                                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                            <!-- error -->

                                            <button type="submit" class="btn btn-success">Save Changes</button>
                                            <button type="button" class="btn btn-primary js_reset-password-link" data-id="{$employee.id}" data-handle="employee">Password reset link</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="profile">
                        <div class="row">
                            <div class="col-md-8">
                                <form class="js_ajax-forms" method="POST" data-url="/employees/edit?edit=profile" autocomplete="off">
                                    <input type="hidden" name="employee_id" value="{$employee.id}"/>
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">First name</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="first_name" value="{$employee.first_name}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Middle name</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="middle_name" value="{$employee.middle_name}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Last name</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="last_name" value="{$employee.last_name}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Gender</label>
                                        <div class="col-sm-9">
                                            <div class="radio radio-primary"> 
                                                <input type="radio" name="gender" value="male" id="gender_male" {if $employee.gender == 'male'}checked="checked"{/if}> 
                                                <label for="gender_male">Male</label> 
                                            </div>
                                            <div class="radio radio-primary"> 
                                                <input type="radio" name="gender" value="female" id="gender_female" {if $employee.gender == 'female'}checked="checked"{/if}> 
                                                <label for="gender_female">Female</label> 
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Phone</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="phone" {if $employee.phone}value="{$employee.phone}"{/if}>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <div class="col-sm-9 offset-sm-3">
                                            <!-- success -->
                                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                            <!-- success -->

                                            <!-- error -->
                                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                            <!-- error -->

                                            <button type="submit" class="btn btn-success">Save Changes</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    {if $employee.is_editor || $employee.is_writer}
                        <div class="tab-pane" id="finances">
                            <div class="row mb10">
                                <div class="col-sm-4">
                                    <div class="stat-panel bg-gradient-info">
                                        <div class="stat-cell">
                                            <i class="fas fa-money-bill-wave bg-icon"></i>
                                            <span class="text-xlg">{formatPrice($outstanding_payment)}</span><br>
                                            <span class="text-lg">Outstanding Payment</span><br>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="stat-panel bg-gradient-indigo">
                                        <div class="stat-cell">
                                            <i class="fas fa-money-bill-wave bg-icon"></i>
                                            <span class="text-xlg">{formatPrice($employee.last_pay)}</span><br>
                                            <span class="text-lg">Last Pay</span><br>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="stat-panel bg-gradient-blue">
                                        <div class="stat-cell">
                                            <i class="fas fa-money-bill-wave bg-icon"></i>
                                            <span class="text-xlg">{formatPrice($employee.total_paid)}</span><br>
                                            <span class="text-lg">Total Earned</span><br>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {hook h='displayEmployeeFinancesStats' employee_id=$employee.id}

                            <div id="admin-chart-income" class="admin-chart"></div>
                        </div>

                        <!-- Admin Charts -->
                        <script src="https://code.highcharts.com/highcharts.js"></script>
                        <script src="https://code.highcharts.com/modules/exporting.js"></script>

                        <script type="text/javascript">
                            var xAxis = {
                                categories: [
                                    "Jan",
                                    "Feb",
                                    "Mar",
                                    "Apr",
                                    "May",
                                    "Jun",
                                    "Jul",
                                    "Aug",
                                    "Sep",
                                    "Oct",
                                    "Nov",
                                    "Dec"
                                ],
                                crosshair: true
                            };

                            var yAxis = {
                                min: 0,
                                title: {
                                    text: "{'Y'|date}"
                                }
                            };

                            var tooltip = {
                                headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                                pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                                    '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
                                footerFormat: '</table>',
                                shared: true,
                                useHTML: true
                            };

                            var plotOptions = {
                                column: {
                                    pointPadding: 0.2,
                                    borderWidth: 0
                                }
                            };
                        </script>


                        <script type="text/javascript">
                            $(function () {
                                $('#admin-chart-income').highcharts({
                                    chart: {
                                        type: 'line'
                                    },
                                    title: {
                                        text: "Monthly Income Average"
                                    },
                                    xAxis,
                                    yAxis,
                                    tooltip : {
                                        headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                                        pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                                            '<td style="padding:0"><b>${literal}{point.y}{/literal}</b></td></tr>',
                                        footerFormat: '</table>',
                                        shared: true,
                                        useHTML: true
                                    },
                                    plotOptions,
                                    series: [{
                                        name: "Income",
                                        data: [{','|implode:$chart['income']}]
                                    }]
                                });
                            });
                        </script>
                    {/if}
                    
                    <div class="tab-pane" id="sessions">
                        <div class="clearfix">
                            <div class="pull-right mb10">
                                <button type="button" class="btn btn-danger js_session-delete-all" data-uid="{$employee.id}">
                                    <i class="fa fa-lock fa-fw"></i> Logout All Sessions
                                </button>
                            </div>
                        </div>

                        {if count($sessions)}
                            <div class="table-responsive">
                                <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                                    <thead>
                                        <tr>
                                            <th>Browser</th>
                                            <th>OS</th>
                                            <th>Date</th>
                                            <th>IP</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {foreach $sessions as $session}
                                            <tr>
                                                <td>{$session.user_browser}</td>
                                                <td>{$session.user_os}</td>
                                                <td>
                                                    <span class="js_moment" data-time="{$session.date_add}">{$session.date_add}</div>
                                                </td>
                                                <td>{$session.user_ip}</td>
                                                <td>
                                                    <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="session" data-id="{$session.session_id}">
                                                        <i class="fa fa-trash-alt"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
            
                                {$pager nofilter}
                            </div>
                        {else}
                            <div class="text-center x-muted"> 
                                <img class="mb20" width="15%" src="/static/images/no_results.png">
                                <p class="mb10"><strong>No sessions to show</strong></p>
                            </div>
                        {/if}               
                    </div>
                
                </div>
               
            </div>
            
        {/if}
    </div>
{/block}
