{extends file='dashboard/layout.tpl'}

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-users mr10"></i>
            {if $section == ""}
                <div class="pull-right flip">
                    <a href="{$base_uri}/customers/add" class="btn btn-primary">
                        <i class="fa fa-plus"></i> Add New Customer
                    </a>
                </div>
            {elseif $section == "edit"}
                <div class="pull-right flip">
                    <a target="_blank" href="{$customer_site.domain}/api/v1/auth/{$customer.id}?authKey={$customer.secure_key}" class="btn btn-warning">
                        <i class="fa fa-user"></i> Impersonate User
                    </a>
                    <a href="{$base_uri}/orders/customer/{$customer.id}" class="btn btn-primary">
                        <i class="fa fa-shopping-basket"></i> View Orders
                    </a>
                </div>
            {/if}

            <strong>Customers</strong>
            {if $section == ""}&rsaquo; <strong>{$total_customers}</strong>{/if}
            {if $section == "edit"}&rsaquo; <strong>Edit</strong> &rsaquo; <strong>{$customer.id}</strong>{/if}
            {if $section == "add"}&rsaquo; <strong>Add</strong>{/if}
        </div>

        {if $section == ""}

            <div class="card-body">

                <div class="mb20"> 
                    <form class="form-inline" method="get" id="filter_form" autocomplete="off"> 
                        <div class="form-group mb0"> 
                        <div class="input-group"> 
                            <input type="text" class="form-control" name="query" value="{$query}"> 
                            <div class="input-group-append"> 
                                <button type="submit" class="btn btn-sm btn-info">
                                    <i class="fas fa-search mr5"></i>Search</button> 
                                </div> 
                            </div> 
                        </div> 
                    </form> 
                    <div class="form-text small">
                        Search customer ID, name, email or site ID
                    </div> 
                </div>

                {if count($customers)}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <td>ID</td>
                                    <td>Name</td>
                                    <td>Contact</td>
                                    <td>Site</td>
                                    <td>Total spent</td>
                                    <td>Registration</td>
                                    <td>Actions</td>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $customers as $customer}
                                    <tr>
                                        <td>
                                            <a href="{$base_uri}/customers/edit/{$customer.id}">#{$customer.id}</a>
                                        </td>
                                        <td>{$customer.name}</td>
                                        <td>
                                            <div class="h5 mb5">{$customer.email}</div>
                                            {if $customer.phone}<div class="h6 mb0">{$customer.phone}</div>{/if}
                                        </td>
                                        <td>
                                            {$customer.site_name}
                                        </td>
                                        <td>
                                            <span class="text_success">${$customer.total_spent}</span>
                                        </td>
                                        <td>
                                            <span class="js_moment" data-time="{$customer.reg_date}">{$customer.reg_date}</div>
                                        </td>
                                        <td>
                                            <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="customer" data-id="{$customer.id}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                            <a data-toggle="tooltip" data-placement="top" title="Edit" href="{$base_uri}/customers/edit/{$customer.id}" class="btn btn-xs btn-primary">
                                                <i class="fa fa-pencil-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> <i class="fa fa-users fa-4x"></i>
                        <p class="mb10"><strong>No customers to show</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $section == "add"}

            <div class="card-body">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/customers?do=add">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Site
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="site_id" required>
                                <option value="-1">Select Site</option>
                                {foreach $sites as $site}
                                <option value="{$site.site_id}">{$site.name}</option>
                                {/foreach}
                            </select>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Email
                        </label>
                        <div class="col-sm-9">
                            <input class="form-control" type="text" name="email" required>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Password
                        </label>
                        <div class="col-sm-9">
                            <input class="form-control" type="text" name="password" required>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Name <small>(optional)</small>
                        </label>
                        <div class="col-sm-9">
                            <input class="form-control" type="text" name="name">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Add Customer</button>
                        </div>
                    </div>

                </form>
            </div>

        {elseif $section == "edit"}
            <div class="card-body">
                <div class="row">
                    <div class="col-xs-12 col-sm-7 mb10">
                        <ul class="list-group">

                            <li class="list-group-item">
                                <span class="badge badge-primary">{$customer.id}</span> Customer ID
                            </li>
                            <li class="list-group-item">
                                <span class="badge badge-primary">{$customer.google_analytics_id}</span> GA Id
                            </li>
                            <li class="list-group-item">
                                <span class="badge badge-primary">{$customer.site_name}</span> From site
                            </li>
                            <li class="list-group-item">
                                <span class="badge badge-primary js_moment" data-time="{$customer.reg_date}">{$customer.reg_date}</span> Joined
                            </li>
                            <li class="list-group-item">
                                <span class="badge badge-primary js_moment" data-time="{$customer.last_login}">{$customer.last_login}</span> Last Login
                            </li>
                        </ul>
                    </div>
                    <div class="col-xs-12 col-sm-5 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge badge-primary">${$customer.total_spent}</span> Total spent
                            </li>
                            <li class="list-group-item">
                                <span class="badge badge-primary">${$customer.affiliate_balance}</span> Affiliate Balance
                            </li>
                            {if $customer.referrer_id}
                                <li class="list-group-item">
                                    <a class="badge badge-primary" href="/customers/edit/{$customer.referrer_id}" target="_blank">{$customer.referrer_id}</a> Referrer ID
                                </li>
                            {/if}
                            <li class="list-group-item">
                                <span class="badge badge-primary">{if $customer.is_subscribed}Yes{else}No{/if}</span> Subscribed
                            </li>
                            <li class="list-group-item">
                                <span class="badge badge-primary js_moment" data-time="{$customer.last_activity}">{$customer.last_activity}</span> Last Activity
                            </li>
                        </ul>
                    </div>
                </div>

                <ul class="nav nav-tabs mb20"> 
                    <li class="nav-item"> 
                        <a class="nav-link active" href="#account" data-toggle="tab"> 
                            <i class="fa fa-cogs fa-fw mr5"></i><strong class="pr5">Account</strong> 
                        </a> 
                    </li>

                    {hook h='displayAdminEditCustomerNavbar' customerId=$customer.id}

                </ul>

                <div class="tab-content">

                    <div class="tab-pane active" id="account">
                        <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/customers?do=edit">
                            <input type="hidden" name="customer_id" value="{$customer.id}"/>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Email
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control" type="text" name="email" value="{$customer.email}" required {if !$user.is_admin}disabled=""{/if}>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Phone
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control" type="text" name="phone" value="{$customer.phone}" {if !$user.is_admin}disabled=""{/if}>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Name <small>(optional)</small>
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control" type="text" name="name" value="{$customer.name}" {if !$user.is_admin}disabled=""{/if}>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Site
                                </label>
                                <div class="col-sm-9">
                                    <select class="form-control" name="site_id" required {if !$user.is_admin}disabled=""{/if}>
                                        <option value="-1">Select Site</option>
                                        {foreach $sites as $site}
                                            <option value="{$site.site_id}" {if $customer.site_id == $site.site_id}selected=""{/if}>{$site.name}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Total Spent
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control force-integer" type="text" name="total_spent" value="{$customer.total_spent}" {if !$user.is_admin}disabled=""{/if}>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Password
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control" type="text" name="password" {if !$user.is_admin}disabled=""{/if}>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <div class="col-sm-9 offset-sm-3">
                                    <!-- success -->
                                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                    <!-- success -->

                                    <!-- error -->
                                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                    <!-- error -->

                                    <button type="submit" class="btn btn-primary" {if !$user.is_admin}disabled=""{/if}>Save Changes</button>
                                    <button type="button" class="btn btn-primary js_reset-password-link" data-id="{$customer.id}" data-handle="customer">Password reset link</button>
                                </div>
                            </div>

                        </form>
                    </div>

                    {hook h='displayAdminEditCustomerNavContent' customerId=$customer.id}
                </div>
            </div>
        {/if}
    </div>
{/block}
