{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon with-nav">
        <div class="mb20">
            <i class="fa fa-cog mr10"></i>
            <strong>Settings</strong>
        </div>

        <!-- tabs nav -->
        <ul class="nav nav-tabs admin">
            <li class="nav-item">
                <a class="nav-link active"href="#general" data-toggle="tab">
                    <i class="fa fa-server fa-fw mr5"></i>
                    <strong class="pr5">General</strong>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link"href="#orders" data-toggle="tab">
                    <i class="fa fa-shopping-basket fa-fw mr5"></i>
                    <strong class="pr5">Orders &amp; Payments</strong>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link"href="#email" data-toggle="tab">
                    <i class="fa fa-envelope fa-fw mr5"></i>
                    <strong class="pr5">Email</strong>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link"href="#writer_payments" data-toggle="tab">
                    <i class="fa fa-money-bill-alt fa-fw mr5"></i>
                    <strong class="pr5">Writer Payment</strong>
                </a>
            </li> 

            <li class="nav-item">
                <a class="nav-link"href="#editor_payments" data-toggle="tab">
                    <i class="fa fa-money-bill-alt fa-fw mr5"></i>
                    <strong class="pr5">Editor Payment</strong>
                </a>
            </li> 

        </ul>
        <!-- tabs nav -->
    </div>

    <div class="card-body">
        <!-- tabs content -->
        <div class="tab-content">

            <!-- General -->
            <div class="tab-pane active" id="general">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=general_settings">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Site ID</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" value="{$formValues.SITE_ID}" readonly>
                            <span class="help-block">
                                Your administrator site ID
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Website Logo</label>
                        <div class="col-sm-9">
                            {if $site_logo == ''}
                                <div class="x-image">
                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_logo" value="">
                                </div>
                            {else}
                                <div class="x-image" style="background-image: url('{$uploads_path}/{$site_logo}')">
                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_logo" value="{$site_logo}">
                                </div>
                            {/if}
                            <span class="help-block">
                                The perfect size for your logo should be (width: 130px & height: 50px)
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Site Favicon</label>
                        <div class="col-sm-9">
                            {if $formValues.SITE_FAVICON == ''}
                                <div class="x-image">
                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_favicon" value="">
                                </div>
                            {else} 
                                <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_FAVICON}')">
                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_favicon" value="{$formValues.SITE_FAVICON}">
                                </div>
                            {/if}
                            <span class="help-block">
                                The perfect size for your favicon should be (wdith: 196px & height: 196px)
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Email Logo</label>
                        <div class="col-sm-9">
                            {if $formValues.SITE_EMAIL_LOGO == ''}
                                <div class="x-image">
                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_email_logo" value="">
                                </div>
                            {else}
                                <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_EMAIL_LOGO}')">
                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_email_logo" value="{$formValues.SITE_EMAIL_LOGO}">
                                </div>
                            {/if}
                            <span class="help-block">
                                The perfect size for your logo should be (width: 130px & height: 50px)
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Website Title
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="site_name" value="{$formValues.SITE_NAME}">
                            <span class="help-block">
                                Title of your website
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Website Domain
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="site_domain" value="{$formValues.SITE_DOMAIN}">
                            <span class="help-block">
                                URL of your website
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Website Email
                        </label>
                        <div class="col-sm-9">
                            <input type="email" class="form-control" name="site_email" value="{$formValues.SITE_EMAIL}">
                            <span class="help-block">
                                The contact email that all messages send to
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Notification Emails</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="notification_emails" value="{$formValues.NOTIFICATION_EMAILS}">
                            <span class="help-block">
                                Additional contact emails that will receive notifications. Separate by a comma <strong>,</strong>
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Default Timezone
                        </label>
                        <div class="col-md-4">
                            <select id="timezone-region" class="form-control" data-combo="timezone-combo">
                                {foreach from=$regions item=region key=key name=name}
                                    <option value="{$key}" {if $default_region == $key } selected="" {/if} >{$key}</option>
                                {/foreach}
                            </select>
                        </div>
                        <div id="timezone-combo" class="col-md-5">
                            {foreach from=$regions item=region key=key name=name}
                                <select id="timezone-combo-{$key}" class="form-control {if $default_region != $key } x-hidden {/if} switch-combo" data-combo-value="{$key}">
                                    {foreach from=$region item=item key=key name=name}
                                        <option value="{$key}" {if $default_timezone == $key } selected="" {/if} >{$item}</option>
                                    {/foreach}
                                </select>
                            {/foreach}
                        </div>
                    </div>
                    <input type="hidden" id="timezone" name="default_timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Registration Enabled</div> 
                            <div class="form-text d-none d-sm-block">Allow users to create accounts</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="registration_enabled"> 
                                <input type="checkbox" name="registration_enabled" id="registration_enabled" {if $formValues.REGISTRATION_ENABLED}checked{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Article Writing Module</div> 
                            <div class="form-text d-none d-sm-block">Enable and disable the article writing module</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="article_writing_enabled"> 
                                <input type="checkbox" name="article_writing_enabled" id="article_writing_enabled" {if $formValues.ARTICLE_WRITING_ENABLED}checked{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Enable Customization</div> 
                            <div class="form-text d-none d-sm-block">Turn the customization On and Off</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="css_customize"> 
                                <input type="checkbox" name="css_customize" id="css_customize" {if $formValues.CSS_CUSTOMIZE}checked{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Header Color</label>
                        <div class="col-sm-9">
                            <div class="input-group js_colorpicker">
                                <input name="header_color" type="text" class="form-control" value="{$formValues.HEADER_COLOR}">
                                <span class="input-group-append"> 
                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Button Primary</label>
                        <div class="col-sm-9">
                            <div class="input-group js_colorpicker">
                                <input name="btn_primary_color" type="text" class="form-control" value="{$formValues.BUTTON_PRIMARY}">
                                <span class="input-group-append"> 
                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Menu Background</label>
                        <div class="col-sm-9">
                            <div class="input-group js_colorpicker">
                                <input name="menu_background_color" type="text" class="form-control" value="{$formValues.MENU_BACKGROUND}">
                                <span class="input-group-append"> 
                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Custom CSS</label>
                        <div class="col-sm-9">
                            <textarea class="form-control js_autosize" rows="10" name="custom_css" id="custom-css">{$formValues.CUSTOM_CSS nofilter}</textarea>
                            <span class="help-block">Header Custom CSS
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                    
                </form>
            </div>
            <!-- General -->

            <!-- Orders & Payments -->
            <div class="tab-pane" id="orders">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=orders_settings">
                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Attach Completed Files</div> 
                            <div class="form-text d-none d-sm-block">Enable this to attach completed files in the customer's notification email</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="attach_completed_files"> 
                                <input type="checkbox" name="attach_completed_files" id="attach_completed_files" {if $formValues.ATTACH_COMPLETED_FILES}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Editor Account</div> 
                            <div class="form-text d-none d-sm-block">Enable and Disable the editor feature</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="editor_account"> 
                                <input type="checkbox" name="editor_account" id="editor_account" {if $formValues.EDITOR_ACCOUNT_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Pay Delivered Orders</div> 
                            <div class="form-text d-none d-sm-block">Include delivered orders in writers and editors payment summary</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="pay_delivered_orders"> 
                                <input type="checkbox" name="pay_delivered_orders" id="pay_delivered_orders" {if $formValues.PAY_DELIVERED_ORDERS}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Confirm Order Assign</div> 
                            <div class="form-text d-none d-sm-block">Enable this to allow writers to confirm when you assign them an order</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="confirm_order_assign"> 
                                <input type="checkbox" name="confirm_order_assign" id="confirm_order_assign" {if $formValues.CONFIRM_ORDER_ASSIGN}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Sub Admin Client Cost</div> 
                            <div class="form-text d-none d-sm-block">Enable the sub admin to see the customer pay</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="subadmin_client_cost"> 
                                <input type="checkbox" name="subadmin_client_cost" id="subadmin_client_cost" {if $formValues.SUBADMIN_CLIENT_COST}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Sub Admin Writer Info</div> 
                            <div class="form-text d-none d-sm-block">Enable the sub admin to see writer info</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="subadmin_writer_info"> 
                                <input type="checkbox" name="subadmin_writer_info" id="subadmin_writer_info" {if $formValues.SUBADMIN_WRITER_INFO}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Auto-Assign Requested Writers</div> 
                            <div class="form-text d-none d-sm-block">Enable this to auto-assign an order when the customer requests for a writer</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="autoassign_requested_writer"> 
                                <input type="checkbox" name="autoassign_requested_writer" id="autoassign_requested_writer" {if $formValues.AUTOASSIGN_REQUESTED_WRITER}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Auto-approve time
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="autoapprove_time">
                                <option value="120" {if $formValues.ORDER_AUTOAPPROVE_TIME == '120'}selected="selected"{/if}>5 days</option>
                                <option value="168" {if $formValues.ORDER_AUTOAPPROVE_TIME == '168'}selected="selected"{/if}>7 days</option>
                                <option value="336" {if $formValues.ORDER_AUTOAPPROVE_TIME == '336'}selected="selected"{/if}>14 days</option>
                                <option value="504" {if $formValues.ORDER_AUTOAPPROVE_TIME == '504'}selected="selected"{/if}>21 days</option>
                                <option value="720" {if $formValues.ORDER_AUTOAPPROVE_TIME == '720'}selected="selected"{/if}>30 days</option>
                            </select>
                            <span class="help-block">
                                The time it will take to auto-approve an order after it is delivered to a customer
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Writer Payment Request Limit
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="writer_payment_request_limit" value="{$formValues.WRITER_PAYMENT_REQUEST_LIMIT}">
                            <span class="help-block">
                                The minimum payment request a writer can request
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Editor Payment Request Limit
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="editor_payment_request_limit" value="{$formValues.EDITOR_PAYMENT_REQUEST_LIMIT}">
                            <span class="help-block">
                                The minimum payment request an editor can request
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Order Autoincrement</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control force-integer" name="order_autoincrement" {if $formValues.ORDER_AUTOINCREMENT}value="{$formValues.ORDER_AUTOINCREMENT}"{else}value="2"{/if}>
                            <span class="help-block">
                                The minimum payment request an editor can request
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>

                    {if !$article_writing_enabled}    
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Order Words Per Page</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control force-integer" name="words_per_page" {if $formValues.WORDS_PER_PAGE}value="{$formValues.WORDS_PER_PAGE}"{else}value="275"{/if}>
                                <span class="help-block">The order form words per page</span>
                            </div>
                        </div>
                        <div class="divider"></div>
                    {/if}

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">New Order Status</label>
                        <div class="col-sm-9">
                            <div class="selectgroup selectgroup-inline">
                                <label class="selectgroup-item" id="new_paid_status">
                                    <input for="new_paid_status" type="radio" name="new_order_status" value="12" {if $formValues.NEW_ORDER_STATUS == "12"}checked=""{/if} class="selectgroup-input">
                                    <span class="selectgroup-button">New Paid</span>
                                </label>
                                <label class="selectgroup-item" id="new_available_status">
                                    <input for="new_available_status" type="radio" name="new_order_status" value="19" {if $formValues.NEW_ORDER_STATUS == "19"}checked=""{/if} class="selectgroup-input">
                                    <span class="selectgroup-button">Available</span>
                                </label>
                            </div>
                            <span class="help-block">The default order status of a new order</span>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Payment Request Dates</label>
                        <div class="col-sm-9">
                            <div class="selectgroup selectgroup-inline">
                                {foreach $payment_dates as $payment_date}
                                    <label class="selectgroup-item">
                                        <input type="checkbox" name="payment_dates[]" value="{$payment_date.day}" {if $payment_date.checked}checked=""{/if} class="selectgroup-input">
                                        <span class="selectgroup-button">{$payment_date.day}</span>
                                    </label>
                                {/foreach}
                            </div>
                            <span class="help-block">
                                Calendar dates that writers and editors can send payment requests
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- Orders & Payments -->

            <!-- Email -->
            <div class="tab-pane" id="email">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=email_settings">

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Mail Method
                        </label>
                        <div class="col-sm-9">
                            <div class="radio radio-primary"> 
                                <input type="radio" name="mail_method" value="1" id="mail_method_1" {if $formValues.MAIL_METHOD == '1'}checked="checked"{/if}> 
                                <label for="mail_method_1">Use PHP's mail() (recommended)</label> 
                            </div>
                            <div class="radio radio-primary"> 
                                <input type="radio" name="mail_method" value="2" id="mail_method_2" {if $formValues.MAIL_METHOD == '2'}checked="checked"{/if}> 
                                <label for="mail_method_2">Set my own SMTP parameters</label> 
                            </div>
                            <div class="radio radio-primary"> 
                                <input type="radio" name="mail_method" value="3" id="mail_method_3" {if $formValues.MAIL_METHOD == '3'}checked="checked"{/if}> 
                                <label for="mail_method_3">Never send emails</label> 
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            SMTP server
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_server" value="{$formValues.MAIL_SERVER}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            SMTP username
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_username" value="{$formValues.MAIL_USER}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            SMTP password
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_password" value="{$formValues.MAIL_PASSWD}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Port
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_port" value="{$formValues.MAIL_SMTP_PORT}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Encryption
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="smtp_encryption">
                                <option value="off" {if $formValues.MAIL_SMTP_ENCRYPTION == 'off'}selected="selected"{/if}>None</option>
                                <option value="ssl" {if $formValues.MAIL_SMTP_ENCRYPTION == 'ssl'}selected="selected"{/if}>SSL</option>
                                <option value="tls" {if $formValues.MAIL_SMTP_ENCRYPTION == 'tls'}selected="selected"{/if}>TLS</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>

                </form>
            </div>
            <!-- Email -->

            <!-- Writer Payments -->
            <div class="tab-pane" id="writer_payments">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=writer_payments">
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">CPP Type</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="writer_cpp_type" data-combo="writer_cpp_type">
                                <option value="percentage" {if $formValues.WRITER_CPP_TYPE == 'percentage'}selected=""{/if}>Percentage of the customer's CPP</option>
                                <option value="fixed" {if $formValues.WRITER_CPP_TYPE == 'fixed'}selected=""{/if}>Fixed amount</option>
                            </select>
                        </div>
                    </div>

                    <div id="writer_cpp_type">
                        <div class="switch-combo {if $formValues.WRITER_CPP_TYPE != 'fixed'}x-hidden{/if}" data-combo-value="fixed">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">
                                    {if $article_writing_enabled}Cost Per Word{else}Cost Per Page{/if}
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="writer_cost_per_page" value="{$formValues.WRITER_AMOUNT_CPP}">
                                    <span class="help-block">
                                        The amount the writer will earn per {if $article_writing_enabled}word{else}page{/if}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo {if $formValues.WRITER_CPP_TYPE != 'percentage'}x-hidden{/if}" data-combo-value="percentage">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">
                                    {if $article_writing_enabled}Cost Per Word{else}Cost Per Page{/if}
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="writer_percent_per_page" value="{$formValues.WRITER_PERCENTAGE_CPP}">
                                    <span class="help-block">
                                        The Percentage the writer will earn from the customer's CPP
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Writer Category</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_category_cost" value="{$formValues.WRITER_W_CATEGORY_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost charged for "Writer Category"
                            </span>
                        </div>
                    </div>
                    
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Complex Assignment</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="complex_assignment_cost" value="{$formValues.WRITER_COMPLEX_ASSIGNMENT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost charged for a complex assignment
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Copy of Sources</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="used_sources_cost" value="{$formValues.WRITER_USED_SOURCES_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Copy of Sources" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Progressive Delivery</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="p_delivery_cost" value="{$formValues.WRITER_PROGRESSIVE_DELIVERY_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Progressive Delivery" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Writer Samples</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_sample_cost" value="{$formValues.WRITER_PROVIDE_ME_SAMPLES_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Get Writer Samples" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Expert Proofreading</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="expert_proofreading_cost" value="{$formValues.WRITER_EXPERT_PROOFREADING_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Expert Proofreading" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">VIP Support</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="vip_support_cost" value="{$formValues.WRITER_VIP_SUPPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "VIP Support" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Plagiarism Report</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="plagiarism_report_cost" value="{$formValues.WRITER_PLAGIARISM_REPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Plagiarism Report" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Draft/Outline</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="draft_outline_cost" value="{$formValues.WRITER_DRAFT_OUTLINE_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Draft/Outline" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-8 offset-sm-4">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>

                </form>
            </div>
            <!-- Writer Payments -->

            <!-- Editor Payments -->
            <div class="tab-pane" id="editor_payments">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=editor_payments">
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">CPP Type</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="editor_cpp_type" data-combo="editor_cpp_type">
                                <option value="percentage" {if $formValues.EDITOR_CPP_TYPE == 'percentage'}selected=""{/if}>Percentage of the customer's CPP</option>
                                <option value="fixed" {if $formValues.EDITOR_CPP_TYPE == 'fixed'}selected=""{/if}>Fixed amount</option>
                            </select>
                        </div>
                    </div>

                    <div id="editor_cpp_type">
                        <div class="switch-combo {if $formValues.EDITOR_CPP_TYPE != 'fixed'}x-hidden{/if}" data-combo-value="fixed">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">
                                    {if $article_writing_enabled}Cost Per Word{else}Cost Per Page{/if}
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="editor_cost_per_page" value="{$formValues.EDITOR_AMOUNT_CPP}">
                                    <span class="help-block">
                                        The amount the editor will earn per {if $article_writing_enabled}word{else}page{/if}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo {if $formValues.EDITOR_CPP_TYPE != 'percentage'}x-hidden{/if}" data-combo-value="percentage">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">
                                    {if $article_writing_enabled}Cost Per Word{else}Cost Per Page{/if}
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="editor_percent_per_page" value="{$formValues.EDITOR_PERCENTAGE_CPP}">
                                    <span class="help-block">
                                        The Percentage the editor will earn from the customer's CPP
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Writer Category</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_category_cost" value="{$formValues.EDITOR_W_CATEGORY_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost charged for "Writer Category"
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Complex Assignment</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="complex_assignment_cost" value="{$formValues.EDITOR_COMPLEX_ASSIGNMENT_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost charged for a complex assignment
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>
                    
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Copy of Sources</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="used_sources_cost" value="{$formValues.EDITOR_USED_SOURCES_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Copy of Sources" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Progressive Delivery</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="p_delivery_cost" value="{$formValues.EDITOR_PROGRESSIVE_DELIVERY_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Progressive Delivery" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Editor Samples</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_sample_cost" value="{$formValues.EDITOR_PROVIDE_ME_SAMPLES_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Get Editor Samples" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Expert Proofreading</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="expert_proofreading_cost" value="{$formValues.EDITOR_EXPERT_PROOFREADING_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Expert Proofreading" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">VIP Support</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="vip_support_cost" value="{$formValues.EDITOR_VIP_SUPPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "VIP Support" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Plagiarism Report</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="plagiarism_report_cost" value="{$formValues.EDITOR_PLAGIARISM_REPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Plagiarism Report" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Draft/Outline</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="draft_outline_cost" value="{$formValues.EDITOR_DRAFT_OUTLINE_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Draft/Outline" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-8 offset-sm-4">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>

                </form>
            </div>
            <!-- Editor Payments -->

        </div>
        <!-- tabs content -->

    </div>
</div>
{/block}