<!doctype html>
<html lang="en-US">
  	<head>
		{block name='head'}
			{include file='_partials/head.tpl'}
		{/block}
	</head>

	<body class="{$body_classes|classnames} {if $theme_mode_night}night-mode{/if}">
        <div class="main-wrapper">

			{block name='header'}
				{include file='_partials/header.tpl'}
			{/block}

			<!-- page content -->
			<div class="container mt20">
				<div class="row">

					<div class="col-xs-12 col-sm-4 offset-sm-4">
						<div class="card card-login">
							
							<!-- signin -->
							<div class="js_panel {if $do == 'up'}x-hidden{/if}">
								<div class="card-header"> 
									<img class="card-img" src="/static/images/square1.jpg"> 
									<h4 class="card-title">Login</h4> 
								</div>
								<div class="card-body">
									{if $highlight}<div class="alert alert-warning" role="alert">{$highlight}</div>{/if}

									<form class="js_ajax-forms" data-url="/signin">
										<div class="form-group"> 
											<div class="input-group"> 
												<div class="input-group-prepend"> 
													<span class="input-group-text"><i class="far fa-user fa-fw"></i></span> 
												</div> 
												<input name="email" type="text" class="form-control" placeholder='Email' required>
											</div> 
										</div>

										<div class="form-group"> 
											<div class="input-group"> 
												<div class="input-group-prepend"> 
													<span class="input-group-text"><i class="fas fa-key fa-fw"></i></span> 
												</div> 
												<input name="password" type="password" class="form-control" placeholder='Password' required>
											</div> 
										</div>
										
										<div class="custom-control custom-checkbox mb10">
											<input type="checkbox" class="custom-control-input" name="remember" id="remember">
											<label for="remember" class="custom-control-label">Remember me</label>
											<a class="pull-right" href="{$base_uri}/forgot-password">Forgotten password?</a>
										</div>

										<!-- error -->
										<div class="alert alert-danger mt10 x-hidden" role="alert"></div>
										<!-- error -->

										<button type="submit" class="btn btn-block btn-info">Login</button>
									</form>

									{if $registration_enabled}
										<div class="mt20 text-center">
											Not registered? <a href="{$base_uri}/signup" class="js_toggle-panel text-link">Create an account</a>
										</div>
									{/if}
								</div>
							</div>
							<!-- signin -->

							{if $registration_enabled}
								<!-- signup -->
								<div class="js_panel {if $do != 'up'}x-hidden{/if}">
									<div class="card-header"> 
										<img class="card-img" src="/static/images/square1.jpg"> 
										<h4 class="card-title">Register</h4> 
									</div>
									<div class="card-body">
										<form class="js_ajax-forms" data-url="/signup">
											<div class="form-group"> 
												<div class="input-group"> 
													<div class="input-group-prepend"> 
														<span class="input-group-text"><i class="fas fa-user fa-fw"></i></span> 
													</div> 
													<input name="first_name" type="text" class="form-control" placeholder='First name' required>
												</div> 
											</div>

											<div class="form-group"> 
												<div class="input-group"> 
													<div class="input-group-prepend"> 
														<span class="input-group-text"><i class="fas fa-user fa-fw"></i></span> 
													</div> 
													<input name="last_name" type="text" class="form-control" placeholder='Last name' required>
												</div> 
											</div>
											<div class="form-group"> 
												<div class="input-group"> 
													<div class="input-group-prepend"> 
														<span class="input-group-text"><i class="fas fa-envelope fa-fw"></i></span> 
													</div> 
													<input name="email" type="email" class="form-control" placeholder='Email' required>
												</div> 
											</div>
											<div class="form-group"> 
												<div class="input-group"> 
													<div class="input-group-prepend"> 
														<span class="input-group-text"><i class="fas fa-key fa-fw"></i></span> 
													</div> 
													<input name="password" type="password" class="form-control" placeholder='Password' required>
												</div> 
											</div>
											<div class="js_hidden-section x-hidden">
												<div class="form-group form-row">
													<label for="gender">I am</label>
													<select name="gender" id="gender" class="form-control" required>
														<option value="-1">Select Gender:</option>
														<option value="male">Male</option>
														<option value="female">Female</option>
													</select>
												</div>
												
												<p class="text-secondary">
													By clicking Sign Up, you agree to our <a href="{$base_uri}/terms">Terms</a>
												</p>
											</div>

											<!-- error -->
											<div class="alert alert-danger mt10 x-hidden" role="alert"></div>
											<!-- error -->

											<button type="submit" class="btn btn-block btn-info">Sign Up</button>
											
										</form>
									
										<div class="mt20 text-center">Have an account? <a href="{$base_uri}/signin" class="js_toggle-panel text-link">Login Now</a></div>
									</div>
								</div>
								<!-- signup -->
							{/if}

						</div>
					</div>


				</div>
			</div>
			<!-- page content -->
        </div>
	</body>

    {include file="_partials/_js_files.tpl"}
    
</html>
