{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-user mr10"></i> <strong>Edit Profile</strong> 
        </div>

        <div class="card-body">
            <div class="row"> 
                <div class="col-xs-offset-3 col-xs-6 col-sm-offset-0 col-sm-3 mb10">
                    <!-- profile-avatar -->
                    <div class="profile-avatar-wrapper">
                        <img src="{$user.user_picture}" alt="{$user.first_name} {$user.last_name}">
                        <div class="profile-avatar-change">
                            <i class="fa fa-camera js_x-uploader" data-handle="picture-user"></i>
                        </div>
                        <div class="profile-avatar-delete {if $user.user_picture_default}x-hidden{/if}">
                            <i class="fa fa-trash js_delete-picture" data-handle="picture-user" title='Delete Picture'></i>
                        </div>
                        <div class="profile-avatar-change-loader">
                            <div class="loader loader_medium"></div>
                        </div>
                    </div>
                    <!-- profile-avatar -->
                </div>
                <div class="col-xs-12 col-sm-6 mb10">
                    <ul class="list-group">
                        <li class="list-group-item"> <span class="badge badge-primary">{$user.id}</span> User ID
                        </li>
                        <li class="list-group-item"> <span class="badge badge-primary">{$user.writer_category_title|capitalize}</span> Category
                        </li>
                        <li class="list-group-item"> <span class="badge badge-primary">{$user.academic_level_title}</span> Academic level
                        </li>
                        <li class="list-group-item"> <span class="badge badge-primary">{$user.employee_status_title}</span> Status</li>
                    </ul>
                </div>
            </div>

            <ul class="nav nav-tabs mb20"> 
                <li class="nav-item"> 
                    <a class="nav-link active" href="#basic" data-toggle="tab"> 
                        <i class="fa fa-user fa-fw mr5"></i><strong class="pr5">Basic</strong> 
                    </a> 
                </li>
                <li class="nav-item"> 
                    <a class="nav-link" href="#email" data-toggle="tab"> 
                        <i class="fa fa-envelope fa-fw mr5"></i><strong class="pr5">Email</strong> 
                    </a> 
                </li>
                <li class="nav-item"> 
                    <a class="nav-link" href="#password" data-toggle="tab"> 
                        <i class="fa fa-key fa-fw mr5"></i><strong class="pr5">Password</strong> 
                    </a> 
                </li>
                <li class="nav-item"> 
                    <a class="nav-link" href="#sessions" data-toggle="tab"> 
                        <i class="fa fa-user-shield fa-fw mr5"></i><strong class="pr5">Login Sessions</strong> 
                    </a> 
                </li> 
            </ul>

            <div class="tab-content">
                <div class="tab-pane active" id="basic">
                    <div class="row">
                        <div class="col-md-7">
                            <form class="js_ajax-forms" method="POST" data-url="/user/settings?edit=basic" autocomplete="off">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">First name</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="first_name" value="{$user.first_name}">
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Middle name</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="middle_name" value="{$user.middle_name}">
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Last name</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="last_name" value="{$user.last_name}">
                                    </div>
                                </div>

                                {if $user.is_editor || $user.is_writer}
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Status</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="status">
                                                <option value="2" {if $user.employee_status == "2"}selected="selected"{/if}>Looking for orders</option>
                                                <option value="4" {if $user.employee_status == "4"}selected="selected"{/if}>Cannot work for now</option>
                                                <option value="5" {if $user.employee_status == "5"}selected="selected"{/if}>Do not use your service</option>
                                            </select>
                                        </div>
                                    </div>
                                {/if}

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Gender</label>
                                    <div class="col-sm-9">
                                        <div class="radio radio-primary"> 
                                            <input type="radio" name="gender" value="male" id="gender_male" {if $user.gender == 'male'}checked="checked"{/if}> 
                                            <label for="gender_male">Male</label> 
                                        </div>
                                        <div class="radio radio-primary"> 
                                            <input type="radio" name="gender" value="female" id="gender_female" {if $user.gender == 'female'}checked="checked"{/if}> 
                                            <label for="gender_female">Female</label> 
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Email Notifications</label>
                                    <div class="col-sm-9">
                                        <label class="switch" for="email_notifications">
                                            <input type="checkbox" name="email_notifications" id="email_notifications" {if $user.email_notifications == '1'}checked="checked"{/if}>
                                            <span class="slider round"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Phone</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="phone" {if $user.phone}value="{$user.phone}"{/if}>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">
                                        Default Timezone
                                    </label>
                                    <div class="col-md-4">
                                        <select id="timezone-region" class="form-control" data-combo="timezone-combo">
                                            {foreach from=$regions item=region key=key name=name}
                                                <option value="{$key}" {if $user.default_region == $key } selected="" {/if} >{$key}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                    <div id="timezone-combo" class="col-md-5">
                                        {foreach from=$regions item=region key=key name=name}
                                            <select id="timezone-combo-{$key}" class="form-control {if $user.default_region != $key } x-hidden {/if} switch-combo" data-combo-value="{$key}">
                                                {foreach from=$region item=item key=key name=name}
                                                    <option value="{$key}" {if $user.timezone == $key } selected="" {/if} >{$item}</option>
                                                {/foreach}
                                            </select>
                                        {/foreach}
                                    </div>
                                </div>
                                <input type="hidden" id="timezone" name="timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">


                                <div class="form-group form-row">
                                    <div class="col-sm-9 offset-sm-3">
                                        <!-- success -->
                                        <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                        <!-- success -->

                                        <!-- error -->
                                        <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                        <!-- error -->

                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="email">
                    <div class="row">
                        <div class="col-md-7">
                            <form class="js_ajax-forms" data-url="/user/settings?edit=email" autocomplete="off">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">
                                        Email Address
                                    </label>
                                    <div class="col-sm-9">
                                        <input type="email" class="form-control" name="email" value="{$user.email}"> 
                                    </div>
                                </div>
                                <div class="form-group form-row">
                                    <div class="col-sm-9 offset-sm-3">
                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                    </div>
                                </div>
                                <div class="alert alert-success mb0 mt10 x-hidden" role="alert"></div>
                                <div class="alert alert-danger mb0 mt10 x-hidden" role="alert"></div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="password">
                    <div class="row">
                        <div class="col-md-7">
                            <form class="js_ajax-forms" data-url="/user/settings?edit=password" autocomplete="off">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Current</label>
                                    <div class="col-sm-9">
                                        <input type="password" class="form-control" name="current" autocomplete="off"> 
                                    </div>
                                </div>
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">New</label>
                                    <div class="col-sm-9">
                                        <input type="password" class="form-control" name="new" autocomplete="off"> 
                                    </div>
                                </div>
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Re-type New</label>
                                    <div class="col-sm-9">
                                        <input type="password" class="form-control" name="confirm" autocomplete="off"> 
                                    </div>
                                </div>
                                <div class="form-group form-row">
                                    <div class="col-sm-9 offset-sm-3">
                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                    </div>
                                </div>
                                <div class="alert alert-success mb0 mt10 x-hidden" role="alert"></div>
                                <div class="alert alert-danger mb0 mt10 x-hidden" role="alert"></div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="sessions">
                    <div class="clearfix">
                        <div class="pull-right mb10">
                            <button type="button" class="btn btn-danger js_session-delete-all">
                                <i class="fa fa-lock fa-fw"></i> Logout All Sessions
                            </button>
                        </div>
                    </div>

                    {if count($sessions)}
                        <div class="table-responsive">
                            <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                                <thead>
                                    <tr>
                                        <th>Browser</th>
                                        <th>OS</th>
                                        <th>Date</th>
                                        <th>IP</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {foreach $sessions as $session}
                                        <tr>
                                            <td>{$session.user_browser}</td>
                                            <td>{$session.user_os}</td>
                                            <td>
                                                <span class="js_moment" data-time="{$session.date_add}">{$session.date_add}</div>
                                            </td>
                                            <td>{$session.user_ip}</td>
                                            <td>
                                                <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="session" data-id="{$session.session_id}">
                                                    <i class="fa fa-trash-alt"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    {/foreach}
                                </tbody>
                            </table>
        
                            {$pager nofilter}
                        </div>
                    {else}
                        <div class="text-center x-muted"> 
                            <img class="mb20" width="15%" src="/static/images/no_results.png">
                            <p class="mb10"><strong>No sessions to show</strong></p>
                        </div>
                    {/if}               
                </div>

        </div>

    </div>
{/block}