{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}

    {if $sub_view == "instructions" || $sub_view == "files" || $sub_view == "messages" || $sub_view == "history"}

        <div class="card">
            <div class="card-header with-icon with-nav">
                
                <div class="mb20">
                    <div class="pull-right flip">
                        {* Writer *}
                        {if $user.is_writer}

                            {* Order published || Inquiry published || Writer Accepted || Inquiry Writer Accepted*}
                            {if $order.status == "19" || 
                                $order.status == "16" || 
                                $order.status == "7"  ||
                                $order.status == "17" 
                            }

                                {if $can_take}
                                    <button data-toggle="tooltip" data-title="Take the order if you are ready to execute this order for {$order.writerPayFormatted}" data-oid="{$order.id}" class="btn btn-success js_take-order"> 
                                        <i class="fa fa-check mr10"></i> Take Order
                                    </button>
                                {elseif $has_bidded}
                                    <button data-toggle="tooltip" data-bid="{$bid.bid_id}" data-title="The bid you have placed equals to - ${$bid.amount} on {$bid.date_add}" data-oid="{$order.id}" class="btn btn-warning js_remove-bid">
                                    <i class="fa fa-times mr10"></i> Remove Bid
                                </button>
                                {else}
                                    <button data-toggle="tooltip" data-title="Place your bid if you are ready to execute this order for {$order.writerPayFormatted}" data-oid="{$order.id}" class="btn btn-success js_place-bid">
                                        <i class="fa fa-check mr10"></i> Place Bid
                                    </button>
                                {/if}

                            {/if}

                            {* Writer Assigned *}
                            {if $order.status == "6"}

                                {if !$order.writerConfirmed}
                                    <button data-toggle="tooltip" data-title="I will work on the order" class="btn btn-success js_confirm-order" data-action="accept" data-oid="{$order.id}">
                                        <i class="fa fa-check fa-fw mr5"></i> Accept
                                    </button>

                                    <button data-toggle="tooltip" data-title="I cannot work on the order at the moment" class="btn btn-danger js_confirm-order" data-action="decline" data-oid="{$order.id}">
                                        <i class="fa fa-times fa-fw mr5"></i> Decline
                                    </button>
                                {else}
                                    {if $order.canSubmitOrder}
                                        {if !$editor_account_enabled}
                                            <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                                <i class="fa fa-check fa-fw mr5"></i> Deliver Order
                                            </button>
                                        {else}
                                            <button data-toggle="tooltip" data-title="I have completed the order" class="btn btn-success js_complete-order" data-oid="{$order.id}">
                                                <i class="fa fa-check fa-fw mr5"></i> Mark as Complete
                                            </button>
                                        {/if}
                                    {/if}
                                {/if}

                            {/if}

                            {* Revision *}
                            {if $order.status == "14" && $order.canSubmitOrder}
                                {if !$editor_account_enabled}
                                    <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                        <i class="fa fa-check fa-fw mr5"></i> Deliver Order
                                    </button>
                                {else}
                                    <button data-toggle="tooltip" data-title="I have completed the order" class="btn btn-success js_complete-order" data-oid="{$order.id}">
                                        <i class="fa fa-check fa-fw mr5"></i> Mark as Complete
                                    </button>
                                {/if}
                            {/if}
                            
                        {/if}

                        {* Editor *}
                        {if $user.is_editor}
                            {* Done *}
                            {if $order.status == "8" && !$order.editorAssigned}
                                <button data-toggle="tooltip" data-title="Take and work on this order" class="btn btn-success js_take-order" data-oid="{$order.id}">
                                    <i class="fa fa-check fa-fw mr5"></i> Take Order
                                </button>
                            {/if}

                            {* In Progress *}
                            {if $order.status == "8" && $order.editorAssigned}
                                <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#revision" data-title="Send order to Revision" class="btn btn-danger" data-oid="{$order.id}">
                                    Revision
                                </button>
                                
                                <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                    <i class="fa fa-check fa-fw mr5"></i> Deliver Order
                                </button>
                            {/if}
                        {/if}

                        {* Admin *}
                        {if $user.is_admin || $user.is_sub_admin}

                            {* Unpaid *}
                            {if $order.status == "0"}
                                <button data-toggle="tooltip" data-title="Make this order available to writers" data-oid="{$order.id}" class="btn btn-primary js_mark-as-paid">Mark as Paid</button>
                            {/if}

                            {if $order.status == "6" || $order.status == "7" || $order.status == "8"}
                                <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                    Deliver Order
                                </button>
                            {/if}

                            {if $order.status == "8"}
                                <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#revision" data-title="Send order to Revision" class="btn btn-danger" data-oid="{$order.id}">
                                    Revision
                                </button> 
                            {/if}

                            {if $sub_view != "assign"}
                                {if $order.paid && $order.status != "10" && $order.status != "1"}
                                    <a href="{$base_uri}/order/{$order.id}/assign" class="btn btn-primary">
                                        <i class="fa fa-users fa-fw mr5"></i> Assign Order
                                    </a>
                                {/if}

                                <a data-toggle="tooltip" data-title="Edit Order" href="{$base_uri}/order/{$order.id}/edit" class="btn btn-primary">
                                    <i class="fa fa-edit fa-fw mr5"></i> Edit
                                </a>
                            {/if}

                        {/if}
                        
                        {hook h='displayOrderActions' order_id=$order.id}
                    </div>                            

                    <i class="fa fa-shopping-basket mr10"></i>
                    <strong>Orders</strong>
                    &rsaquo; <strong>#{$order.id}</strong>
                    {if $sub_view == "instructions" || $sub_view == "files" || $sub_view == "messages" || $sub_view == "history"}&rsaquo; <strong>{$order.statusTitle}</strong>{/if}
                </div>

                <!-- tabs nav -->
                <ul class="nav nav-tabs admin">
                    <li class="nav-item"> 
                        <a class="nav-link {if $sub_view == "instructions"} active {/if}" href="#instructions" data-toggle="tab">
                            <strong class="pr5">Instructions</strong>
                        </a>
                    </li>
                    {if $order.progressiveDeliveryHidden}
                    <li class="nav-item">
                        <a class="nav-link {if $sub_view == "#progressive-delivery"} active {/if}" href="#progressive-delivery" data-toggle="tab">
                            <strong class="pr5">Progressive Delivery</strong>
                        </a>
                    </li>
                    {/if}
                    <li class="nav-item">
                        <a class="nav-link {if $sub_view == "files"} active {/if}" href="#files" data-toggle="tab">
                            <strong class="pr5">All Files {if $order.allFilesCount} ({$order.allFilesCount}) {/if}</strong>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $sub_view == "messages"} active {/if}" href="#messages" data-toggle="tab">
                            <strong class="pr5">Messages {if $order.allMessagesCount} ({$order.allMessagesCount}) {/if}</strong>
                        </a>
                    </li>

                    {if count($orderHistory)}
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "history"} active {/if}" href="#order-history" data-toggle="tab">
                                <strong class="pr5">Order History</strong>
                            </a>
                        </li>
                    {/if}
                </ul>
                <!-- tabs nav -->

            </div>

            {if $sub_view == "instructions" || $sub_view == "files" || $sub_view == "messages" || $sub_view == "history"}

                <div class="card-body">

                    <!-- tabs content -->
                    <div class="tab-content">

                        <!-- instructions tab -->
                        <div class="tab-pane {if $sub_view == "instructions"}active{/if}" id="instructions">
                           
                            <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                <tbody>
                                    <tr class="first">
                                        <th>Type of service:</th>
                                        <td>{$order.serviceTypeTitle}</td>
                                    </tr>
                                    {if ($user.is_admin || $user.is_sub_admin) && $order.trackingId}
                                        <tr>
                                            <th>Tracking ID:</th>
                                            <td>{$order.trackingId}</td>
                                        </tr>
                                    {/if}
                                    {if ($user.is_admin || $user.is_sub_admin) && count($order.services)}
                                        <tr>
                                            <th>Additional services:</th>
                                            <td>
                                                {foreach $order.services as $service}
                                                    <output class="fw-bold">{$service.title} {if $show_client_cost} - {$service.description} {/if}</output>
                                                {/foreach}
                                            </div>
                                        </tr>
                                    {/if}

                                    {if ($user.is_writer || $user.is_editor) && count($order.services)}
                                        <tr>
                                            <th>Additional services:</th>
                                            <td>
                                                {foreach $order.services as $service}
                                                    <output class="fw-bold">{$service.title}</output>
                                                {/foreach}
                                            </div>
                                        </tr>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <tr>
                                            <th>{if $order.ukForm}Desirable grade{else}Writer category{/if}:</th>
                                            <td>{$order.writerCategoryTitle}</td>
                                        </tr>
                                    {/if}
                                    <tr>
                                        <th>{if $article_writing_enabled}Project{else}Work type{/if}:</th>
                                        <td>{$order.paperTypeTitle} {if $order.paperType == "64"}: {$order.paperTypeOption} {/if}</td>
                                    </tr>
                                    {if !$article_writing_enabled}
                                        <tr>
                                            <th>Format:</th>
                                            <td>{$order.paperFormatTitle} {if $order.paperFormat == "4"}: {$order.paperFormatTypeOption} {/if}</td>
                                        </tr>
                                    {/if}

                                    {if $article_writing_enabled}
                                        <tr>
                                            <th>Words:</th>
                                            <td>{pluralize('word', $order.pages)}, {$order.spacing|capitalize} spaced</td>
                                        </tr>
                                    {else}
                                        <tr>
                                            <th>Pages:</th>
                                            <td>{$order.pages} pages ({if $order.spacing == 'single'} {$order.pages*550} {else} {$order.pages*275} {/if} words, {$order.spacing|capitalize} spaced</td>
                                        </tr>
                                    {/if}

                                    {if !$article_writing_enabled}
                                        {if $order.slides}
                                            <tr>
                                                <th>Slides:</th>
                                                <td>{$order.slides}</td>
                                            </tr>
                                        {/if}
                                        {if $order.charts}
                                            <tr>
                                                <th>Charts:</th>
                                                <td>{$order.charts}</td>
                                            </tr>
                                        {/if}
                                    {/if}

                                    <tr>
                                        <th>Deadline:</th>
                                        <td>
                                            <span class="js_moment" data-time="{$order.deadline}">{$order.deadline}</span> ({$order.timeLeftHtml nofilter})
                                            {if $user.is_admin || $user.is_sub_admin}
                                                <span data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"customer"{literal}}{/literal}' class="btn btn-secondary btn-xs pull-right"><i class="fa fa-edit"></i> Change</span>
                                            {/if}
                                        </td>
                                    </tr>
                                    
                                    {if $user.is_admin || $user.is_sub_admin}
                                        {if $order.paid}
                                            <tr>
                                                <th>Writer deadline:</th>
                                                <td>
                                                    <span class="js_moment" data-time="{$order.writerDeadline}">{$order.writerDeadline}</span> ({$order.writerTimeLeftHtml nofilter})
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <span data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"writer"{literal}}{/literal}' class="btn btn-secondary btn-xs pull-right"><i class="fa fa-edit"></i> Change</span>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/if}
                                        <tr>
                                            <th>Created At:</th>
                                            <td>
                                                <span class="js_moment" data-time="{$order.createdAt}">{$order.createdAt}</span>
                                            </td>
                                        </tr>
                                        {if $order.status == "11" || $order.status == "10"}
                                            <tr>
                                                <th>Delivered At:</th>
                                                <td>
                                                    <span class="js_moment" data-time="{$order.finishedAt}">{$order.finishedAt}</span>
                                                </td>
                                            </tr>
                                        {/if}
                                        {if $order.status == "10"}
                                            <tr>
                                                <th>Approved At:</th>
                                                <td>
                                                    <span class="js_moment" data-time="{$order.approvedAt}">{$order.approvedAt}</span>
                                                </td>
                                            </tr>
                                        {/if}
                                        {if $order.status == "9"}
                                            <tr>
                                                <th>Cancelled At:</th>
                                                <td>
                                                    <span class="js_moment" data-time="{$order.cancelledDate}">{$order.cancelledDate}</span>
                                                </td>
                                            </tr>
                                        {/if}
                                    {/if}
                                </tbody>
                            </table>
                            <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                <tbody>
                                    {if !$article_writing_enabled}
                                        <tr class="first">
                                            <th>Academic level:</th>
                                            <td>{$order.academicLevelTitle}</td>
                                        </tr>
                                    {/if}
                                    <tr>
                                        <th>{if $article_writing_enabled}Category{else}Subject or discipline{/if}:</th>
                                        <td>{$order.topcat} {if $order.topcatId == "52"}: {$order.topcatOption} {/if}</td>
                                    </tr>
                                    <tr>
                                        <th>Title:</th>
                                        <td>{$order.title}</td>
                                    </tr>
                                    {if !$article_writing_enabled}
                                        <tr>
                                            <th>Number of sources:</th>
                                            <td>{$order.sources}</td>
                                        </tr>
                                    {/if}
                                </tbody>
                            </table>
                            <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                <tbody>
                                    <tr class="first">
                                        <th>Paper instructions:</th>
                                        <td>
                                            <div class="OrderInstructions">
                                                {$order.paperDetails nofilter}
                                            </div>
                                        </td>
                                    </tr>

                                    {if $user.is_admin || $user.is_sub_admin}
                                        {if $order.requestedWriter.id}
                                            <tr>
                                                <th>Requested Writer:</th>
                                                <td>
                                                    {if $show_writer_info}
                                                        <a href="{$base_uri}/employees/edit/{$order.requestedWriter.id}" target="_blank"> {$order.requestedWriter.first_name} {$order.requestedWriter.last_name} ({$order.requestedWriter.id}) </a>
                                                    {else}
                                                        <strong class="text-primary">{$order.requestedWriter.id} - {$order.requestedWriter.first_name}</strong>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/if}
                                    {/if}

                                    {if $order.comments}
                                        <tr>
                                            <th>Additional comments from Customer:</th>
                                            <td>{$order.comments}</td>
                                        </tr>
                                    {/if}

                                    {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
                                        <tr>
                                            <th>Price:</th>
                                            <td>
                                                {if $order.noDiscountPrice > $order.price}
                                                    <span style="text-decoration:line-through;" class="text-dark mr10 text-sm">{$order.noDiscountPriceFormatted}</span>
                                                {/if}
                                                <span class="text-success text-lg">{$order.priceFormatted}</span>
                                                {if $user.is_admin || $user.is_sub_admin}
                                                    <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_customer_pay":"1","customer_pay":{$order.price}{literal}}{/literal}' class="btn btn-secondary btn-xs pull-right"><i class="fa fa-edit"></i> Edit</span>
                                                {/if}

                                                {if $user.is_admin || $user.is_sub_admin}
                                                    <span data-toggle="modal" data-url="#modal-additional-payment" data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' class="btn btn-secondary btn-xs pull-right mr10">
                                                        <i class="fa fa-credit-card mr1"></i> Additional Payment
                                                    </span>
                                                {/if}
                                            </td>
                                        </tr>

                                        {if $order.additionalPayments}
                                            <tr>
                                                <th>Additional payments:</th>
                                                <td>
                                                    {foreach $order.additionalPayments as $additionalPayment}
                                                        <div>{$additionalPayment.title} was paid at <span class="js_moment" data-time="{$additionalPayment.paidAt}"></span></div>
                                                        {if count($order.additionalPayments) > 1}<hr  class="mb10 mt10">{/if}
                                                    {/foreach}
                                                </td>
                                            </tr>
                                        {/if}

                                        {if $order.paymentMethod}
                                            <tr>
                                                <th>Payment Method:</th>
                                                <td class="text-capitalize">{$order.paymentMethod}</td>
                                            </tr>
                                        {/if}

                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin || $user.is_writer}
                                        <tr>
                                            <th>{if $user.is_admin || $user.is_sub_admin}Writer {/if}Fee:</th>
                                            <td>
                                                <span class="text-success text-lg">{$order.writerPayFormatted}</span> 
                                                {if $user.is_admin || $user.is_sub_admin}
                                                    <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_writer_pay":"1","writer_pay":{$order.writerPay}{literal}}{/literal}' class="btn btn-secondary btn-xs pull-right"><i class="fa fa-edit"></i> Edit</span>
                                                {/if}
                                            </td>
                                        </tr>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin || $user.is_editor}
                                        <tr>
                                            <th>{if $user.is_admin || $user.is_sub_admin}Editor {/if}Fee:</th>
                                            <td>
                                                <span class="text-success text-lg">{$order.editorPayFormatted}</span>
                                                {if $user.is_admin || $user.is_sub_admin}
                                                    <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_editor_pay":"1","editor_pay":{$order.editorPay}{literal}}{/literal}' class="btn btn-secondary btn-xs pull-right"><i class="fa fa-edit"></i> Edit</span>
                                                {/if}
                                            </td>
                                        </tr>
                                    {/if}

                                    {hook h='displayOrderAdditionalInfo' order_id=$order.id|intval}
                                </tbody>
                            </table>
 
                            {if $user.is_admin || $user.is_sub_admin}
                                <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                    <tbody>
                                        <tr class="first">
                                            <th>Status:</th>
                                            <td>
                                                <strong>{$order.statusTitle}</strong>
                                                <span data-toggle="modal" data-url="#editStatusModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"status_id":{$order.status}{literal}}{/literal}' class="btn btn-secondary btn-xs pull-right"><i class="fa fa-edit"></i> Change Status</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Customer:</th>
                                            <td>
                                                {if $user.is_sub_admin}
                                                    <strong>{$order.customer.id}</strong>
                                                {else}
                                                    <a href="{$base_uri}/customers/edit/{$order.customer.id}" target="_blank"> {$order.customer.name} ({$order.customer.id}) </a>
                                                {/if}
                                            </td>
                                        </tr>

                                        {if $order.writer.id}
                                            <tr>
                                                <th>Writer:</th>
                                                <td>
                                                    {if $show_writer_info}
                                                        <a href="{$base_uri}/employees/edit/{$order.writer.id}" target="_blank"> {$order.writer.first_name} {$order.writer.last_name} ({$order.writer.id}) </a>
                                                    {else}
                                                        <strong class="text-primary">{$order.writer.id} - {$order.writer.first_name}</strong>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/if}

                                        {if $order.editor.id}
                                            <tr>
                                                <th>Editor:</th>
                                                <td>
                                                    <a href="{$base_uri}/employees/edit/{$order.editor.id}" target="_blank"> {$order.editor.first_name} {$order.editor.last_name} ({$order.editor.id}) </a>
                                                </td>
                                            </tr>
                                        {/if}

                                        <tr>
                                            <th>Site:</th>
                                            <td>
                                                {if $user.is_admin}
                                                    <a href="{$base_uri}/my-sites/{$order.site.id}/edit" target="_blank"> {$order.site.name} </a>
                                                {elseif $user.is_sub_admin}
                                                    <strong class="text-primary">{$order.site.name}</strong>
                                                {/if}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            {/if}
                        </div>
                        <!-- instructions tab -->

                        {if $order.progressiveDeliveryHidden}
                        <!-- progressive-delivery tab -->
                        <div class="tab-pane" id="progressive-delivery">

                            {if $order.hasPDSchedule}

                                <div class="ProgressiveDeliverySchedule">
                                    <ul class="ProgressiveDeliverySchedule__parts">
                                        {foreach $order.pdSchedule as $schedule}
                                            <li class="ProgressiveDeliverySchedule__part">
                                                <strong class="ProgressiveDeliverySchedule__part__title">Part 1</strong>
                                                <span class="ProgressiveDeliverySchedule__part__deadline">
                                                    <strong class="ProgressiveDeliverySchedule__part__deadline__calendar">21</strong>
                                                    <span>Jun 12:48</span>
                                                </span>
                                                <span class="ProgressiveDeliverySchedule__part__counts">
                                                    <strong>{$schedule.pages}</strong> page <strong>{$schedule.slides}</strong> slides <strong>{$schedule.pages}</strong> chart
                                                </span>
                                            </li>
                                        {/foreach}
                                    </ul>
                                    <div class="ProgressiveDeliverySchedule__actions">
                                        <button class="btn btn-primary" type="button">Edit</button>
                                    </div>
                                </div>

                            {else} 

                                <div class="text-center x-muted mt20 mb20"> 
                                    <i class="fa fa-calendar fa-4x"></i>
                                    <p class="mt20">
                                        <strong>This is a progressive delivey order. Create a delivery schedule.</strong>
                                    </p>
                                    <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#modal-progressive-delivery" type="button" class="btn btn-xs btn-primary">
                                        <i class="fa fa-plus"></i> Add Delivery Schedule
                                    </button>
                                </div>

                            {/if}

                        </div>
                        <!-- progressive-delivery tab -->
                        {/if}

                        <!-- files tab -->
                        <div class="tab-pane {if $sub_view == "files"}active{/if}" id="files">
                               
                            <div class="OrderDetailsFiles">
                                <div class="OrderDetailsFiles__split OrderDetailsFiles__split--from-service pl0">
                                    <div class="OrderDetailsFiles__split__header">
                                        <strong class="OrderDetailsFiles__split__title bold">Files uploaded by Writer </strong>
                                        <span class="OrderDetailsFiles__split__count">{count($order.writerFiles)} files</span>
                                    </div>
                                    <div class="OrderDetailsFiles__split__body">
                                        {if count($order.writerFiles) > 0}
                                            {foreach $order.writerFiles as $file}
                                                {include file="dashboard/order/_order.file.tpl"}
                                            {/foreach}
                                        {else}
                                            <div class="OrderDetailsFiles__no-from-customer-message">There are no files uploaded writer</div>
                                        {/if}
                                    </div>
                                     
                                    {if $user.is_writer}
                                        {* Writer | Writer Assigned *}
                                        {if $order.status == "11" || $order.status == "6" && $order.writerConfirmed}
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">Upload Files</button>
                                        {/if}

                                        {* Writer | Revision *}
                                        {if $order.status == "14" && $order.writerConfirmed}
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">Upload Files</button>
                                        {/if}
                                    {/if}

                                    {if $user.is_editor}
                                        {* Editor | Done *}
                                        {if $order.editorAssigned == '1' && $order.editor.id == $user.id && $order.status == "8"}
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">Upload Files</button>
                                        {/if}
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">
                                            <i class="fa fa-upload"></i> Upload Files
                                        </button>
                                    {/if}

                                    {hook h='displayOrderWriterFilesActions' order_id=$order.id}
                                </div>

                                <div class="OrderDetailsFiles__split OrderDetailsFiles__split--from-customer pr0">
                                    <div class="OrderDetailsFiles__split__header">
                                        <strong class="OrderDetailsFiles__split__title bold">Customer uploads</strong>
                                        <div class="OrderDetailsFiles__split__count">{count($order.customerFiles)} files</div>
                                    </div>
                                    <div class="OrderDetailsFiles__split__body">
                                        {if count($order.customerFiles) > 0}
                                            {foreach $order.customerFiles as $file}
                                                {include file="dashboard/order/_order.file.tpl"}
                                            {/foreach}
                                        {else}
                                            <div class="OrderDetailsFiles__no-from-customer-message">There are no files uploaded by customer</div>
                                        {/if}
                                    </div>
                                    
                                    {if count($order.customerFiles) > 0 && (!$cloud_storage && !$ifs_enabled)}
                                        <a class="btn btn-primary" href="{$base_uri}/api/orders/{$order.id}/download_all_attachments">Download all attachments</a>
                                    {/if}

                                    {hook h='displayOrderCustomerFilesActions' order_id=$order.id}
                                </div>
                            </div>
                        </div>
                        <!-- files tab -->

                        <!-- messages tab -->
                        <div class="tab-pane {if $sub_view == "messages"}active{/if}" id="messages">
                            {if count($order.messages)}
                                <div class="clearfix">
                                    <div class="pull-right">
                                        <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#newMessage" class="btn btn-primary">New Message</button>
                                    </div>
                                </div>
                            {/if}

                            <div class="OrderMessages__content mt20">
                                {if count($order.messages)}
                                    {foreach $order.messages as $message}
                                        <div class="message">
                                            <div class="message--container js_order-message {if !$message.is_sender && !$message.is_viewed}new{/if}" data-id="{$message.id}" data-read="{$message.is_viewed}">
                                                <button class="message--toggle" data-toggle="collapse" href="#message-{$message.id}" role="button" aria-expanded="false" aria-controls="message-{$message.id}">
                                                    <div class="message--icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19" viewBox="0 0 20 19"><path d="M4,7.863l8,4.907,8-4.907h0L12,2.956,4,7.863H4m18,0v9.814a1.982,1.982,0,0,1-2,1.963H4a1.982,1.982,0,0,1-2-1.963V7.863a1.947,1.947,0,0,1,.97-1.678L12,.64l9.03,5.545A1.947,1.947,0,0,1,22,7.863Z" transform="translate(-2 -0.64)" fill="#9e9e9e"></path></svg>
                                                    </div>
                                                    <div class="message--from-to">
                                                        <div class="message--sender">{$message.from_department.name|ucfirst}</div>
                                                        <div class="message--to">{$message.to_department.name|ucfirst}</div>
                                                    </div>
                                                    
                                                    <div class="message--subject">
                                                        <span class="message--subject__text_collapse">{$message.subject}</span>
                                                    </div>
                                                    <div class="message--date">
                                                        {if $message.is_viewed && $message.is_sender}
                                                            <span data-toggle="tooltip" data-placement="top" data-title="{$message.read_at}">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16.749" height="11.42" viewBox="0 0 16.749 11.42"><path d="M9.375,7.926a2.284,2.284,0,1,0,2.284,2.284A2.284,2.284,0,0,0,9.375,7.926m0,6.091a3.807,3.807,0,1,1,3.807-3.807,3.807,3.807,0,0,1-3.807,3.807m0-9.517A9,9,0,0,0,1,10.21a9,9,0,0,0,16.749,0A9,9,0,0,0,9.375,4.5Z" transform="translate(-1 -4.5)" fill="#9e9e9e"></path></svg>
                                                            </span>
                                                        {/if}
                                                        <span class="js_moment" data-time="{$message.created_at}">{$message.created_at}</span>
                                                    </div>
                                                    <div class="message--arrow">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="7.42" viewBox="0 0 12 7.42"><path d="M7.41,8.58,12,13.17l4.59-4.59L18,10l-6,6L6,10Z" transform="translate(-6 -8.58)" fill="#9e9e9e"></path></svg>
                                                    </div>
                                                </button>
                                                <div class="message--collapse collapse" id="message-{$message.id}">
                                                    <div class="message--text">{$message.body nofilter}</div>

                                                    {if !$message.is_sender}
                                                        <form data-url="/messages/{$message.id}/reply" class="ReplyMessageForm js_ajax-forms" method="POST">
                                                            <textarea name="reply" class="form-control mb10 js_autosize" placeholder="Type your reply..." tabindex="0"></textarea>
                                                            <!-- success -->
                                                            <div class="alert alert-success mt10 mb10 x-hidden" role="alert"></div>
                                                            <!-- success -->

                                                            <!-- error -->
                                                            <div class="alert alert-danger mt10 mb10 x-hidden" role="alert"></div>
                                                            <!-- error -->
                                                            <div class="ReplyMessageForm__buttons">
                                                                <button class="btn btn-primary" type="submit">Reply</button>
                                                                {if $user.is_admin || $user.is_sub_admin}
                                                                    <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">Delete</a>
                                                                {/if}
                                                            </div>
                                                        </form>
                                                    {else}
                                                        <div class="message--buttons">
                                                            {if $user.is_admin || $user.is_sub_admin}
                                                                <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">Delete</a>
                                                            {/if}
                                                        </div>
                                                    {/if}
                                                </div>
                                            </div>
                                        </div>
                                    {/foreach}
                                {else}
                                    <div class="text-center x-muted"> 
                                        <i class="fa fa-envelope fa-4x"></i>
                                        <p class="mb20"><strong>No messages to show</strong></p>
                                        <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#newMessage" class="btn btn-primary">New Message</button>
                                    </div>
                                {/if}
                            </div>
                        </div>
                        <!-- messages tab -->

                        <!-- order-history tab -->
                        {if count($orderHistory) > 0}
                            <div class="tab-pane {if $sub_view == "history"}active{/if}" id="order-history">
                                <div class="table-responsive">
                                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                                        <thead>
                                            <tr>
                                                <th>Order ID</th>
                                                <th>Topic Title</th>
                                                <th>{if $article_writing_enabled}Category{else}Discipline{/if}</th>
                                                <th>Status</th>
                                                <th>{if $article_writing_enabled}Words{else}Pages{/if}</th>
                                                {if $show_client_cost}
                                                    <th>Cost</th>
                                                {/if}
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {foreach $orderHistory as $oHistory}
                                                <tr>
                                                    <td>
                                                        <strong><a target="_blank" href="{$base_uri}/order/{$oHistory.id}">#{$oHistory.id}</a></strong>
                                                    </td>
                                                    <td>{$oHistory.title}</td>
                                                    <td>
                                                        <small class="btn-block">{$oHistory.topcat}</small>
                                                        <small class="btn-block text-muted">{$oHistory.academicLevelTitle}</small>
                                                    </td>
                                                    <td>{$oHistory.statusTitle}</td>
                                                    <td>{$oHistory.pages}</td>
                                                    {if $user.is_writer}
                                                        <td>{$oHistory.writerPayFormatted}</td>
                                                    {elseif $user.is_editor}
                                                        <td>{$oHistory.editorPayFormatted}</td>
                                                    {elseif $show_client_cost}
                                                        <td>{$oHistory.priceFormatted}</td>
                                                    {/if}
                                                </tr>
                                            {/foreach}
                                        </tbody>
                                    </table>

                                    {$pager nofilter}
                                </div>
                            </div>
                        {/if}
                        <!-- order-history tab -->

                    </div>
                    <!-- tabs content -->

                </div>
            {/if}
        </div>

    {elseif $sub_view == "assign"}
        
        <div class="card">
            <div class="card-header with-icon with-nav">
                <div class="mb20"> 
                    <div class="pull-right flip">
                        <a href="{$base_uri}/order/{$order.id}" class="btn btn-secondary">
                            <i class="fa fa-arrow-left fa-fw mr5"></i> Back to Order
                        </a>
                    </div>

                    <i class="fa fa-shopping-basket mr10"></i>
                    <strong>Orders</strong>
                    &rsaquo; <strong>#{$order.id}</strong>
                    &rsaquo; <strong>Bids &amp; Writers</strong>
                </div>

                <ul class="nav nav-tabs">
                    <li {if $_get == "bids"}class="active"{/if}>
                        <a href="{$base_uri}/order/{$order.id}/assign?get=bids"> 
                            {if $_get == "bids"}<strong class="pr5">Bids</strong>{else}Bids{/if}
                            {if count($bids) > 0}
                                <span class="label label-success ml5">{count($bids)}</span>
                            {/if}
                        </a>
                    </li>
                    <li {if $_get == "writers"}class="active"{/if}> 
                        <a href="{$base_uri}/order/{$order.id}/assign?get=writers">
                            {if $_get == "writers"}<strong class="pr5">Writers</strong>{else}Writers{/if}
                            {if count($writers) > 0}
                                <span class="label label-success ml5">{count($writers)}</span>
                            {/if}
                        </a> 
                    </li>
                </ul>

            </div>

            {if $_get == "writers"}

                <div class="card-body">

                    <form class="row mb10" method="GET">
                        <div class="col-md-7">
                            <input type="hidden" name="get" value="writers"/>
                            <input type="text" name="query" autocomplete="off" class="form-control input-sm" value="{$query}" placeholder="Search writer ID, name or email" />
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-primary">Search</button>
                        </div>
                    </form> 

                    {if $total_writers > 0}
                        <ul class="row">
                            {foreach $writers as $writer}
                                <li class="col-sm-12 col-md-6">
                                    <div class="data-container ">
                                        <div class="data-content pl0">
                                            <div class="pull-right flip">
                                                {if $order.writer.id == $writer.id}
                                                    <button type="button" class="btn btn-success" data-uid="{$writer.id}" data-oid="{$order.id}"> 
                                                        <i class="fa fa-check"></i> Assigned
                                                    </button>
                                                {else}
                                                    <button type="button" class="btn btn-primary js_assign-order" data-uid="{$writer.id}" data-oid="{$order.id}"> 
                                                        <i class="fa fa-check"></i> Assign
                                                    </button>
                                                {/if}
                                            </div>
                                            <div> 
                                                <span class="name js_user-popover" data-uid="{$writer.id}" data-type="employee"> 
                                                    {if $show_writer_info}
                                                        <a target="_blank" href="{$base_uri}/employees/edit/{$writer.id}">U{$writer.id} - {$writer.first_name} {$writer.last_name}</a> 
                                                    {else}
                                                        <strong class="text-primary">{$writer.id} - {$writer.first_name}</strong>
                                                    {/if}
                                                </span>
                                                <div>{$writer.order_stats.progress} progress • {$writer.order_stats.done+$writer.order_stats.delivered} Done/Delivered • {$writer.order_stats.revision} Revision</div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            {/foreach}
                        </ul>

                        {$pager nofilter}
                    {else}
                        <div class="text-center x-muted"> 
                            <i class="fa fa-users fa-4x"></i>
                            <p class="mb10"><strong>No writers found</strong></p>
                        </div>
                    {/if}
                </div>

            {elseif $_get == "bids"}
                <div class="card-body">
                    {if $total_bids > 0}
                        <ul class="row">
                            {foreach $bids as $bid}
                                <li class="col-sm-12 col-md-6">
                                    <div class="data-container ">
                                        <div class="data-content pl0">
                                            <div class="pull-right flip">
                                                {if $bid.writer_id == $order.writer.id}
                                                    <button type="button" class="btn btn-success" data-uid="{$bid.writer_id}" data-oid="{$order.id}"> 
                                                        <i class="fa fa-check"></i> Assigned
                                                    </button>
                                                {else}
                                                    <button type="button" class="btn btn-primary js_assign-order" data-uid="{$bid.writer_id}" data-oid="{$order.id}"> 
                                                        <i class="fa fa-check"></i> Assign
                                                    </button>
                                                {/if}
                                            </div>
                                            <div> 
                                                <span class="name js_user-popover" data-uid="{$bid.writer_id}" data-type="employee"> 
                                                    {if $show_writer_info}
                                                        <a target="_blank" href="{$base_uri}/employees/edit/{$bid.writer.id}">U{$bid.writer.id} - {$bid.writer.first_name} {$bid.writer.last_name}</a> 
                                                    {else}
                                                        <strong class="text-primary">U{$bid.writer.id} - {$bid.writer.first_name}</strong>
                                                    {/if}
                                                </span>
                                                <div>{$bid.writer.order_stats.progress} progress • {$bid.writer.order_stats.done+$bid.writer.order_stats.delivered} Done/Delivered • {$bid.writer.order_stats.revision} Revision </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            {/foreach}
                        </ul>

                        {$pager nofilter}
                    {else}
                        <div class="text-center x-muted"> 
                            <i class="fa fa-users fa-4x"></i>
                            <p class="mb10"><strong>No bids found</strong></p>
                        </div>
                    {/if}
                </div>
            {/if}

        </div>

    {/if}

    {if $user.is_admin || $user.is_sub_admin}
        <!-- Order Status -->
        <script id="editStatusModal" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/orders/{$order.id}/edit-status" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Change Status</h5>
                    <span class="modal-close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label">Select status</label>
                        <select class="form-control" name="status_id">
                            <option value="-1" selected="">Select Status</option>
                            <option value="13" {if $order.status == '13'}selected=""{/if}>Free Inquiry</option>
                            <option value="0" {if $order.status == '0'}selected=""{/if}>Waiting for Payment</option>
                            <option value="12" {if $order.status == '12'}selected=""{/if}>New Paid</option>
                            <option value="19" {if $order.status == '19'}selected=""{/if}>Available</option>
                            <option value="6" {if $order.status == '6'}selected=""{/if}>Writer Assigned</option>
                            {if $editor_account_enabled}
                                <option value="8" {if $order.status == '8'}selected=""{/if}>Done/Editing</option>
                            {/if}
                            <option value="11" {if $order.status == '11'}selected=""{/if}>Delivered</option>
                            <option value="10" {if $order.status == '10'}selected=""{/if}>Finished</option>
                            <option value="14" {if $order.status == '14'}selected=""{/if}>Revision</option>
                            <option value="9" {if $order.status == '9'}selected=""{/if}>Cancelled</option>
                            <option value="1" {if $order.status == '1'}selected=""{/if}>Dispute</option>
                        </select>
                    </div>

                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                </div>
            </form>
        </script>
        <!-- Order Status -->
    {/if}
{/block}
