{extends file='dashboard/layout.tpl'} 
 
{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-envelope mr10"></i> 
            <strong>Messages</strong>
        </div>

        <div class="card-body">
            {if count($messages)}
                <div class="messages">
                    {foreach $messages as $message}
                        <div class="message">
                            <div class="message--container js_order-message {if !$message.is_sender && !$message.is_viewed}new{/if}" data-id="{$message.id}" data-read="{$message.is_viewed}">
                                <button class="message--toggle" data-toggle="collapse" href="#message-{$message.id}" role="button" aria-expanded="false" aria-controls="message-{$message.id}">
                                    <div class="message--icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19" viewBox="0 0 20 19"><path d="M4,7.863l8,4.907,8-4.907h0L12,2.956,4,7.863H4m18,0v9.814a1.982,1.982,0,0,1-2,1.963H4a1.982,1.982,0,0,1-2-1.963V7.863a1.947,1.947,0,0,1,.97-1.678L12,.64l9.03,5.545A1.947,1.947,0,0,1,22,7.863Z" transform="translate(-2 -0.64)" fill="#9e9e9e"></path></svg>
                                    </div>
                                    <div class="message--from-to">
                                        <div class="message--sender">{$message.from_department.name|ucfirst}</div>
                                        <div class="message--to">{$message.to_department.name|ucfirst}</div>
                                    </div>
                                    
                                    <div class="message--subject">
                                        <strong class="message--subject__text">
                                            <a href="/order/{$message.order_id}">#{$message.order_id}</a>
                                        </strong>
                                        <span class="message--subject__text_collapse">{$message.subject}</span>
                                    </div>
                                    <div class="message--date">
                                        {if $message.is_viewed && $message.is_sender}
                                            <span data-toggle="tooltip" data-placement="top" data-title="{$message.read_at}">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16.749" height="11.42" viewBox="0 0 16.749 11.42"><path d="M9.375,7.926a2.284,2.284,0,1,0,2.284,2.284A2.284,2.284,0,0,0,9.375,7.926m0,6.091a3.807,3.807,0,1,1,3.807-3.807,3.807,3.807,0,0,1-3.807,3.807m0-9.517A9,9,0,0,0,1,10.21a9,9,0,0,0,16.749,0A9,9,0,0,0,9.375,4.5Z" transform="translate(-1 -4.5)" fill="#9e9e9e"></path></svg>
                                            </span>
                                        {/if}
                                        <span class="js_moment" data-time="{$message.created_at}">{$message.created_at}</span>
                                    </div>
                                    <div class="message--arrow">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="7.42" viewBox="0 0 12 7.42"><path d="M7.41,8.58,12,13.17l4.59-4.59L18,10l-6,6L6,10Z" transform="translate(-6 -8.58)" fill="#9e9e9e"></path></svg>
                                    </div>
                                </button>
                                <div class="message--collapse collapse" id="message-{$message.id}">
                                    <div class="message--text">{$message.body nofilter}</div>

                                    {if !$message.is_sender}
                                        <form data-url="/messages/{$message.id}/reply" class="ReplyMessageForm js_ajax-forms" method="POST">
                                            <textarea name="reply" class="form-control mb10 js_autosize" placeholder="Type your reply..." tabindex="0"></textarea>
                                            <!-- success -->
                                            <div class="alert alert-success mt10 mb10 x-hidden" role="alert"></div>
                                            <!-- success -->

                                            <!-- error -->
                                            <div class="alert alert-danger mt10 mb10 x-hidden" role="alert"></div>
                                            <!-- error -->
                                            <div class="ReplyMessageForm__buttons">
                                                <button class="btn btn-primary" type="submit">
                                                    <i class="fa fa-reply"></i> Reply
                                                </button>
                                                <a class="btn btn-success" href="/order/{$message.order_id}">
                                                    <i class="fa fa-eye"></i> View Order
                                                </a>
                                                {if $user.is_admin || $user.is_sub_admin}
                                                    <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">
                                                        <i class="fa fa-trash-alt"></i> Delete
                                                    </a>
                                                {/if}
                                            </div>
                                        </form>
                                    {else}
                                        <div class="message--buttons">
                                            <a class="btn btn-success" href="/order/{$message.order_id}">
                                                <i class="fa fa-eye"></i> View Order
                                            </a>
                                            {if $user.is_admin || $user.is_sub_admin}
                                                <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">
                                                    <i class="fa fa-trash-alt"></i> Delete
                                                </a>
                                            {/if}
                                        </div>
                                    {/if}
                                </div>
                            </div>
                        </div>
                    {/foreach}
                </div>

                {$pager nofilter}
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="15%" src="/static/images/no_results.png">
                    <p class="mb10"><strong>No orders to show</strong></p>
                </div>
            {/if}
        </div>
    </div>
{/block}