{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon">

        {if $sub_view == "coupons"}
            <div class="pull-right flip">
                <a href="{$base_uri}/coupons/add" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Add New Coupon
                </a>
            </div>
        {/if}

        <i class="fa fa-tags mr10"></i>
        <strong>Coupon</strong>
        {if $sub_view == "edit"} &rsaquo; <strong>{$coupon.coupon_code}</strong>{/if}
        {if $sub_view == "add"} &rsaquo; <strong>Add New</strong>{/if}
    </div>

    {if $sub_view == "coupons"}

        <div class="card-body">

        {if count($coupons)}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <td>Coupon</td>
                                <td>Site Name</td>
                                <td>Type</td>
                                <td>Value</td>
                                <td>Expiry</td>
                                <td>Actions</td>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $coupons as $coupon}
                                <tr>
                                    <td>
                                        <a href="{$base_uri}/coupons/edit/{$coupon.id}">{$coupon.coupon_code}</a>
                                    </td>
                                    <td>{$coupon.site_name}</td>
                                    <td>{$coupon.coupon_type}</td>
                                    <td>{$coupon.coupon_value}</td>
                                    <td>
                                        <span class="js_moment" data-time="{$coupon.expiry}"><span>
                                    </td>
                                    <td>
                                        <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="coupon" data-id="{$coupon.id}">
                                            <i class="fa fa-trash-alt"></i>
                                        </button>
                                        <a data-toggle="tooltip" data-placement="top" title="Edit" href="{$base_uri}/coupons/edit/{$coupon.id}" class="btn btn-xs btn-primary">
                                            <i class="fa fa-pencil-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="15%" src="/static/images/no_results.png">
                    <p class="mb10"><strong>No coupons to show</strong></p>
                </div>
            {/if}
        </div>

    {elseif $sub_view == "edit"}

        <form class="js_ajax-forms" data-url="/admin/coupon?do=edit" autocomplete="off">
            <div class="card-body">
                <div class="col-md-9">
                    <input type="hidden" name="coupon_id" value="{$coupon.id}"/>
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Site ID
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="site_id">
                                <option value="0">Select website</option>
                                {foreach $sites as $site}
                                    <option value="{$site.site_id}" {if $site.site_id == $coupon.site_id}selected=""{/if}>{$site.name}</option>
                                {/foreach}
                            </select>                        
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Coupon Code
                        </label>
                        <div class="col-sm-9">
                            <input class="form-control" type="text" name="coupon_code" value="{$coupon.coupon_code}" required>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Coupon Type
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="coupon_type" data-combo="coupon_type">
                                <option value="1" {if $coupon.coupon_type == "1"}selected=''{/if}>Percent</option>
                                <option value="3" {if $coupon.coupon_type == "3"}selected=''{/if}>Amount</option>
                                <option value="9" {if $coupon.coupon_type == "9"}selected=''{/if}>Fixed CPP</option>
                                <option value="5" {if $coupon.coupon_type == "5"}selected=''{/if}>Free Unit</option>
                                <option value="7" {if $coupon.coupon_type == "7"}selected=''{/if}>Writer Category</option>
                            </select>
                        </div>
                    </div>

                    <div id="coupon_type">
                        <div {if $coupon.coupon_type == "1"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="1">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Percent Discount
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control force-integer" type="text" name="coupon_percent" value="{$coupon.coupon_value}">
                                </div>
                            </div>
                        </div>

                        <div {if $coupon.coupon_type == "3"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="3">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Amount Discount
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control force-integer" type="text" name="coupon_amount" value="{$coupon.coupon_value}">
                                </div>
                            </div>
                        </div>
                        
                        <div {if $coupon.coupon_type == "5"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="5">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Free Unit
                                </label>
                                <div class="col-sm-9">
                                    <select class="form-control" name="service_type_id">
                                        <option value="3" {if $coupon.service_type_id == "3"}selected=''{/if}>Writer Category</option>
                                        <option value="21" {if $coupon.service_type_id == "21"}selected=''{/if}>Used Sources</option>
                                        <option value="4" {if $coupon.service_type_id == "4"}selected=''{/if}>Writer Samples</option>
                                        <option value="37" {if $coupon.service_type_id == "37"}selected=''{/if}>Complex Assignment</option>
                                        <option value="41" {if $coupon.service_type_id == "41"}selected=''{/if}>Expert Proofreading</option>
                                        <option value="5" {if $coupon.service_type_id == "5"}selected=''{/if}>Progressive Delivery</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div {if $coupon.coupon_type == "7"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="7">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Writer Category
                                </label>
                                <div class="col-sm-9">
                                    <select class="form-control" name="writer_category_id">
                                        <option value="3" {if $coupon.writer_category_id == "3"}selected=''{/if}>ESL advanced</option>
                                        <option value="4" {if $coupon.writer_category_id == "4"}selected=''{/if}>ENL (English Native Language)</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div {if $coupon.coupon_type == "9"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="9">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Cost Per Page
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control force-integer" type="text" name="coupon_cpp_amount" value="{$coupon.coupon_value}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Customer ID
                        </label>
                        <div class="col-sm-9">
                            <input class="form-control force-integer" type="text" name="user_id" {if $coupon.user_id}value="{$coupon.user_id}"{/if}> 
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Order ID
                        </label>
                        <div class="col-sm-9">
                            <input class="form-control force-integer" type="text" name="order_id" {if $coupon.order_id}value="{$coupon.order_id}"{/if}>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Expiry</label>
                        <div class="col-sm-9">
                            <div class="input-group date js_datetimepicker" id="coupon_expiry" data-target-input="nearest">
                                <input type='text' class="form-control datetimepicker-input" value='{$coupon.expiry|date_format:"%d/%m/%Y %H:%I:%S %p"}' data-target="#coupon_expiry" name="coupon_expiry" />
                                <div class="input-group-append" data-target="#coupon_expiry" data-toggle="datetimepicker">
                                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            One-time use
                        </label>
                        <div class="col-sm-9">
                            <label class="switch" for="one_time">
                                <input type="checkbox" name="one_time" id="one_time" {if $coupon.one_time == '1'}checked="checked"{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Active
                        </label>
                        <div class="col-sm-9">
                            <label class="switch" for="active">
                                <input type="checkbox" name="active" id="active" {if $coupon.active == '1'}checked="checked"{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mb0 mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mb0 mt10 x-hidden" role="alert"></div>
                            <!-- error -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer text-right">
                <div class="row">
                    <div class="col-md-9 text-right">
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                </div>
            </div>
        </form>

    {elseif $sub_view == "add"}
        <form class="js_ajax-forms" data-url="/admin/coupon?do=add" autocomplete="off">
            <div class="card-body">
                <div class="col-md-9">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Site ID
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="site_id">
                                <option value="0">Select website</option>
                                {foreach $sites as $site}
                                    <option value="{$site.site_id}">{$site.name}</option>
                                {/foreach}
                            </select>                        
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Coupon Code
                        </label>
                        <div class="col-sm-9">
                            <input class="form-control" type="text" name="coupon_code" required>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Coupon Type
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="coupon_type" data-combo="coupon_type">
                                <option value="1" selected="">Percent</option>
                                <option value="3">Amount</option>
                                <option value="5">Free Unit</option>
                                <option value="7">Writer Category</option>
                                <option value="9">Fixed CPP</option>
                            </select>
                        </div>
                    </div>

                    <div id="coupon_type">
                        <div class="switch-combo" data-combo-value="1">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Percent Discount
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control force-int" type="text" name="coupon_percent">
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo x-hidden" data-combo-value="3">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Amount Discount
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control force-int" type="text" name="coupon_amount">
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo x-hidden" data-combo-value="5">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Free Unit
                                </label>
                                <div class="col-sm-9">
                                    <select class="form-control" name="service_type_id">
                                        <option value="3">Writer Category</option>
                                        <option value="21">Used Sources</option>
                                        <option value="4">Writer Samples</option>
                                        <option value="37">Complex Assignment</option>
                                        <option value="41">Expert Proofreading</option>
                                        <option value="5">Progressive Delivery</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo x-hidden" data-combo-value="7">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Writer Category
                                </label>
                                <div class="col-sm-9">
                                    <select class="form-control" name="writer_category_id">
                                        <option value="3">ESL advanced</option>
                                        <option value="4">ENL (English Native Language)</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo x-hidden" data-combo-value="9">
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Cost Per Page
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control force-int" type="text" name="coupon_cpp_amount">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Expiry</label>
                        <div class="col-sm-9">
                            <div class="input-group date js_datetimepicker" id="coupon_expiry" data-target-input="nearest">
                                <input type='text' class="form-control datetimepicker-input" data-target="#coupon_expiry" name="coupon_expiry" />
                                <div class="input-group-append" data-target="#coupon_expiry" data-toggle="datetimepicker">
                                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mb0 mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mb0 mt10 x-hidden" role="alert"></div>
                            <!-- error -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-9 text-right">
                        <button type="submit" class="btn btn-primary">Add Coupon</button>
                    </div>
                </div>
            </div>
        </form>
    {/if}

</div>
{/block}