

{if $_settings == 'two-factor'}
    <div class="nk-block-head nk-block-head-lg">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">Two-Factor Authentication</h4>
                <div class="nk-block-des">
                    <p>Log in with a code from your 
                        {if $two_factor_type == "email"}email{/if} 
                        {if $two_factor_type == "sms"}phone{/if} 
                        {if $two_factor_type == "google"}Google Authenticator App{/if} 
                        as well as a password</p>
                </div>
            </div>
        </div>
    </div>
    <form class="js_ajax-forms" data-url="/two_factor_auth/updateProfileSettings" autocomplete="off">    
        <input type="hidden" name="type" value="{$two_factor_type}">
        {if !$userData.two_factor_enabled && $two_factor_type == "google"}
            <div class="row mb-3">
                <div class="col-12">
                    <div class="d-flex">
                        <div class="pe-5 mr-4">
                            <h6>1. Configuring your authenticator</h6>
                            <p class="medium mb-2">You need to download Google Authenticator app for <a target="_blank" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en">Android</a> or <a target="_blank" href="https://itunes.apple.com/eg/app/google-authenticator/id388497605?mt=8">IOS</a></p>
                            <p class="medium mb-0">In your app, add a new account by scanning the QR code to the right.</p>
                            <div class="code-block px-0">
                                <h6 class="overline-title title">Enter this QR code</h6>
                                <button type="button" class="btn btn-sm clipboard-init" title="Copy to clipboard" data-clipboard-target="#twoFactoeCode" data-clip-success="Copied" data-clip-text="Copy">
                                    <span class="clipboard-text">Copy</span>
                                </button>
                                <div class="bg-light p-2 round-sm" id="twoFactoeCode">{$two_factor_gsecret}</div>
                            </div>
                        </div>
                        <div class="border p-1 round-lg w-200px bg-white bg-dark">
                            <img src="{$two_factor_QR}" alt="qr-code">
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="form-group">
                        <label class="form-label">2. Enter the 6-digit code shown on your app</label>
                        <div class="form-control-wrap">
                            <input type="text" class="form-control" name="gcode" placeholder="Check your app">
                        </div>
                    </div>
                </div>
            </div>
        {else}
            <div class="form-table-row">
                <div>
                    <div class="form-control-label h6 fw-500 text-dark">Two-Factor Authentication</div>
                    <div class="form-text nk-block-des">Enable two-factor to log in with a code from your email/phone as well as a password</div>
                </div>
                <div class="text-right">
                    <label class="switch" for="two_factor_enabled">
                        <input type="checkbox" name="two_factor_enabled" id="two_factor_enabled" {if $userData.two_factor_enabled}checked{/if}>
                        <span class="slider round"></span>
                    </label>
                </div>
            </div>
        {/if}
        <div class="form-group">
            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->

            <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
    </form>
{/if}