<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\PaymentModule;
use Proxim\Util\ArrayUtils;

class Two_Checkout extends PaymentModule
{
    /**
    * 2Checkout configuration
    */
    const TWO_CHECKOUT_ENABLED = 'TWO_CHECKOUT_ENABLED';
    const TWO_CHECKOUT_MODE = 'TWO_CHECKOUT_MODE';
    const TWO_CHECKOUT_MERCHANT_CODE = 'TWO_CHECKOUT_MERCHANT_CODE';
    const TWO_CHECKOUT_API_PUBLISHABLE_KEY = 'TWO_CHECKOUT_API_PUBLISHABLE_KEY';
    const TWO_CHECKOUT_API_PRIVATE_KEY = 'TWO_CHECKOUT_API_PRIVATE_KEY';

    public function __construct()
    {
        $this->name = 'two_checkout';
        $this->icon = 'fab fa-credit-card';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';
        $this->displayName = '2Checkout';
        $this->description = '2Checkout allows you to accept payment on your site via credit card';

        $this->bootstrap = true;
        parent::__construct();
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin === true;
    }

    public function install()
    { 
        return parent::install() && 
        $this->registerHook('paymentOptions') &&
        $this->registerHook('verifyPayment') &&
        $this->registerHook('displayClientHeader') &&
        $this->registerHook('displayClientFooter');
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . $templateName.'.tpl');
    }

    public function getContent()
    {
        $application = $this->application;

        $twoCheckoutConfiguration = Configuration::getMultiple([
                'PAYMENT_METHOD_DEFAULT',
                self::TWO_CHECKOUT_ENABLED,
                self::TWO_CHECKOUT_MODE,
                self::TWO_CHECKOUT_MERCHANT_CODE,
                self::TWO_CHECKOUT_API_PUBLISHABLE_KEY,
                self::TWO_CHECKOUT_API_PRIVATE_KEY,
                'SITE_ID'
            ],
            $application->site->id
        );

        $this->smarty->assign([
            'twoCheckoutConfiguration' => $twoCheckoutConfiguration
        ]);

        return $this->getTemplateContent('configure');
    }

    public function update2CheckoutSettings() {
        $app = $this->application;
        $payload = $app->request->post();

        $site_id = (int) $app->request->post('site_id');
        Configuration::updateValue('PAYMENT_METHOD_DEFAULT', ArrayUtils::has($payload, 'default_method_enabled') ? $this->name : '' , false, $site_id);
        Configuration::updateValue(self::TWO_CHECKOUT_ENABLED, (ArrayUtils::get($payload, '2checkout_enabled') == 'on') ? true : false , false, $site_id);
        Configuration::updateValue(self::TWO_CHECKOUT_MODE, ArrayUtils::get($payload, '2checkout_mode'), false, $site_id);
        Configuration::updateValue(self::TWO_CHECKOUT_MERCHANT_CODE, ArrayUtils::get($payload, '2checkout_merchant_code'), false, $site_id);
        Configuration::updateValue(self::TWO_CHECKOUT_API_PUBLISHABLE_KEY, ArrayUtils::get($payload, '2checkout_publishable_key'), false, $site_id);
        Configuration::updateValue(self::TWO_CHECKOUT_API_PRIVATE_KEY, ArrayUtils::get($payload, '2checkout_private_key'), false, $site_id);

        return $app->sendResponse([
            "success" => true,
			"message" => "System settings have been updated"
        ]);
    }
}