<!-- Transactions -->
<form method="GET" class="mb20" autocomplete="off">
    <div class="row"> 
 
        <div class="form-group col-md-3">
            <select class="form-select" name="payment_method">
                <option value="0" {if !$selected_payment_method}selected="selected"{/if}>Payment Method</option>
                {foreach $payment_methods as $payment_method}
                    <option value="{$payment_method.name}" {if $payment_method.name == $selected_payment_method}selected="selected"{/if}>{$payment_method.name|ucfirst}</option>
                {/foreach}
            </select>
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="from" data-target-input="nearest">
                <input type='text' class="form-control date-time-picker" placeholder="From" value="{$date_from}" data-target="#from" name="from" />
                <div class="input-group-append" data-target="#from" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="icon ni ni-calendar"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="to" data-target-input="nearest">
                <input type='text' class="form-control date-time-picker" placeholder="To" value="{$date_to}" data-target="#to" name="to" />
                <div class="input-group-append" data-target="#to" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="icon ni ni-calendar"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group col-md-3">
            <button type="submit" name="search" class="btn btn-primary">
                <i class="icon ni ni-search"></i><span>Search</span>
                </button>
            <button type="submit" name="export" class="btn btn-success">
                <i class="icon ni ni-file-download"></i><span>Export</span>
            </button>
        </div>
    </div>
</form> 

{if count($transactions)}
    <div class="card">
        <div class="card-inner-group">
            <div class="card-inner p-0">
                <table class="table table-orders">
                    <thead class="tb-odr-head">
                        <tr class="tb-odr-item">
                            <th class="tb-odr-info">Type</th>
                            <th class="tb-odr-info">Node ID</th>
                            <th class="tb-odr-info">Payment Method</th>
                            <th class="tb-odr-info">Amount</th>
                            <th class="tb-odr-info">Date</th>
                            <th class="tb-odr-info">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="tb-odr-body">
                        {foreach $transactions as $transaction}
                            <tr class="tb-odr-item">
                                <td class="tb-odr-info">{$transaction.node_type|ucfirst}</td>
                                <td class="tb-odr-info">
                                    {if $transaction.node_type == "order" ||  $transaction.node_type == "add-payment" || $transaction.node_type == "tip"}
                                        <strong>
                                            <a href="{$base_uri}/order/{$transaction.node_id}" data-ajax="/order/{$transaction.node_id}">#{$transaction.node_id}</a>
                                        </strong>
                                    {elseif $transaction.node_type == "paper"}
                                        <strong>
                                            <a href="{$base_uri}/prepapers/viewPaper?paperId={$transaction.node_id}" data-ajax="/prepapers/viewPaper?paperId={$transaction.node_id}">#{$transaction.node_id}</a>
                                        </strong>
                                    {elseif $transaction.node_type == "wallet"}
                                        <strong>
                                            <a href="{$base_uri}/customers/edit/{$transaction.node_id}" data-ajax="/customers/edit/{$transaction.node_id}">#{$transaction.node_id}</a>
                                        </strong>
                                    {/if}
                                </td>
                                <td class="tb-odr-info">
                                    {if $transaction.payment_method}{$transaction.payment_method|ucfirst}{else}N/A{/if}
                                </td>
                                <td class="tb-odr-info text-primary">{$transaction.amountFormatted}</td>
                                <td class="tb-odr-info">
                                    <span class="js_moment" data-time="{$transaction.date_add}">{$transaction.date_add}</span>
                                </td>
                                <td class="tb-odr-info">
                                    {if $transaction.node_type == "order" ||  $transaction.node_type == "add-payment" || $transaction.node_type == "tip"}
                                        <a class="btn btn-primary btn-dim btn-sm" href="{$base_uri}/order/{$transaction.node_id}" data-ajax="/order/{$transaction.node_id}"> 
                                            <i class="icon ni ni-eye"></i> <span>View</span>
                                        </a>
                                    {elseif $transaction.node_type == "paper"}
                                        <a class="btn btn-primary btn-dim btn-sm" href="{$base_uri}/prepapers/viewPaper?paperId={$transaction.node_id}" data-ajax="/prepapers/viewPaper?paperId={$transaction.node_id}"> 
                                            <i class="icon ni ni-eye"></i> <span>View</span>
                                        </a>
                                    {elseif $transaction.node_type == "wallet"}
                                        <a class="btn btn-primary btn-dim btn-sm" href="{$base_uri}/customers/edit/{$transaction.node_id}" data-ajax="/customers/edit/{$transaction.node_id}"> 
                                            <i class="icon ni ni-eye"></i> <span>View</span>
                                        </a>
                                    {/if}
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                    <tfoot>
                        {foreach $amounts as $amount}
                            <tr class="tb-odr-item border-top">
                                <td colspan="3"></td>
                                <td class="fw-bold">
                                    <small class="text-primary mr-2">{$amount.iso_code}</small>
                                    <strong class="text-primary">{$amount.amountFormatted}</strong>
                                </td>
                            </tr>
                        {/foreach}
                    </tfoot>
                </table>
            </div>
            <div class="card-inner">
                {$pager nofilter}
            </div>
        </div>
    </div>
{else}
    <div class="text-center py-5"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <h6 class="text-dark title mb-3">No transactions to show</h6>
    </div>
{/if}
<!-- Transactions -->