<!-- Stripe -->
<div class="tab-pane" id="stripe">
    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updateStripeSettings">
        <div class="alert alert-info">
            <div class="icon">
                <i class="fas fa-info-circle fa-2x"></i>
            </div>
            <div class="text">
                To start using Stripe, you'll need to create an account at <a target="_blank" href="https://dashboard.stripe.com/">Stripe</a><br>
                Check the documentation for more help
            </div>
        </div>
        
        <input type="hidden" name="site_id" value="{$stripeConfiguration.SITE_ID}"/>

        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Stripe Enabled</div> 
                <div class="form-text">Enable payments via Credit Card</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="stripe_enabled"> 
                    <input type="checkbox" name="stripe_enabled" id="stripe_enabled" {if $stripeConfiguration.STRIPE_ENABLED == '1'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Default</div> 
                <div class="form-text">Make it the default payment method of the site</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="default_method_enabled"> 
                    <input type="checkbox" name="default_method_enabled" id="default_method_enabled" {if $stripeConfiguration.PAYMENT_METHOD_DEFAULT == 'stripe'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Stripe Mode
            </label>
            <div class="col-sm-9">
                <div class="form-selectgroup">
                    <label class="form-selectgroup-item" for="stripe_live">
                        <input id="stripe_live" type="radio" name="stripe_mode" value="live" class="form-selectgroup-input" {if $stripeConfiguration.STRIPE_MODE == 'live'}checked{/if}>
                        <span class="form-selectgroup-label">
                            <i class="icon fas fa-money-check fa-lg"></i>    
                            <span class="text middle">Live</span>
                        </span>
                    </label>
                    <label class="form-selectgroup-item" for="stripe_test">
                        <input id="stripe_test" type="radio" name="stripe_mode" value="test" class="form-selectgroup-input" {if $stripeConfiguration.STRIPE_MODE == 'test'}checked{/if}>
                        <span class="form-selectgroup-label">
                            <i class="icon fab fa-dev fa-lg"></i>    
                            <span class="text middle">Test</span>
                        </span>
                    </label>
                </div>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Live Publishable Key
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="stripe_live_key" id="stripe_live_key" maxlength="255" value="{$stripeConfiguration.STRIPE_LIVE_KEY}">
                <span class="help-block">
                    Stripe secret key that starts with pk_
                </span>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Test Publishable Key
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="stripe_test_key" id="stripe_test_key" maxlength="255" value="{$stripeConfiguration.STRIPE_TEST_KEY}">
                <span class="help-block">
                    Stripe secret key that starts with pk_
                </span>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Live Secret Key
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="stripe_live_secret" id="stripe_live_secret" maxlength="255" value="{$stripeConfiguration.STRIPE_LIVE_SECRET}">
                <span class="help-block">
                    Stripe secret key that starts with sk_
                </span>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Test Secret Key
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="stripe_test_secret" id="stripe_test_secret" maxlength="255" value="{$stripeConfiguration.STRIPE_TEST_SECRET}">
                <span class="help-block">
                    Stripe secret key that starts with sk_
                </span>
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- Stripe -->