{extends file='dashboard/layout.tpl'}

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            {if $sub_view == "listSamples"}
                <div class="pull-right flip">
                    <a class="btn btn-primary" href="{$base_uri}/samples/addNew">
                        <i class="fa fa-plus"></i> Add New Sample
                    </a>
                </div>
            {/if}

            <i class="fa fa-book mr10"></i>
            <strong>Samples</strong>
            {if $sub_view == "addSample"}
                &rsaquo; <strong>Add New</strong>
            {elseif $sub_view == "viewSample"}
                &rsaquo; <strong>{$sample.id}</strong>
            {/if}
        </div>

        {if $sub_view == "listSamples"}

            <div class="card-body">
                {if count($samples)}
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <th>Sample ID</th>
                                    <th>Type of paper</th>
                                    <th>Discipline</th>
                                    <th>Academic Level</th>
                                    <th>Pages</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $samples as $sample}
                                    <tr>
                                        <td>
                                            <strong>
                                                <a href="{$base_uri}/samples/viewSample?sampleId={$sample.id}" data-ajax="/samples/viewSample?sampleId={$sample.id}">#{$sample.id}</a>
                                            </strong>
                                        </td>
                                        <td>{$sample.paper_type.title}</td>
                                        <td>{$sample.discipline.title}</td>
                                        <td>{$sample.academic_level.title}</td>
                                        <td>{$sample.pages}</td>
                                        <td>
                                            <span class="js_moment" data-time="{$sample.date_add}">{$sample.date_add}</span>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$sample.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$sample.id}">
                                                    <a class="dropdown-item" href="{$base_uri}/samples/viewSample?sampleId={$sample.id}" data-ajax="/samples/viewSample?sampleId={$sample.id}"">
                                                        <i class="fa fa-pencil-alt mr5"></i> Edit
                                                    </a>
                                                    <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="sample" data-id="{$sample.id}">
                                                        <i class="fa fa-trash-alt mr5"></i> Delete
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted">
                        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb10"><strong>No samples to show</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $sub_view == "viewSample"}

            <div class="card-body">
                <div class="row">
                    <div class="col-xs-12 col-sm-5 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$sample.id}</span>
                                Sample ID
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.paper_type.title}</span>
                                Paper Type
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.discipline.title}</span>
                                Discipline
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.academic_level.title}</span>
                                Academic Level
                            </li>
                        </ul>
                    </div>

                    <div class="col-xs-12 col-sm-5 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{if $sample.spacing == 'double'}Double Spaced{else}Single Spaced{/if}</span>
                                Spacing
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.pages}</span>
                                Pages
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.sources}</span>
                                Sources
                            </li>
                            <li class="list-group-item">
                                <span data-time="{$sample.date_add}" class="badge js_moment">{$sample.date_add}</span>
                                Created At
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- tabs nav -->
                <ul class="nav nav-tabs mb20">
                    <li class="nav-item">
                        <a href="#info" data-toggle="tab" class="nav-link active">
                            <i class="fa fa-info fa-fw mr5"></i><strong class="pr5">Sample Info</strong>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#files" data-toggle="tab" class="nav-link">
                            <i class="fa fa-file fa-fw mr5"></i><strong class="pr5">Files</strong>
                        </a>
                    </li>
                </ul>
                <!-- tabs nav -->

                <!-- tabs content -->
                <div class="tab-content">

                    <!-- info tab -->
                    <div class="tab-pane active" id="info">
                        <form class="js_ajax-forms" data-url="/samples/apiAddSample" autocomplete="off">
                            <input type="hidden" name="sample_id" value="{$sample.id}"/>
                            <div class="col-md-8 form-horizontal">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Title</label>
                                    <div class="col-sm-9">
                                        <input class="form-control" name="title" value="{$sample.title}">
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Paper Instructions</label>
                                    <div class="col-sm-9">
                                        <textarea class="form-control js_summernote" data-height="200" name="instructions">{$sample.instructions nofilter}</textarea>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Academic Level</label>
                                    <div class="col-sm-9">
                                        <select name="academicLevelId" class="form-control select_search">
                                            {foreach $academicLevels as $academicLevel}
                                                <option value="{$academicLevel.id}" {if $academicLevel.id == $sample.academic_level_id}selected=""{/if}>{$academicLevel.title}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Type of paper</label>
                                    <div class="col-sm-9">
                                        <select name="paperTypeId" class="form-control select_search" data-combo="paperType">
                                            {foreach $paperTypes as $paperType}
                                                <option value="{$paperType.id}" {if $paperType.id == $sample.paper_type_id}selected=""{/if}>{$paperType.title}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                                <div id="paperType">
                                    <div {if $sample.paper_type_id == '64'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="64">
                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Type:</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="paperTypeOption" id="paperTypeOption" maxlength="255" value="{$sample.paper_type_option}">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Discipline</label>
                                    <div class="col-sm-9">
                                        <select id="topicCatId" class="form-control select_search" name="topicCatId" data-combo="discipline">
                                            {foreach $disciplineGroups as $topicCat}
                                                <optgroup label="{$topicCat.title}">
                                                    {foreach $topicCat.disciplines as $discipline}
                                                        <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}" {if $sample.topic_category_id == $discipline.discipline_id}selected{/if}>{$discipline.title}</option>
                                                    {/foreach}
                                                </optgroup>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                                <div id="discipline">
                                    <div {if $sample.topic_category_id == '52'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="52">
                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label" for="paperFormatOption">Custom Discipline:</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="topcatOption" id="topcatOption" maxlength="255" value="{$sample.topic_category_option}">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Paper Format</label>
                                    <div class="col-sm-9">
                                        <select class="form-control select_search" name="paperFormat" data-combo="paperFormat">
                                            {foreach $paperFormats as $paperFormat}
                                                <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == $sample.paper_format_id}selected=""{/if}>{$paperFormat.title}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                                <div id="paperFormat">
                                    <div {if $sample.paper_format_id == '4'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="4">
                                        <div class="form-group form-row">
                                            <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Format:</label>
                                            <div class="col-sm-9">
                                                <input class="form-control" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255" value="{$sample.paper_format_option}">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Spacing</label>
                                    <div class="col-sm-9">
                                        <select class="form-control" name="spacing" style="width:150px;">
                                            <option {if $sample.spacing == 'double'}selected=""{/if} value="double">Double Spaced</option>
                                            <option {if $sample.spacing == 'single'}selected=""{/if} value="single">Single Spaced</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Pages</label>
                                    <div class="col-sm-4">
                                        <div class="control-stepper">
                                            <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                            <input name="pages" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$sample.pages}">
                                            <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label">Sources</label>
                                    <div class="col-sm-4">
                                        <div class="control-stepper">
                                            <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                            <input name="sources" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$sample.sources}">
                                            <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group form-row mt20">
                                    <div class="col-sm-9 offset-sm-3">
                                        <!-- success -->
                                        <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                        <!-- success -->

                                        <!-- error -->
                                        <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                        <!-- error -->

                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>
                    <!-- info tab -->

                    <!-- files tab -->
                    <div class="tab-pane" id="files">
                        <div class="row">
                            <div class="col-md-8">
                                <form class="js_files-uploader p0 m0" data-handle="sample" data-id="{$sample.id}" method="POST">
                                    <div class="files-control js_dropzone" data-handle="sample" data-id="{$sample.id}">
                                        <div class="files-control--files">
                                            {foreach $sample.files as $file}
                                                <div class="FormFile" data-handle="sample-file" data-id="{$file.id}" data-uploaded="true">
                                                    <div class="FormFile__controls">
                                                        <div class="FormFile__icon">
                                                            <div class="FormFile__icon__badge FormFile__icon__badge--{$file.icon}">{$file.icon}</div>
                                                        </div>
                                                        <button type="button" class="FormFile__info">
                                                            <div class="FormFile__title">
                                                                <a href="{$file.download_link}" class="text-primary">{$file.name}</a>
                                                            </div>
                                                            <span class="FormFile__size">{$file.size_formatted}</span>
                                                            <span class="OrderDetailsFilesCustomersFile__date js_moment" data-time="{$file.date_add}">{$file.date_add}</span>
                                                        </button>
                                                        <button type="button" data-toggle="tooltip" data-title="Delete File" class="FormFile__remove-button"></button>
                                                    </div>
                                                </div>
                                            {/foreach}
                                        </div>
                                        <div class="dropzone-description">
                                            <button class="browse-button btn btn-primary" type="button">Browse</button>
                                            <span class="control-or">or</span>
                                            <span class="control-drop-here">Drop files here</span>
                                        </div>
                                        <div class="dropzone-static">
                                            <div class="dropzone-border">Drop files here</div>
                                        </div>
                                        <input multiple="" type="file" style="display: none;" data-handle="sample" data-id="{$sample.id}">
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- files tab -->

                </div>
            </div>

        {elseif $sub_view == "addSample"}

            <form class="js_ajax-forms" data-url="/samples/apiAddSample" autocomplete="off">
                <div class="card-body">
                    <div class="col-md-8 form-horizontal">
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Title</label>
                            <div class="col-sm-9">
                                <input class="form-control" name="title">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Paper Instructions</label>
                            <div class="col-sm-9">
                                <textarea class="form-control js_summernote" data-height="200" name="instructions"></textarea>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Academic Level</label>
                            <div class="col-sm-9">
                                <select name="academicLevelId" class="form-control select_search">
                                    {foreach $academicLevels as $academicLevel}
                                        <option value="{$academicLevel.id}">{$academicLevel.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Type of paper</label>
                            <div class="col-sm-9">
                                <select name="paperTypeId" class="form-control select_search" data-combo="paperType">
                                    {foreach $paperTypes as $paperType}
                                        <option value="{$paperType.id}">{$paperType.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperType">
                            <div class="switch-combo x-hidden" data-combo-value="64">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Type:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="paperTypeOption" id="paperTypeOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Discipline</label>
                            <div class="col-sm-9">
                                <select id="topicCatId" class="form-control select_search" name="topicCatId" data-combo="discipline">
                                    {foreach $disciplineGroups as $topicCat}
                                        <optgroup label="{$topicCat.title}">
                                            {foreach $topicCat.disciplines as $discipline}
                                                <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}">{$discipline.title}</option>
                                            {/foreach}
                                        </optgroup>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="discipline">
                            <div class="switch-combo x-hidden" data-combo-value="52">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Discipline:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="topcatOption" id="topcatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Paper Format</label>
                            <div class="col-sm-9">
                                <select class="form-control select_search" name="paperFormat" data-combo="paperFormat">
                                    {foreach $paperFormats as $paperFormat}
                                        <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == "1"}selected=""{/if}>{$paperFormat.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperFormat">
                            <div class="switch-combo x-hidden" data-combo-value="4">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Format:</label>
                                    <div class="col-sm-9">
                                        <input class="form-control" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Spacing</label>
                            <div class="col-sm-9">
                                <select class="form-control" name="spacing" style="width:150px;">
                                    <option value="double">Double Spaced</option>
                                    <option value="single">Single Spaced</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Pages</label>
                            <div class="col-sm-4">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="pages" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="1">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Sources</label>
                            <div class="col-sm-4">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="sources" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <div class="col-sm-9">
                                <!-- success -->
                                <div class="alert alert-success mt10 mb0 x-hidden" role="alert"></div>
                                <!-- success -->

                                <!-- error -->
                                <div class="alert alert-danger mt10 mb0 x-hidden" role="alert"></div>
                                <!-- error -->
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Add New Sample</button>
                </div>
            </form>

        {/if}

    </div>
{/block}
