{extends file='dashboard/layout.tpl'}

{block name='content_wrapper'} 
    <div class="{if $sub_view == "listSamples"}wide-lg{else}wide-sm{/if}">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title"> Samples
                            {if $sub_view == "viewSample"} &rsaquo; <strong class="text-primary small">#{$sample.id}</strong>{/if}
                            {if $sub_view == "addSample"} &rsaquo; <strong class="text-primary small">Add New</strong>{/if}
                        </h3>
                    </div>
                    <!-- .nk-block-head-content -->

                    {if $sub_view == "listSamples"}
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                                <div class="toggle-expand-content" data-content="more-options">
                                    <ul class="nk-block-tools g-3">
                                        <li class="nk-block-tools-opt">
                                            <a href="{$base_uri}/samples/addNew" data-ajax="/samples/addNew" class="btn btn-icon btn-primary d-md-none">
                                                <em class="icon ni ni-plus"></em>
                                            </a>
                                            <a href="{$base_uri}/samples/addNew" data-ajax="/samples/addNew" class="btn btn-primary d-none d-md-inline-flex">
                                                <em class="icon ni ni-plus"></em><span>Add New Sample</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- .nk-block-head-content -->
                    {/if}
                </div>
                <!-- .nk-block-between -->
            </div>
        </div>

        <div class="nk-block">

            {if $sub_view == "listSamples"}

                {if count($samples)}
                    <div class="table-responsive">
                        <table class="nk-tb-list is-separate nk-tb-ulist mb-3">
                            <thead>
                                <tr class="nk-tb-item nk-tb-head">
                                    <th class="nk-tb-col">Sample ID</th>
                                    <th class="nk-tb-col">Type of paper</th>
                                    <th class="nk-tb-col">Discipline</th>
                                    <th class="nk-tb-col">Academic Level</th>
                                    <th class="nk-tb-col">Pages</th>
                                    <th class="nk-tb-col">Created At</th>
                                    <th class="nk-tb-col">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $samples as $sample}
                                    <tr class="nk-tb-item">
                                        <td class="nk-tb-col">
                                            <strong>
                                                <a href="{$base_uri}/samples/viewSample?sampleId={$sample.id}" data-ajax="/samples/viewSample?sampleId={$sample.id}">#{$sample.id}</a>
                                            </strong>
                                        </td>
                                        <td class="nk-tb-col">{$sample.paper_type.title}</td>
                                        <td class="nk-tb-col">{$sample.discipline.title}</td>
                                        <td class="nk-tb-col">{$sample.academic_level.title}</td>
                                        <td class="nk-tb-col">{$sample.pages}</td>
                                        <td class="nk-tb-col">
                                            <span class="js_moment" data-time="{$sample.date_add}">{$sample.date_add}</span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="dropdown">
                                                <button class="dropdown-toggle btn btn-icon btn-trigger" type="button" id="dropdownMenu-{$sample.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <em class="icon ni ni-more-h"></em>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$sample.id}">
                                                    <ul class="link-list-opt no-bdr">
                                                        <li>
                                                            <a class="dropdown-item" href="{$base_uri}/samples/viewSample?sampleId={$sample.id}" data-ajax="/samples/viewSample?sampleId={$sample.id}"">
                                                                <i class="icon ni ni-edit mr5"></i> <span>Edit</span>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="sample" data-id="{$sample.id}">
                                                                <i class="icon ni ni-trash-alt mr5"></i> <span>Delete</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        <div class="nk-block-between-md g-3">
                            <div class="g">
                                {$pager nofilter}
                            </div>
                        </div><!-- .nk-block-between -->
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <h6 class="text-dark title mb-3">No samples to show</h6>
                    </div>
                {/if}

            {elseif $sub_view == "viewSample"}
                <div class="row">
                    <div class="col-xs-12 col-sm-6 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$sample.id}</span>
                                Sample ID
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.paper_type.title}</span>
                                Paper Type
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.discipline.title}</span>
                                Discipline
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.academic_level.title}</span>
                                Academic Level
                            </li>
                        </ul>
                    </div>

                    <div class="col-xs-12 col-sm-6 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{if $sample.spacing == 'double'}Double Spaced{else}Single Spaced{/if}</span>
                                Spacing
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.pages}</span>
                                Pages
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$sample.sources}</span>
                                Sources
                            </li>
                            <li class="list-group-item">
                                <span data-time="{$sample.date_add}" class="badge js_moment">{$sample.date_add}</span>
                                Created At
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="card card-preview">
                    <div class="card-inner">
                        <!-- tabs nav -->
                        <ul class="nav nav-tabs mt-n3">
                            <li class="nav-item">
                                <a href="#info" data-toggle="tab" class="nav-link active">
                                    <i class="icon ni ni-info fa-fw mr5"></i><span class="pr5">Sample Info</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#files" data-toggle="tab" class="nav-link">
                                    <i class="icon ni ni-file fa-fw mr5"></i><span class="pr5">Files</span>
                                </a>
                            </li>
                        </ul>
                        <!-- tabs nav -->

                        <!-- tabs content -->
                        <div class="tab-content">

                            <!-- info tab -->
                            <div class="tab-pane active" id="info">
                                <form class="js_ajax-forms" data-url="/samples/apiAddSample" autocomplete="off">
                                    <input type="hidden" name="sample_id" value="{$sample.id}"/>
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Title</label>
                                        <div class="col-sm-9">
                                            <input class="form-control form-control-lg" name="title" value="{$sample.title}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Paper Instructions</label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control summernote-minimal" data-height="200" name="instructions">{$sample.instructions nofilter}</textarea>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Academic Level</label>
                                        <div class="col-sm-9">
                                            <select name="academicLevelId" class="form-select" data-search="on" data-ui="lg">
                                                {foreach $academicLevels as $academicLevel}
                                                    <option value="{$academicLevel.id}" {if $academicLevel.id == $sample.academic_level_id}selected=""{/if}>{$academicLevel.title}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Type of paper</label>
                                        <div class="col-sm-9">
                                            <select name="paperTypeId" class="form-select" data-search="on" data-ui="lg" data-combo="paperType">
                                                {foreach $paperTypes as $paperType}
                                                    <option value="{$paperType.id}" {if $paperType.id == $sample.paper_type_id}selected=""{/if}>{$paperType.title}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div id="paperType">
                                        <div {if $sample.paper_type_id == '64'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="64">
                                            <div class="form-group form-row">
                                                <label class="col-sm-3 form-label" for="paperFormatOption">Custom Paper Type:</label>
                                                <div class="col-sm-9">
                                                    <input type="text" class="form-control form-control-lg" name="paperTypeOption" id="paperTypeOption" maxlength="255" value="{$sample.paper_type_option}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Discipline</label>
                                        <div class="col-sm-9">
                                            <select id="topicCatId" class="form-select" data-search="on" data-ui="lg" name="topicCatId" data-combo="discipline">
                                                {foreach $disciplineGroups as $topicCat}
                                                    <optgroup label="{$topicCat.title}">
                                                        {foreach $topicCat.disciplines as $discipline}
                                                            <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}" {if $sample.topic_category_id == $discipline.discipline_id}selected{/if}>{$discipline.title}</option>
                                                        {/foreach}
                                                    </optgroup>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div id="discipline">
                                        <div {if $sample.topic_category_id == '52'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="52">
                                            <div class="form-group form-row">
                                                <label class="col-sm-3 form-label" for="paperFormatOption">Custom Discipline:</label>
                                                <div class="col-sm-9">
                                                    <input type="text" class="form-control form-control-lg" name="topcatOption" id="topcatOption" maxlength="255" value="{$sample.topic_category_option}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Paper Format</label>
                                        <div class="col-sm-9">
                                            <select class="form-select" data-search="on" data-ui="lg" name="paperFormat" data-combo="paperFormat">
                                                {foreach $paperFormats as $paperFormat}
                                                    <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == $sample.paper_format_id}selected=""{/if}>{$paperFormat.title}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div id="paperFormat">
                                        <div {if $sample.paper_format_id == '4'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="4">
                                            <div class="form-group form-row">
                                                <label class="col-sm-3 form-label" for="paperFormatOption">Custom Paper Format:</label>
                                                <div class="col-sm-9">
                                                    <input class="form-control form-control-lg" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255" value="{$sample.paper_format_option}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Spacing</label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-lg" name="spacing" style="width:150px;">
                                                <option {if $sample.spacing == 'double'}selected=""{/if} value="double">Double Spaced</option>
                                                <option {if $sample.spacing == 'single'}selected=""{/if} value="single">Single Spaced</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Pages</label>
                                        <div class="col-sm-4">
                                            <div class="form-control-wrap number-spinner-wrap">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                                    <em class="icon ni ni-minus"></em>
                                                </button>
                                                <input type="text" name="pages" class="form-control form-control-lg js_calculate number-spinner" placeholder="pages"  value="{$sample.pages}" min="0" max="999">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                                    <em class="icon ni ni-plus"></em>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Sources</label>
                                        <div class="col-sm-4">
                                            <div class="form-control-wrap number-spinner-wrap">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                                    <em class="icon ni ni-minus"></em>
                                                </button>
                                                <input type="text" name="sources" class="form-control form-control-lg js_calculate number-spinner" placeholder="sources" value="{$sample.sources}" min="0" max="999">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                                    <em class="icon ni ni-plus"></em>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <!-- error -->
                                        <div class="alert alert-danger alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                        <!-- error -->

                                        <!-- success -->
                                        <div class="alert alert-success alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                                        <!-- success -->

                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                    </div>

                                </form>
                            </div>
                            <!-- info tab -->

                            <!-- files tab -->
                            <div class="tab-pane" id="files">
                                <form class="js_files-uploader p0 m0" data-handle="sample" data-id="{$sample.id}" method="POST">
                                    <div class="files-control js_dropzone" data-handle="sample" data-id="{$sample.id}">
                                        <div class="files-control--files">
                                            {foreach $sample.files as $file}
                                                <div class="FormFile" data-handle="sample-file" data-id="{$file.id}" data-uploaded="true">
                                                    <div class="FormFile__controls">
                                                        <div class="FormFile__icon">
                                                            <div class="FormFile__icon__badge FormFile__icon__badge--{$file.icon}">{$file.icon}</div>
                                                        </div>
                                                        <button type="button" class="FormFile__info">
                                                            <div class="FormFile__title">
                                                                <a href="{$file.download_link}" class="text-primary">{$file.name}</a>
                                                            </div>
                                                            <span class="FormFile__size">{$file.size_formatted}</span>
                                                            <span class="OrderDetailsFilesCustomersFile__date js_moment" data-time="{$file.date_add}">{$file.date_add}</span>
                                                        </button>
                                                        <button type="button" data-toggle="tooltip" data-title="Delete File" class="FormFile__remove-button"></button>
                                                    </div>
                                                </div>
                                            {/foreach}
                                        </div>
                                        <div class="dropzone-description">
                                            <button class="browse-button btn btn-primary" type="button">Browse</button>
                                            <span class="control-or">or</span>
                                            <span class="control-drop-here">Drop files here</span>
                                        </div>
                                        <div class="dropzone-static">
                                            <div class="dropzone-border">Drop files here</div>
                                        </div>
                                        <input multiple="" type="file" style="display: none;" data-handle="sample" data-id="{$sample.id}">
                                    </div>
                                </form>
                            </div>
                            <!-- files tab -->

                        </div>
                    </div>
                </div>

            {elseif $sub_view == "addSample"}

                <form class="card card-preview js_ajax-forms" data-url="/samples/apiAddSample" autocomplete="off">
                    <div class="card-inner">
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label">Title</label>
                            <div class="col-sm-9">
                                <input class="form-control form-control-lg" name="title">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label">Paper Instructions</label>
                            <div class="col-sm-9">
                                <textarea class="form-control summernote-minimal" data-height="200" name="instructions"></textarea>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label">Academic Level</label>
                            <div class="col-sm-9">
                                <select name="academicLevelId" class="form-select" data-search="on" data-ui="lg">
                                    {foreach $academicLevels as $academicLevel}
                                        <option value="{$academicLevel.id}">{$academicLevel.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label">Type of paper</label>
                            <div class="col-sm-9">
                                <select name="paperTypeId" class="form-select" data-search="on" data-ui="lg" data-combo="paperType">
                                    {foreach $paperTypes as $paperType}
                                        <option value="{$paperType.id}">{$paperType.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperType">
                            <div class="switch-combo x-hidden" data-combo-value="64">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 form-label" for="paperFormatOption">Custom Paper Type:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control form-control-lg" name="paperTypeOption" id="paperTypeOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label">Discipline</label>
                            <div class="col-sm-9">
                                <select id="topicCatId" class="form-select" data-search="on" data-ui="lg" name="topicCatId" data-combo="discipline">
                                    {foreach $disciplineGroups as $topicCat}
                                        <optgroup label="{$topicCat.title}">
                                            {foreach $topicCat.disciplines as $discipline}
                                                <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}">{$discipline.title}</option>
                                            {/foreach}
                                        </optgroup>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="discipline">
                            <div class="switch-combo x-hidden" data-combo-value="52">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 form-label" for="paperFormatOption">Custom Discipline:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control form-control-lg" name="topcatOption" id="topcatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label">Paper Format</label>
                            <div class="col-sm-9">
                                <select class="form-select" data-search="on" data-ui="lg" name="paperFormat" data-combo="paperFormat">
                                    {foreach $paperFormats as $paperFormat}
                                        <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == "1"}selected=""{/if}>{$paperFormat.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperFormat">
                            <div class="switch-combo x-hidden" data-combo-value="4">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 form-label" for="paperFormatOption">Custom Paper Format:</label>
                                    <div class="col-sm-9">
                                        <input class="form-control form-control-lg" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label">Spacing</label>
                            <div class="col-sm-9">
                                <select class="form-select" data-ui="lg" name="spacing" style="width:150px;">
                                    <option value="double">Double Spaced</option>
                                    <option value="single">Single Spaced</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Pages</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="pages" class="form-control form-control-lg js_calculate number-spinner" placeholder="pages" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Sources</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="sources" class="form-control form-control-lg js_calculate number-spinner" placeholder="sources" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <!-- error -->
                            <div class="alert alert-danger alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->

                            <!-- success -->
                            <div class="alert alert-success alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                            <!-- success -->
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Add New Sample</button>
                    </div>
                </form>

            {/if}

        </div>
    </div>
{/block}
