<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Order\Order;
use Proxim\Tools;
use Proxim\Util\ArrayUtils;
use Proxim\Validate;

class Referral_Link extends Module
{
    public function __construct()
    {
        $this->name = 'referral_link';
        $this->icon = 'fa fa-link';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'Referral Link';
        $this->description = 'This addon helps you to track user referer and display referer information in the order details';
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin ? true : false;
    }

    public function install()
    {
        if (!parent::install()) {
            return false;
        }

        try {
            Db::getInstance()->Execute("
                ALTER TABLE " . Db::prefix("order") . " ADD (
                    `referer_link` TEXT DEFAULT NULL
                );
            ");
        } catch(Exception $e) {

        }
        
        $this->registerHook([
            'displayOrderAdditionalInfo',
            'actionAfterOrderCreate',
            'actionDispatcherBeforeRun'
        ]);
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . PROX_ACTIVE_THEME . '/' . $templateName.'.tpl');
    }

    public function hookDisplayOrderAdditionalInfo( $params ) {
        $order_id = ArrayUtils::get($params, 'order_id');

        if(!$this->checkAccess()) {
            return;
        }

        $order = new Order( (int) $order_id );
        if(Validate::isLoadedObject($order)) {
            $referer_link = Db::getInstance()->getValue('SELECT referer_link FROM ' . Db::prefix('order') . ' WHERE order_id = ' . (int) $order->id );

            if($referer_link) {
                $this->smarty->assign([
                    'order_id' => $order->id,
                    'referer_link' => $referer_link
                ]);
    
                $this->showTemplate('order.referer_link');
            }
        }

    }
}