<h4 class="mt0">Adding a Pricing Table on your website</h4>
<ol class="ml0 pl10">
    <li class="mb5">Log in to your <strong>WordPress dashboard</strong>.</li>
    <li class="mb5">Click <strong>Pages</strong>, from the navigation menu.</li>
    <li class="mb5">Click <strong>Add New</strong> button, you’ll be directed to the WordPress visual editor. Add a title for the page e.g. Pricing.</li>
    <li class="mb5">Click the <strong>Plus</strong> icon on the block area or the top of the editor.</li>
    <li class="mb5">Choose the <strong>Custom HTML</strong> icon under the Formatting. Search <strong>Custom HTML</strong> option if you can't find it.</li>
    <li class="mb5"><strong>Copy and Paste</strong> the below HTML code to your WordPress page.</li>
    <li class="mb5">Alternatively, you can switch to the editor mode. Click the <strong>three dots menu</strong> on the top right side corner, then select <strong>Code Editor</strong>.</li>
    <li class="mb5">Click <strong>Preview</strong> if you want to see the results before publishing.</li>
</ol>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.2/codemirror.min.css" integrity="sha512-xIf9AdJauwKIVtrVRZ0i4nHP61Ogx9fSRAkCLecmE2dL/U8ioWpDvFCAy4dcfecN72HHB9+7FfQj3aiO68aaaw==" crossorigin="anonymous" />
{literal}
    <textarea class="form-control" name="custom-code" id="custom-code">
        <link rel="stylesheet" href="/static/css/pricing-table.css" type="text/css" media="all">

        <style type="text/css">@-webkit-keyframes flat-spinner{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes flat-spinner{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}
        .flat-spinner{margin:90px auto;position:relative;border-top:5px solid rgba(0,147,221,.2);border-right:5px solid rgba(0,147,221,.2);border-bottom:5px solid rgba(0,147,221,.2);border-left:5px solid #0093dd;-webkit-transform:translateZ(0);transform:translateZ(0);-webkit-animation:flat-spinner 1s infinite linear;animation:flat-spinner 1s infinite linear}.flat-spinner,.flat-spinner:after{border-radius:50%;width:64px;height:64px}
        </style>
        <div class="pricing-page pricing-page-new">
            <div class="pricing-page-tables">
                <div class="table-wrap">
                    <div data-pricing-table="0">
                        <div class="flat-spinner"></div>
                    </div>
                </div>
            </div>
            <div class="text">
                <p>All prices are given in USD for writing 1 page. You will be able to choose currency during checkout.</p>
                <p>These prices do not include the <strong>Value Added TAX</strong>. Prices for EU customers are calculated according to the tariffs of the country the customer is from.</p>
            </div>
        </div>

        <script async="" defer="" type="text/javascript" src="/static/js/pricing-table.js"></script>
    </textarea>
{/literal}

{block name="custom_js"}
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.2/codemirror.min.js" integrity="sha512-UxcTlYsLkcuGZL9JNnMsfo3p7VFSmcgBjH1VUSM82Okk5ni52bk7vz9f2p+D1VnMcNUmMzbzgWqWcdJ2j8Svow==" crossorigin="anonymous"></script>
<script type="text/javascript">
    CodeMirror.fromTextArea(document.getElementById('custom-code'), {
        lineNumbers: true,
        readOnly: true,
        mode:  "htmlmixed"
    });
    </script>
{/block}