<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2020 Proxim
 * @version    1.0
 * @since      File available since Release 1.0
*/

use Proxim\Presenter\PresenterInterface;

class PrePaperPresenter implements PresenterInterface
{
    /**
     * @param PrePaper $prepaper
     *
     * @return PrePaperPresenter
     *
     * @throws Exception
     */
    public function present($prepaper)
    {
        if (!($prepaper instanceof PrePaper)) {
            throw new Exception('PrePaperPresenter can only present instance of PrePaper');
        }

        return new PrePaperLazyArray($prepaper);
    }
}
